{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon">
        <i class="fa fa-shopping-basket mr10"></i>
        <strong>Addons</strong>
        &rsaquo; <strong>Purchase</strong>
    </div>

    <div class="card-body"> 

       
    </div>
</div>
{/block}

{block name="custom_js"}
    <script src='https://js.stripe.com/v3/' type='text/javascript'></script>
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function(event) {
            var stripe = Stripe('{$stripe_key}'); 
            var elements = stripe.elements();

            var card = elements.create('card');
            // Add an instance of the card UI component into the `card-element` <div>
            card.mount('#card-element');

            // Handle events and errors
            card.addEventListener('change', function(event) {
                var displayError = document.getElementById('card-errors');
                if (event.error) {
                    displayError.textContent = event.error.message;
                } else {
                    displayError.textContent = '';
                }
            });

            function stripeTokenHandler(token) {
                // Insert the token ID into the form so it gets submitted to the server
                var form = document.getElementById('payment-form');
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'stripeToken');
                hiddenInput.setAttribute('value', token.id);
                form.appendChild(hiddenInput);

                // Submit the form
                form.submit();
            }

            function createToken() {
                stripe.createToken(card).then(function(result) {
                    if (result.error) {
                        // Inform the user if there was an error
                        var errorElement = document.getElementById('card-errors');
                        errorElement.textContent = result.error.message;
                    } else {
                        // Send the token to your server
                        stripeTokenHandler(result.token);
                    }
                });
            };

            // Create a token when the form is submitted.
            var form = document.getElementById('payment-form');
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                form.getElementById('stripeJSPayButton').disabled = true;
                createToken();
            });
        });
    </script>
{/block}