<div class="card-header with-icon with-nav">
    <div class="mb20">
        <i class="fa fa-globe mr10"></i>
        <strong>Sites</strong>
        &rsaquo; <strong>{$site.name}</strong>
        &rsaquo; <strong>Preferences</strong>
        
        <div class="pull-right">
            <a href="{$base_uri}/my-sites/{$site.id}" class="btn btn-default">
                <i class="fa fa-arrow-left"></i> Back to Site
            </a>

            {if $tab == "deadlines"}
                <button type="button" data-toggle="modal" data-url="#addDeadlineModal" data-size="medium" class="btn btn-primary ml5">
                    <i class="fa fa-plus"></i> Add new Deadline
                </button>
            {/if}
            
        </div>
    </div>

    <!-- tabs nav -->
    <ul class="nav nav-tabs admin">
        <li {if $tab == "features"}class="active"{/if}>
            <a href="{$base_uri}/my-sites/{$site.id}/preferences?tab=features"> 
                {if $tab == "features"}<strong class="pr5">Features</strong>{else}Features{/if} 
            </a>
        </li>
        <li {if $tab == "deadlines"}class="active"{/if}>
            <a href="{$base_uri}/my-sites/{$site.id}/preferences?tab=deadlines"> 
                {if $tab == "deadlines"}<strong class="pr5">Deadlines</strong>{else}Deadlines{/if} 
            </a>
        </li>
    </ul>
    <!-- tabs nav -->
</div> 

<div class="card-body">
    {if $tab == "features"}
        <!-- Features -->
        <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/sites?do=features_settings">
            <input type="hidden" name="site_id" value="{$site.id}"/>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Order Form Coupons
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="order_form_coupons">
                        <input type="checkbox" name="order_form_coupons" id="order_form_coupons" {if $formValues.ORDER_FORM_COUPONS == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">Show available coupons on the order form</span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Free Inquiry
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="order_inquiry_enabled">
                        <input type="checkbox" name="order_inquiry_enabled" id="order_inquiry_enabled" {if $formValues.INQUIRY_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">Allow customers to make free inquiries</span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Expert Proofreading
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="expert_proofreading_enabled">
                        <input type="checkbox" name="expert_proofreading_enabled" id="expert_proofreading_enabled" {if $formValues.EXPERT_PROOFREADING_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Expert Proofreading (25%) - Get your paper checked by an expert proofreader: no grammatical and spelling mistakes, a perfect match with your requirements, and correspondence with the chosen academic level.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    VIP Support
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="vip_support_enabled">
                        <input type="checkbox" name="vip_support_enabled" id="vip_support_enabled" {if $formValues.VIP_SUPPORT_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        VIP Support ($9.99) - Personal 24/7 VIP manager responsible for tracking your order until final delivery, alongside personalized communication via call and text.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Plagiarism Report
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="plagiarism_report_enabled">
                        <input type="checkbox" name="plagiarism_report_enabled" id="plagiarism_report_enabled" {if $formValues.PLAGIARISM_REPORT_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Plagiarism Report ($9.99) - All papers are checked for plagiarims but if you'd like an official report alongside your paper please choose this option.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Draft/Outline
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="draft_outline_enabled">
                        <input type="checkbox" name="draft_outline_enabled" id="draft_outline_enabled" {if $formValues.DRAFT_OUTLINE_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Draft/Outline (25%) - We will prepare a draft outlining structure and key points to be discussd in your paper and send send it before the final paper is complete.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Writer Samples
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="writer_samples_enabled">
                        <input type="checkbox" name="writer_samples_enabled" id="writer_samples_enabled" {if $formValues.WRITER_SAMPLES_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Writer Samples ($5) - Review 3 samples of work previously completed by the writer assigned to your order.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Progressive Delivery
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="p_delivery_enabled">
                        <input type="checkbox" name="p_delivery_enabled" id="p_delivery_enabled" {if $formValues.PROGRESSIVE_DELIVERY_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Progressive Delivery (10%) - Get your paper delivered step by step. For more information, please check our Progressive Delivery web page. Available for orders with a deadline of 5 days and longer, and with the value of $200 or more.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Copy of Sources
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="copy_of_sources_enabled">
                        <input type="checkbox" name="copy_of_sources_enabled" id="copy_of_sources_enabled" {if $formValues.COPY_OF_SOURCES_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Copy Of Sources (10%) - Get excerpts of the articles and e-books or the links to these excerpts cited in the paper.
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">
                    Lifetime Discounts
                </label>
                <div class="col-sm-9">
                    <label class="switch" for="discounts_enabled">
                        <input type="checkbox" name="discounts_enabled" id="discounts_enabled" {if $formValues.DISCOUNTS_ENABLED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Give customers lifetime discounts 
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-3 control-label text-left">Request Refund</label>
                <div class="col-sm-9">
                    <label class="switch" for="request_refund_enabled">
                        <input type="checkbox" name="request_refund_enabled" id="request_refund_enabled" {if $formValues.REQUEST_REFUND_ALLOWED == '1'}checked="checked"{/if}>
                        <span class="slider round"></span>
                    </label>
                    <span class="help-block">
                        Enable or disable to allow your customers to request refunds on your website 
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <div class="col-sm-9 offset-sm-3">
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->

                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </div>

        </form>
        <!-- Features -->
    {elseif $tab == "deadlines"}

        {if !$article_writing_enabled}
            <form class="form-inline mb20" action="/my-sites/{$site.id}/preferences" method="get">
                {if $tab}
                    <input type="hidden" name="tab" value="{$tab}">
                {/if}
                <div class="form-group">
                    <div class="input-group"> 
                        <select class="form-control" name="academicLevel">
                            {foreach $academic_levels as $academic_level}
                                <option value="{$academic_level.id}" {if $academic_level_selected == $academic_level.id}selected=""{/if}>{$academic_level.title}</option>
                            {/foreach}
                        </select>
                        <div class="input-group-append"> 
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search mr5"></i> Filter
                            </button> 
                        </div>
                    </div>
                </div>
            </form>
        {/if}

        {if count($deadlines)}
            <div class="table-responsive">
                <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            {if $article_writing_enabled}
                                <th>Price Per Word</th>
                            {else}
                                <th>Price Per Page</th>
                            {/if}
                            <th>Hours Customer</th>
                            <th>Hours Writer</th>
                            {if $article_writing_enabled}
                                <th>Minimum Words</th>
                            {else}
                                <th>Minimum Pages</th>
                            {/if}
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $deadlines as $deadline}
                            <tr>
                                <td>{$deadline.id}</td>
                                <td>{$deadline.name}</td>
                                <td>{$deadline.price_per_page.amountFormatted}</td>
                                <td>{pluralize('Hour', $deadline.hrs)}</td>
                                <td>{pluralize('Hour', $deadline.hrs_writer)}</td>
                                {if $article_writing_enabled}
                                    <td>{pluralize('Word', $deadline.min_pages)}</td>
                                {else}
                                    <td>{pluralize('Page', $deadline.min_pages)}</td>
                                {/if}
                                <td>
                                    <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="deadline" data-id="{$deadline.id}">
                                        <i class="fa fa-trash-alt"></i>
                                    </button>
                                    <button type="button" data-toggle="modal" data-url="#editDeadlineModal" data-size="medium" data-options='{$deadline|json_encode nofilter}' class="btn btn-xs btn-primary">
                                        <i class="fa fa-pencil-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb20" width="15%" src="/static/images/no_results.png">
                <p class="mb10"><strong>No deadlines to show</strong></p>
            </div>
        {/if}

        <!-- Add Deadline -->
        <script id="addDeadlineModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDeadline" method="POST" autocomplete="off">
                <input type="hidden" name="site_id" value="{$site.id}">
                <div class="modal-header">
                    <h5 class="modal-title">Add Deadline</h5>
                    <span class="modal-close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </span>
                </div>

                <div class="modal-body">
                    {if $article_writing_enabled}
                        <input type="hidden" name="academic_level_id" value="{LEVEL_ARTICLE_WRITING}"/>
                    {else}
                        <div class="form-group">
                            <label class="control-label">Academic Level</label>
                            <select class="form-control" name="academic_level_id">
                                {foreach $academic_levels as $academic_level}
                                    <option value="{$academic_level.id}">{$academic_level.title}</option>
                                {/foreach}
                            </select>
                        </div>
                    {/if}

                    <div class="form-group">
                        <label class="control-label">Name</label>
                        <input name="name" type="text" class="form-control">
                        <span class="help-block">Deadline name e.g. 12 Hours</span>
                    </div>

                    <div class="form-group">
                        <label class="control-label text-left">Price per {if $article_writing_enabled}word{else}page{/if}</label>
                        <div class="row">
                            <div class="input-group col-md-4">
                                <div class="input-group-prepend"> 
                                    <span class="input-group-text d-none d-sm-block">$</span> 
                                </div>
                                <input name="price_per_page" type="text" class="form-control force-integer">
                            </div>
                        </div>
                        <span class="help-block">The customer's price per {if $article_writing_enabled}word{else}page{/if}</span>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Hours Customer</label>
                        <input name="hrs_customer" type="text" class="form-control force-integer">
                        <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Hours Writer</label>
                        <input name="hrs_writer" type="text" class="form-control force-integer">
                        <span class="help-block">The number of hours the writer will get to complete the order</span>
                    </div>

                    <div class="form-group mb0">
                        <label class="control-label">Minimum {if $article_writing_enabled}words{else}pages{/if}</label>
                        <input name="min_pages" type="text" class="form-control force-integer" value="0">
                        <span class="help-block">The minimum {if $article_writing_enabled}words{else}pages{/if} needed to show this deadline. i.e You can hide a 1 Month deadline for orders with less than {if $article_writing_enabled}250 words{else}5 page{/if}.</span>
                    </div>
                
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deadline</button>
                </div>
            </form>
        </script>
        <!-- Add Deadline -->

        <!-- Edit Deadline -->
        <script id="editDeadlineModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDeadline" method="POST" autocomplete="off">
                <input type="hidden" name="deadline_id" value="{literal}{{id}}{/literal}">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Deadline</h5>
                    <span class="modal-close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </span>
                </div>

                <div class="modal-body">
                    <div class="form-group">
                        <label class="control-label">Name</label>
                        <input name="name" type="text" class="form-control" value="{literal}{{name}}{/literal}">
                        <span class="help-block">Deadline name e.g. 12 Hours</span>
                    </div>

                    <div class="form-group">
                        <label class="control-label text-left">Price per {if $article_writing_enabled}word{else}page{/if}</label>
                        <div class="row">
                            <div class="input-group col-md-4">
                                <div class="input-group-prepend"> 
                                    <span class="input-group-text d-none d-sm-block">$</span> 
                                </div>
                                <input name="price_per_page" type="text" class="form-control force-integer" value="{literal}{{price_per_page.value}}{/literal}">
                            </div>
                        </div>
                        <span class="help-block">The customer's price per {if $article_writing_enabled}word{else}page{/if}</span>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Hours Customer</label>
                        <input name="hrs_customer" type="text" class="form-control force-integer" value="{literal}{{hrs}}{/literal}">
                        <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Hours Writer</label>
                        <input name="hrs_writer" type="text" class="form-control force-integer" value="{literal}{{hrs_writer}}{/literal}">
                        <span class="help-block">The number of hours the writer will get to complete the order</span>
                    </div>

                    <div class="form-group mb0">
                        <label class="control-label">Minimum {if $article_writing_enabled}words{else}pages{/if}</label>
                        <input name="min_pages" type="text" class="form-control force-integer" value="{literal}{{min_pages}}{/literal}">
                        <span class="help-block">The minimum {if $article_writing_enabled}words{else}pages{/if} needed to show this deadline. i.e You can hide a 1 Month deadline for orders with less than {if $article_writing_enabled}250 words{else}5 page{/if}.</span>
                    </div>
                
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                </div>
            </form>
        </script>
        <!-- Edit Deadline -->
    {/if}
</div>