<div class="card-header with-icon">
    <i class="fa fa-globe mr10"></i>
    <strong>Sites</strong>
    {if $sub_view == "add"} 
        &rsaquo; <strong>Add New</strong>
    {/if}

    <div class="pull-right flip">
        <a href="{$base_uri}/my-sites/add" class="btn btn-primary">
            <i class="fa fa-plus"></i> Add New Site
        </a>
    </div>
</div>

<div class="card-body">
    {if $total_sites}
        <div class="table-responsive">
            <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                <thead>
                    <tr>
                        <td>Site ID</td>
                        <td>Site Name</td>
                        <td>URL</td>
                        <td>Orders</td>
                        <td>Customers</td>
                        <td>Payments</td>
                        <td>Actions</td>
                    </tr>
                </thead>
                <tbody>
                    {foreach $sites as $site}
                        <tr>
                            <td><a href="{$base_uri}/my-sites/{$site.id}/edit">#{$site.id}</a></td>
                            <td><span class="order-subject">{$site.name}</span></td>
                            <td><span class="order-subject">{$site.domain}</span></td>
                            <td><span class="green_currency">{$site.orders}</span></td>
                            <td><span class="green_currency">{$site.customers}</span></td>
                            <td><span class="green_currency">${$site.payments}</span></td>
                            <td>
                                <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="site" data-id="{$site.id}">
                                    <i class="fa fa-trash-alt"></i>
                                </button>
                                <a data-toggle="tooltip" data-placement="top" title="Edit" href="{$base_uri}/my-sites/{$site.id}/edit" class="btn btn-xs btn-primary">
                                    <i class="fa fa-pencil-alt"></i>
                                </a>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>

            {$pager nofilter}
        </div>
    {else}
        <div class="text-center x-muted"> 
            <i class="fa fa-globe fa-4x"></i>
            <p class="mb10"><strong>No sites to show</strong></p>
        </div>
    {/if}
</div>