{if $user.is_writer}
    {* Order published || Inquiry published || Writer Accepted || Inquiry Writer Accepted*}
    {if $order.status == "19" || 
        $order.status == "16" || 
        $order.status == "7"  ||
        $order.status == "17" 
    }
 
        {if $has_bidded}
            <form class="js_ajax-forms alert alert-success" data-url="/orders/{$order.id}/remove_bid">
                <input type="hidden" name="bid_id" value="{$bid.bid_id}"/>
                <p class="mb5">The bid you have placed equals to - ${$bid.amount} on {$bid.date_add}<p>
                <!-- error -->
                <div class="alert alert-danger mt5 mb20 x-hidden" role="alert"></div>
                <!-- error -->
                <button type="submit" class="btn btn-primary">Remove Bid</button>
            </form>
        {else}

            <form class="js_ajax-forms alert alert-success" data-url="/orders/{$order.id}/apply">
                <input name="bid[amount]" type="hidden" value="{$order.writerPayFormatted}">
                <p class="mb5">Place your bid, if you are ready to execute this order for <strong>{$order.writerPayFormatted}</strong><p>
                <!-- error -->
                <div class="alert alert-danger mt5 mb20 x-hidden" role="alert"></div>
                <!-- error -->
                <button type="submit" class="btn btn-primary">Place Bid</button>
            </form>

        {/if}

    {/if}

{elseif $user.is_editor}

{elseif $user.is_admin || $user.is_sub_admin}

    {* Unpaid *}
    {if $order.status == "0"} 
        <form class="js_ajax-forms alert alert-success" data-url="/orders/{$order.id}/mark-as-paid">
            <p class="mb5">This order is unpaid. Select and submit the type of order below to make it available to writers</p>
            <div class="row mt10">
                <div class="col-md-4">
                    <select class="form-control" name="order_type">
                        <option value="-1" disabled="" selected="">Select the Type of Order</option>
                        <option value="take_bid">Take or Bid</option>
                        <option value="bid">Bid only</option>
                        <option value="bid_price">Bid with price</option>
                        <option value="bid_deadline">Bid with deadline</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-primary">Mark as Paid</button>
                </div>
            </div>
            <!-- error -->
            <div class="alert alert-danger mt5 mb0 x-hidden" role="alert"></div>
            <!-- error -->
        </form>
    {/if}
{/if}
