{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon">
        <i class="fa fa-shopping-basket mr10"></i>
        <strong>Orders</strong>
        &rsaquo; <strong>Create</strong>
    </div>

    <form class="form-horizontal js_ajax-forms" id="orderForm" data-url="/order" method="POST">
        {if $article_writing_enabled}
            <input type="hidden" name="academicLevelId" value="{LEVEL_ARTICLE_WRITING}"/>
        {/if}
        <div class="card-body">
            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left" for="customerId">Customer:</label>
                <div class="col-sm-7">
                    <select name="customerId" class="form-control select_search">
                        <option value="-1" selected="" disabled="">Select Customer</option>
                        {foreach $customers as $customer}
                            <option value="{$customer.customer_id}">{$customer.customer_id} {if $user.is_admin} {if $customer.name}({$customer.name}){/if} - {$customer.email} {/if}</option>
                        {/foreach}
                    </select>
                </div>
            </div>

            {if !$article_writing_enabled}
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left" for="academicLevel">Academic Level:</label>
                    <div class="col-sm-7">
                        <select name="academicLevelId" class="form-control js_calculate">
                            {foreach $academicLevels as $academicLevel}
                                <option value="{$academicLevel.id}" {if $defaultCourseLevelId == $academicLevel.id}selected=""{/if}>{$academicLevel.title}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>
            {/if}

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left" for="paperTypeId">{if $article_writing_enabled}Project{else}Type of paper{/if}:</label>
                <div class="col-sm-7">
                    <select name="paperTypeId" class="form-control select_search js_calculate js_custom-toggle" data-val="64">
                        {foreach $paperTypes as $paperType}
                            <option value="{$paperType.id}">{$paperType.title}</option>
                        {/foreach}
                    </select>
                </div>
            </div>

            <div class="form-group x-hidden form-row">
                <label class="col-sm-2 control-label text-left" for="paperTypeOption">{if $article_writing_enabled}Add Project{else}Add Paper Type{/if}:</label>
                <div class="col-sm-7">
                    <input type="text" class="form-control js_calculate" name="paperTypeOption" id="paperTypeOption" maxlength="255">
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left" for="topicCatId">{if $article_writing_enabled}Category{else}Discipline{/if}:</label>
                <div class="col-sm-7">
                    <select name="topicCatId" id="topicCatId" class="form-control select_search js_calculate js_custom-toggle" data-val="52">
                        {foreach $disciplineGroups as $topicCat}
                            <optgroup label="{$topicCat.title}">
                                {foreach $topicCat.disciplines as $discipline}
                                    <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}">{$discipline.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                </div>
            </div>

            <div class="form-group x-hidden form-row">
                <label class="col-sm-2 control-label text-left" for="topcatOption">{if $article_writing_enabled}Add Category{else}Add Discipline{/if}:</label>
                <div class="col-sm-7">
                    <input type="text" class="form-control js_calculate" name="topcatOption" id="topcatOption" maxlength="255">
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left" for="topic">Topic:</label>
                <div class="col-sm-7">   
                    <input type="text" class="form-control" name="topic" id="topic" value="Writer’s choice" maxlength="255">
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left" for="paperDetails">Paper instructions:</label>
                <div class="col-sm-7">
                    <textarea id="summernote" name="paperDetails" class="form-control"></textarea>
                </div>
            </div>

            {if !$article_writing_enabled}
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left" for="paperFormat">Paper Format:</label>
                    <div class="col-sm-7">
                        <select class="form-control js_calculate js_custom-toggle" name="paperFormat" data-val="4">
                            {foreach $paperFormats as $paperFormat}
                                <option value="{$paperFormat.paper_format_id}">{$paperFormat.title}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>

                <div class="form-group form-row x-hidden">
                    <label class="col-sm-2 control-label text-left" for="paperFormatOption">Add Paper Format:</label>
                    <div class="col-sm-7">
                        <input class="form-control js_calculate" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255">
                    </div>
                </div>
            {/if}

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Deadline:</label>
                <div class="col-sm-7">
                    <select name="tariffId" class="form-control js_calculate" data-tariff-control=""></select>
                </div>
            </div>

            <div class="divider"></div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Spacing</label>
                <div class="col-sm-4">
                    <select class="js_calculate form-control" name="spacing">
                        <option value="double">Double Spaced</option>
                        <option value="single">Single Spaced</option>
                    </select>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">{if $article_writing_enabled}Words{else}Pages{/if}</label>
                <div class="col-sm-4">
                    <div class="control-stepper">
                        <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                        <input name="pages" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="1">
                        <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                    </div>
                </div>
            </div>

            {if !$article_writing_enabled}
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Sources to be cited</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="sources" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Charts</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="charts" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">PowerPoint slides</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="slides" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>
            {/if}

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Writer Category</label>
                <div class="col-sm-7">
                    <select class="form-control js_calculate" name="writerCategoryId">
                        {foreach $writerPreferences as $writerPreference}
                            <option {if isset($writerPreference.percent)}data-percent="{$writerPreference.percent}"{/if} value="{$writerPreference.id}"{if $writerPreference.id == "2"}selected=""{/if}>{$writerPreference.title}</option>
                        {/foreach}
                    </select>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Tracking ID</label>
                <div class="col-sm-7">
                    <input class="form-control" type="text" name="tracking_id" id="tracking_id" maxlength="255">
                </div>
            </div>

            {if !$article_writing_enabled}
                <div class="divider"></div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Get Writer Samples</label>
                    <div class="col-sm-7">
                        <label class="switch" for="samplesNeeded">
                            <input class="js_calculate" type="checkbox" name="samplesNeeded" id="samplesNeeded">
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Copy of Sources</label>
                    <div class="col-sm-7">
                        <label class="switch" for="usedsources">
                            <input class="js_calculate" type="checkbox" name="usedsources" id="usedsources">
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Progressive Delivery</label>
                    <div class="col-sm-7">
                        <label class="switch" for="progressiveDeliveryHidden">
                            <input class="js_calculate" type="checkbox" name="progressiveDeliveryHidden" id="progressiveDeliveryHidden">
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Expert Proofreading</label>
                    <div class="col-sm-7">
                        <label class="switch" for="expertProofreading">
                            <input class="js_calculate" type="checkbox" name="expertProofreading" id="expertProofreading">
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
            {/if}

            <div class="divider"></div>
                
            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Total</label>
                <div class="col-sm-7">
                    <span id="orderPrice" class="h2 text-success">$0.00</span>
                </div>
            </div>

            <div class="form-group form-row">
                <div class="col-md-9 offset-sm-3">
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
            </div>
        </div>
        <div class="card-footer text-center">
            <button type="submit" class="btn btn-primary">Create Order</button>
        </div>
    </form>
</div>
{/block}

{block name="custom_js"}
    <script type="text/javascript">
    $(function () { 
        var siteId;
        var customerId;
        var article_writing_enabled = {$article_writing_enabled};
        var academicLevel = article_writing_enabled ? academicLevel = $("[name='academicLevelId']").val(): $("[name='academicLevelId'] :selected").val();
        var tariffs = {json_encode($tariffs) nofilter};
        var customerSites = {json_encode($customerSites) nofilter};

        var $form = $("#orderForm");
        $form.find('[name="customerId"], [name="academicLevelId"]').change(function(e) {
            customerId = $("[name='customerId'] :selected").val();
            academicLevel = article_writing_enabled ? academicLevel = $("[name='academicLevelId']").val(): $("[name='academicLevelId'] :selected").val();
            siteId = customerSites[customerId];
            if(siteId && academicLevel) {
                renderTariffs(siteId, academicLevel);
            }
        });

        $(document).on('change click input', $form.find('.js_calculate'), function(e) {
            calculate();
        });

        $('.js_custom-toggle').on('change',function(){
            var _this = $(this);
            var $value= _this.val();
            var $val = _this.data('val');
            var parent = $(this).closest('.form-group');

            if($value == $val) {
                parent.next('.form-group').removeClass('x-hidden');
            } else {
                parent.next('.form-group').addClass('x-hidden');
            }
        });

        function renderTariffs( siteId, academicLevel ) {
            var tariffControl = $("[data-tariff-control]");
            tariffControl.empty();

            if ( siteId && academicLevel ) {
                activeTariff = tariffs[siteId][academicLevel];
                $.each(activeTariff, function(i, tariff){
                    tariffControl.append( $('<option>').text(tariff.name).attr('value', tariff.id).attr('data-hrs', tariff.hrs).attr('data-cpp', tariff.price_per_page.value) );
                });
            }

            return true;
        }

        function calculate() {
            var availableWinbackCoupons = null;
            var discount = null;

            var formStateForCalculator = {
                discount,
                winbackCoupons: availableWinbackCoupons,
                writerCategoryId: parseInt($form.find('[name="writerCategoryId"] :selected').val()) || null,
                writerPercent: parseInt($form.find('[name="writerCategoryId"] :selected').data('percent')) || null,
                complexAssignmentDiscipline: $form.find('[name="topicCatId"] :selected').data('complex') || 0,
                pages: parseInt($form.find('[name="pages"]').val()),
                slides: parseInt($form.find('[name="slides"]').val()),
                charts: parseInt($form.find('[name="charts"]').val()),
                tariffPricePerPage: $form.find('[name="tariffId"] :selected').data('cpp') || 0,
                tariffHrs: $form.find('[name="tariffId"] :selected').data('hrs') || 0,
                spacing: $form.find('[name="spacing"] :selected').val() || false,
                getSamplesOn: $form.find('[name="samplesNeeded"]:checked').val() || false,
                getProgressiveDeliveryOn: $form.find('[name="progressiveDeliveryHidden"]:checked').val() || false,
                getUsedSourcesOn: $form.find('[name="usedsources"]:checked').val() || false,
                expertProofreading: $form.find('[name="expertProofreading"]:checked').val() || false
            };

            try {
                var cost = PROXIMCostCalculator.calculate(formStateForCalculator);
                $form.find("#orderPrice").text("$"+cost.totalCost);
            } catch (e) {
                console.error(e);
            }
        }        
    });
    </script>
{/block}