{extends file='dashboard/layout.tpl'} 
 
{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon">
        {if $user.is_admin || $user.is_sub_admin}
            <div class="pull-right flip">
                <a href="{$base_uri}/order/{$order.id}" class="btn btn-secondary">
                    <i class="fa fa-arrow-left fa-fw mr5"></i> Back to Order
                </a>
            </div>
        {/if}
        <i class="fa fa-shopping-basket mr10"></i>
        <strong>Orders</strong>
        &rsaquo; <strong>#{$order.id}</strong>
        &rsaquo; <strong>Edit</strong>
    </div>
 
    <form class="form-horizontal js_ajax-forms" id="orderForm" data-url="/order" method="POST">
        <div class="card-body">
            <input type="hidden" name="order_id" value="{$order.id}">
            {if $article_writing_enabled}
                <input type="hidden" name="academicLevelId" value="{LEVEL_ARTICLE_WRITING}"/>
            {/if}
            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">{if $article_writing_enabled}Project{else}Type of paper{/if}</label>
                <div class="col-sm-7">
                    <select name="paperTypeId" class="form-control js_calculate select_search js_custom-toggle" data-val="64">
                        {foreach $paperTypes as $paperType}
                            <option value="{$paperType.id}" {if $order.paperType == $paperType.id}selected=""{/if} >{$paperType.title}</option>
                        {/foreach}
                    </select>
                </div>
            </div>

            <div class="form-group form-row {if $order.paperType != 64}x-hidden{/if}">
                <label class="col-sm-2 control-label text-left">{if $article_writing_enabled}Add Project{else}Add Paper Type{/if}</label>
                <div class="col-sm-7">
                    <input type="text" class="js_calculate form-control" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$order.paperTypeOption}">
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">{if $article_writing_enabled}Category{else}Discipline{/if}</label> 
                <div class="col-sm-7">
                    <select name="topicCatId" id="topicCatId" class="form-control js_calculate select_search js_custom-toggle" data-val="52">
                        {foreach $disciplineGroups as $topicCat}
                            <optgroup label="{$topicCat.title}">
                                {foreach $topicCat.disciplines as $discipline}
                                    <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $order.topcatId == $discipline.discipline_id}selected=""{/if} >{$discipline.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                </div>
            </div>

            <div class="form-group form-row {if $order.topcatId != 52}x-hidden{/if}">
                <label class="col-sm-2 control-label text-left">{if $article_writing_enabled}Add Category{else}Add Discipline{/if}</label>
                <div class="col-sm-7">
                    <input type="text" class="js_calculate form-control" name="topcatOption" id="topcatOption" maxlength="255" value="{$order.topcat}">
                </div>
            </div>

            {if !$article_writing_enabled}
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left" for="paperFormat">Paper Format:</label>
                    <div class="col-sm-7">
                        <select class="form-control js_calculate js_custom-toggle" name="paperFormat" data-val="4">
                            {foreach $paperFormats as $paperFormat} 
                                <option value="{$paperFormat.paper_format_id}" {if $order.paperFormat == $paperFormat.paper_format_id}selected=""{/if}>{$paperFormat.title}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>

                <div class="form-group form-row {if $order.paperFormat != 4}x-hidden{/if}">
                    <label class="col-sm-2 control-label text-left">Add Paper Format</label>
                    <div class="col-sm-7">
                        <input type="text" class="js_calculate form-control" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$order.paperFormatTypeOption}">
                    </div>
                </div>
            {/if}

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Topic</label>
                <div class="col-sm-7">
                    <input class="form-control" type="text" name="topic" id="topic" maxlength="255" value="{$order.title}">
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Paper Instructions</label>
                <div class="col-sm-7">
                    <textarea id="summernote" class="form-control" name="paperDetails">{$order.paperDetailsRaw}</textarea>
                </div>
            </div>

            <div class="divider"></div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Spacing</label>
                <div class="col-sm-4">
                    <select class="js_calculate form-control" name="spacing">
                        <option value="double" {if $order.spacing == 'double'}selected=""{/if} >Double Spaced</option>
                        <option value="single" {if $order.spacing == 'single'}selected=""{/if} >Single Spaced</option>
                    </select>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">{if $article_writing_enabled}Words{else}Pages{/if}</label>
                <div class="col-sm-4">
                    <div class="control-stepper">
                        <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                        <input name="pages" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.pages}" data-minvalue="0">
                        <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                    </div>
                </div>
            </div>

            {if !$article_writing_enabled}
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Sources to be cited</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="sources" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.sources}" data-minvalue="0">
                            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Charts</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="charts" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.charts}" data-minvalue="0">
                            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">PowerPoint slides</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="slides" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.slides}" data-minvalue="0">
                            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>
            {/if}

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Writer Category</label>
                <div class="col-sm-7">
                    <select class="form-control js_calculate" name="writerCategoryId">
                        {foreach $writerPreferences as $writerPreference}
                            <option {if isset($writerPreference.percent)}data-percent="{$writerPreference.percent}"{/if} value="{$writerPreference.id}" {if $order.writerCategoryId == $writerPreference.id}selected=""{/if} >{$writerPreference.title}</option>
                        {/foreach}
                    </select>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Tracking ID</label>
                <div class="col-sm-7">
                    <input class="form-control" type="text" name="tracking_id" id="tracking_id" maxlength="255" value="{$order.trackingId}">
                </div>
            </div>

            <div class="divider"></div>

            {if !$article_writing_enabled}
                {if $siteSettings.WRITER_SAMPLES_ENABLED ||  $order.areSamplesRequired}
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">Get Writer Samples</label>
                        <div class="col-sm-7">
                            <label class="switch" for="samplesNeeded">
                                <input class="js_calculate" type="checkbox" name="samplesNeeded" id="samplesNeeded" {if $order.areSamplesRequired == '1'}checked="checked"{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                {/if}

                {if $siteSettings.COPY_OF_SOURCES_ENABLED || $order.areSourcesRequired}
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">Copy of Sources</label>
                        <div class="col-sm-7">
                            <label class="switch" for="usedsources">
                                <input class="js_calculate" type="checkbox" name="usedsources" id="usedsources" {if $order.areSourcesRequired == '1'}checked="checked"{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                {/if}

                {if $siteSettings.PROGRESSIVE_DELIVERY_ENABLED ||  $order.progressiveDeliveryHidden}
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">Progressive Delivery</label>
                        <div class="col-sm-7">
                            <label class="switch" for="progressiveDeliveryHidden">
                                <input class="js_calculate" type="checkbox" name="progressiveDeliveryHidden" id="progressiveDeliveryHidden" {if $order.progressiveDeliveryHidden == '1' && $order.tariffHrs > 120}checked="checked"{/if} {if $order.tariffHrs < 120}disabled=""{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                {/if}

                {if $siteSettings.EXPERT_PROOFREADING_ENABLED ||  $order.expertProofreading}
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">Expert Proofreading</label>
                        <div class="col-sm-7">
                            <label class="switch" for="expertProofreading">
                                <input class="js_calculate" type="checkbox" name="expertProofreading" id="expertProofreading" {if $order.expertProofreading == '1'}checked="checked"{/if}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                    </div>
                {/if}
                <div class="divider"></div>
            {/if}
            
            {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">Total</label>
                <div class="col-sm-7">
                    <span id="orderPrice" class="h2 text-success">$0.00</span>
                </div>
            </div>
            {/if}

            <div class="form-group form-row">
                <label class="col-sm-2 control-label text-left">
                    Change Deadline
                </label>
                <div class="col-sm-7">
                    <label class="switch" for="changeDeadline">
                        <input type="checkbox" name="changeDeadline" id="changeDeadline">
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>
            
            <div deadline-combo class="x-hidden">
                {if !$article_writing_enabled}
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">Academic level</label>
                        <div class="col-sm-7">
                            <select name="academicLevelId" class="form-control js_calculate">
                                {foreach $academicLevels as $academicLevel}
                                    <option value="{$academicLevel.id}" {if $order.academicLevel == $academicLevel.id}selected=""{/if}>{$academicLevel.title}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>
                {/if}

                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Deadline</label>
                    <div class="col-sm-7">
                        <select name="tariffId" class="form-control js_calculate" data-tariff-control="" tariff-id="{$order.tariffId}"></select>
                    </div>
                </div>
            </div>

            <div class="form-group form-row">
                <div class="col-md-9 offset-sm-3">
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
            </div>
        </div>
        <div class="card-footer text-center">
            <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
</div>
{/block}

{block name="custom_js"}
    <script type="text/javascript">
        $(function () { 
            var $form = $("#orderForm");
            var article_writing_enabled = {$article_writing_enabled};
            var tariffs = {json_encode($tariffs) nofilter};
            var academicLevel = article_writing_enabled ? academicLevel = $("[name='academicLevelId']").val(): $("[name='academicLevelId'] :selected").val();

            $form 
                && renderTariffs( academicLevel ) 
                    && calculate();

            $(document).on('change click input', $form.find('.js_calculate'), function(e) {
                calculate();
            });

            $('[name="changeDeadline"]').on('change',function(){
                if ($(this).is(':checked')) {
                    $form.find('[deadline-combo]').removeClass('x-hidden');
                } else {
                    $form.find('[deadline-combo]').addClass('x-hidden');
                }
            });

            $("[name='academicLevelId']").on('change',function(){
                var academicLevel = $(this).val();
                renderTariffs(academicLevel);
            });

            function renderTariffs( academicLevel ) {
                var tariffControl = $("[data-tariff-control]");
                var tariffId = tariffControl.attr("tariff-id");

                tariffControl.empty();
                if ( academicLevel ) {
                    activeTariff = tariffs[academicLevel]
                    $.each(activeTariff, function(i, tariff){
                        tariffControl.append( 
                            $('<option>').text(tariff.name).attr('value', tariff.id).attr('data-hrs', tariff.hrs).attr('data-cpp', tariff.price_per_page.value)
                        );
                    });
                }

                return true;
            }

            $('.js_custom-toggle').on('change',function(){
                var _this = $(this);
                var $value= _this.val();
                var $val = _this.data('val');
                var parent = $(this).closest('.form-group');

                if($value == $val) {
                    parent.next('.form-group').removeClass('x-hidden');
                } else {
                    parent.next('.form-group').addClass('x-hidden');
                }
            });

            function calculate() {
                var availableWinbackCoupons = null;
                var discount = null;

                var formStateForCalculator = {
                    discount,
                    winbackCoupons: availableWinbackCoupons,
                    writerCategoryId: parseInt($form.find('[name="writerCategoryId"] :selected').val()) || null,
                    writerPercent: parseInt($form.find('[name="writerCategoryId"] :selected').data('percent')) || null,
                    complexAssignmentDiscipline: $form.find('[name="topicCatId"] :selected').data('complex') || 0,
                    pages: parseInt($form.find('[name="pages"]').val()),
                    slides: parseInt($form.find('[name="slides"]').val()),
                    charts: parseInt($form.find('[name="charts"]').val()),
                    tariffPricePerPage: {$order.tariffPricePerPage},
                    tariffHrs: {$order.tariffHrs},
                    spacing: $form.find('[name="spacing"] :selected').val() || false,
                    getSamplesOn: $form.find('[name="samplesNeeded"]:checked').val() || false,
                    getProgressiveDeliveryOn: $form.find('[name="progressiveDeliveryHidden"]:checked').val() || false,
                    getUsedSourcesOn: $form.find('[name="usedsources"]:checked').val() || false,
                    expertProofreading: $form.find('[name="expertProofreading"]:checked').val() || false
                };

                if( $form.find('[name="changeDeadline"]').is(':checked') ) {
                    formStateForCalculator.tariffPricePerPage = $form.find('[name="tariffId"] :selected').data('cpp') || 0;
                    formStateForCalculator.tariffHrs = $form.find('[name="tariffId"] :selected').data('hrs') || 0;
                }

                if($form.find("#orderPrice").length) {
                    try {
                        var cost = PROXIMCostCalculator.calculate(formStateForCalculator);
                        $form.find("#orderPrice").text("$"+cost.totalCost);
                    } catch (e) {
                        console.error(e);
                    }
                }
            }        
        });
    </script>
{/block}
