<div class="mb20">

    {if $article_writing_enabled}
        <form method="GET" id="filter_form" autocomplete="off">
            <div class="row mb10">
                <div class="col-md-4">
                    <label for="discipline">Discipline:</label>
                    <select class="form-control input-sm select_search" name="discipline[]" multiple>
                        {foreach $disciplineGroups as $topicCat}
                            <optgroup label="{$topicCat.title}">
                                {foreach $topicCat.disciplines as $discipline}
                                    <option value="{$discipline.discipline_id}" {if $discipline.selected}selected=""{/if} >{$discipline.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="toptitle">Topic Title:</label>
                    <input class="form-control input-sm" type="text" name="toptitle" placeholder="Topic Title" value="{$toptitle}" />
                </div>
                <div class="col-md-2">
                    <label for="order_id">Order ID:</label>
                    <input class="form-control input-sm force-integer" type="text" name="order_id" placeholder="Order Id" value="{$order_id}" />
                </div>
                <div class="col-md-2">
                    <button name="search" class="btn btn-primary mt20">Search</button>
                </div>
            </div>
        </form>
    {else}
        <form method="GET" id="filter_form" autocomplete="off">
            <div class="row mb10">
                <div class="col-md-4">
                    <label for="corslevel">Academic Level:</label>
                    <select class="form-control input-sm" name="corslevel">
                        <option value="-1" selected="selected">All available</option>
                        <option value="1" {if $corslevel == "1"}selected=""{/if}>High school</option>
                        <option value="2" {if $corslevel == "2"}selected=""{/if}>Undergraduate (yrs. 1-2) </option>
                        <option value="3" {if $corslevel == "3"}selected=""{/if}>Undergraduate (yrs. 3-4)</option>
                        <option value="4" {if $corslevel == "4"}selected=""{/if}>Graduate</option>
                        <option value="5" {if $corslevel == "5"}selected=""{/if}>Ph.D.</option>
                    </select>
                </div>

                <div class="col-md-5">
                    <label for="discipline">Discipline:</label>
                    <select class="form-control input-sm select_search" name="discipline[]" multiple>
                        {foreach $disciplineGroups as $topicCat}
                            <optgroup label="{$topicCat.title}">
                                {foreach $topicCat.disciplines as $discipline}
                                    <option value="{$discipline.discipline_id}" {if $discipline.selected}selected=""{/if} >{$discipline.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="deadline">Deadline:</label>
                    <select class="form-control input-sm" name="deadline">
                        <option value="-1" selected="selected">All available</option>
                        <option value="1" {if $deadline == "1"}selected=""{/if}>Urgent</option>
                        <option value="2" {if $deadline == "2"}selected=""{/if}>1-3 days</option>
                        <option value="3" {if $deadline == "3"}selected=""{/if}>4-7 days</option>
                        <option value="4" {if $deadline == "4"}selected=""{/if}>Long-term</option>
                    </select>
                </div>
            </div>

            <div class="row mb10">
                <div class="col-md-2">
                    <label>Pages:</label>
                    <select class="form-control input-sm" name="pages">
                        <option value="-1" selected="selected">All available</option>
                        <option value="1" {if $pages == "1"}selected=""{/if}>< 5</option>
                        <option value="2" {if $pages == "2"}selected=""{/if}>5 - 10</option>
                        <option value="3" {if $pages == "3"}selected=""{/if}>10 - 20</option>
                        <option value="4" {if $pages == "4"}selected=""{/if}>20 - 30</option>
                        <option value="5" {if $pages == "5"}selected=""{/if}>> 30</option>
                    </select>
                </div>

                {if $show_client_cost}
                    <div class="col-md-2">
                        <label>Cost:</label>
                        <select class="form-control input-sm" name="cost">
                            <option value="-1" selected="selected">All available</option>
                            <option value="1" {if $cost == "1"}selected=""{/if}>< $10</option>
                            <option value="2" {if $cost == "2"}selected=""{/if}>$10 - $30</option>
                            <option value="3" {if $cost == "3"}selected=""{/if}>$30 - $100</option>
                            <option value="4" {if $cost == "4"}selected=""{/if}>$100 - $500</option>
                            <option value="5" {if $cost == "5"}selected=""{/if}>> $500</option>
                        </select>
                    </div>
                {/if}
                
                <div class="col-md-4">
                    <label for="toptitle">Topic Title:</label>
                    <input class="form-control input-sm" type="text" name="toptitle" placeholder="Topic Title" value="{$toptitle}" />
                </div>
                <div class="col-md-2">
                    <label for="order_id">Order ID:</label>
                    <input class="form-control input-sm force-integer" type="text" name="order_id" placeholder="Order Id" value="{$order_id}" />
                </div>
                <div class="col-md-2">
                    <button name="search" class="btn btn-primary mt20">Search</button>
                </div>
            </div>
        </form>
    {/if}
</div>