{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-flag mr10"></i>
            <strong>Orders</strong>
            {if $sub_view != ""}
                &rsaquo; <strong>{$sub_view|capitalize} ({$total_orders})</strong>
            {/if}
        </div>

        <div class="card-body">

            {if $user.is_admin || $user.is_sub_admin}
                {include file='dashboard/orders/_filters.orders.tpl'}
            {/if}

            {if count($orders)}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <th>
                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="custom-control custom-checkbox"> 
                                            <input type="checkbox" class="custom-control-input js_select-all" name="select_all" id="js_select-all"> 
                                            <label class="custom-control-label" for="js_select-all">Order ID</label>
                                        </div>
                                    {else}
                                        Order ID
                                    {/if}
                                </th>
                                <th>Topic Title</th>
                                <th>{if $article_writing_enabled}Category{else}Discipline{/if}</th>
                                <th>Deadline</th>
                                <th>{if $article_writing_enabled}Words{else}Pages{/if}</th>
                                {if $show_client_cost}
                                    <th>COST</th>
                                {/if}
                                {if $user.is_admin || $user.is_sub_admin}
                                    {if $show_writer_info}<th>Writer</th>{/if}
                                    <th>Actions</th>
                                {/if}
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $orders as $order}
                                <tr>
                                    <td>
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="custom-control custom-checkbox"> 
                                                <input type="checkbox" class="custom-control-input" name="bulk_action" value="{$order.id}" id="check-{$order.id}"> 
                                                <label class="custom-control-label" for="check-{$order.id}"><a class="fw-bold" href="{$base_uri}/order/{$order.id}">#{$order.id}</a></label>
                                            </div>
                                        {else}
                                            <strong><a href="{$base_uri}/order/{$order.id}">#{$order.id}</a></strong>
                                        {/if}
                                    </td>
                                    <td>
                                        <span data-toggle="tooltip" data-title="{$order.title}"> {$order.titleTruncated}</span>
                                    </td>
                                    <td>
                                        <small class="btn-block">{$order.topcat}</small>
                                        <small class="btn-block text-secondary">{$order.academicLevelTitle}</small>
                                    </td>
                                    <td>{$order.timeLeftHtml nofilter}</td>
                                    <td>{$order.pages} {if $order.slides}, {$order.slides} Slides {/if} </td>
                                    {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
                                        <td>{$order.priceFormatted}</td>
                                    {elseif $user.is_writer}
                                        <td>{$order.writerPayFormatted}</td>
                                    {elseif $user.is_editor}
                                        <td>{$order.editorPayFormatted}</td>
                                    {/if}
                                    
                                    {if ($user.is_admin || $user.is_sub_admin) && $show_writer_info}
                                        <td>
                                            {if $order.writer.id}
                                                <strong><a class="text-capitalize" href="{$base_uri}/employees/edit/{$order.writer.id}">{$order.writer.first_name} {$order.writer.last_name}</a></strong>
                                            {else}
                                                N/A
                                            {/if}
                                        </td>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="order" data-id="{$order.id}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <a data-toggle="tooltip" data-placement="top" title="View" href="{$base_uri}/order/{$order.id}" class="btn btn-xs btn-primary">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    {/if}
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {if $user.is_admin || $user.is_sub_admin}
                        <div class="mb-1">
                            <button class="btn btn-success btn-sm js_bulk-actions float-left">Bulk Actions</button>
                        </div>
                    {/if}

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> <img class="mb20" width="15%" src="/static/images/no_results.png">
                    <p class="mb10"><strong>No orders to show</strong></p>
                </div>
            {/if}

        </div>
    </div>
{/block}
