{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon with-nav">
            <div class="mb20"> 
                <i class="fa fa-money-bill-alt mr10"></i> <strong>Payments</strong> 
            </div>
            <ul class="nav nav-tabs">
                <li {if $sub_view == "overview"}class="active"{/if}>
                    <a href="{$base_uri}/payments/overview"> 
                        {if $sub_view == "overview"}<strong class="pr5">Overview</strong>{else}Overview{/if} 
                    </a>
                </li>

                <li {if $sub_view == "requests"}class="active"{/if}>
                    <a href="{$base_uri}/payments/requests"> 
                        {if $sub_view == "requests"}<strong class="pr5">Payment Requests</strong>{else}Payment Requests{/if} 
                    </a>
                </li>

                <li {if $sub_view == "history"}class="active"{/if}>
                    <a href="{$base_uri}/payments/history"> 
                        {if $sub_view == "history"}<strong class="pr5">Payment History</strong>{else}Payment History{/if} 
                    </a>
                </li>

            </ul>
        </div>

        {if $sub_view == "overview"}

            <div class="card-body">
                <form method="GET" class="mb20" autocomplete="off">
                    <input type="hidden" name="page" value="{$selected_page}"/>
                    <div class="row">

                        <div class="form-group col-md-4">
                            <label class="control-label text-left">From (completed date)</label>
                            <div class="input-group date js_datetimepicker" id="from" data-target-input="nearest">
                                <input type='text' class="form-control datetimepicker-input" value="{$date_from}" data-target="#from" name="from" />
                                <div class="input-group-append" data-target="#from" data-toggle="datetimepicker">
                                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group col-md-4">
                            <label class="control-label text-left">To (completed date)</label>
                            <div class="input-group date js_datetimepicker" id="to" data-target-input="nearest">
                                <input type='text' class="form-control datetimepicker-input" value="{$date_to}" data-target="#to" name="to" />
                                <div class="input-group-append" data-target="#to" data-toggle="datetimepicker">
                                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group col-md-2">
                            <label class="form-label">Employee</label>
                            <select name="employee" class="form-control">
                                <option value="all" {if $employee_group == "all"}selected=""{/if}>All</option>
                                <option value="writer" {if $employee_group == "writer"}selected=""{/if}>Writer</option>
                                <option value="editor" {if $employee_group == "editor"}selected=""{/if}>Editor</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Search</button>
                    <a href="{$base_uri}/payments/{$sub_view}" class="btn btn-default">Clear</a>
                </form>

                {if count($payment_overview) > 0}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                                
                                    <th>EMPLOYEE</th>
                                    <th>EMAIL</th>
                                    <th>ORDERS</th>
                                    <th>{if $article_writing_enabled}WORDS{else}PAGES{/if}</th>
                                    <th>TOTAL</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $payment_overview as $overview}
                                    <tr>
                                        <td>
                                            <strong>
                                            {if $overview.employee_group == "2"}Editor{else}Writer{/if}
                                            <a target="_blank" href="{$base_uri}/employees/edit/{$overview.employee_id}">{$overview.first_name} {$overview.last_name}</a>
                                            </strong>
                                        </td>
                                        <td>{$overview.email}</td>
                                        <td>{$overview.total_orders}</td>
                                        <td>{$overview.total_pages}</td>
                                        <td class="text-right">
                                            <strong class="text-success">${$overview.employee_pay}</strong>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb20" width="15%" src="/static/images/no_results.png">
                        <p class="mb10"><strong>The list is empty.</strong></p>
                    </div>
                {/if}

            </div>

        {elseif $sub_view == "requests"}

            <div class="card-body">
                {if count($requests) > 0}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <th>Employee</th>
                                    <th>Date</th>
                                    <th>Done Orders</th>
                                    <th>Approved Orders</th>
                                    <th>Total</th>
                                    <th>Orders</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $requests as $request}
                                    <tr>
                                        <td>
                                            <strong>
                                                {if $request.employee.employee_group == "2"}Editor{else}Writer{/if}
                                                <a target="_blank" href="{$base_uri}/employees/edit/{$request.employee.id}">{$request.employee.first_name} {$request.employee.last_name}</a>
                                            </strong>
                                        </td>
                                        <td>
                                            <span class="js_moment" data-time="{$request.date_add}">{$request.date_add}</span>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-success">${$request.total_done_pay}</strong>
                                        <td class="text-right">
                                            <strong class="text-success">${$request.total_completed_pay}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-success">${$request.total_pay}</strong>
                                        </td>
                                        <td>
                                            <span class="text-link" data-toggle="modal" data-url="/user/payment-requests/{$request.payment_request_id}">Show</span>
                                        </td>
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="" class="btn btn-xs btn-success js_admin-withdraw" data-handle="approve" data-id="{$request.payment_request_id}" data-original-title="Mark as Paid"> 
                                                <i class="fa fa-check"></i> 
                                            </button>
                                            <button data-toggle="tooltip" data-placement="top" title="Decline" class="btn btn-xs btn-danger js_admin-withdraw" data-handle="decline" data-id="{$request.payment_request_id}"> 
                                                <i class="fa fa-times"></i> 
                                            </button>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb20" width="15%" src="/static/images/no_results.png">
                        <p class="mb10"><strong>The list is empty.</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "history"}

            <div class="card-body">
                {if count($requests) > 0}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <th>PAID AT</th>
                                    <th>DONE ORDERS</th>
                                    <th>APPROVED ORDERS</th>
                                    <th>TOTAL</th>
                                    <th>ORDERS</th>
                                    <th>STATUS</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $requests as $request}
                                    <tr>
                                        <td>
                                            <span class="js_moment" data-time="{$request.paid_at}">{$request.paid_at}</span>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-success">${$request.total_done_pay}</strong>
                                        <td class="text-right">
                                            <strong class="text-success">${$request.total_completed_pay}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong class="text-success">${$request.total_pay}</strong>
                                        </td>
                                        <td>
                                            <span class="text-link" data-toggle="modal" data-url="/user/payment-requests/{$request.payment_request_id}">Show</span>
                                        </td>
                                        <td>
                                            {if $request.status == "0"}
                                                <span class="label label-warning">Pending</span>
                                            {elseif $request.status == "1"}
                                                <span class="label label-success">Paid</span>
                                            {elseif $request.status == "-1"}
                                                <span class="label label-danger">Declined</span>
                                            {/if}
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb20" width="15%" src="/static/images/no_results.png">
                        <p class="mb10"><strong>The list is empty.</strong></p>
                    </div>
                {/if}
            </div>

        {/if}

    </div>
{/block}