<!doctype html>
<html lang="en-US">
  	<head>
		{block name='head'}
			{include file='_partials/head.tpl'}
		{/block}
	</head>

	<body class="nk-body bg-lighter npc-general has-sidebar {$body_classes|classnames} {if $theme_mode_night}dark-mode{/if}">
		<div class="nk-app-root"> 

            <div class="nk-app-root">
                <!-- main @s -->
                <div class="nk-main ">
                    <!-- wrap @s -->
                    <div class="nk-wrap nk-wrap-nosidebar">
                        <!-- content @s -->
                        <div class="nk-content ">
                            <div class="nk-block nk-block-middle nk-auth-body">
                                <div class="brand-logo pb-4">
                                    <a href="{$base_uri}" class="logo-link">
                                        {if $site_logo}
                                            <img class="logo-light logo-img logo-img-lg" src="{$uploads_path}/{$site_logo}./images/logo.png" srcset="{$uploads_path}/{$site_logo} 2x" alt="logo">
                                            <img class="logo-dark logo-img logo-img-lg" src="{$uploads_path}/{$site_logo}" srcset="{$uploads_path}/{$site_logo} 2x" alt="logo-dark">
                                        {else}
                                            {$site_name}
                                        {/if}
                                    </a>
                                </div>
                                <div class="nk-block-head">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title mb-3">Hi {$user.first_name},</h4>
                                        <div class="nk-block-des text-dark mb-3">
                                            <p>You currently can't access the dashboard. We will process your request and get back to you soon.</p> 
                                            <p>If you think this is an error please contact us at <strong>{$site_email}</strong>.</p>
                                        </div>

                                        <a href="{$base_uri}/logout" class="btn btn-lg btn-primary btn-block">Sign out</a>
                                    </div>
                                </div>
                            </div>
                            <div class="nk-footer nk-auth-footer-full">
                                <div class="container wide-lg">
                                    <div class="nk-block-content text-center text-lg-left">
                                        <p class="text-soft">&copy; {date('Y')} {$site_name}. All Rights Reserved.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- wrap @e -->
                    </div>
                    <!-- content @e -->
                </div>
                <!-- main @e -->
            </div>

        </div>
        
    </body>

    {include file="_partials/_js_files.tpl"}

    {if $user.logged}
        <!-- Notification -->
        <audio id="notification_sound" preload="auto">
            <source src="{$base_uri}/static/sounds/notification.mp3" type="audio/mpeg">
        </audio>
        <!-- Notification -->
        <!-- Chat -->
        <audio id="chat_sound" preload="auto">
            <source src="{$base_uri}/static/sounds/chat.mp3" type="audio/mpeg">
        </audio>
        <!-- Chat -->
    {/if}

    {block name='hook_footer_after'}
        {hook h='displayFooterAfter'}
    {/block}

</html>