{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}

    {if $sub_view == "coupons"}

        <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Coupons
                            {if $sub_view == "edit"} &rsaquo; <strong class="text-primary small">{$coupon.coupon_code}</strong>{/if}
                            {if $sub_view == "add"} &rsaquo; <strong class="text-primary small">Add New</strong>{/if}
                        </h3>
                    </div>
                    <!-- .nk-block-head-content -->

                    {if $sub_view == "coupons"}
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                                <div class="toggle-expand-content" data-content="more-options">
                                    <ul class="nk-block-tools g-3">
                                        <li class="nk-block-tools-opt">
                                            <a href="{$base_uri}/coupons/add" data-ajax="/coupons/add" class="btn btn-icon btn-primary d-md-none">
                                                <em class="icon ni ni-plus"></em>
                                            </a>
                                            <a href="{$base_uri}/coupons/add" data-ajax="/coupons/add" class="btn btn-primary d-none d-md-inline-flex">
                                                <em class="icon ni ni-plus"></em><span>Add Coupon</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- .nk-block-head-content -->
                    {/if}
                </div>
                <!-- .nk-block-between -->
            </div>

            <div class="nk-block">
                {if count($coupons)}
                    <table class="nk-tb-list is-separate nk-tb-ulist mb-3">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th class="nk-tb-col">
                                    <span class="sub-text">Coupon</span>
                                </th>
                                <th class="nk-tb-col tb-col-md">Site Name</th>
                                <th class="nk-tb-col tb-col-md">Type</th>
                                <th class="nk-tb-col">Value</th>
                                <th class="nk-tb-col tb-col-md">Expiry</th>
                                <th class="nk-tb-col">Status</th>
                                <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $coupons as $coupon}
                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col">
                                        <a class="fw-bold" href="{$base_uri}/coupons/edit/{$coupon.id}" data-ajax="/coupons/edit/{$coupon.id}">{$coupon.coupon_code}</a>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        {$coupon.site_name}</td>
                                    <td class="nk-tb-col">{$coupon.coupon_type}

                                    </td>
                                    <td class="nk-tb-col fw-bold tb-col-md">
                                        {$coupon.coupon_value}
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <span class="js_moment" data-time="{$coupon.expiry}">{$coupon.expiry}<span>
                                    </td>
                                    <td class="nk-tb-col fw-bold">
                                        {if $coupon.active}
                                            <span class="badge badge-dot badge-success">Active</span>
                                        {else}
                                            <span class="badge badge-dot badge-danger">Inactive</span>
                                        {/if}
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <ul class="nk-tb-actions gx-1">
                                            <li>
                                                <div class="dropdown">
                                                    <button class="dropdown-toggle btn btn-sm btn-icon btn-trigger" data-toggle="dropdown" type="button" id="dropdownMenu-{$coupon.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <em class="icon ni ni-more-h"></em>
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" aria-labelledby="dropdownMenu-{$coupon.id}">
                                                        <ul class="link-list-opt no-bdr">
                                                            <li>
                                                                <a href="{$base_uri}/coupons/edit/{$coupon.id}" data-ajax="/coupons/edit/{$coupon.id}">
                                                                    <em class="icon ni ni-edit"></em> <span>Edit</span>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a class="js_deleter" href="javascript:void(0);" data-handle="coupon" data-id="{$coupon.id}">
                                                                    <em class="icon ni ni-trash"></em> <span>Delete</span>
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    <div class="nk-block-between-md g-3">
                        <div class="g">
                            {$pager nofilter}
                        </div>
                    </div><!-- .nk-block-between -->
                    
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">No coupons to show</h6>
                    </div>
                {/if}
            </div>
        </div>

    {elseif $sub_view == "edit"}

        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/coupons" data-ajax="/coupons">
                            <em class="icon ni ni-arrow-left"></em><span>Coupons</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Edit coupon</h2>
                </div>
            </div>
        
            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms" data-url="/admin/coupon?do=edit" autocomplete="off">
                        <input type="hidden" name="coupon_id" value="{$coupon.id}"/>

                        <div class="form-group mb-2">
                            <label class="form-label" for="site_id">Site Name</label>
                            <select class="form-select" data-ui="lg" name="site_id" id="site_id">
                                <option value="0" disabled>Select website</option>
                                {foreach $sites as $site}
                                    <option value="{$site.site_id}" {if $site.site_id == $coupon.site_id}selected=""{/if}>{$site.name}</option>
                                {/foreach}
                            </select>
                        </div>
        
                        <div class="form-group mb-2">
                            <label class="form-label" for="coupon_code">Coupon Code</label>
                            <input type="text" class="form-control form-control-lg" name="coupon_code" id="coupon_code" value="{$coupon.coupon_code}">
                        </div>
        
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-label" for="coupon_type">Coupon Type</label>
                                <select class="form-select" name="coupon_type" data-ui="lg" data-combo="coupon_type">
                                    <option value="1" {if $coupon.coupon_type == "1"}selected=''{/if}>Percent</option>
                                    <option value="3" {if $coupon.coupon_type == "3"}selected=''{/if}>Amount</option>
                                    <option value="9" {if $coupon.coupon_type == "9"}selected=''{/if}>Fixed CPP</option>
                                    <option value="5" {if $coupon.coupon_type == "5"}selected=''{/if}>Free Unit</option>
                                    <option value="7" {if $coupon.coupon_type == "7"}selected=''{/if}>Writer Category</option>
                                </select>
                            </div>
        
                            <div class="col-md-6" id="coupon_type">
                                <div {if $coupon.coupon_type == "1"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="1">
                                    <div class="form-group">
                                        <label class="form-label" for="coupon_percent">Percentage</label>
                                        <div class="form-control-wrap">
                                            <div class="form-icon lg form-icon-right">
                                                <em class="icon ni ni-percent"></em>
                                            </div>
                                            <input type="text" class="form-control form-control-lg force-integer" name="coupon_percent" value="{$coupon.coupon_value}">
                                        </div>
                                    </div>
                                </div>
            
                                <div {if $coupon.coupon_type == "3"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="3">
                                    <div class="form-group">
                                        <label class="form-label" for="coupon_amount">Amount</label>
                                        <div class="form-control-wrap">
                                            <div class="form-icon lg form-icon-left">
                                                <em class="icon ni ni-sign-dollar"></em>
                                            </div>
                                            <input type="text" class="form-control form-control-lg force-integer" name="coupon_amount" value="{$coupon.coupon_value}">
                                        </div>
                                    </div>
                                </div>
                                
                                <div {if $coupon.coupon_type == "5"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="5">
                                    <div class="form-group">
                                        <label class="form-label">Free Unit</label>
                                        <select  class="form-select" data-ui="lg" name="service_type_id">
                                            <option value="3" {if $coupon.service_type_id == "3"}selected=''{/if}>Writer Category</option>
                                            <option value="21" {if $coupon.service_type_id == "21"}selected=''{/if}>Used Sources</option>
                                            <option value="4" {if $coupon.service_type_id == "4"}selected=''{/if}>Writer Samples</option>
                                            <option value="37" {if $coupon.service_type_id == "37"}selected=''{/if}>Complex Assignment</option>
                                            <option value="41" {if $coupon.service_type_id == "41"}selected=''{/if}>Expert Proofreading</option>
                                            <option value="5" {if $coupon.service_type_id == "5"}selected=''{/if}>Progressive Delivery</option>
                                        </select>
                                    </div>
                                </div>

                                <div {if $coupon.coupon_type == "7"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="7">
                                    <div class="form-group">
                                        <label class="form-label">Writer Category</label>
                                        <select class="form-select" data-ui="lg" name="writer_category_id">
                                            <option value="3" {if $coupon.writer_category_id == "3"}selected=''{/if}>ESL advanced</option>
                                            <option value="4" {if $coupon.writer_category_id == "4"}selected=''{/if}>ENL (English Native Language)</option>
                                        </select>
                                    </div>
                                </div>

                                <div {if $coupon.coupon_type == "9"} class="switch-combo" {else} class="x-hidden switch-combo" {/if} data-combo-value="9">
                                    <div class="form-group">
                                        <label class="form-label" for="coupon_cpp_amount">Cost Per Page</label>
                                        <div class="form-control-wrap">
                                            <div class="form-icon lg form-icon-left">
                                                <em class="icon ni ni-sign-dollar"></em>
                                            </div>
                                            <input type="text" class="form-control form-control-lg force-integer" name="coupon_cpp_amount" value="{$coupon.coupon_value}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-label" for="coupon_amount">Customer ID</label>
                                <div class="form-control-wrap">
                                    <div class="form-icon lg form-icon-left">
                                        <em class="icon ni ni-user"></em>
                                    </div>
                                    <input type="text" class="form-control form-control-lg force-integer" name="user_id" {if $coupon.user_id}value="{$coupon.user_id}"{/if}>
                                </div>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="form-label" for="coupon_amount">Order ID</label>
                                <div class="form-control-wrap">
                                    <div class="form-icon lg form-icon-left">
                                        <em class="icon ni ni-bag"></em>
                                    </div>
                                    <input type="text" class="form-control form-control-lg force-integer" name="order_id" {if $coupon.order_id}value="{$coupon.order_id}"{/if}>
                                </div>
                            </div>
                        </div>
        
                        <div class="form-group mb-4">
                            <label class="form-label" for="coupon_expiry">Expiry</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-right">
                                    <em class="icon ni ni-calendar-alt"></em>
                                </div>
                                <input type="text" class="form-control form-control-lg date-time-picker" name="coupon_expiry" id="coupon_expiry" value='{$coupon.expiry|date_format:"%d/%m/%Y %H:%I:%S %p"}'>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox checked">
                                <input type="checkbox" class="custom-control-input" id="one_time" name="one_time" {if $coupon.one_time}checked="checked"{/if}>
                                <label class="custom-control-label" for="one_time">One-time use</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox checked">
                                <input type="checkbox" class="custom-control-input" id="active" name="active" {if $coupon.active}checked="checked"{/if}>
                                <label class="custom-control-label" for="active">Active</label>
                            </div>
                        </div>

                        <!-- error -->
                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                        <!-- error -->
        
                        <!-- success -->
                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                        <!-- success -->
        
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary btn-lg">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    {elseif $sub_view == "add"}
        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/coupons" data-ajax="/coupons">
                            <em class="icon ni ni-arrow-left"></em><span>Coupons</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Add new coupon</h2>
                </div>
            </div>

            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms" data-url="/admin/coupon?do=add" autocomplete="off">
                        <div class="form-group mb-2">
                            <label class="form-label" for="site_id">Site Name</label>
                            <select class="form-select" data-ui="lg" name="site_id" id="site_id">
                                <option value="0" disabled>Select website</option>
                                {foreach $sites as $site}
                                    <option value="{$site.site_id}">{$site.name}</option>
                                {/foreach}
                            </select>
                        </div>

                        <div class="form-group mb-2">
                            <label class="form-label" for="coupon_code">Coupon Code</label>
                            <input type="text" class="form-control form-control-lg" name="coupon_code" id="coupon_code">
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-label" for="coupon_type">Coupon Type</label>
                                <select class="form-select" name="coupon_type" data-ui="lg" data-combo="coupon_type">
                                    <option value="1" selected="">Percent</option>
                                    <option value="3">Amount</option>
                                    <option value="5">Free Unit</option>
                                    <option value="7">Writer Category</option>
                                    <option value="9">Fixed CPP</option>
                                </select>
                            </div>

                            <div class="form-group col-md-6" id="coupon_type">
                                <div class="switch-combo" data-combo-value="1">
                                    <div class="form-group">
                                        <label class="form-label" for="coupon_percent">Percentage</label>
                                        <div class="form-control-wrap">
                                            <div class="form-icon lg form-icon-right">
                                                <em class="icon ni ni-percent"></em>
                                            </div>
                                            <input type="text" class="form-control form-control-lg force-integer" name="coupon_percent">
                                        </div>
                                    </div>
                                </div>

                                <div class="switch-combo x-hidden" data-combo-value="3">
                                    <div class="form-group">
                                        <label class="form-label" for="coupon_amount">Amount</label>
                                        <div class="form-control-wrap">
                                            <div class="form-icon lg form-icon-left">
                                                <em class="icon ni ni-sign-dollar"></em>
                                            </div>
                                            <input type="text" class="form-control form-control-lg force-integer" name="coupon_amount">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="switch-combo x-hidden" data-combo-value="5">
                                    <div class="form-group">
                                        <label class="form-label">Free Unit</label>
                                        <select  class="form-select" data-ui="lg" name="service_type_id">
                                            <option value="3">Writer Category</option>
                                            <option value="21">Used Sources</option>
                                            <option value="4">Writer Samples</option>
                                            <option value="37">Complex Assignment</option>
                                            <option value="41">Expert Proofreading</option>
                                            <option value="5">Progressive Delivery</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="switch-combo x-hidden" data-combo-value="7">
                                    <div class="form-group">
                                        <label class="form-label">Writer Category</label>
                                        <select class="form-select" data-ui="lg" name="writer_category_id">
                                            <option value="3">ESL advanced</option>
                                            <option value="4">ENL (English Native Language)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="switch-combo x-hidden" data-combo-value="9">
                                    <div class="form-group">
                                        <label class="form-label" for="coupon_cpp_amount">Cost Per Page</label>
                                        <div class="form-control-wrap">
                                            <div class="form-icon lg form-icon-left">
                                                <em class="icon ni ni-sign-dollar"></em>
                                            </div>
                                            <input type="text" class="form-control form-control-lg force-integer" name="coupon_cpp_amount">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-2">
                            <label class="form-label" for="coupon_expiry">Expiry</label>
                            <div class="form-control-wrap">
                                <div class="form-icon lg form-icon-right">
                                    <em class="icon ni ni-calendar-alt"></em>
                                </div>
                                <input type="text" class="form-control form-control-lg date-time-picker" name="coupon_expiry" id="coupon_expiry">
                            </div>
                        </div>

                        <!-- error -->
                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                        <!-- error -->

                        <!-- success -->
                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                        <!-- success -->

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary btn-lg">Add Coupon</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    {/if}
{/block}