{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Financial overview</h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        {if $sub_view == "unrequested" && ( ($user.is_writer || $user.is_editor) || ($user.is_sub_admin && $order_manager_enabled))}
            <div class="nk-block">  
                <div class="row">
                    <div class="col-md-6">
                        <div class="alert alert-success">
                            <div class="d-flex justify-content-between align-items-center">
                                <strong class="fs-16px">Your Balance: <span class="ml-2 {if $total_pay < 0}text-danger{else}text-dark{/if}">{formatPrice($total_pay, $currencyFormat)}</span></strong>
                                <button type="button" class="btn btn-success {if $can_request_payment}js_request-payment{else}disabled{/if}">
                                    <i class="icon ni ni-check"></i> <span>Request Payment</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <p class="mb-1">You can request payments on <strong>{$payment_dates}</strong> (start-end at 8 PM (GMT+0))</p>
                        <p class="mb-0">Check our <a  href="{$base_uri}/guides/payment-guide" data-ajax="/guides/payment-guide">Payment Guide</a> for more details.</p>
                    </div>
                </div>
            </div>
        {/if}

        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "unrequested"}active{/if}" href="{$base_uri}/financial-overview/unrequested" data-ajax="/financial-overview/unrequested"> 
                                <span>Unrequested</span>
                            </a>
                        </li>
                        <li class="nav-item"> 
                            <a class="nav-link {if $sub_view == "requested"}active{/if}" href="{$base_uri}/financial-overview/requested" data-ajax="/financial-overview/requested">
                                <span>Requests</span>
                            </a> 
                        </li>
                        <li class="nav-item"> 
                            <a class="nav-link {if $sub_view == "history"}active{/if}" href="{$base_uri}/financial-overview/history" data-ajax="/financial-overview/history">
                                <span>History</span>
                            </a> 
                        </li>

                        {hook h='displayFinancialOverviewNavbar'}
                    </ul>
 
                    {if $sub_view == "unrequested"}

                        {if count($orders) > 0}
                            <div class="border border-light rounded">
                                <table class="table table-tranx is-compact mb-0">
                                    <thead>
                                        <tr class="tb-tnx-head">
                                            <th class="tb-tnx-info">DATE</th>
                                            <th class="tb-tnx-info">ORDER</th>
                                            <th class="tb-tnx-info">TRANSACTION TYPE</th>
                                            <th class="tb-tnx-info">COMMENTS</th>
                                            <th class="tb-tnx-info">AMOUNT</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {foreach $orders as $order}
                                            <tr class="tb-tnx-item">
                                                <td class="tb-tnx-info">
                                                    {if $order.status == "10"}
                                                        <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                                                    {elseif $order.status == "11"}
                                                        <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                                                    {/if}
                                                </td>
                                                <td class="tb-tnx-info">
                                                    <strong><a target="_blank" href="{$base_uri}/order/{$order.id}">#{$order.referenceId}</a></strong>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    {if $order.status == "10"}
                                                        <strong>Approved</strong>
                                                    {elseif $order.status == "11"}
                                                        <strong>Completed</strong> 
                                                    {/if} 
                                                    {" - "}
                                                    {if $order.isProgramming || $order.isCalculations}
                                                        {$order.serviceTypeTitle}
                                                    {elseif $order.isArticleWriting}
                                                        {pluralize('word', $order.words)}
                                                    {else}
                                                        {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                                                        {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                                                        {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                                                        {if $order.excelSheets} {pluralize('excel sheet', $order.excelSheets)} {/if} 
                                                    {/if}
                                                </td>
                                                {if $order.isProgramming || $order.isCalculations}
                                                    <td class="tb-tnx-info">{$order.topicCategory}</td>
                                                {elseif $order.isArticleWriting}
                                                    <td class="tb-tnx-info">{$order.disciplineTitle}</td>
                                                {else}
                                                    <td class="tb-tnx-info">{$order.topicCategory}</td>
                                                {/if}
                                                <td class="tb-tnx-info">
                                                    {if $user.is_sub_admin}
                                                        <strong class="text-success">+ {$order.orderManagerPayFormatted}</strong>
                                                    {elseif $user.is_writer}
                                                        <strong class="text-success">+ {$order.writerPayFormatted}</strong>
                                                    {elseif $user.is_editor}
                                                        <strong class="text-success">+ {$order.editorPayFormatted}</strong>
                                                    {else}
                                                        <strong class="text-danger">+ $0.00</strong>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                    <tfoot class="tb-odr-foot">
                                        {if $pay_delivered_orders}
                                            <tr style="display: table-row;">
                                                <th class="tb-tnx-info text-right align-middle" align="right" colspan="4">
                                                    <span>Completed orders:</span>
                                                </th>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-success">+ {formatPrice($done_orders_pay, $currencyFormat)}</strong>
                                                </td>
                                            </tr>
                                        {/if}
                                        <tr style="display: table-row;">
                                            <th class="tb-tnx-info text-right align-middle" align="right" colspan="4">Approved orders:</th>
                                            <td class="tb-tnx-info">
                                                <strong class="text-success">+ {formatPrice($completed_orders_pay, $currencyFormat)}</strong>
                                            </td>
                                        </tr>
                                        {if $has_employee_credit || $has_employee_fine}
                                            <tr style="display: table-row;">
                                                <th class="tb-tnx-info text-right align-middle" align="right" colspan="4">Sub Total:</th>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-success">+ {formatPrice($subtotal_pay, $currencyFormat)}</strong>
                                                </td>
                                            </tr>
                                        {/if}
                                        {if $has_employee_credit}
                                            <tr style="display: table-row;">
                                                <th class="tb-tnx-info text-right align-middle" align="right" colspan="4">Credit:</th>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-warning">+ {formatPrice($employee_credit, $currencyFormat)}</strong>
                                                </td>
                                            </tr>
                                        {/if}
                                        {if $has_employee_fine}
                                            <tr style="display: table-row;">
                                                <th class="tb-tnx-info text-right align-middle" align="right" colspan="4">Fine:</th>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-danger">- {formatPrice($employee_fine, $currencyFormat)}</strong>
                                                </td>
                                            </tr>
                                        {/if}
                                        <tr style="display: table-row;">
                                            <th class="tb-tnx-info text-right align-middle" align="right" colspan="4">Total:</th>
                                            <td class="tb-tnx-info">
                                                <strong class="{if $total_pay < 0}text-danger{else}text-success{/if}">{formatPrice($total_pay, $currencyFormat)}</strong>
                                            </td>
                                        </tr>
                                    </tfoot>
                                    
                                </table>
                            </div>

                            <div class="nk-block-between-md g-3">
                                <div class="g">
                                    {$pager nofilter}
                                </div>
                            </div><!-- .nk-block-between -->
                        {else}
                            <div class="text-center x-muted py-5">
                                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                <h6 class="text-dark title mb-3">No orders to show</h6>
                            </div>
                        {/if}

                    {elseif $sub_view == "requested"}

                        {if count($requests) > 0}
                            <div class="border border-light rounded">
                                <table class="table table-tranx is-compact mb-0">
                                    <thead>
                                        <tr class="tb-tnx-head">
                                            <th class="tb-tnx-info">DATE</th>
                                            <th class="tb-tnx-info">DONE ORDERS</th>
                                            <th class="tb-tnx-info">APPROVED ORDERS</th>
                                            <th class="tb-tnx-info">TOTAL</th>
                                            <th class="tb-tnx-info">ORDERS</th>
                                            <th class="tb-tnx-info">STATUS</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-odr-body">
                                        {foreach $requests as $request}
                                        <tr class="tb-tnx-item">
                                                <td class="tb-tnx-info fw-bold">
                                                    <span class="js_moment" data-time="{$request.date_add}">{$request.date_add}</span>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-success">{formatPrice($request.total_done_pay, $currencyFormat)}</strong>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-success">{formatPrice($request.total_completed_pay, $currencyFormat)}</strong>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    <strong class="text-success">{formatPrice($request.total_pay, $currencyFormat)}</strong>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    {if $request.status == "-1"}
                                                        <span>N/A</span>
                                                    {else}
                                                        <button class="btn btn-secondary btn-sm" data-toggle="modal" data-size="large" data-url="/user/payment-requests/{$request.payment_request_id}">
                                                            <i class="icon ni ni-eye"></i><span>Show</span>
                                                        </button>
                                                    {/if}
                                                </td>
                                                <td class="tb-tnx-info">
                                                    {if $request.status == "0"}
                                                        <span class="badge badge-dot badge-warning">Pending</span>
                                                    {elseif $request.status == "1"}
                                                        <span class="badge badge-dot badge-success">Paid</span>
                                                    {elseif $request.status == "-1"}
                                                        <span class="badge badge-dot badge-danger">Declined</span>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
                            </div>

                            <div class="nk-block-between-md g-3">
                                <div class="g">
                                    {$pager nofilter}
                                </div>
                            </div><!-- .nk-block-between -->
                        {else}
                            <div class="text-center x-muted py-5">
                                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                <h6 class="text-dark title mb-3">No orders to show</h6>
                            </div>
                        {/if}

                    {elseif $sub_view == "history"}

                        {if count($requests) > 0}
                            <div class="border border-light rounded">
                                <table class="table table-tranx is-compact mb-0">
                                    <thead>
                                        <tr class="tb-tnx-head">
                                            <th class="tb-tnx-info">PAID AT</th>
                                            <th class="tb-tnx-info">DONE ORDERS</th>
                                            <th class="tb-tnx-info">APPROVED ORDERS</th>
                                            <th class="tb-tnx-info">TOTAL</th>
                                            <th class="tb-tnx-info">ORDERS</th>
                                            <th class="tb-tnx-info">STATUS</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {foreach $requests as $request}
                                            <tr class="tb-tnx-item {if $request.status == "-1"}danger{/if}">
                                                <td class="tb-tnx-info fw-bold">
                                                    {if $request.status == "-1"} 
                                                        <strong class="text-danger">Declined</strong>
                                                    {else} 
                                                        <span class="js_moment" data-time="{$request.paid_at}">{$request.paid_at}</span> 
                                                    {/if}
                                                </td>
                                                <td class="tb-tnx-info">
                                                    <strong class="{if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_done_pay, $currencyFormat)}</strong>
                                                <td class="tb-tnx-info">
                                                    <strong class="{if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_completed_pay, $currencyFormat)}</strong>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    <div class="tb-tnx-total">
                                                        <span class="amount {if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_pay, $currencyFormat)}</span>
                                                    </div>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    <button class="btn btn-secondary btn-sm" data-toggle="modal" data-size="large" data-url="/user/payment-requests/{$request.payment_request_id}">
                                                        <i class="icon ni ni-eye"></i><span>Show</span>
                                                    </button>
                                                </td>
                                                <td class="tb-tnx-info">
                                                    {if $request.status == "0"}
                                                        <span class="badge badge-dot badge-warning">Pending</span>
                                                    {elseif $request.status == "1"}
                                                        <span class="badge badge-dot badge-success">Paid</span>
                                                    {elseif $request.status == "-1"}
                                                        <span class="badge badge-dot badge-danger">Declined</span>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>

                                <div class="nk-block-between-md g-3">
                                    <div class="g">
                                        {$pager nofilter}
                                    </div>
                                </div><!-- .nk-block-between -->
                            </div>
                        {else}
                            <div class="text-center x-muted py-5">
                                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                <h6 class="text-dark title mb-3">No orders to show</h6>
                            </div>
                        {/if}

                    {else} 
                        {hook h='displayFinancialOverviewNavContent'}
                    {/if}
                </div>
            </div>
        </div>
    </div>
{/block}