{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 

    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">

        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    {if $sub_view == "writing-guide"}
                        <h3 class="nk-block-title page-title">Writing Guide</h3> 
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_guides} writing guides.</p>
                        </div>
                    {elseif $sub_view == "payment-guide"}
                        <h3 class="nk-block-title page-title">Payment Guide</h3> 
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_guides} payment guides.</p>
                        </div>
                    {elseif $sub_view == "faqs"}
                        <h3 class="nk-block-title page-title">FAQs</h3> 
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_guides} faqs.</p>
                        </div>
                    {elseif $sub_view == "software-programming"}
                        <h3 class="nk-block-title page-title">Software &amp; Programming</h3> 
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_rows} items.</p>
                        </div>
                    {/if}
                </div>
                
                <div class="nk-block-head-content">
                    {if $sub_view == "writing-guide"}
                        <a href="{$base_uri}/info/writing-guide/add" data-ajax="/info/writing-guide/add" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Writing Guide</span>
                        </a>
                    {elseif $sub_view == "payment-guide"}
                        <a href="{$base_uri}/info/payment-guide/add" data-ajax="/info/payment-guide/add" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Payment Guide</span>
                        </a>
                    {elseif $sub_view == "faqs"}
                        <a href="{$base_uri}/info/faqs/add" data-ajax="/info/faqs/add" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add FAQ</span>
                        </a>
                    {elseif $sub_view == "software-programming"}
                        <button data-toggle="modal" data-url="#modalAddSoftwareProgramming" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Item</span>
                        </button>
                    {/if}
                    
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div> 

        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    
                    {if $sub_view == "writing-guide" || $sub_view == "payment-guide" || $sub_view == "faqs"}

                        {if count($guides)}
                            <div class="card-inner-group">
                                <div class="card-inner p-0">
                                    <table class="table table-tranx">
                                        <thead>
                                            <tr class="tb-tnx-head">
                                                <th>Title</th>
                                                <th class="tb-tnx-action">Actions</th>
                                            </tr>
                                        </thead> 
                                        <tbody>
                                            {foreach $guides as $guide}
                                                <tr class="tb-tnx-item">
                                                    <td>
                                                        {$guide.title}
                                                    </td>
                                                    <td class="tb-tnx-action">
                                                        <div class="drodown">
                                                            <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                                                                Actions
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li>
                                                                        <a href="{$base_uri}/info/{$sub_view}/edit/{$guide.id}" data-ajax="/info/{$sub_view}/edit/{$guide.id}">
                                                                            <em class="icon ni ni-eye"></em><span>Edit</span>
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="js_deleter" href="javascript:void(0);" data-handle="writing_guide" data-id="{$guide.id}">
                                                                            <em class="icon ni ni-trash"></em><span>Delete</span>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>

                                {if $pager}
                                    <div class="card-inner">
                                        {$pager nofilter}
                                    </div>
                                {/if}
                            </div>
                        {else}
                            <div class="text-center x-muted py-5"> 
                                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                {if $sub_view == "writing-guide"}
                                    <p class="mb10"><strong>No writing guides to show</strong></p>
                                {elseif $sub_view == "payment-guide"}
                                    <p class="mb10"><strong>No payment guides to show</strong></p>
                                {elseif $sub_view == "faqs"}
                                    <p class="mb10"><strong>No FAQs to show</strong></p>
                                {/if}
                            </div>
                        {/if}

                    {elseif $sub_view == "software-programming"}

                        {if count($rows)}
                            <div class="card-inner-group">
                                <div class="card-inner p-0">
                                    <table class="table table-tranx">
                                        <thead>
                                            <tr class="tb-tnx-head">
                                                <th>Title</th>
                                                <th class="tb-tnx-action">Actions</th>
                                            </tr>
                                        </thead> 
                                        <tbody>
                                            {foreach $rows as $row}
                                                <tr class="tb-tnx-item">
                                                    <td>
                                                        {$row.title}
                                                    </td>
                                                    <td class="tb-tnx-action">
                                                        <div class="drodown">
                                                            <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                                                                Actions
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li>
                                                                        <a href="javascript:void(0);" data-toggle="modal" data-url="#modalEditSoftwareProgramming" data-options='{$row|json_encode}'>
                                                                            <em class="icon ni ni-eye"></em><span>Edit</span>
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a class="js_deleter" href="javascript:void(0);" data-handle="software_programming" data-id="{$row.software_programming_id}">
                                                                            <em class="icon ni ni-trash"></em><span>Delete</span>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>
                                </div>

                                {if $pager}
                                    <div class="card-inner">
                                        {$pager nofilter}
                                    </div>
                                {/if}
                            </div>
                        {else}
                            <div class="text-center x-muted py-5"> 
                                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                <p class="mb10"><strong>No items to show</strong></p>
                            </div>
                        {/if}

                    {/if}

                </div>
            </div>
        </div>

    </div>

    <!-- Add Software & Programming -->
    <script id="modalAddSoftwareProgramming" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/info/software-programming/add" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Software or Programming Language</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Item</button>
            </div>
        </form>
    </script>
    <!-- Add Software & Programming -->

    <!-- Edit Software & Programming -->
    <script id="modalEditSoftwareProgramming" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/info/software-programming/edit" method="POST" autocomplete="off">
            <input type="hidden" name="item_id" value="{literal}{{software_programming_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit {literal}{{title}}{/literal}</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div> 

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Title</label>
                    <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
                </div>

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Edit Software & Programming -->

{/block}