{if $ajax_page}
    <meta name="pagetitle" data-content="{$page_title}">
	{if isset($full_app)}
    	<meta name="fullapp" data-content="true">
	{/if}
	{include file='dashboard/layout.body.tpl'}
{else}
	<!doctype html>
	<html lang="en-US">
		<head>
			{block name='head'}
				{include file='_partials/head.tpl'}
			{/block}
		</head>

		<body class="nk-body bg-lighter npc-general has-sidebar {$themeOptions.style} {$body_classes|classnames} {if $theme_mode_night}dark-mode{else}light-mode{/if}">

			<div class="nk-app-root">
                <!-- main @s -->
                <div class="nk-main">

                    {block name='sidebar'}
                        {include file='_partials/sidebar.tpl'}
                    {/block}

                    <!-- wrap @s -->
                    <div class="nk-wrap">
						{block name='header'}
							{include file='_partials/header.tpl'}
						{/block}

						{include file='dashboard/layout.body.tpl'}
                    </div>
                    <!-- wrap @e -->

                </div>
                <!-- main @e -->
            </div>
            <!-- app-root @e -->

			<div class="barloading"></div>
		</body>

		{if $user.logged}
			<!-- Notification -->
			<audio class="js_audio" id="notification_sound" preload="auto">
				<source src="{$base_uri}/static/sounds/notification.mp3" type="audio/mpeg">
			</audio>
			<!-- Notification -->
			<!-- Chat -->
			<audio class="js_audio" id="chat_sound" preload="auto">
				<source src="{$base_uri}/static/sounds/chat.mp3" type="audio/mpeg">
			</audio>
			<!-- Chat -->
		{/if}

		{include file="_partials/_js_files.tpl"}

		{literal}
		<script type="text/javascript">
			$(function() {

				$(document).on('click', 'a[data-ajax]', function(e) {
					e.preventDefault();
					var _this = $(this);

					startLoadingBar();
					var pageContainer = $('.nk-content');
					var url = $(this).attr('data-ajax');
					var originalURL = `${base_uri+url}`;
					url = new URL(originalURL);
					url.searchParams.set('ajaxpage', 1);

					$.get(url, function (data) { 
						if(_this.hasClass('nk-menu-link')) {
							var _parent = _this.parent();

							$('.nk-menu-item').removeClass('active current-page');

							if(_this.parents('.nk-menu-sub').length) {
								var subMenu = _this.parents('.nk-menu-sub');
								_parent = subMenu.parent();
								_this.parent().addClass('active current-page');
							} else {
								$('.nk-menu-sub').slideUp();
							}

							_parent.addClass('active current-page');
						}
						
						var htmlPage = $(data).filter('.nk-content').html();
						pageContainer.html(htmlPage);
						$('[role=tooltip]').tooltip('dispose');
						
						initialize();

						if(typeof initialize_modal === "function") {
							initialize_modal();
						}

						NioApp.ajaxPageLoad();

						window.history.pushState({state:'new'},'', originalURL);
						window.onpopstate = function(event) {
							$(window).unbind('popstate');
							window.location.href = document.location;
						};

						if( $(data).filter('[name="fullapp"]').length ) {
							pageContainer.addClass('p-0');

							if($('.chat-sidebar')) {
								$('.chat-sidebar').addClass('closed');
							}
						} else {
							pageContainer.removeClass('p-0');
						}

						document.title = $(data).filter('[name="pagetitle"]').data('content');
						$("html, body").animate({ scrollTop: 0 }, 150);
						stopLoadingBar();
					});

				});
			}); 
		</script>
		{/literal}

	</html>
{/if}