{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 

    {if $sub_view == "mails"}
        <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">
                            Mailing / <strong class="text-primary small">Mails</strong>
                            {if $sub_view == "send"} &rsaquo; <strong class="text-primary small">Send</strong>{/if}
                            {if $sub_view == "templates"} &rsaquo; <strong class="text-primary small">Templates {if $_tab == "add"} &rsaquo; Add {/if}</strong>{/if}
                        </h3> 
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_mails} Mails.</p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        {if $sub_view == "mails"}
                            <a href="{$base_uri}/mailing/add" data-ajax="/mailing/add" class="btn btn-primary"> 
                                <em class="icon ni ni-plus"></em> <span>Add New Mail</span>
                            </a> 
                        {elseif $sub_view == "templates"}
                            {if $_tab == "templates"}
                                <a href="{$base_uri}/mailing/templates" data-ajax="/mailing/templates/add" class="btn btn-primary">
                                    <em class="icon ni ni-plus"></em> <span>Add New Templete</span>
                                </a>
                            {/if}
                        {/if}
                    </div>
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>
            
            <div class="nk-block">  
                {include file="dashboard/mailing/$sub_view.tpl"}
            </div>
        </div>  
    {elseif $sub_view == "add"}
        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/mailing/mails" data-ajax="/mailing/mails">
                            <em class="icon ni ni-arrow-left"></em><span>Mails</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Add New</h2>
                </div>
            </div>
        
            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms form-horizontal" data-url="/admin/mailing?do=add_mail" autocomplete="off">
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Name (optional)</label>
                            <div class="col-sm-9">  
                                <input class="form-control form-control-lg" type="text" name="name" required="">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Email</label>
                            <div class="col-sm-9">  
                                <input class="form-control form-control-lg" type="text" name="email" required="">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Site ID</label>
                            <div class="col-sm-9">  
                                <select class="form-select" data-ui="lg" name="site_id" required="">
                                    {foreach $sites as $site}
                                        <option value="{$site.site_id}">{$site.site_id} - {$site.name}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                                <!-- success -->
                
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->
                
                                <button type="submit" class="btn btn-primary">Add new</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    {elseif $sub_view == "edit"}
        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/mailing/mails" data-ajax="/mailing/mails">
                            <em class="icon ni ni-arrow-left"></em><span>Mails</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Edit mail</h2>
                </div>
            </div>
        
            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms form-horizontal" data-url="/admin/mailing?do=edit_mail" autocomplete="off">
                        <input type="hidden" name="mail_id" value="{$mail.mail_id}">
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Name (optional)</label>
                            <div class="col-sm-9">  
                                <input class="form-control form-control-lg" type="text" name="name" value="{$mail.name}" required="">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Email</label>
                            <div class="col-sm-9">  
                                <input class="form-control form-control-lg" type="text" name="email" required="" value="{$mail.email}">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">Site ID</label>
                            <div class="col-sm-9">  
                                <select class="form-select" data-ui="lg" name="site_id" required="">
                                    {foreach $sites as $site}
                                        <option value="{$site.site_id}" {if $mail.site_id == $site.site_id}selected=""{/if}>{$site.site_id} - {$site.name}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                                <!-- success -->
            
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->
            
                                <button type="submit" class="btn btn-primary">Save changes</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    {elseif $sub_view == "send"}
        <div class="wide-sm">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <h3 class="nk-block-title page-title">
                        Mailing / <strong class="text-primary small">Send mail</strong>
                    </h3> 
                </div>
            </div>

            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms" data-url="/admin/mailing?do=send_mail" autocomplete="off">
                        <div class="form-group form-row">
                            <label class="col-sm-2 form-label text-left">
                                Subject
                            </label>
                            <div class="col-sm-10">  
                                <input class="form-control form-control-lg" type="text" name="subject">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-2 form-label text-left">
                                Message
                            </label>
                            <div class="col-sm-10">  
                                <textarea class="form-control summernote-minimal" rows="15" name="message"></textarea>
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-2 form-label text-left">
                                Send to
                            </label>
                            <div class="col-sm-10">
                                <select class="form-select" data-ui="lg" name="recipient" data-combo="recipient">
                                    <option value="1">Select from customers</option>
                                    <option value="2">Select from writers</option>
                                    <option value="7">Select from sites</option>
                                    <option value="3">Select from mailing list</option>
                                    <option value="4">All customers</option>
                                    <option value="5">All writers</option>
                                    <option value="6">All mailing list</option>
                                </select>
                            </div>
                        </div>
                
                        <div class="mb-3" id="recipient">
                            <div class="switch-combo" data-combo-value="1">
                                <div class="form-group form-row">
                                    <label class="col-sm-2 form-label text-left">Customer</label>
                                    <div class="col-sm-10">
                                        <select class="form-select" name="customer_ids[]" multiple="">
                                            {foreach from=$customers item=$site_customers key=$site_name}
                                                <optgroup label="{$site_name}">
                                                    {foreach $site_customers as $customer}
                                                        <option value="{$customer.id}">{$customer.id} - {$customer.name}</option>
                                                    {/foreach}
                                                </optgroup>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="x-hidden switch-combo" data-combo-value="2">
                                <div class="form-group form-row">
                                    <label class="col-sm-2 form-label text-left">Writer</label>
                                    <div class="col-sm-10">
                                        <select class="form-select" name="writer_ids[]" multiple="">
                                            {foreach $writers as $writer}
                                                <option value="{$writer.employee_id}">{$writer.employee_id} - {$writer.first_name} {$writer.last_name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="x-hidden switch-combo" data-combo-value="3">
                                <div class="form-group form-row">
                                    <label class="col-sm-2 form-label text-left">Mail list</label>
                                    <div class="col-sm-10">
                                        <select class="form-select" name="mail_ids[]" multiple="">
                                            {foreach $mailing_list as $mail}
                                                <option value="{$mail.mail_id}">{$mail.name} - {$mail.email}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                
                            <div class="x-hidden switch-combo" data-combo-value="7">
                                <div class="form-group form-row">
                                    <label class="col-sm-2 form-label text-left">Select Site</label>
                                    <div class="col-sm-10">
                                        <select class="form-select" name="site_ids[]" multiple="">
                                            {foreach $mail_sites as $mail_site}
                                                <option value="{$mail_site.site_id}">{$mail_site.name}</option>
                                            {/foreach}
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                
                        <div class="form-group form-row">
                            <label class="col-sm-2 form-label">Test email</label>
                            <div class="col-sm-10">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="test_email" id="test_email">
                                    <label class="custom-control-label" for="test_email">The message will be sent to Website Email only</label>
                                </div>
                            </div>
                        </div>
                
                        <div class="form-group form-row">
                            <div class="col-sm-10 col-sm-offset-2">
                                <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                                <!-- success -->
                
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->
                
                                <button type="submit" class="btn btn-primary">Send Mail</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    {else}
        {include file="dashboard/mailing/$sub_view.tpl"}
    {/if}

{/block}