{extends file='dashboard/layout.tpl'} 
 
{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Messages</h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        {if count($messages)}
            <div class="messages mb-4">
                {foreach $messages as $message}
                    <div class="message">
                        <div class="message--container js_order-message {if !$message.isSender && !$message.isViewed}new{/if}" data-id="{$message.id}" data-read="{$message.isViewed}">
                            <button class="message--toggle" data-toggle="collapse" href="#message-{$message.id}" role="button" aria-expanded="false" aria-controls="message-{$message.id}">
                                <div class="message--icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19"><path d="M4,7.863l8,4.907,8-4.907h0L12,2.956,4,7.863H4m18,0v9.814a1.982,1.982,0,0,1-2,1.963H4a1.982,1.982,0,0,1-2-1.963V7.863a1.947,1.947,0,0,1,.97-1.678L12,.64l9.03,5.545A1.947,1.947,0,0,1,22,7.863Z" transform="translate(-2 -0.64)" fill="#9e9e9e"></path></svg>
                                </div>
                                <div class="message--from-to">
                                    <div class="message--sender">{$message.fromDepartment.name|ucfirst}</div>
                                    <div class="message--to">{$message.toDepartment.name|ucfirst}</div>
                                </div>
                                
                                <div class="message--subject">
                                    <strong class="message--subject__text">
                                        <a class="text-primary" href="{$base_uri}/order/{$message.orderId}" data-ajax="/order/{$message.orderId}">#{$message.orderReference}</a>
                                    </strong> 
                                    <span class="message--subject__text_collapse">{$message.subject}</span>
                                </div>
                                <div class="message--date">
                                    {if $message.isViewed && $message.isSender}
                                        <span data-toggle="tooltip" data-placement="top" data-title="{$message.readAt}">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                        </span>
                                    {/if}
                                    <span class="js_moment" data-time="{$message.createdAt}">{$message.createdAt}</span>
                                </div>
                                <div class="message--arrow">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                </div>
                            </button>
                            <div class="message--collapse collapse" id="message-{$message.id}">
                                <div class="message--text">{$message.body nofilter}</div>

                                {if !$message.isSender}
                                    <div class="nk-reply-form ml-0 mr-0">
                                        <form data-url="/messages/{$message.id}/reply" class="nk-reply-form-editor js_ajax-forms" method="POST">
                                            <div class="nk-reply-form-field">
                                                <textarea name="reply" class="form-control form-control-simple js_autosize" placeholder="Type your reply..."></textarea>
                                                <!-- error -->
                                                <div class="alert alert-danger alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                <!-- error -->

                                                <!-- success -->
                                                <div class="alert alert-success alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                                                <!-- success -->
                                            </div>
                                            <div class="nk-reply-form-tools">
                                                <div class="nk-reply-form-actions g-1">
                                                    <button class="btn btn-primary mr-2" type="submit">
                                                        <i class="icon ni ni-reply"></i> <span>Reply</span>
                                                    </button>
                                                    <a class="btn btn-secondary mr-2" href="{$base_uri}/order/{$message.orderId}" data-ajax="/order/{$message.orderId}">
                                                        <i class="icon ni ni-eye"></i> <span>View Order</span>
                                                    </a>
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <a class="btn btn-danger mr-2 js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">
                                                            <i class="icon ni ni-trash-alt"></i> <span>Delete</span>
                                                        </a>
                                                    {/if}
                                                </div>
                                            </div>
                                            <!-- .nk-reply-form-tools -->
                                        </form> 
                                    </div>
                                {else}
                                    <div class="message--buttons">
                                        <a class="btn btn-success" href="{$base_uri}/order/{$message.orderId}" data-ajax="/order/{$message.orderId}">
                                            <i class="icon ni ni-eye"></i> <span>View Order</span>
                                        </a>
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">
                                                <i class="icon ni ni-trash-alt"></i> <span>Delete</span>
                                            </a>
                                        {/if}
                                    </div>
                                {/if}
                            </div>
                        </div>
                    </div>
                {/foreach}
            </div>

            <div class="nk-block-between-md g-3">
                <div class="g">
                    {$pager nofilter}
                </div>
            </div><!-- .nk-block-between -->
        {else}
            <div class="text-center x-muted"> 
                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                <h6 class="text-dark title mb-3">No messages to show</h6>
            </div> 
        {/if}
    </div>
{/block}