{if count($deadlines)}
    <table class="table table-orders">
        <thead class="tb-odr-head">
            <tr class="tb-odr-item">
                <th class="tb-odr-info">Name</th>
                <th class="tb-odr-info tb-col-md">Hours Customer</th>
                <th class="tb-odr-info tb-col-md">Hours Writer</th>
                <th class="tb-odr-info">Price Modifier</th>
                <th class="tb-odr-action">Actions</th>
            </tr>
        </thead>
        <tbody>
            {foreach $deadlines as $deadline}
                <tr class="tb-odr-item">
                    <td class="tb-odr-info">{$deadline.name}</td>
                    <td class="tb-odr-info tb-col-md">{pluralize('Hour', $deadline.hrs)}</td>
                    <td class="tb-odr-info tb-col-md">{pluralize('Hour', $deadline.hrs_writer)}</td>
                    <td class="tb-odr-info">
                        <strong class="text-success">{$deadline.price_modifier.amountFormatted}</strong>
                    </td>
                    <td class="tb-odr-action">
                        <div class="dropdown">
                            <a class="text-soft dropdown-toggle btn btn-icon btn-trigger" data-offset="-8,0" id="dropdownMenu-{$deadline.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <em class="icon ni ni-more-h"></em>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-xs" aria-labelledby="dropdownMenu-{$deadline.id}">
                                <ul class="link-list-plain">
                                    <li>
                                        <a href="javascript:void(0);" data-toggle="modal" data-url="#editDeadlineModal" data-size="medium" data-options='{$deadline|json_encode nofilter}'>
                                            <i class="icon ni ni-edit mr5"></i> <span>Edit</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="js_deleter" href="javascript:void(0);" data-handle="deadline" data-id="{$deadline.id}">
                                            <i class="icon ni ni-trash-alt mr5"></i> <span>Delete</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>
{else}
    <div class="text-center x-muted"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No deadlines to show</strong></p>
    </div>
{/if}

<!-- Add Deadline -->
<script id="addDeadlineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addCalculationsDeadline" method="POST" autocomplete="off">
        <input type="hidden" name="site_id" value="{$site.id}">
        <div class="modal-header">
            <h5 class="modal-title">Add Deadline</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="form-label">Name</label>
                    <input name="name" type="text" class="form-control form-control-lg">
                    <span class="help-block">Deadline name e.g. 12 Hours</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="form-label text-left">Price Modifier</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price_modifier" type="text" class="form-control form-control-lg force-integer">
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="form-label">Hours Customer</label>
                    <input name="hrs_customer" type="text" class="form-control form-control-lg force-integer">
                    <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="form-label">Hours Writer</label>
                    <input name="hrs_writer" type="text" class="form-control form-control-lg force-integer">
                    <span class="help-block">The number of hours the writer will get to complete the order</span>
                </div>
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Deadline</button>
        </div>
    </form>
</script>
<!-- Add Deadline -->

<!-- Edit Deadline -->
<script id="editDeadlineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editCalculationsDeadline" method="POST" autocomplete="off">
        <input type="hidden" name="deadline_id" value="{literal}{{id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Deadline</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="form-label">Name</label>
                    <input name="name" type="text" class="form-control form-control-lg" value="{literal}{{name}}{/literal}">
                    <span class="help-block">Deadline name e.g. 12 Hours</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="form-label text-left">Price Modifier</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="price_modifier" type="text" class="form-control form-control-lg force-integer" value="{literal}{{price_modifier.value}}{/literal}">
                    </div>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label class="form-label">Hours Customer</label>
                    <input name="hrs_customer" type="text" class="form-control form-control-lg force-integer" value="{literal}{{hrs}}{/literal}">
                    <span class="help-block">i.e If the deadline name is 12 Hours use <strong>12</strong> as Hours Customer</span>
                </div>

                <div class="form-group col-md-6">
                    <label class="form-label">Hours Writer</label>
                    <input name="hrs_writer" type="text" class="form-control form-control-lg force-integer" value="{literal}{{hrs_writer}}{/literal}">
                    <span class="help-block">The number of hours the writer will get to complete the order</span>
                </div>
            </div>
        
            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Deadline -->