{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        My Sites  
                        &rsaquo; <strong class="text-primary small">{$site.name}</strong>
                        &rsaquo; <strong class="small">Deadlines</strong>
                    </h3>
                </div>
                <!-- .nk-block-head-content -->

                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                        <div class="toggle-expand-content" data-content="more-options">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <a href="{$base_uri}/my-sites/{$site.id}" data-ajax="/my-sites/{$site.id}" class="btn btn-outline-light bg-white">
                                        <i class="icon ni ni-arrow-left"></i> <span>Back</span>
                                    </a>
                                </li>
                                <li class="nk-block-tools-opt">
                                    <button type="button" data-toggle="modal" data-url="#addDeadlineModal" data-size="medium" class="btn btn-primary hidden-sm ml-auto">
                                        <i class="icon ni ni-plus"></i> Add new Deadline
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link {if $tab == "academic"}active{/if}" href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=academic" data-ajax="/my-sites/{$site.id}/deadlines?tab=academic"> 
                                <em class="icon ni ni-text"></em> <span>{if $tab == "academic"}<strong class="pr5">Academic Writing</strong>{else}Academic Writing{/if}</span>
                            </a>
                        </li>
        
                        {if $is_programming_enabled}
                            <li class="nav-item">
                                <a class="nav-link {if $tab == "programming"}active{/if}" href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=programming" data-ajax="/my-sites/{$site.id}/deadlines?tab=programming"> 
                                    <em class="icon ni ni-article"></em> <span>{if $tab == "programming"}<strong class="pr5">Programming</strong>{else}Programming{/if}</span> 
                                </a>
                            </li>
                        {/if}
        
                        {if $is_calculations_enabled}
                            <li class="nav-item">
                                <a class="nav-link {if $tab == "calculations"}active{/if}" href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=calculations" data-ajax="/my-sites/{$site.id}/deadlines?tab=calculations"> 
                                    <em class="icon ni ni-calc"></em> <span>{if $tab == "calculations"}<strong class="pr5">Calculations</strong>{else}Calculations{/if}</span> 
                                </a>
                            </li>
                        {/if}
        
                        {if $is_articlewriting_enabled}
                            <li class="nav-item">
                                <a class="nav-link {if $tab == "articles"}active{/if}" href="{$base_uri}/my-sites/{$site.id}/deadlines?tab=articles" data-ajax="/my-sites/{$site.id}/deadlines?tab=articles"> 
                                    <em class="icon ni ni-code"></em> <span>{if $tab == "article"}<strong class="pr5">Article Writing</strong>{else}Article Writing{/if}</span> 
                                </a>
                            </li>
                        {/if}
                    </ul>

                    <div class="card-inner">
                        {include file="dashboard/my-sites/deadlines.$tab.tpl"}
                    </div>
                </div>
            </div>
        </div>

    </div>
{/block}