{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">My Sites</h3>
                </div>
                <!-- .nk-block-head-content -->

                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                        <div class="toggle-expand-content" data-content="more-options">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <a href="{$base_uri}/my-sites/add" data-ajax="/my-sites/add" class="btn btn-icon btn-primary d-md-none">
                                        <em class="icon ni ni-plus"></em>
                                    </a>
                                    <button type="button" data-toggle="modal" data-url="#addSiteModal" data-size="small" class="btn btn-primary d-none d-md-inline-flex">
                                        <em class="icon ni ni-plus"></em><span>Add Site</span>
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        {if $total_sites}
            <div class="nk-tb-list is-separate is-medium mb-3">
                <div class="nk-tb-item nk-tb-head">
                    <div class="nk-tb-col">
                        <span>Site ID</span>
                    </div>
                    <div class="nk-tb-col">
                        <span>Site Name</span>
                    </div>
                    <div class="nk-tb-col">
                        <span>Domain</span>
                    </div>
                    <div class="nk-tb-col tb-col-md">
                        <span>Orders</span>
                    </div>
                    <div class="nk-tb-col tb-col-md">
                        <span>Customers</span>
                    </div>
                    <div class="nk-tb-col tb-col-md">
                        <span>Payments</span>
                    </div>
                    <div class="nk-tb-col">
                        <span>&nbsp;</span>
                    </div>
                </div>

                {foreach $sites as $site}
                    <div class="nk-tb-item">
                        <div class="nk-tb-col">
                            <span class="tb-lead">
                                <a target="_blank" href="{$base_uri}/my-sites/{$site.id}/edit" data-ajax="/my-sites/{$site.id}/edit">#{$site.id}</a>
                            </span>
                        </div>

                        <div class="nk-tb-col">
                            <span class="tb-sub">{$site.name}</span>
                        </div>

                        <div class="nk-tb-col">
                            <span class="tb-sub">{$site.domain}</span>
                        </div>

                        <div class="nk-tb-col tb-col-md">
                            <strong class="tb-sub text-dark">{toFixed($site.orders, 0)}</strong>
                        </div>

                        <div class="nk-tb-col tb-col-md">
                            <strong class="tb-sub text-dark">{toFixed($site.customers, 0)}</strong>
                        </div>

                        <div class="nk-tb-col tb-col-md">
                            <strong class="tb-lead">{formatPrice($site.payments)}</strong>
                        </div>

                        <div class="nk-tb-col nk-tb-col-tools">
                            <ul class="nk-tb-actions gx-1">
                                <li class="nk-tb-action-hidden">
                                    <a href="{$base_uri}/my-sites/{$site.id}/edit" data-ajax="/my-sites/{$site.id}/edit" class="btn btn-icon btn-trigger btn-tooltip" data-original-title="View Site">
                                        <em class="icon ni ni-eye"></em>
                                    </a>
                                </li>
                                <li>
                                    <div class="dropdown">
                                        <a class="text-soft dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown" aria-expanded="false"><em class="icon ni ni-more-h"></em></a>
                                        <div class="dropdown-menu dropdown-menu-right dropdown-menu-xs" style="">
                                            <ul class="link-list-plain">
                                                <li><a href="{$base_uri}/my-sites/{$site.id}/edit" data-ajax="/my-sites/{$site.id}/edit">Edit</a></li>
                                                <li><a href="javascript:void(0);" class="js_deleter" data-handle="site" data-id="{$site.id}">Remove</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                {/foreach}
            </div>

            <div class="nk-block-between-md g-3">
                <div class="g">
                    {$pager nofilter}
                </div>
            </div><!-- .nk-block-between -->
        {else}
            <div class="text-center x-muted"> 
                <i class="fas fa-globe fa-4x"></i>
                <p class="mb10"><strong>No sites to show</strong></p>
            </div>
        {/if}
    </div>

    <!-- Add Site -->
    <script id="addSiteModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/admin/sites?do=add" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add New Site</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label text-left">Site Name</label>
                    <input class="form-control form-control-lg" type="text" name="site_name" id="site_name" maxlength="255">
                </div>

                <div class="form-group">
                    <label class="form-label text-left">Site Email</label>
                    <input class="form-control form-control-lg" type="text" name="site_email" id="site_email" maxlength="255">
                </div>

                <div class="form-group">
                    <label class="form-label text-left">Site URL</label>
                    <input class="form-control form-control-lg" type="text" name="site_domain" id="site_domain" maxlength="255">
                </div>
            
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Site</button>
            </div>
        </form>
    </script>
    <!-- Add Site -->
{/block} 

