<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Type of Paper</label>
    <div class="col-sm-7">
        <select name="paperTypeId" class="form-select js_calculate js_custom-toggle" data-val="64" data-ui="lg" data-search="on">
            {foreach $paperTypes as $paperType}
                <option value="{$paperType.id}" {if $order.paperType == $paperType.id}selected=""{/if}>{$paperType.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row {if $order.paperType != 64}x-hidden{/if}">
    <label class="col-sm-2 form-label text-left">Add Paper Type</label>
    <div class="col-sm-7">
        <input type="text" class="js_calculate form-control form-control-lg" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$order.paperTypeOption}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Discipline</label> 
    <div class="col-sm-7">
        <select name="topicCatId" id="topicCatId" class="form-select js_calculate js_custom-toggle" data-val="52" data-ui="lg" data-search="on">
            {foreach $disciplineGroups as $topicCat}
                <optgroup label="{$topicCat.title}">
                    {foreach $topicCat.disciplines as $discipline}
                        <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $order.topicCategoryId == $discipline.discipline_id}selected=""{/if} >{$discipline.title}</option>
                    {/foreach}
                </optgroup>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row {if $order.topicCategoryId != 52}x-hidden{/if}">
    <label class="col-sm-2 form-label text-left">Add Discipline</label>
    <div class="col-sm-7">
        <input type="text" class="js_calculate form-control form-control-lg" name="topcatOption" id="topcatOption" maxlength="255" value="{$order.topicCategory}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left" for="paperFormat">Paper Format:</label>
    <div class="col-sm-7">
        <select class="form-select js_calculate js_custom-toggle" name="paperFormat" data-val="4" data-ui="lg">
            {foreach $paperFormats as $paperFormat} 
                <option value="{$paperFormat.paper_format_id}" {if $order.paperFormat == $paperFormat.paper_format_id}selected=""{/if}>{$paperFormat.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row {if $order.paperFormat != 4}x-hidden{/if}">
    <label class="col-sm-2 form-label text-left">Add Paper Format</label>
    <div class="col-sm-7">
        <input type="text" class="js_calculate form-control" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$order.paperFormatTypeOption}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Topic</label>
    <div class="col-sm-7">
        <input class="form-control form-control-lg" type="text" name="topic" id="topic" maxlength="255" value="{$order.title}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Paper Instructions</label>
    <div class="col-sm-7">
        <textarea class="form-control summernote-minimal" name="paperDetails">{$order.paperDetailsRaw}</textarea>
    </div>
</div>

<div class="divider"></div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Spacing</label>
    <div class="col-sm-8">
        <ul class="custom-control-group">
            <li>
                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                    <input type="radio" name="spacing" value="double" class="custom-control-input js_calculate" id="double_spaced"  {if $order.spacing == 'double'}checked=""{/if}>
                    <label class="custom-control-label" for="double_spaced">Double Spaced</label>
                </div>
            </li>
            <li>
                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                    <input type="radio" name="spacing" value="single" class="custom-control-input js_calculate" id="single_spaced" {if $order.spacing == 'single'}checked=""{/if}>
                    <label class="custom-control-label" for="single_spaced">Single Spaced</label>
                </div>
            </li>
        </ul>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Pages</label>
    <div class="col-sm-4">
        <div class="form-control-wrap number-spinner-wrap">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                <em class="icon ni ni-minus"></em>
            </button>
            <input type="text" name="pages" class="form-control form-control-lg js_calculate number-spinner" placeholder="pages" value="{$order.pages}" min="0" max="999">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                <em class="icon ni ni-plus"></em>
            </button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Sources to be cited</label>
    <div class="col-sm-4">
        <div class="form-control-wrap number-spinner-wrap">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                <em class="icon ni ni-minus"></em>
            </button>
            <input type="text" name="sources" class="form-control form-control-lg js_calculate number-spinner" placeholder="sources" value="{$order.sources}" min="0" max="999">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                <em class="icon ni ni-plus"></em>
            </button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Charts</label>
    <div class="col-sm-4">
        <div class="form-control-wrap number-spinner-wrap">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                <em class="icon ni ni-minus"></em>
            </button>
            <input type="text" name="charts" class="form-control form-control-lg js_calculate number-spinner" placeholder="charts" value="{$order.charts}" min="0" max="999">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                <em class="icon ni ni-plus"></em>
            </button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">PowerPoint slides</label>
    <div class="col-sm-4">
        <div class="form-control-wrap number-spinner-wrap">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                <em class="icon ni ni-minus"></em>
            </button>
            <input type="text" name="slides" class="form-control form-control-lg js_calculate number-spinner" placeholder="slides" value="{$order.slides}" min="0" max="999">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                <em class="icon ni ni-plus"></em>
            </button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Excel Sheets</label>
    <div class="col-sm-4">
        <div class="form-control-wrap number-spinner-wrap">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                <em class="icon ni ni-minus"></em>
            </button>
            <input type="text" name="excelSheets" class="form-control form-control-lg js_calculate number-spinner" placeholder="Excel sheets" value="{$order.excelSheets}" min="0" max="999">
            <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                <em class="icon ni ni-plus"></em>
            </button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Writer Category</label>
    <div class="col-sm-4">
        <select class="form-select js_calculate" name="writerCategoryId" data-ui="lg">
            {foreach $writerPreferences as $writerPreference}
                <option {if isset($writerPreference.percent)}data-percent="{$writerPreference.percent}"{/if} value="{$writerPreference.id}" {if $order.writerCategoryId == $writerPreference.id}selected=""{/if} >{$writerPreference.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 form-label text-left">Tracking ID</label>
    <div class="col-sm-4">
        <input class="form-control form-control-lg" type="text" name="tracking_id" id="tracking_id" maxlength="255" value="{$order.trackingId}">
    </div>
</div>

{if ($siteSettings.WRITER_SAMPLES_ENABLED ||  $order.areSamplesRequired) ||
    ($siteSettings.COPY_OF_SOURCES_ENABLED || $order.areSourcesRequired) ||
    ($siteSettings.PROGRESSIVE_DELIVERY_ENABLED || $order.progressiveDeliveryHidden) ||
    ($siteSettings.EXPERT_PROOFREADING_ENABLED || $order.expertProofreading)
}
    <div class="data-head my-4">
        <h6 class="overline-title">Additional Services</h6>
    </div>

    <div class="form-group">
        <ul class="custom-control-group">
            {if $siteSettings.WRITER_SAMPLES_ENABLED ||  $order.areSamplesRequired}
                <li>
                    <div class="custom-control custom-control-sm custom-checkbox custom-control-pro">
                        <input type="checkbox" class="custom-control-input js_calculate" name="samplesNeeded" id="samplesNeeded" {if $order.areSamplesRequired == '1'}checked="checked"{/if}>
                        <label class="custom-control-label" for="samplesNeeded">Get Writer Samples</label>
                    </div>
                </li>
            {/if}

            {if $siteSettings.COPY_OF_SOURCES_ENABLED || $order.areSourcesRequired}
                <li>
                    <div class="custom-control custom-control-sm custom-checkbox custom-control-pro">
                        <input type="checkbox" class="custom-control-input js_calculate" name="usedsources" id="usedsources" {if $order.areSourcesRequired == '1'}checked="checked"{/if}>
                        <label class="custom-control-label" for="usedsources">Copy of Sources</label>
                    </div>
                </li>
            {/if}

            {if $siteSettings.PROGRESSIVE_DELIVERY_ENABLED ||  $order.progressiveDeliveryHidden}
                <li>
                    <div class="custom-control custom-control-sm custom-checkbox custom-control-pro">
                        <input type="checkbox" class="custom-control-input js_calculate" name="progressiveDeliveryHidden" id="progressiveDeliveryHidden" {if $order.progressiveDeliveryHidden == '1'}checked="checked"{/if}>
                        <label class="custom-control-label" for="progressiveDeliveryHidden">Progressive Delivery</label>
                    </div>
                </li>
            {/if}

            {if $siteSettings.EXPERT_PROOFREADING_ENABLED ||  $order.expertProofreading}
                <li>
                    <div class="custom-control custom-control-sm custom-checkbox custom-control-pro">
                        <input type="checkbox" class="custom-control-input js_calculate" name="expertProofreading" id="expertProofreading" {if $order.expertProofreading == '1'}checked="checked"{/if}>
                        <label class="custom-control-label" for="expertProofreading">Expert Proofreading</label>
                    </div>
                </li>
            {/if}
        </ul>
    </div>

    <div class="divider"></div>
{/if}

<div class="form-group">
    <div class="custom-control custom-checkbox">
        <input type="checkbox" class="custom-control-input" name="changeDeadline" id="changeDeadline">
        <label class="custom-control-label" for="changeDeadline">Change Deadline</label>
    </div>
</div>

<div deadline-combo class="x-hidden">
    <div class="form-group form-row mb-3">
        <label class="col-sm-2 form-label text-left">Academic level</label>
        <div class="col-sm-4">
            <select name="academicLevelId" class="form-select js_calculate" data-ui="lg">
                {foreach $academicLevels as $academicLevel}
                    <option value="{$academicLevel.id}" {if $order.academicLevel == $academicLevel.id}selected=""{/if}>{$academicLevel.title}</option>
                {/foreach}
            </select>
        </div>
    </div>

    <div class="form-group form-row">
        <label class="col-sm-2 form-label text-left">Deadline</label>
        <div class="col-sm-4">
            <select name="tariffId" class="form-select js_calculate" data-ui="lg" data-tariff-control="" tariff-id="{$order.tariffId}"></select>
        </div>
    </div>
</div>

{if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
    <div class="divider"></div>

    <div class="form-group form-row">
        <label class="col-sm-2 form-label text-left">Total</label>
        <div class="col-sm-7">
            <span id="orderPrice" class="h2 text-success">{$order.priceFormatted}</span>
        </div>
    </div>
{/if}