<div class="nk-block-head">
    <div class="nk-block-between g-3">
        <div class="nk-block-head-content">
            <h3 class="nk-block-title page-title">
                Orders &rsaquo; <strong class="text-primary small">#{$order.referenceId}</strong> 
                &rsaquo; <strong class="small">Bids &amp; Writers</strong> 
            </h3>
        </div>
        <div class="nk-block-head-content">
            <ul class="nk-block-tools g-3">
                <li>
                    <a href="{$base_uri}/order/{$order.id}" class="btn btn-outline-light bg-white d-none d-sm-inline-flex">
                        <i class="icon ni ni-arrow-left fa-fw mr5"></i> Back to Order
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="card card-preview">
    <div class="card-inner">
        <ul class="nav nav-tabs mt-n3">
            <li class="nav-item">
                <a class="nav-link {if $_get == "bids"}active{/if}" href="{$base_uri}/order/{$order.id}/assign?get=bids" data-ajax="/order/{$order.id}/assign?get=bids"> 
                    {if $_get == "bids"}<strong class="pr5">Bids</strong>{else}Bids{/if}
                    {if count($bids) > 0}
                        <span class="badge badge-success ml5">{count($bids)}</span>
                    {/if}
                </a>
            </li>
            
            <li class="nav-item"> 
                <a class="nav-link {if $_get == "writers"}active{/if}" href="{$base_uri}/order/{$order.id}/assign?get=writers" data-ajax="/order/{$order.id}/assign?get=writers">
                    {if $_get == "writers"}<strong class="pr5">Writers</strong>{else}Writers{/if}
                    {if count($writers) > 0}
                        <span class="badge badge-success ml5">{count($writers)}</span>
                    {/if}
                </a> 
            </li>

            {if $editor_account_enabled}
                <li class="nav-item"> 
                    <a class="nav-link {if $_get == "editors"}active{/if}" href="{$base_uri}/order/{$order.id}/assign?get=editors" data-ajax="/order/{$order.id}/assign?get=editors">
                        {if $_get == "editors"}<strong class="pr5">Editors</strong>{else}Editors{/if}
                    </a> 
                </li>
            {/if}

            {if $order_manager_enabled}
                <li class="nav-item"> 
                    <a class="nav-link {if $_get == "ordermanagers"}active{/if}" href="{$base_uri}/order/{$order.id}/assign?get=ordermanagers" data-ajax="/order/{$order.id}/assign?get=ordermanagers">
                        {if $_get == "ordermanagers"}<strong class="pr5">Order Managers</strong>{else}Order Managers{/if}
                    </a> 
                </li>
            {/if}
        </ul>

        {if $_get == "writers"}
            <div class="tab-content">

                <form class="row mb-4" method="GET">
                    <input type="hidden" name="get" value="writers"/>
                    <div class="col-md-7">
                        <div class="form-control-wrap">
                            <div class="input-group">
                                <input type="text" name="query" autocomplete="off" class="form-control form-control" value="{$query}" placeholder="Search ID, name or email">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-outline-primary btn-dim">
                                        <em class="icon ni ni-search"></em> <span>Search</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form> 

                {if $total_writers > 0}
                    <ul class="row">
                        {foreach $writers as $writer}
                            <li class="col-sm-12 col-md-6">
                                {include file='dashboard/order/__assign.writer.tpl' _writer=$writer}
                            </li>
                        {/foreach}
                    </ul>

                    {$pager nofilter}
                {else}
                    <div class="text-center x-muted mb-3"> 
                        {include file='__svg_icons.tpl' class="mb-3" icon="users-list" width="100px" height="100px"}
                        <h6 class="text-muted title fw-normal mb-3">No writers to show</h6>
                    </div>
                {/if}
            </div>

        {elseif $_get == "bids"}
            <div class="tab-content">
                {if $total_bids > 0}
                    <ul class="row">
                        {foreach $bids as $bid}
                            <li class="col-sm-12 col-md-6">
                                {include file='dashboard/order/__assign.writer.tpl' _writer=$bid}
                            </li>
                        {/foreach}
                    </ul>

                    {$pager nofilter}
                {else}
                    <div class="text-center x-muted mb-3"> 
                        {include file='__svg_icons.tpl' class="mb-3" icon="users-list" width="100px" height="100px"}
                        <h6 class="text-muted title fw-normal mb-3">No bids to show</h6>
                    </div>
                {/if}
            </div>

        {elseif $_get == "editors"}

            <div class="tab-content">

                <form class="row mb-4" method="GET">
                    <input type="hidden" name="get" value="editors"/>
                    <div class="col-md-7">
                        <div class="form-control-wrap">
                            <div class="input-group">
                                <input type="text" name="query" autocomplete="off" class="form-control form-control" value="{$query}" placeholder="Search ID, name or email">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-outline-primary btn-dim">
                                        <em class="icon ni ni-search"></em> <span>Search</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form> 

                {if $total_editors > 0}
                    <ul class="row">
                        {foreach $editors as $editor}
                            <li class="col-sm-12 col-md-6">
                                {include file='dashboard/order/__assign.editor.tpl' _editor=$editor}
                            </li>
                        {/foreach}
                    </ul>

                    {$pager nofilter}
                
                {else}
                    <div class="text-center x-muted mb-3"> 
                        {include file='__svg_icons.tpl' class="mb-3" icon="users-list" width="100px" height="100px"}
                        <h6 class="text-muted title fw-normal mb-3">No editors to show</h6>
                    </div>
                {/if}
            </div>

        {elseif $_get == "ordermanagers"}

            <div class="tab-content">

                <form class="row mb-4" method="GET">
                    <input type="hidden" name="get" value="ordermanagers"/>
                    <div class="col-md-7">
                        <div class="form-control-wrap">
                            <div class="input-group">
                                <input type="text" name="query" autocomplete="off" class="form-control form-control" value="{$query}" placeholder="Search ID, name or email">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-outline-primary btn-dim">
                                        <em class="icon ni ni-search"></em> <span>Search</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form> 

                {if $total_ordermanagers > 0}
                    <ul class="row">
                        {foreach $ordermanagers as $ordermanager}
                            <li class="col-sm-12 col-md-6">
                                {include file='dashboard/order/__assign.ordermanager.tpl' _ordermanager=$ordermanager}
                            </li>
                        {/foreach}
                    </ul>

                    {$pager nofilter}
                
                {else}
                    <div class="text-center x-muted mb-3"> 
                        {include file='__svg_icons.tpl' class="mb-3" icon="users-list" width="100px" height="100px"}
                        <h6 class="text-muted title fw-normal mb-3">No order managers to show</h6>
                    </div>
                {/if}
            </div>
        {/if}
    </div>
</div>

