{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="wide-xl">

        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Performance Overview</h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        {if count($writer_pools)}
            <div class="nk-block">  
                <div class="slider-init" {literal}data-slick='{ {/literal} "arrows": true, "dots": true, "initialSlide": {$initialSlide}, "adaptiveHeight": false, "slidesToShow": 1, "slidesToScroll": 1, "infinite":false {literal}}'{/literal}>
                    {foreach $writer_pools as $pool}
                        <div class="p-0 m-0 text-center card-full">
                            <div class="card-inner bg-white p-4">
                                {if $pool.badge}
                                    <div class="pricing-media">
                                        <img class="mx-auto" src="{$pool.badge_url}">
                                    </div>
                                {/if}

                                <div class="pricing-title w-220px mx-auto">
                                    <h5 class="title">{$pool.name}</h5>
                                    {if $pool.description}
                                        <span class="sub-text">{$pool.description}</span>
                                    {/if}

                                    {if $user.employee_pool_id == $pool.id}
                                        <span class="badge bg-primary badge-sm text-white mt-2">Your Status</span>
                                    {/if}
                                </div>
                            </div>

                            {if $pool.benefits || $pool.requirements}
                                <div class="card-inner p-5 bg-primary-dim">
                                    <div class="row g-gs">
                                        {if $pool.benefits && count($pool.benefits_array)}
                                            <div class="col-md-6">
                                                <div class="card card-full text-left round-xl overflow-hidden">
                                                    <div class="card-header">
                                                        <h6 class="card-title">Requirements <em class="icon ni ni-list-thumb-fill pull-right"></em></h6>
                                                    </div>
                                                    <div class="card-inner">
                                                        <ul class="list">
                                                            {foreach $pool.benefits_array as $requirement}
                                                                <li>{$requirement}</li>
                                                            {/foreach}
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        {/if}

                                        {if $pool.requirements && count($pool.requirements_array)}
                                            <div class="col-md-6">
                                                <div class="card card-full text-left round-xl overflow-hidden">
                                                    <div class="card-header">
                                                        <h6 class="card-title">Benefits <em class="icon ni ni-gift pull-right"></em></h6>
                                                    </div>
                                                    <div class="card-inner">
                                                        <ul class="list">
                                                            {foreach $pool.requirements_array as $requirement}
                                                                <li>{$requirement}</li>
                                                            {/foreach}
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        {/if}
                                    </div>
                                </div>
                            {/if}
                        </div>
                    {/foreach}
                </div>
            </div>
        {/if}

        <div class="nk-block">  
            <div class="row g-gs">
                <div class="col-md-6">
                    <div class="card card-full">
                        <div class="card-inner mb-1">
                            <div class="card-title-group align-start">
                                <div class="card-title">
                                    <span class="badge badge-sm badge-dot has-bg badge-primary">Completed Order Stats</span>
                                </div>
                            </div>
                        </div>
                
                        <div class="nk-tb-list mt-n2">
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Approved orders (total)</span>
                                </div>
                                <div class="nk-tb-col text-right">
                                    <span class="tb-sub tb-amount">{$insights.approved_orders_total}</span>
                                </div>
                            </div>
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Approved orders (15+ pages)</span>
                                </div>
                                <div class="nk-tb-col text-right">
                                    <span class="tb-sub tb-amount">{$insights.approved_orders_pages}</span>
                                </div>
                            </div>
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Approved orders (urgent)</span>
                                </div> 
                                <div class="nk-tb-col text-right">
                                    <span class="tb-sub tb-amount">{$insights.approved_orders_urgent}</span>
                                </div>
                            </div>
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Total Income</span>
                                </div>
                                <div class="nk-tb-col text-right">
                                    <span class="tb-sub tb-amount">{formatPrice($insights.total_income)}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card card-full">
                        <div class="card-inner mb-1">
                            <div class="card-title-group align-start">
                                <div class="card-title">
                                    <span class="badge badge-sm badge-dot has-bg badge-primary">Performance Indicators</span>
                                </div>
                            </div>
                        </div>
                
                        <div class="nk-tb-list mt-n2">
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Lateness Level</span>
                                </div>
                                <div class="nk-tb-col">
                                    <div class="project-list-progress">
                                        <div class="progress progress-pill progress-md">
                                            <div class="progress-bar bg-warning" data-progress="{numberFormat($insights.lateness_level)}"></div>
                                        </div>
                                        <div class="project-progress-percent">{numberFormat($insights.lateness_level)}%</div>
                                    </div>
                                </div>
                            </div>
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Total number of revisions</span>
                                </div>
                                <div class="nk-tb-col">
                                    <span class="tb-sub tb-amount">{$insights.revision_orders}</span>
                                </div>
                            </div>
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Revision Rate</span>
                                </div>
                                <div class="nk-tb-col">
                                    <div class="project-list-progress">
                                        <div class="progress progress-pill progress-md">
                                            <div class="progress-bar bg-danger" data-progress="{numberFormat($insights.revision_rate)}"></div>
                                        </div>
                                        <div class="project-progress-percent">{numberFormat($insights.revision_rate)}%</div>
                                    </div>
                                </div>
                            </div>
                            <div class="nk-tb-item">
                                <div class="nk-tb-col tb-col-sm">
                                    <span class="tb-lead text-muted">Confirmation Rate (auto-assigned orders)</span>
                                </div>
                                <div class="nk-tb-col">
                                    <div class="project-list-progress">
                                        <div class="progress progress-pill progress-md">
                                            <div class="progress-bar bg-primary" data-progress="{numberFormat($insights.confirmation_rate)}"></div>
                                        </div>
                                        <div class="project-progress-percent">{numberFormat($insights.confirmation_rate)}%</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {if $is_fines_enabled}
            <div class="nk-block">  
                <div class="row g-gs">
                    <div class="col-md-6">
                        <div class="card card-full">
                            <div class="card-inner mb-1">
                                <div class="card-title-group align-start">
                                    <div class="card-title">
                                        <span class="badge badge-sm badge-dot has-bg badge-primary">Quality Controls</span>
                                    </div>
                                </div>
                            </div>

                            {if count($charged_fines)}
                                <div class="card-inner pt-0 px-0">
                                    <div class="js_scroller" data-slimScroll-height="300px">
                                        <ul class="nk-tb-list mt-n2">
                                            {foreach $charged_fines as $charged_fine}
                                                <li class="nk-tb-item">
                                                    <div class="nk-tb-col">
                                                        <span class="tb-lead text-muted">
                                                            <span class="js_moment" data-time="{$charged_fine.date_add}">{$charged_fine.date_add}</span>
                                                        </span>
                                                    </div>
                                                    <div class="nk-tb-col text-left">
                                                        <span class="tb-sub tb-amount">{if $charged_fine.description}{$charged_fine.desc_trucnate}{else}N.A{/if}</span>
                                                    </div>
                                                    <div class="nk-tb-col text-right tb-col-sm">
                                                        <span class="tb-sub tb-amount">{$charged_fine.order_id}</span>
                                                    </div>
                                                </li>
                                            {/foreach}
                                        </ul>
                                    </div>

                                    {if count($charged_fines) >= 8}
                                        <!-- see-more -->
                                        <button class="d-block btn btn-outline-light bg-white btn-sm js_see-more mt-3 mx-auto" data-get="quality_controls">
                                            <span>See More</span>
                                            <div class="loader loader_small x-hidden"></div>
                                        </button>
                                        <!-- see-more -->
                                    {/if}
                                </div>
                            {else}
                                <div class="card-inner h-100 card-inner-xl d-flex justify-content-center align-items-center">
                                    <div class="text-center">
                                        <h6 class="mb-2">No Quality Controls noticed.</h6>
                                        <p class="text-muted">You're doing great!</p>
                                    </div>
                                </div>
                            {/if}
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card card-full">
                            <div class="card-inner mb-1">
                                <div class="card-title-group align-start">
                                    <div class="card-title">
                                        <span class="badge badge-sm badge-dot has-bg badge-primary">Fines</span>
                                        <p class="mt-2">Fine is a penalty for violation of the Company's standards and requirements to Products, or not fulfilling the Writer's liabilities. Do your best to perform faultlessly to avoid being familiar with the following fines:</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card-inner pt-0">
                                <div class="js_scroller" data-slimScroll-height="250px">
                                    {foreach $fines as $fine}
                                        <div class="row mx-0 mb-2">
                                            <div class="col-md-10 p-2 bg-primary-dim fw-bold d-flex align-items-center rounded-left">
                                                {$fine.name}
                                            </div>
                                            <div class="col-md-2 p-2 bg-primary fw-bold text-white  d-flex align-items-center rounded-right">
                                                {if $fine.type == 'amount'}{formatPrice($fine.value)}{else}{numberFormat($fine.value, 0)}%{/if}
                                            </div>
                                        </div>
                                    {/foreach}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        {/if}

        {if count($ratings)}
            <div class="nk-block">  
                <div class="card">
                    <div class="card-inner">
                        <div class="row g-gs">
                            <div class="col-md-5">
                                <h6 class="title">Customer Rating</h6>
                                <div class="d-flex align-center mb-5">
                                    <div class="progress-amount mr-4">
                                        <h1 class="title">{$insights['average_customer_rating']}</h1>
                                        <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_customer_rating']}">
                                            <span class="Rating-total">
                                                <span class="Rating-progress"></span>
                                            </span>
                                        </div>
                                        <span class="sub-text mt-1"><em class="icon ni ni-users-fill"></em> {$insights['total_customer_reviews']} Total</span>
                                    </div>

                                    <div class="rating-progress-bar gy-2 w-100">
                                        {foreach range(1,5) as $i}
                                            <div class="progress-rating">
                                                <div class="progress-rating-title">{$i} star</div>
                                                {if isset($insights['customer_ratings'][$i])}
                                                    <div class="progress progress-pill">
                                                        <div class="progress-bar mb-0 bg-teal" data-progress="{$insights['customer_ratings'][$i]['width']}"></div>
                                                    </div>
                                                    <div class="progress-rating-percent">{$insights['customer_ratings'][$i]['total_rating']}</div>
                                                {else}
                                                    <div class="progress progress-pill">
                                                        <div class="progress-bar mb-0 bg-teal" data-progress="0" style="width: 0%;"></div>
                                                    </div>
                                                    <div class="progress-rating-percent">0</div>
                                                {/if}
                                            </div>
                                        {/foreach}
                                    </div>
                                </div>

                                {if $user.is_writer}
                                    <h6 class="title">Editor Rating</h6>
                                    <div class="d-flex align-center gy-3">
                                        <div class="progress-amount mr-4">
                                            <h1 class="title">{$insights['average_editor_rating']}</h1>
                                            <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_editor_rating']}">
                                                <span class="Rating-total">
                                                    <span class="Rating-progress"></span>
                                                </span>
                                            </div>
                                            <span class="sub-text mt-1"><em class="icon ni ni-users-fill"></em> {$insights['total_editor_reviews']} Total</span>
                                        </div>

                                        <div class="rating-progress-bar gy-2 w-100">
                                            {foreach range(1,5) as $i}
                                                <div class="progress-rating">
                                                    <div class="progress-rating-title">{$i} star</div>
                                                    {if isset($insights['editor_ratings'][$i])}
                                                        <div class="progress progress-pill">
                                                            <div class="progress-bar mb-0 bg-teal" data-progress="{$insights['editor_ratings'][$i]['width']}"></div>
                                                        </div>
                                                        <div class="progress-rating-percent">{$insights['editor_ratings'][$i]['total_rating']}</div>
                                                    {else}
                                                        <div class="progress progress-pill">
                                                            <div class="progress-bar mb-0 bg-teal" data-progress="0" style="width: 0%;"></div>
                                                        </div>
                                                        <div class="progress-rating-percent">0</div>
                                                    {/if}
                                                </div>
                                            {/foreach}
                                        </div>
                                    </div>
                                {/if}
                                
                            </div>
                            <div class="col-md-6 offset-md-1">
                                <ul>
                                    {foreach $ratings as $rating}
                                        {include file='_partials/__order_rating.tpl'}
                                    {/foreach}
                                </ul>

                                {if count($ratings) >= 5}
                                    <!-- see-more -->
                                    <button class="d-block btn btn-outline-light bg-white btn-sm js_see-more mt-3 mx-auto" data-get="user_reviews">
                                        <span>See More</span>
                                        <div class="loader loader_small x-hidden"></div>
                                    </button>
                                    <!-- see-more -->
                                {/if}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        {/if}

    </div>
{/block}