{if count($academic_levels)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>Title</th>
                        <th>Short Title</th>
                        <th>Degree</th>
                        <th>Date</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead> 
                <tbody>
                    {foreach $academic_levels as $academic_level}
                        <tr class="tb-tnx-item">
                            <td>{$academic_level.title}</td>
                            <td>{$academic_level.short_title}</td>
                            <td>{$academic_level.degree}</td>
                            <td>
                                <span class="js_moment" data-time="{$academic_level.date_add}">{$academic_level.date_add}</span>
                            </td>
                            <td class="tb-tnx-action">
                                <div class="dropdown">
                                    <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$academic_level.academic_level_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$academic_level.academic_level_id}">
                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editAcademicLevelModal" data-size="small" data-options='{$academic_level|json_encode}'>
                                            <em class="icon ni ni-edit"></em><span>Edit</span>
                                        </a>
                                        {if $academic_level.academic_level_id != '4'}
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="academic_level" data-id="{$academic_level.academic_level_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        {/if}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted py-5"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No academic levels to show</strong></p>
    </div>
{/if}

<!-- Add Academic Level -->
<script id="addAcademicLevelModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addAcademicLevel" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Academic Level</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title<span class="text-danger">*</span></label>
                <input name="title" type="text" class="form-control form-control-lg" placeholder="Undergrad. (yrs 3-4)" required>
            </div>

            <div class="form-group">
                <label class="form-label">Short Title</label>
                <input name="short_title" type="text" class="form-control form-control-lg" placeholder="University" required>
                <span class="help-block">For small and mobile devices</span>
            </div>

            <div class="form-group">
                <label class="form-label">Degree</label>
                <input name="degree" type="text" class="form-control form-control-lg" placeholder="Bachelor's degree">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Academic Level</button>
        </div>
    </form>
</script>
<!-- Add Academic Level -->

<!-- Edit Academic Level -->
<script id="editAcademicLevelModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editAcademicLevel" method="POST" autocomplete="off">
        <input type="hidden" name="academic_level_id" value="{literal}{{academic_level_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Academic Level</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title<span class="text-danger">*</span></label>
                <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}" required>
            </div>

            <div class="form-group">
                <label class="form-label">Short Title</label>
                <input name="short_title" type="text" class="form-control form-control-lg" value="{literal}{{short_title}}{/literal}">
                <span class="help-block">For small and mobile devices</span>
            </div>

            <div class="form-group">
                <label class="form-label">Degree</label>
                <input name="degree" type="text" class="form-control form-control-lg" value="{literal}{{degree}}{/literal}">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Academic Level -->