{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Preferences / <strong class="text-primary small">Academic Writing</strong>
                    </h3>
                </div>
                <div class="nk-block-head-content">
                    {if $controller == "paperTypes"}
                        <button type="button"  data-toggle="modal" data-url="#addPaperTypeModal" data-size="small" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Paper Type</span>
                        </button>
                    {/if}

                    {if $controller == "paperFormats"}
                        <button type="button"  data-toggle="modal" data-url="#addPaperFormatModal" data-size="small" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Paper Format</span>
                        </button>
                    {/if}

                    {if $controller == "academicLevels"}
                        <button type="button"  data-toggle="modal" data-url="#addAcademicLevelModal" data-size="small" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Academic Level</span>
                        </button>
                    {/if}
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>
        
        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "paperTypes"}active{/if}" href="{$base_uri}/preferences/academic/paper-types" data-ajax="/preferences/academic/paper-types"> 
                                <span>Paper Types</span>
                            </a>
                        </li>
            
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "disciplines"}active{/if}" href="{$base_uri}/preferences/academic/disciplines" data-ajax="/preferences/academic/disciplines"> 
                                <span>Disciplines</span>
                            </a>
                        </li>
            
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "paperFormats"}active{/if}" href="{$base_uri}/preferences/academic/paper-formats" data-ajax="/preferences/academic/paper-formats"> 
                                <span>Paper Formats</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link {if $controller == "academicLevels"}active{/if}" href="{$base_uri}/preferences/academic/academic-levels" data-ajax="/preferences/academic/academic-levels"> 
                                <span>Academic Levels</span>
                            </a>
                        </li>
                    </ul>

                    {include file="dashboard/preferences/academic/$controller.tpl"}
                </div>
            </div>

        </div>
    </div>  
{/block}