{if count($paper_types)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>ID</th>
                        <th>Date</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $paper_types as $paper_type}
                        <tr class="tb-tnx-item">
                            <td>{$paper_type.title}</td>
                            <td>
                                <span class="js_moment" data-time="{$paper_type.date_add}">{$paper_type.date_add}</span>
                            </td>
                            <td class="tb-tnx-action">
                                <div class="dropdown">
                                    <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$paper_type.paper_type_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$paper_type.paper_type_id}">
                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editPaperTypeModal" data-size="small" data-options='{$paper_type|json_encode nofilter}'>
                                            <em class="icon ni ni-edit"></em><span>Edit</span>
                                        </a>
                                        {if $paper_type.paper_type_id != '64'}
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="paper_type" data-id="{$paper_type.paper_type_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        {/if}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted py-5"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No paper types to show</strong></p>
    </div>
{/if}

<!-- Add Paper Type -->
<script id="addPaperTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addPaperType" method="POST" autocomplete="off">
        <input type="hidden" name="is_academic_writing" value="1"/>
        <div class="modal-header">
            <h5 class="modal-title">Add Paper Type</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Paper Type</button>
        </div>
    </form>
</script>
<!-- Add Paper Type -->

<!-- Edit Paper Type -->
<script id="editPaperTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editPaperType" method="POST" autocomplete="off">
        <input type="hidden" name="paper_type_id" value="{literal}{{paper_type_id}}{/literal}">
        <input type="hidden" name="is_academic_writing" value="1"/>
        <div class="modal-header">
            <h5 class="modal-title">Edit Paper Type</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
            </div>

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
            <!-- success -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Paper Type -->