{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Preferences / <strong class="text-primary small">Article Writing</strong>
                    </h3> 
                </div>
                <div class="nk-block-head-content">
                    {if $controller == "contentTypes"}
                        <button type="button"  data-toggle="modal" data-url="#addContentTypeModal" data-size="small" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Content Type</span>
                        </button>
                    {/if}
                    

                    {if $controller == "categories"}
                        <button type="button" data-toggle="modal" data-url="#addCategoryModal" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Category</span>
                        </button>
                    {/if}
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>
        
        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "contentTypes"}active{/if}" href="{$base_uri}/preferences/articles/content-types" data-ajax="/preferences/articles/content-types"> 
                                {if $controller == "contentTypes"}<strong class="pr5">Content Types</strong>{else}Content Types{/if} 
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "categories"}active{/if}" href="{$base_uri}/preferences/articles/categories" data-ajax="/preferences/articles/categories"> 
                                {if $controller == "categories"}<strong class="pr5">Categories</strong>{else}Categories{/if} 
                            </a>
                        </li>
            
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "other"}active{/if}" href="{$base_uri}/preferences/articles/other" data-ajax="/preferences/articles/other"> 
                                {if $controller == "other"}<strong class="pr5">Other</strong>{else}Other{/if} 
                            </a>
                        </li>
                    </ul>

                    {include file="dashboard/preferences/articles/$controller.tpl"}
                </div>
            </div>

        </div>
    </div>  
{/block}