{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'} 
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Preferences / <strong class="text-primary small">Calculations</strong>
                    </h3> 
                </div>
                <div class="nk-block-head-content">
                    {if $controller == "descriptors"}
                        <button type="button" data-toggle="modal" data-url="#addDescriptorModal" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Descriptor</span>
                        </button>
                    {/if}

                    {if $controller == "pricing"}
                        <button type="button" data-toggle="modal" data-size="medium" data-url="#addItemPricingModal" class="btn btn-primary">
                            <em class="icon ni ni-plus"></em> <span>Add Item Pricing</span>
                        </button>
                    {/if}
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>
        
        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "disciplines"}active{/if}" href="{$base_uri}/preferences/calculations/disciplines" data-ajax="/preferences/calculations/disciplines"> 
                                {if $controller == "disciplines"}<strong class="pr5">Disciplines</strong>{else}Disciplines{/if} 
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link {if $controller == "descriptors"}active{/if}" href="{$base_uri}/preferences/calculations/descriptors" data-ajax="/preferences/calculations/descriptors"> 
                                {if $controller == "descriptors"}<strong class="pr5">Descriptors</strong>{else}Descriptors{/if} 
                            </a>
                        </li>
            
                        <li class="nav-item">
                            <a class="nav-link {if $controller == "pricing"}active{/if}" href="{$base_uri}/preferences/calculations/pricing" data-ajax="/preferences/calculations/pricing"> 
                                {if $controller == "pricing"}<strong class="pr5">Pricing</strong>{else}Pricing{/if} 
                            </a>
                        </li>
                    </ul>

                    {include file="dashboard/preferences/calculations/$controller.tpl"}
                </div>
            </div>

        </div>
    </div>  
{/block}