{if count($disciplines)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>Title</th>
                        <th>
                            <span class="pointer" data-toggle="tooltip" title="Complex Assignment">
                                <em class="icon ni ni-cmd"></em>
                            </span>
                        </th>
                        <th>
                            <span class="pointer" data-toggle="tooltip" title="Academic Writing">
                                <em class="icon ni ni-text"></em>
                            </span>
                        </th>
                        {if $is_calculations_enabled}
                            <th>
                                <span class="pointer" data-toggle="tooltip" title="Programming">
                                    <em class="icon ni ni-code"></em>
                                </span>
                            </th>
                        {/if}
                        {if $is_calculations_enabled}
                            <th>
                                <span class="pointer" data-toggle="tooltip" title="Calculations">
                                    <em class="icon ni ni-calc"></em>
                                </span>
                            </th>
                        {/if}
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead> 
                <tbody>
                    {foreach $disciplines as $discipline}
                        <tr class="tb-tnx-item">
                            <td>
                                {$discipline.title} {if isset($disciplineGroups[$discipline.discipline_id])}<span class="badge badge-secondary">Group</span>{/if}
                            </td>
                            <td>
                                {if $discipline.is_complex_assignment}
                                    <span class="icon ni ni-check text-success"></span>
                                {else}
                                    <span class="icon ni ni-cross text-danger"></span>
                                {/if}
                            </td>
                            <td>
                                {if $discipline.is_academic_writing}
                                    <span class="icon ni ni-check text-success"></span>
                                {else}
                                    <span class="icon ni ni-cross text-danger"></span>
                                {/if}
                            </td>
                            {if $is_programming_enabled}
                                <td>
                                    {if $discipline.is_programming}
                                        <span class="icon ni ni-check text-success"></span>
                                    {else}
                                        <span class="icon ni ni-cross text-danger"></span>
                                    {/if}
                                </td>
                            {/if}

                            {if $is_calculations_enabled}
                                <td>
                                    {if $discipline.is_calculations}
                                        <span class="icon ni ni-check text-success"></span>
                                    {else}
                                        <span class="icon ni ni-cross text-danger"></span>
                                    {/if}
                                </td>
                            {/if}
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$discipline.discipline_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$discipline.discipline_id}">
                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDisciplineModal" data-size="medium" data-options='{$discipline|json_encode nofilter}'>
                                            <em class="icon ni ni-edit"></em><span>Edit</span>
                                        </a>
                                        {if $discipline.discipline_id != '52'}
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="discipline" data-id="{$discipline.discipline_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        {/if}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No disciplines to show</strong></p>
    </div>
{/if}

<!-- Add Discipline -->
<script id="addDisciplineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDiscipline" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Discipline</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg">
            </div>

            {if count($disciplineGroups)}
                <div class="form-group">
                    <label class="form-label">Discipline group</label>
                    <select class="form-control form-control-lg" name="discipline_group">
                        <option value="-1">None</option>
                        {foreach $disciplineGroups as $disciplineGroup}
                            <optgroup label="{$disciplineGroup.title}">
                                {foreach $disciplineGroup.disciplines as $discipline}
                                    <option value="{$discipline.discipline_id}">{$discipline.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                    <span class="help-block">
                        Disciplines have groups. You might have a Chemistry discipline under Formal Science group. Totally optional.
                    </span>
                </div>
            {/if}

            <hr>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">Complex Assignment</div> 
                    <div class="form-text">Charge an extra 20% for the complexity of this Discipline</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <hr>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">
                        {include file='__svg_icons.tpl' icon="academic" class="mr5" width="20px" height="20px"} Academic Writing
                    </div> 
                    <div class="form-text">Custom papers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_academic_writing"> 
                        <input type="checkbox" name="is_academic_writing" id="is_academic_writing"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            {if $is_programming_enabled}
            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">
                        {include file='__svg_icons.tpl' icon="programming" class="mr5" width="20px" height="20px"} Programming
                    </div> 
                    <div class="form-text">Tech assignments</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_programming"> 
                        <input type="checkbox" name="is_programming" id="is_programming"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>
            {/if}

            {if $is_calculations_enabled}
            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">
                        {include file='__svg_icons.tpl' icon="calculations" class="mr5" width="20px" height="20px"} Calculations
                    </div> 
                    <div class="form-text">Problems solving</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_calculations"> 
                        <input type="checkbox" name="is_calculations" id="is_calculations"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>
            {/if}

            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Discipline</button>
        </div>
    </form>
</script>
<!-- Add Discipline -->

<!-- Edit Discipline -->
<script id="editDisciplineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDiscipline" method="POST" autocomplete="off">
        <input type="hidden" name="discipline_id" value="{literal}{{discipline_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Discipline</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
            </div>

            {if count($disciplineGroups)}
                <div class="form-group">
                    <label class="form-label">Discipline group</label>
                    <select class="form-control form-control-lg" name="discipline_group">
                        <option value="-1">None</option>
                        {foreach $disciplineGroups as $disciplineGroup}
                            <optgroup label="{$disciplineGroup.title}">
                                {foreach $disciplineGroup.disciplines as $discipline}
                                    <option value="{$discipline.discipline_id}">{$discipline.title}</option>
                                {/foreach}
                            </optgroup>
                        {/foreach}
                    </select>
                    <span class="help-block">
                        Disciplines have groups. You might have a Chemistry discipline under Formal Science group. Totally optional.
                    </span>
                </div>
            {/if}

            <hr>

            <div class="form-table-row mb0"> 
                <div> 
                    <div class="form-control-label h5">Complex Assignment</div> 
                    <div class="form-text">Charge an extra 20% for the complexity of this Discipline</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment" {literal}{{#is_complex_assignment}}{/literal}checked=""{literal}{{/is_complex_assignment}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <hr>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">
                        {include file='__svg_icons.tpl' icon="academic" class="mr5" width="20px" height="20px"} Academic Writing
                    </div> 
                    <div class="form-text">Custom papers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_academic_writing"> 
                        <input type="checkbox" name="is_academic_writing" id="is_academic_writing" {literal}{{#is_academic_writing}}{/literal}checked=""{literal}{{/is_academic_writing}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            {if $is_programming_enabled}
            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">
                        {include file='__svg_icons.tpl' icon="programming" class="mr5" width="20px" height="20px"} Programming
                    </div> 
                    <div class="form-text">Tech assignments</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_programming"> 
                        <input type="checkbox" name="is_programming" id="is_programming" {literal}{{#is_programming}}{/literal}checked=""{literal}{{/is_programming}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>
            {/if}

            {if $is_calculations_enabled}
            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">
                        {include file='__svg_icons.tpl' icon="calculations" class="mr5" width="20px" height="20px"} Calculations
                    </div> 
                    <div class="form-text">Problems solving</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_calculations"> 
                        <input type="checkbox" name="is_calculations" id="is_calculations" {literal}{{#is_calculations}}{/literal}checked=""{literal}{{/is_calculations}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>
            {/if}

            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Discipline -->