{if count($uploadTypes)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx">
                <thead>
                    <tr class="tb-tnx-head">
                        <th>Title</th>
                        <th>Customer</th>
                        <th>Writer</th>
                        <th>Editor</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $uploadTypes as $upload_type}
                        <tr class="tb-tnx-item">
                            <td>{$upload_type.title}</td>
                            <td>
                                {if $upload_type.customer}
                                    <span class="fas fa-check text-success"></span>
                                {else}
                                    <span class="fas fa-times text-danger"></span>
                                {/if}
                            </td>
                            <td>
                                {if $upload_type.writer}
                                    <span class="fas fa-check text-success"></span>
                                {else}
                                    <span class="fas fa-times text-danger"></span>
                                {/if}
                            </td>
                            <td>
                                {if $upload_type.editor}
                                    <span class="fas fa-check text-success"></span>
                                {else}
                                    <span class="fas fa-times text-danger"></span>
                                {/if}
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$upload_type.upload_type_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        Actions
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$upload_type.upload_type_id}">
                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editUploadTypeModal" data-size="medium" data-options='{$upload_type|json_encode nofilter}'>
                                            <em class="icon ni ni-edit"></em><span>Edit</span>
                                        </a>
                                        {if $upload_type.upload_type_id != '39'}
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="upload_type" data-id="{$upload_type.upload_type_id}">
                                                <i class="fas fa-trash mr5"></i> Delete
                                            </a>
                                        {/if}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No upload types to show</strong></p>
    </div>
{/if}

<!-- Add Upload Type -->
<script id="addUploadTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addUploadType" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Upload Type</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg">
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Customer</div> 
                    <div class="form-text">Show this option to customers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="customer"> 
                        <input type="checkbox" name="customer" id="customer"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Writer</div> 
                    <div class="form-text">Show this option to writers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="writer"> 
                        <input type="checkbox" name="writer" id="writer"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">Editor</div> 
                    <div class="form-text">Show this option to editors</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="editor"> 
                        <input type="checkbox" name="editor" id="editor"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Upload Type</button>
        </div>
    </form>
</script>
<!-- Add Upload Type -->

<!-- Edit Upload Type -->
<script id="editUploadTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editUploadType" method="POST" autocomplete="off">
        <input type="hidden" name="upload_type_id" value="{literal}{{upload_type_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Upload Type</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Title</label>
                <input name="title" type="text" class="form-control form-control-lg" value="{literal}{{title}}{/literal}">
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Customer</div> 
                    <div class="form-text">Show this option to customers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="customer"> 
                        <input type="checkbox" name="customer" id="customer" {literal}{{#customer}}{/literal}checked=""{literal}{{/customer}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Writer</div> 
                    <div class="form-text">Show this option to writers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="writer"> 
                        <input type="checkbox" name="writer" id="writer" {literal}{{#writer}}{/literal}checked=""{literal}{{/writer}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">Editor</div> 
                    <div class="form-text">Show this option to editors</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="editor"> 
                        <input type="checkbox" name="editor" id="editor" {literal}{{#editor}}{/literal}checked=""{literal}{{/editor}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Upload Type -->