{if count($disciplines)}
    <div class="card-inner-group">
        <div class="card-inner p-0">
            <table class="table table-tranx table-bordered">
                <thead>
                    <tr class="tb-tnx-head">
                        <th width="15%">Discipline</th>
                        <th>Tasks</th>
                        <th>Deliverables</th>
                        <th class="tb-tnx-action">Actions</th>
                    </tr>
                </thead> 
                <tbody>
                    {foreach $disciplines as $discipline}
                        <tr class="tb-tnx-head">
                            <th colspan="4">{$discipline.title}</th>
                        </tr>
                        {if isset($descriptorsByDiscipline[$discipline.discipline_id])}
                            {foreach $descriptorsByDiscipline[$discipline.discipline_id] as $descriptor}
                                <tr class="tb-tnx-item">
                                    <th>&nbsp;</th>
                                    <th class="vm" headers="blank">
                                        {$descriptor.task_size_title}
                                    </th>
                                    <th width="60%" headers="blank">
                                        <div class="text-muted mb-1 fs-15px fw-bold">{$descriptor.example}</div>
                                        <ul class="task_deliverables">
                                            {foreach $descriptor.deliverables as $deliverable}
                                                <li class="fs-14px task_deliverables_item task_deliverables_item--{$deliverable.slug}">{$deliverable.name}</li>
                                            {/foreach}
                                        </ul>
                                    </th>
                                    <th id="co4" headers="blank">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$descriptor.descriptor_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$descriptor.descriptor_id}">
                                                <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDescriptorModal-{$descriptor.descriptor_id}" data-size="medium" data-options='{$descriptor|json_encode nofilter}'>
                                                    <i class="fas fa-pencil-alt mr5"></i> Edit
                                                </a>
                                                <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="descriptor" data-id="{$descriptor.descriptor_id}">
                                                    <i class="fas fa-trash mr5"></i> Delete
                                                </a>
                                            </div>
                                        </div>
                                        
                                        <!-- Edit Descriptor -->
                                        <script id="editDescriptorModal-{$descriptor.descriptor_id}" type="text/template">
                                            <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDescriptor" method="POST" autocomplete="off">
                                                <input type="hidden" name="descriptor_id" value="{$descriptor.descriptor_id}">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Edit Descriptor</h5>
                                                    <span class="close" data-dismiss="modal" aria-label="Close">
                                                        <em class="icon ni ni-cross"></em>
                                                    </span>
                                                </div>

                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label class="form-label">Discipline</label>
                                                        <select class="form-select" data-search="on" data-ui="lg" name="discipline_id">
                                                            {foreach $disciplines as $discipline}
                                                                <option value="{$discipline.discipline_id}" {if $discipline.discipline_id == $descriptor.discipline_id}selected{/if}>{$discipline.title}</option>
                                                            {/foreach}
                                                        </select>
                                                    </div>

                                                    <div class="form-group">
                                                        <label class="form-label">Example</label>
                                                        <input name="example" type="text" class="form-control form-control-lg" value="{$descriptor.example}" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <label class="form-label">Task Size</label>
                                                        <div class="">
                                                            <div class="btn-fullwidth">
                                                                {foreach from=$taskSizes item=$taskSize key=$sizeId}
                                                                    <label class="selectgroup-item" id="task_size_{$sizeId}">
                                                                        <input for="task_size_{$sizeId}" type="radio" name="task_size" {if $descriptor.task_size_id == $sizeId}checked=""{/if} value="{$sizeId}" class="selectgroup-input">
                                                                        <span class="selectgroup-button">{$taskSize.title}</span>
                                                                    </label>
                                                                {/foreach}
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="form-group">
                                                        <label class="form-label">Possible deliverables</label>
                                                        <div class="">
                                                            <div class="btn-fullwidth">
                                                                <select class="form-select" data-search="on" data-ui="lg" name="deliverables[]" multiple="" size="10">
                                                                    {foreach $deliverables as $deliverable}
                                                                        <option value="{$deliverable.deliverable_id}" {if isset($descriptor.deliverables[$deliverable.deliverable_id])}selected{/if}>{$deliverable.name}</option>
                                                                    {/foreach}
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!-- success -->
                                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                    <!-- success -->

                                                    <!-- error -->
                                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                                    <!-- error -->
                                                </div>
                                                
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                                                </div>
                                            </form>
                                        </script>
                                        <!-- Edit Descriptor -->
                                    </th>
                                </tr>
                            {/foreach}
                        {/if}
                    {/foreach}
                </tbody>
            </table>
        </div>

        {if $pager}
            <div class="card-inner">
                {$pager nofilter}
            </div>
        {/if}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No task sizes to show</strong></p>
    </div>
{/if}

<!-- Add Descriptor -->
<script id="addDescriptorModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDescriptor" method="POST" autocomplete="off">
        <input type="hidden" name="is_programming" value="1">
        <div class="modal-header">
            <h5 class="modal-title">Add Descriptor</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div> 

        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Discipline</label>
                <select class="form-select" data-search="on" data-ui="lg" name="discipline_id">
                    {foreach $disciplines as $discipline}
                        <option value="{$discipline.discipline_id}">{$discipline.title}</option>
                    {/foreach}
                </select>
            </div>

            <div class="form-group">
                <label class="form-label">Example</label>
                <input name="example" type="text" class="form-control form-control-lg" required>
            </div>

            <div class="form-group">
                <label class="form-label">Task Size</label>
                <div class="">
                    <div class="btn-fullwidth">
                        {foreach from=$taskSizes item=$taskSize key=$sizeId}
                            <label class="selectgroup-item" id="task_size_{$sizeId}">
                                <input for="task_size_{$sizeId}" type="radio" name="task_size" {if $sizeId == '1'}checked=""{/if} value="{$sizeId}" class="selectgroup-input">
                                <span class="selectgroup-button">{$taskSize.title}</span>
                            </label>
                        {/foreach}
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Possible deliverables</label>
                <div class="">
                    <div class="btn-fullwidth">
                        <select class="form-select" data-search="on" data-ui="lg" name="deliverables[]" multiple="" size="10">
                            {foreach $deliverables as $deliverable}
                                <option value="{$deliverable.deliverable_id}">{$deliverable.name}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>
            </div>
            
            <!-- success -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Descriptor</button>
        </div>
    </form>
</script>
<!-- Add Descriptor -->