{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Ratings
                    </h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">
            <div class="row g-gs">
                <div class="col-md-12 col-lg-6">
                    <div class="card card-bordered">
                        <div class="card-inner">
                            <h6 class="card-title">Customer Rating</h6>
                            <div class="d-flex align-center gy-3">
                                <div class="progress-amount mr-4">
                                    <h1 class="title">{$insights['average_customer_rating']}</h1>
                                    <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_customer_rating']}">
                                        <span class="Rating-total">
                                            <span class="Rating-progress"></span>
                                        </span>
                                    </div>
                                    <span class="sub-text mt-1"><em class="icon ni ni-users-fill"></em> {$insights['total_customer_reviews']} Total</span>
                                </div>

                                <div class="rating-progress-bar gy-2 w-100">
                                    {foreach range(1,5) as $i}
                                        <div class="progress-rating">
                                            <div class="progress-rating-title">{$i} star</div>
                                            {if isset($insights['customer_ratings'][$i])}
                                                <div class="progress progress-md progress-alt">
                                                    <div class="progress-bar mb-0 bg-teal" data-progress="{$insights['customer_ratings'][$i]['width']}"></div>
                                                </div>
                                                <div class="progress-rating-percent">{$insights['customer_ratings'][$i]['total_rating']}</div>
                                            {else}
                                                <div class="progress progress-md progress-alt">
                                                    <div class="progress-bar mb-0 bg-teal" data-progress="0" style="width: 0%;"></div>
                                                </div>
                                                <div class="progress-rating-percent">0</div>
                                            {/if}
                                        </div>
                                    {/foreach}
                                </div>
                            </div>
                        </div>
                        <!-- .card-inner -->
                    </div>
                </div>

                <div class="col-md-12 col-lg-6">
                    <div class="card card-bordered">
                        <div class="card-inner">
                            <h6 class="card-title">Editor Rating</h6>
                            <div class="d-flex align-center gy-3">
                                <div class="progress-amount mr-4">
                                    <h1 class="title">{$insights['average_editor_rating']}</h1>
                                    <div class="Rating Rating--large Rating--labeled" data-star_rating="{$insights['average_editor_rating']}">
                                        <span class="Rating-total">
                                            <span class="Rating-progress"></span>
                                        </span>
                                    </div>
                                    <span class="sub-text mt-1"><em class="icon ni ni-users-fill"></em> {$insights['total_editor_reviews']} Total</span>
                                </div>

                                <div class="rating-progress-bar gy-2 w-100">
                                    {foreach range(1,5) as $i}
                                        <div class="progress-rating">
                                            <div class="progress-rating-title">{$i} star</div>
                                            {if isset($insights['editor_ratings'][$i])}
                                                <div class="progress progress-md progress-alt">
                                                    <div class="progress-bar mb-0 bg-teal" data-progress="{$insights['editor_ratings'][$i]['width']}"></div>
                                                </div>
                                                <div class="progress-rating-percent">{$insights['editor_ratings'][$i]['total_rating']}</div>
                                            {else}
                                                <div class="progress progress-md progress-alt">
                                                    <div class="progress-bar mb-0 bg-teal" data-progress="0" style="width: 0%;"></div>
                                                </div>
                                                <div class="progress-rating-percent">0</div>
                                            {/if}
                                        </div>
                                    {/foreach}
                                </div>
                            </div>
                        </div>
                        <!-- .card-inner -->
                    </div>
                </div>
            </div>

        </div>

        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Ratings</h4>
                <p>You have total {pluralize('review', count($ratings))}.</p>
            </div>
        </div>

        {if count($ratings)}
            <div class="table-responsive">
                <table class="nk-tb-list is-separate nk-tb-ulist mb-3">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col">Order ID</th>
                            <th class="nk-tb-col">Paper Rating</th>
                            <th class="nk-tb-col tb-col-md">Paper on Time</th>
                            <th class="nk-tb-col">Date</th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $ratings as $rating}
                            <tr class="nk-tb-item {if $rating.user_type == 'employee'}info{/if}">
                                <td class="nk-tb-col">
                                    <a class="fw-bold" target="_blank" href="{$base_uri}/order/{$rating.order_id}" data-ajax="/order/{$rating.order_id}">#{$rating.order_id}</a>
                                </td>
                                <td class="nk-tb-col">  
                                    <div class="Rating Rating--labeled" data-star_rating="{$rating.paper_rating}">
                                        <span class="Rating-total">
                                            <span class="Rating-progress"></span>
                                        </span>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-md">
                                    {if $rating.paper_on_time}
                                        <span class="badge badge-success">Yes</span>
                                    {else}
                                        <span class="badge badge-danger">No</span>
                                    {/if}
                                </td>
                                <td class="nk-tb-col">
                                    <span class="js_moment" data-time="{$rating.date}">{$rating.date}</span>
                                </td>
                                <td class="nk-tb-col nk-tb-col-tools">
                                    <ul class="nk-tb-actions gx-1">
                                        <li>
                                            <button class="btn btn-primary btn-sm btn-dim" data-toggle="modal" data-url="#viewRatingsModal" data-options="{$rating|json_encode}">
                                                <i class="icon ni ni-eye mr5"></i> <span>View</span>
                                            </button>
                                        </li>
                                    </ul>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>

                {$pager nofilter}
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                <h6 class="text-dark title mb-3">No ratings to show</h6>
            </div>
        {/if} 
    </div>

    <script id="viewRatingsModal" type="text/template">
        <div class="modal-header fc-event-primary">
            <h5 class="modal-title">View Ratings</h5>
            <a href="#" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">
            <div class="row gy-3 py-1">
                <div class="col-sm-6">
                    <h6 class="overline-title">Order ID</h6>
                    <a target="_blank" class="fw-bold" href="{$base_uri}/order/{literal}{{order_id}}{/literal}">#{literal}{{order_id}}{/literal}</a>
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Customer ID</h6>
                    <p class="fw-bold">#{literal}{{user_id}}{/literal}</p>
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Paper Rating</h6>
                    <div class="Rating Rating--labeled" data-star_rating="{literal}{{paper_rating}}{/literal}">
                        <span class="Rating-total">
                            <span class="Rating-progress"></span>
                        </span>
                    </div>
                </div>
                <div class="col-sm-6">
                    <h6 class="overline-title">Paper on Time</h6>
                    {literal}{{#paper_on_time}}{/literal}
                        <span class="badge badge-success">Yes</span>
                    {literal}{{/paper_on_time}}{/literal}

                    {literal}{{^paper_on_time}}{/literal}
                        <span class="badge badge-danger">No</span>
                    {literal}{{/paper_on_time}}{/literal}
                </div>

                {literal}{{#comment}}{/literal}
                <div class="col-sm-10">
                    <h6 class="overline-title">Comment</h6>
                    <p>{literal} {{{ comment }}} {/literal}</p>
                </div>
                {literal}{{/comment}}{/literal}
            </div>
        </div>
    </script>
{/block}