{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}

    {if $sub_view == "currency"}
        <div class="{if $chat_enabled}wide-md{else}wide-lg{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">
                            Settings / <strong class="text-primary small">Currency</strong>
                        </h3> 
                    </div>
                    <div class="nk-block-head-content">
                        {if $sub_view == "currency"}
                            <a href="{$base_uri}/system/currency/add" class="btn btn-primary">
                                <em class="icon ni ni-plus"></em> <span>Add New Currency</span>
                            </a>
                        {/if}
                    </div>
                </div>
            </div> 

            <div class="nk-block">
                {if count($currencies)}
                    <table class="nk-tb-list is-separate nk-tb-ulist mb-3">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th class="nk-tb-col">Title</th>
                                <th class="nk-tb-col">Currency</th>
                                <th class="nk-tb-col">Symbol</th>
                                <th class="nk-tb-col">Exchange Rate</th>
                                <th class="nk-tb-col">Status</th>
                                <th class="nk-tb-col nk-tb-col-tools text-right">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="tb-odr-body">
                            {foreach $currencies as $currency}
                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col fw-bold">
                                        <a class="fw-bold" href="{$base_uri}/system/currency/edit/{$currency.id}" data-ajax="/system/currency/edit/{$currency.id}">{$currency.title}</a>
                                    </td>
                                    <td class="nk-tb-col fw-bold">{$currency.iso_code}</td>
                                    <td class="nk-tb-col fw-bold">{$currency.symbol}</td>
                                    <td class="nk-tb-col">{$currency.conversion_rate}</td>
                                    <td class="nk-tb-col">
                                        {if $currency.active}
                                            <span class="badge badge-dot badge-success">Active</span>
                                        {else}
                                            <span class="badge badge-dot badge-danger">Inactive</span>
                                        {/if}    
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <ul class="nk-tb-actions gx-1">
                                            <li>
                                                <div class="dropdown">
                                                    <button class="dropdown-toggle btn btn-sm btn-icon btn-trigger" data-toggle="dropdown" type="button" id="dropdownMenu-{$currency.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <em class="icon ni ni-more-h"></em>
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" aria-labelledby="dropdownMenu-{$currency.id}">
                                                        <ul class="link-list-opt no-bdr">
                                                            <li>
                                                                <a href="{$base_uri}/system/currency/edit/{$currency.id}" data-ajax="/system/currency/edit/{$currency.id}">
                                                                    <em class="icon ni ni-edit"></em> <span>Edit</span>
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a class="js_deleter" href="javascript:void(0);" data-handle="currency" data-id="{$currency.id}">
                                                                    <em class="icon ni ni-trash"></em> <span>Delete</span>
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    <div class="nk-block-between-md g-3">
                        <div class="g">
                            {$pager nofilter}
                        </div>
                    </div><!-- .nk-block-between -->
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">No currencies to show</h6>
                    </div>
                {/if}
            </div>
        </div>
    {elseif $sub_view == "edit"}
        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/system/currency" data-ajax="/system/currency">
                            <em class="icon ni ni-arrow-left"></em><span>Currency</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Edit currency</h2>
                </div>
            </div>
        
            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms form-horizontal" data-url="/admin/currency?do=edit">
                        <input type="hidden" name="currency_id" value="{$currency.id}"/>
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Title
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="title" value="{$currency.title}" required>
                                <span class="help-block">
                                    Currency title i.e US Dollars, Canadian Dollars
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                ISO Code
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="iso_code" value="{$currency.iso_code}" required>
                                <span class="help-block">
                                    Currency ISO Code i.e USD, GBP. List of <a target="_blank" href="https://www.iban.com/currency-codes">ISO Codes</a>.
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Symbol
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="symbol"  value="{$currency.symbol}" required>
                                <span class="help-block">
                                    Currency symbol €, £, $, ¥ 
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Exchange Rate
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control force-integer" type="text" name="conversion_rate" value="{$currency.conversion_rate}" required>
                                <span class="help-block">
                                    1 USD is equivalent to the <strong>Exchange Rate</strong> this currency. Default is 1
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Active
                            </label>
                            <div class="col-sm-9">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="active" id="active" {if $currency.active == '1'}checked="checked"{/if}>
                                    <label class="custom-control-label" for="active">Display this currency in checkout forms</label>
                                </div>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->

                                <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                <!-- success -->
        
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </div>
        
                    </form>
                </div>
            </div>
        </div>
    {elseif $sub_view == "add"}
        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="{$base_uri}/system/currency" data-ajax="/system/currency">
                            <em class="icon ni ni-arrow-left"></em><span>Currency</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Add currency</h2>
                </div>
            </div>
        
            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms form-horizontal" data-url="/admin/currency?do=add">
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Title
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="title" required>
                                <span class="help-block">
                                    Currency title i.e US Dollars, Canadian Dollars
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                ISO Code
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="iso_code" required>
                                <span class="help-block">
                                    Currency ISO Code i.e USD, GBP. List of <a target="_blank" href="https://www.iban.com/currency-codes">ISO Codes</a>.
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Symbol
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="symbol" required>
                                <span class="help-block">
                                    Currency symbol €, £, $, ¥ 
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <label class="col-sm-3 form-label text-left">
                                Exchange Rate
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control force-integer" type="text" name="conversion_rate" required>
                                <span class="help-block">
                                    1 USD is equivalent to the <strong>Exchange Rate</strong> this currency. Default is 1
                                </span>
                            </div>
                        </div>
        
                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->

                                <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                <!-- success -->
        
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </div>
        
                    </form>
                </div>
            </div>
        </div>
    {/if}

{/block}