{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-md{else}wide-lg{/if}">

        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">
                        Settings / <strong class="text-primary small">System Settings</strong>
                    </h3> 
                </div>
            </div> 
        </div>

        <div class="nk-block">  
            <div class="card">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link active" href="#general" data-toggle="tab">
                                <i class="icon ni ni-server fa-fw mr-1"></i>
                                <strong class="pr5">General</strong>
                            </a>
                        </li>
    
                        <li class="nav-item">
                            <a class="nav-link" href="#email" data-toggle="tab">
                                <i class="icon ni ni-mail fa-fw mr-1"></i>
                                <strong class="pr5">Email</strong>
                            </a>
                        </li>
                    </ul>

                    <div class="card-inner">
                        <!-- tabs content -->
                        <div class="tab-content">

                            <!-- General -->
                            <div class="tab-pane active" id="general">
                                <form class="js_ajax-forms form-horizontal" data-url="/admin/settings?edit=general_settings">
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Site ID</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" value="{$formValues.SITE_ID}" readonly>
                                            <span class="help-block">
                                                Your administrator site ID
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Website Light Logo</label>
                                        <div class="col-sm-9">
                                            {if $site_logo == ''}
                                                <div class="x-image">
                                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_logo" value="">
                                                </div>
                                            {else}
                                                <div class="x-image" style="background-image: url('{$uploads_path}/{$site_logo}')">
                                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_logo" value="{$site_logo}">
                                                </div>
                                            {/if}
                                            <span class="help-block">
                                                The perfect size for your logo should be (width: 130px & height: 50px)
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Website Dark Logo</label>
                                        <div class="col-sm-9">
                                            {if $site_dark_logo == ''}
                                                <div class="x-image">
                                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_dark_logo" value="">
                                                </div>
                                            {else}
                                                <div class="x-image" style="background-image: url('{$uploads_path}/{$site_dark_logo}')">
                                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_dark_logo" value="{$site_dark_logo}">
                                                </div>
                                            {/if}
                                            <span class="help-block">
                                                The perfect size for your logo should be (width: 130px & height: 50px)
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Site Favicon</label>
                                        <div class="col-sm-9">
                                            {if $formValues.SITE_FAVICON == ''}
                                                <div class="x-image">
                                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_favicon" value="">
                                                </div>
                                            {else} 
                                                <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_FAVICON}')">
                                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_favicon" value="{$formValues.SITE_FAVICON}">
                                                </div>
                                            {/if}
                                            <span class="help-block">
                                                The perfect size for your favicon should be (width: 196px & height: 196px)
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Email Logo</label>
                                        <div class="col-sm-9">
                                            {if $formValues.SITE_EMAIL_LOGO == ''}
                                                <div class="x-image">
                                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_email_logo" value="">
                                                </div>
                                            {else}
                                                <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_EMAIL_LOGO}')">
                                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="site_email_logo" value="{$formValues.SITE_EMAIL_LOGO}">
                                                </div>
                                            {/if}
                                            <span class="help-block">
                                                The perfect size for your logo should be (width: 130px & height: 50px)
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            Website Title
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="site_name" value="{$formValues.SITE_NAME}">
                                            <span class="help-block">
                                                Title of your website
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            Website Domain
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="site_domain" value="{$formValues.SITE_DOMAIN}">
                                            <span class="help-block">
                                                URL of your website
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            Website Email
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control form-control-lg" name="site_email" value="{$formValues.SITE_EMAIL}">
                                            <span class="help-block">
                                                The contact email that all messages send to
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Notification Emails</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="notification_emails" value="{$formValues.NOTIFICATION_EMAILS}">
                                            <span class="help-block">
                                                Additional contact emails that will receive notifications. Separate by a comma <strong>,</strong>
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Lifetime of dashboard cookies</label>
                                        <div class="col-sm-9">
                                            <div class="form-control-wrap" style="max-width:200px">
                                                <div class="form-icon lg form-icon-right">
                                                    <em class="icon ni ni-clock"></em>
                                                </div>
                                                <input type="text" class="form-control form-control-lg force-integer" name="cookie_lifetime" value="{$formValues.COOKIE_LIFETIME}">
                                            </div>
                                            <div class="form-text">
                                                Set the amount of hours during which the dashboard cookies are valid. After that amount of time, the employee will have to log in again.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            Default Timezone
                                        </label>
                                        <div class="col-md-4">
                                            <select id="timezone-region" class="form-select" data-ui="lg" data-combo="timezone-combo">
                                                {foreach from=$regions item=region key=key name=name}
                                                    <option value="{$key}" {if $default_region == $key } selected="" {/if} >{$key}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                        <div id="timezone-combo" class="col-md-5">
                                            {foreach from=$regions item=region key=key name=name}
                                                <div id="timezone-combo-{$key}" class="{if $default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                                    <select data-ui="lg" class="form-select">
                                                        {foreach from=$region item=item key=key name=name}
                                                            <option value="{$key}" {if $default_timezone == $key } selected="" {/if} >{$item}</option>
                                                        {/foreach}
                                                    </select>
                                                </div>
                                            {/foreach}
                                        </div>
                                    </div>
                                    <input type="hidden" id="timezone" name="default_timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">

                                    <div class="divider"></div>

                                    <div class="form-table-row"> 
                                        <div> 
                                            <div class="form-control-label h6 fw-500">Registration Enabled</div> 
                                            <div class="form-text">Allow users to create accounts</div> 
                                        </div> 
                                        <div class="text-right"> 
                                            <label class="switch" for="registration_enabled"> 
                                                <input type="checkbox" name="registration_enabled" id="registration_enabled" {if $formValues.REGISTRATION_ENABLED}checked{/if}> 
                                                <span class="slider round"></span> 
                                            </label> 
                                        </div> 
                                    </div>

                                    <div class="form-table-row">
                                        <div>
                                            <div class="form-control-label h6 fw-500">Cookie Consent (GDPR)</div>
                                            <div class="form-text">Turn the cookie consent notification On and Off</div>
                                        </div>
                                        <div class="text-right"> 
                                            <label class="switch" for="cookie_consent_enabled"> 
                                                <input type="checkbox" name="cookie_consent_enabled" id="cookie_consent_enabled"  {if $formValues.COOKIE_CONSENT_ENABLED}checked{/if}> 
                                                <span class="slider round"></span> 
                                            </label> 
                                        </div>
                                    </div>

                                    <div class="form-table-row"> 
                                        <div> 
                                            <div class="form-control-label h6 fw-500">PWA Enabled</div>
                                            <div class="form-text">Enable Progressive Web App (PWA)</div> 
                                        </div> 
                                        <div class="text-right"> 
                                            <label class="switch" for="pwa_enabled"> 
                                                <input type="checkbox" name="pwa_enabled" id="pwa_enabled" {if $formValues.PWA_ENABLED == '1'}checked{/if}> 
                                                <span class="slider round"></span> 
                                            </label> 
                                        </div> 
                                    </div>

                                    <div class="heading-small mb20">Manifest Settings</div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Application Icon</label>
                                        <div class="col-sm-9">
                                            {if $formValues.PWA_APP_ICON == ''}
                                                <div class="x-image">
                                                    <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div>
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-localstorage data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="pwa_app_icon" value="">
                                                </div>
                                            {else}
                                                <div class="x-image" style="background-image: url('{$base_uri}/uploads/{$formValues.PWA_APP_ICON}')">
                                                    <button type="button" class="close js_x-image-remover" title='Remove'>
                                                        <span>×</span>
                                                    </button>
                                                    <div class="loader loader_small x-hidden"></div> 
                                                    <i class="icon ni ni-camera-fill js_x-uploader" data-localstorage data-handle="x-image"></i>
                                                    <input type="hidden" class="js_x-image-input" name="pwa_app_icon" value="{$formValues.PWA_APP_ICON}">
                                                </div>
                                            {/if}
                                            <span class="help-block">
                                                The perfect size for your icon should be (width: 512px & height: 512px)
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Application Name</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="pwa_app_name" value="{$formValues.PWA_APP_NAME}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Short Name</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="pwa_short_name" value="{$formValues.PWA_SHORT_NAME}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Theme Color</label>
                                        <div class="col-sm-9">
                                            <div class="input-group js_colorpicker">
                                                <input name="pwa_theme_color" type="text" class="form-control form-control-lg" value="{$formValues.PWA_THEME_COLOR}">
                                                <span class="input-group-append"> 
                                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Background Color</label>
                                        <div class="col-sm-9">
                                            <div class="input-group js_colorpicker">
                                                <input name="pwa_background_color" type="text" class="form-control form-control-lg" value="{$formValues.PWA_BACKGROUND_COLOR}">
                                                <span class="input-group-append"> 
                                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="divider"></div>

                                    <div class="form-table-row"> 
                                        <div> 
                                            <div class="form-control-label h6 fw-500">Enable Customization</div> 
                                            <div class="form-text">Turn the customization On and Off</div> 
                                        </div> 
                                        <div class="text-right"> 
                                            <label class="switch" for="css_customize"> 
                                                <input type="checkbox" name="css_customize" id="css_customize" {if $formValues.CSS_CUSTOMIZE}checked{/if}> 
                                                <span class="slider round"></span> 
                                            </label> 
                                        </div> 
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Header Color</label>
                                        <div class="col-sm-9">
                                            <div class="input-group js_colorpicker">
                                                <input name="header_color" type="text" class="form-control form-control-lg" value="{$formValues.HEADER_COLOR}">
                                                <span class="input-group-append"> 
                                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Button Primary</label>
                                        <div class="col-sm-9">
                                            <div class="input-group js_colorpicker">
                                                <input name="btn_primary_color" type="text" class="form-control form-control-lg" value="{$formValues.BUTTON_PRIMARY}">
                                                <span class="input-group-append"> 
                                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">Menu Background</label>
                                        <div class="col-sm-9">
                                            <div class="input-group js_colorpicker">
                                                <input name="menu_background_color" type="text" class="form-control form-control-lg" value="{$formValues.MENU_BACKGROUND}">
                                                <span class="input-group-append"> 
                                                    <span class="input-group-text colorpicker-input-addon"><i></i></span>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">Custom CSS</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control form-control-lg js_autosize" rows="10" name="custom_css" id="custom-css">{$formValues.CUSTOM_CSS nofilter}</textarea>
                                            <span class="help-block">Header Custom CSS
                                            </span>
                                        </div>
                                    </div>

                                    <div class="simplebar-content" style="padding: 0px;">
                                        <div class="nk-opt-set">
                                            <div class="nk-opt-set-title">Main UI Style</div>
                                            <div class="nk-opt-list col-2x">
                                                <div class="nk-opt-item only-text {if $themeOptions.style == 'ui-default'}active{/if}" data-key="style" data-update="ui-default">
                                                    <input class="x-hidden" type="radio" name="customize[style]" value="ui-default" {if $themeOptions.style == 'ui-default'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="nk-opt-item-name">Default</span></span>
                                                </div>
                                                <div class="nk-opt-item only-text {if $themeOptions.style == 'ui-bordered'}active{/if}" data-key="style" data-update="ui-bordered">
                                                    <input class="x-hidden" type="radio" name="customize[style]" value="ui-bordered" {if $themeOptions.style == 'ui-bordered'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="nk-opt-item-name">Bordered</span></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="nk-opt-set nk-opt-set-aside">
                                            <div class="nk-opt-set-title">Sidebar Style</div>
                                            <div class="nk-opt-list col-4x">
                                                <div class="nk-opt-item {if $themeOptions.aside == 'is-light'}active{/if}" data-key="aside" data-update="is-light">
                                                    <input class="x-hidden" type="radio" name="customize[aside]" value="is-light" {if $themeOptions.aside == 'is-light'}checked{/if}/>
                                                    <span class="nk-opt-item-bg is-light"><span class="bg-lighter"></span></span><span class="nk-opt-item-name">White</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.aside == 'is-default'}active{/if}" data-key="aside" data-update="is-default">
                                                    <input class="x-hidden" type="radio" name="customize[aside]" value="is-default" {if $themeOptions.aside == 'is-default'}checked{/if}/>
                                                    <span class="nk-opt-item-bg is-light"><span class="bg-light"></span></span><span class="nk-opt-item-name">Light</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.aside == 'is-dark'}active{/if}" data-key="aside" data-update="is-dark">
                                                    <input class="x-hidden" type="radio" name="customize[aside]" value="is-dark" {if $themeOptions.aside == 'is-dark'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="bg-dark"></span></span><span class="nk-opt-item-name">Dark</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.aside == 'is-theme'}active{/if}" data-key="aside" data-update="is-theme">
                                                    <input class="x-hidden" type="radio" name="customize[aside]" value="is-theme" {if $themeOptions.aside == 'is-theme'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="bg-theme"></span></span><span class="nk-opt-item-name">Theme</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="nk-opt-set nk-opt-set-header">
                                            <div class="nk-opt-set-title">Header Style</div>
                                            <div class="nk-opt-list col-4x">
                                                <div class="nk-opt-item {if $themeOptions.header == 'is-light'}active{/if}" data-key="header" data-update="is-light">
                                                    <input class="x-hidden" type="radio" name="customize[header]" value="is-light" {if $themeOptions.header == 'is-light'}checked{/if}/>
                                                    <span class="nk-opt-item-bg is-light"><span class="bg-lighter"></span></span><span class="nk-opt-item-name">White</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.header == 'is-default'}active{/if}" data-key="header" data-update="is-default">
                                                    <input class="x-hidden" type="radio" name="customize[header]" value="is-default" {if $themeOptions.header == 'is-default'}checked{/if}/>
                                                    <span class="nk-opt-item-bg is-light"><span class="bg-light"></span></span><span class="nk-opt-item-name">Light</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.header == 'is-dark'}active{/if}" data-key="header" data-update="is-dark">
                                                    <input class="x-hidden" type="radio" name="customize[header]" value="is-dark" {if $themeOptions.header == 'is-dark'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="bg-dark"></span></span><span class="nk-opt-item-name">Dark</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.header == 'is-theme'}active{/if}" data-key="header" data-update="is-theme">
                                                    <input class="x-hidden" type="radio" name="customize[header]" value="is-theme" {if $themeOptions.header == 'is-theme'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="bg-theme"></span></span><span class="nk-opt-item-name">Theme</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="nk-opt-set nk-opt-set-skin">
                                            <div class="nk-opt-set-title">Primary Skin</div>
                                            <div class="nk-opt-list">
                                                <div class="nk-opt-item {if $themeOptions.skin == 'default'}active{/if}" data-key="skin" data-update="default">
                                                    <input class="x-hidden" type="radio" name="customize[skin]" value="default" {if $themeOptions.skin == 'default'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="skin-default"></span></span><span class="nk-opt-item-name">Default</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.skin == 'blue'}active{/if}" data-key="skin" data-update="blue">
                                                    <input class="x-hidden" type="radio" name="customize[skin]" value="blue" {if $themeOptions.skin == 'blue'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="skin-blue"></span></span><span class="nk-opt-item-name">Blue</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.skin == 'egyptian'}active{/if}" data-key="skin" data-update="egyptian">
                                                    <input class="x-hidden" type="radio" name="customize[skin]" value="egyptian" {if $themeOptions.skin == 'egyptian'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="skin-egyptian"></span></span><span class="nk-opt-item-name">Egyptian</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.skin == 'bluelite'}active{/if}" data-key="skin" data-update="bluelite">
                                                    <input class="x-hidden" type="radio" name="customize[skin]" value="bluelite" {if $themeOptions.skin == 'bluelite'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="skin-bluelite"></span></span><span class="nk-opt-item-name">Blue Light</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.skin == 'green'}active{/if}" data-key="skin" data-update="green">
                                                    <input class="x-hidden" type="radio" name="customize[skin]" value="green" {if $themeOptions.skin == 'green'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="skin-green"></span></span><span class="nk-opt-item-name">Green</span>
                                                </div>
                                                <div class="nk-opt-item {if $themeOptions.skin == 'red'}active{/if}" data-key="skin" data-update="red">
                                                    <input class="x-hidden" type="radio" name="customize[skin]" value="red" {if $themeOptions.skin == 'red'}checked{/if}/>
                                                    <span class="nk-opt-item-bg"><span class="skin-red"></span></span><span class="nk-opt-item-name">Red</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <div class="col-sm-9 offset-sm-3">
                                            <!-- success -->
                                            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                                            <!-- success -->

                                            <!-- error -->
                                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                            <!-- error -->

                                            <button type="submit" class="btn btn-primary">Save Changes</button>
                                        </div>
                                    </div>
                                    
                                </form>
                            </div>
                            <!-- General -->

                            <!-- Email -->
                            <div class="tab-pane" id="email">
                                <form class="js_ajax-forms form-horizontal" data-url="/admin/settings?edit=email_settings">

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label text-left">
                                            Mail Method
                                        </label>
                                        <div class="col-sm-9">
                                            <ul class="custom-control-group custom-control-vertical w-100">
                                                <li>
                                                    <div class="custom-control custom-radio checked"> 
                                                        <input class="custom-control-input" type="radio" name="mail_method" value="1" id="mail_method_1" {if $formValues.MAIL_METHOD == '1'}checked="checked"{/if}> 
                                                        <label class="custom-control-label" for="mail_method_1">Use PHP's mail() (recommended)</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="custom-control custom-radio checked"> 
                                                        <input class="custom-control-input" type="radio" name="mail_method" value="2" id="mail_method_2" {if $formValues.MAIL_METHOD == '2'}checked="checked"{/if}> 
                                                        <label class="custom-control-label" for="mail_method_2">Set my own SMTP parameters</label> 
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="custom-control custom-radio checked"> 
                                                        <input class="custom-control-input" type="radio" name="mail_method" value="3" id="mail_method_3" {if $formValues.MAIL_METHOD == '3'}checked="checked"{/if}> 
                                                        <label class="custom-control-label" for="mail_method_3">Never send emails</label> 
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            SMTP server
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="smtp_server" value="{$formValues.MAIL_SERVER}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            SMTP username
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="smtp_username" value="{$formValues.MAIL_USER}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            SMTP password
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="smtp_password" value="{$formValues.MAIL_PASSWD}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            Port
                                        </label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-lg" name="smtp_port" value="{$formValues.MAIL_SMTP_PORT}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 form-label">
                                            Encryption
                                        </label>
                                        <div class="col-sm-9">
                                            <div class="form-selectgroup">
                                                <label class="form-selectgroup-item" for="smtp_encryption_off">
                                                    <input id="smtp_encryption_off" type="radio" name="smtp_encryption" value="off" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'off'}checked{/if}>
                                                    <span class="form-selectgroup-label">
                                                        <i class="icon icon ni ni-unlock fa-lg"></i>    
                                                        <span class="text middle">None</span>
                                                    </span>
                                                </label>
                                                <label class="form-selectgroup-item" for="smtp_encryption_ssl">
                                                    <input id="smtp_encryption_ssl" type="radio" name="smtp_encryption" value="ssl" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'ssl'}checked{/if}>
                                                    <span class="form-selectgroup-label">
                                                        <i class="icon fab fa-expeditedssl fa-lg"></i>    
                                                        <span class="text middle">SSL</span>
                                                    </span>
                                                </label>
                                                <label class="form-selectgroup-item" for="smtp_encryption_tls">
                                                    <input id="smtp_encryption_tls" type="radio" name="smtp_encryption" value="tls" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'tls'}checked{/if}>
                                                    <span class="form-selectgroup-label">
                                                        <i class="icon icon ni ni-shield-fill fa-lg"></i>    
                                                        <span class="text middle">TLS</span>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <div class="col-sm-9 offset-sm-3">
                                            <!-- success -->
                                            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                                            <!-- success -->

                                            <!-- error -->
                                            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                            <!-- error -->

                                            <button type="submit" class="btn btn-primary">Save Changes</button>
                                        </div>
                                    </div>

                                </form>
                            </div>
                            <!-- Email -->

                        </div>
                        <!-- tabs content -->
                    </div>
                </div>
            </div>

        </div>

    </div>
{/block}