{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Themes</h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">
            <div class="row g-gs theme-browser">
                {foreach $themes as $theme}
                    <div class="col-lg-4 col-xxl-4 col-sm-6">
                        <div class="theme {if $theme->attributes.name == $active_theme}active{/if}" data-slug="{$theme->attributes.name}">
                            {if $theme->attributes.preview}
                                <div class="theme-screenshot">
                                    <img src="{$theme->attributes.preview}" alt="{$theme->attributes.display_name}">
                                </div>
                            {else}
                                <div class="theme-screenshot blank"></div>
                            {/if}
                            <a target="_blank" href="{$theme->attributes.theme_link}" aria-label="View Theme Details for {$theme->attributes.display_name}" class="more-details" id="{$theme->attributes.name}-action">Theme Details</a>
                            <div class="theme-author">By {$theme->attributes.author.name}</div>
                            <div class="theme-id-container">
                                <h2 class="theme-name" id="{$theme->attributes.name}-name">{$theme->attributes.display_name}</h2>
                                {if $theme->attributes.name != $active_theme}
                                    <div class="theme-actions">
                                        {if $theme->attributes.premium}
                                            <a target="_blank" aria-label="Buy Theme {$theme->attributes.display_name}" class="btn btn-primary load-customize" href="{$theme->attributes.theme_link}">Buy Theme</a>
                                        {else}
                                            <button data-theme="{$theme->attributes.name}" class="btn btn-primary activate js_install-theme" title="Activate {$theme->attributes.name}">Activate</button>
                                        {/if}
                                    </div>
                                {/if}
                            </div>
                        </div>
                    </div>
                {/foreach}
            </div>
        </div>
    </div>
{/block}