{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    {if 
        $sub_view == "writers" ||
        $sub_view == "editors" ||
        $sub_view == "sub-admins" ||
        $sub_view == "administrators"
    }

        <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Employees</h3>
                        <div class="nk-block-des text-soft">
                            <p>You have total {$total_employees} employees.</p>
                        </div>
                    </div>
                    <!-- .nk-block-head-content -->
                    <div class="nk-block-head-content">
                        <div class="toggle-wrap nk-block-tools-toggle">
                            <a href="#" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                            <div class="toggle-expand-content" data-content="more-options">
                                <ul class="nk-block-tools g-3">
                                    <li>
                                        <form class="form-control-wrap" method="get" id="filter_form" autocomplete="off"> 
                                            <div class="form-icon form-icon-right">
                                                <em class="icon ni ni-search"></em>
                                            </div>
                                            <input type="text" class="form-control" value="{$query}" name="query" placeholder="Search by ID & email">
                                        </form>
                                    </li>
                                    <li class="nk-block-tools-opt">
                                        <a href="{$base_uri}/employees/add" data-ajax="/employees/add" class="btn btn-icon btn-primary d-md-none"><em class="icon ni ni-plus"></em></a>
                                        <a href="{$base_uri}/employees/add" data-ajax="/employees/add" class="btn btn-primary d-none d-md-inline-flex"><em class="icon ni ni-plus"></em><span>Add</span></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- .nk-block-head-content -->
                </div>
                <!-- .nk-block-between -->
            </div>

            {if count($employees)}
                <div class="nk-block">
                    <div class="card card-stretch">
                        <div class="card-inner-group">
                            <div class="card-inner p-0">
                                <table class="nk-tb-list nk-tb-ulist">
                                    <thead>
                                        <tr class="nk-tb-item nk-tb-head">
                                            <th class="nk-tb-col"><span class="sub-text">Employee</span></th>
                                            <th class="nk-tb-col"><span class="sub-text">Phone</span></th>
                                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Status</span></th>
                                            {if $sub_view == "writers" || $sub_view == "editors"}
                                                <th class="nk-tb-col"><span class="sub-text">Total Earned</span></th>
                                            {/if}
                                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Registered</span></th>
                                            <th class="nk-tb-col nk-tb-col-tools text-right">&nbsp;</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        {foreach $employees as $employee}
                                            <tr class="nk-tb-item">
                                                <td class="nk-tb-col">
                                                    <a href="{$base_uri}/employees/edit/{$employee.id}" data-ajax="/employees/edit/{$employee.id}" class="project-title">
                                                        <div class="user-card">
                                                            {if $employee.user_picture_default && $employee.first_name && $employee.last_name}
                                                                <div class="user-avatar bg-primary sq">
                                                                    <span>{$employee.first_name[0]|strtoupper}{$employee.last_name[0]|strtoupper}</span>
                                                                    {if $employee.employee_status == "4" ||  $employee.employee_status == "5"}
                                                                        <div class="status dot dot-lg dot-warning"></div>
                                                                    {elseif $employee.employee_status == "6"}
                                                                        <div class="status dot dot-lg dot-danger"></div>
                                                                    {/if}
                                                                </div>
                                                            {else}
                                                                <div class="user-avatar avatar-img sq" style="background-image: url({$employee.user_picture})">
                                                                    {if $employee.employee_status == "4" ||  $employee.employee_status == "5"}
                                                                        <div class="status dot dot-lg dot-warning"></div>
                                                                    {elseif $employee.employee_status == "6"}
                                                                        <div class="status dot dot-lg dot-danger"></div>
                                                                    {/if}
                                                                </div>
                                                            {/if}
                                                            <div class="flex-fill">
                                                                <div class="fw-bold">{$employee.first_name} {$employee.last_name}</div>
                                                                <div class="text-secondary">{$employee.email}</div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </td>
                                                <td class="nk-tb-col">
                                                    <span>{if $employee.phone} {$employee.phone} {else} N.A {/if}</span>
                                                </td>
                                                <td class="nk-tb-col tb-col-lg">
                                                    {if $employee.employee_status == "6"}
                                                        <span class="badge badge-dim badge-danger">Probation</span>
                                                    {elseif $employee.is_started}
                                                        <span class="badge badge-dim badge-success">Active</span>
                                                    {else}
                                                        <span class="badge badge-dim badge-danger">Inactive</span>
                                                    {/if}
                                                </td>
                                                {if $sub_view == "writers" || $sub_view == "editors"}
                                                    <td class="nk-tb-col">
                                                        <span class="tb-amount">{formatPrice($employee.total_paid, $currencyFormat)}</span>
                                                    </td>
                                                {/if}
                                                <td class="nk-tb-col tb-col-lg">
                                                    <span class="js_moment" data-time="{$employee.reg_date}">{$employee.reg_date}</span>
                                                </td>
                                                <td class="nk-tb-col nk-tb-col-tools">
                                                    <ul class="nk-tb-actions gx-1">
                                                        <li class="nk-tb-action-hidden">
                                                            <a href="{$base_uri}/employees/edit/{$employee.id}" data-ajax="/employees/edit/{$employee.id}" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="" data-original-title="View Details">
                                                                <em class="icon ni ni-eye-fill"></em>
                                                            </a>
                                                        </li>
                                                        <li class="nk-tb-action-hidden">
                                                            <a target="_blank" href="{$base_uri}/authorize/{$employee.id}/{$employee.secure_key}" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="" data-original-title="Impersonate">
                                                                <em class="icon ni ni-security"></em>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <div class="drodown">
                                                                <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                                <div class="dropdown-menu dropdown-menu-right">
                                                                    <ul class="link-list-opt no-bdr">
                                                                        <li>
                                                                            <a href="{$base_uri}/employees/edit/{$employee.id}" data-ajax="/employees/edit/{$employee.id}">
                                                                                <em class="icon ni ni-eye"></em><span>View Details</span>
                                                                            </a>
                                                                        </li>
                                                                        <li>
                                                                            <a target="_blank" href="{$base_uri}/authorize/{$employee.id}/{$employee.secure_key}"><em class="icon ni ni-security"></em><span>Impersonate</span></a>
                                                                        </li>
                                                                        <li class="divider"></li>
                                                                        <li>
                                                                            <a class="js_deleter" href="#" data-handle="employee" data-id="{$employee.id}">
                                                                                <em class="icon ni ni-trash"></em><span>Delete</span>
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="nk-block-between-md mt-3">
                        <div class="g">
                            {$pager nofilter}
                        </div>
                    </div><!-- .nk-block-between -->
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                    <h6 class="text-dark title mb-3">No employees to show</h6>
                </div>
            {/if}

        </div>

    {elseif $sub_view == "add"}

        <div class="wide-xs mx-auto">
            <div class="nk-block-head nk-block-head-lg wide-sm">
                <div class="nk-block-head-content">
                    <div class="nk-block-head-sub">
                        <a class="back-to" href="javascript:void(0)"  onclick="history.back()">
                            <em class="icon ni ni-arrow-left"></em><span>Employees</span>
                        </a>
                    </div>
                    <h2 class="nk-block-title fw-normal">Add new employee</h2>
                </div>
            </div>

            <div class="card card-bordered">
                <div class="card-inner">
                    <form class="js_ajax-forms" method="POST" data-url="/employees/add" autocomplete="off">
                        <div class="form-group">
                            <label class="form-label">Employee Group</label>
                            <select class="form-select" data-ui="lg" name="employee_group">
                                <option value="5">Applicant</option>
                                <option value="3">Writer</option>
                                <option value="2">Editor</option>
                                <option value="4">Sub Admin</option>
                                <option value="1">Administrator</option>
                            </select>
                        </div>
        
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-label">First name</label>
                                <input type="text" class="form-control form-control-lg" name="first_name">
                            </div> 
            
                            <div class="form-group col-md-6">
                                <label class="form-label">Last name</label>
                                <input type="text" class="form-control form-control-lg" name="last_name">
                            </div>
                        </div>
        
                        <div class="form-group">
                            <label class="form-label">Email Address</label>
                            <input type="email" class="form-control form-control-lg" name="email"> 
                        </div>
        
                        <div class="form-group">
                            <label class="form-label">Gender</label>
                            <div class="form-control-wrap">
                                <ul class="custom-control-group">
                                    <li>
                                        <div class="custom-control custom-control-md custom-radio">
                                            <input type="radio" class="custom-control-input" name="gender" value="male" id="gender_male" required="">
                                            <label class="custom-control-label" for="gender_male">Male</label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="custom-control custom-control-md custom-radio">
                                            <input type="radio" class="custom-control-input" name="gender" value="female" id="gender_female" required="">
                                            <label class="custom-control-label" for="gender_female">Female</label>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
        
                        <div class="form-group">
                            <label class="form-label">Password</label>
                            <input type="text" class="form-control form-control-lg" name="password" autocomplete="off"> 
                        </div>
        
                        <div class="form-group">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- success -->
                                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                                <!-- success -->
        
                                <!-- error -->
                                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                <!-- error -->
                            </div>
                        </div>
                        <button type="submit" class="btn btn-success btn-lg">Add new Employee</button>
                    </form>
                </div>
            </div>

        </div>

    {elseif $sub_view == "edit"}

        <div class="{if $chat_enabled}wide-lg{else}wide-xl{/if}">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between g-3">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">Employees / <strong class="text-primary small">{$employee.first_name|ucfirst} {$employee.last_name|ucfirst}</strong></h3>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-aside-wrap">
                    <div class="card-inner card-inner-lg">
                        <div class="tab-content">
                            <div class="tab-pane {if $_tab == 'info'}active{/if}" id="personalInformation">
                                <div class="nk-block-head">
                                    <div class="nk-block-between d-flex justify-content-between">
                                        <div class="nk-block-head-content">
                                            <h4 class="nk-block-title">Personal Information</h4>
                                            <div class="nk-block-des">
                                                <p>Basic info, like your name and address, that you use on {$site_name}.</p>
                                            </div>
                                        </div>
                                        <div class="nk-tab-actions mr-n1">
                                            <a href="#" class="btn btn-icon btn-trigger d-none d-lg-block" data-toggle="modal" data-url="#profileEditModal" data-size="large">
                                                <em class="icon ni ni-edit"></em>
                                            </a>

                                            <a href="#" class="toggle btn btn-icon btn-trigger d-lg-none" data-target="userAside">
                                                <em class="icon ni ni-menu-alt-r"></em>
                                            </a>
                                        </div>
                                    </div>
                                </div><!-- .nk-block-head -->
        
                                <div class="nk-block">
                                    <div class="nk-data data-list">
                                        <div class="data-head">
                                            <h6 class="overline-title">Basics</h6>
                                        </div>
        
                                        <div class="data-item" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                            <div class="data-col">
                                                <span class="data-label">Name</span>
                                                <span class="data-value">{$employee.first_name} {$employee.middle_name} {$employee.last_name}</span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </div>
                                        <!-- data-item -->
        
                                        <div class="data-item" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                            <div class="data-col">
                                                <span class="data-label">Gender</span>
                                                <span class="data-value">{$employee.gender|ucfirst}</span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </div>
                                        <!-- data-item -->
        
                                        <!-- data-item -->
                                        <div class="data-item" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                            <div class="data-col">
                                                <span class="data-label">Email</span>
                                                <span class="data-value">{$employee.email}</span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </div>
                                        <!-- data-item -->
        
                                        <div class="data-item" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                            <div class="data-col">
                                                <span class="data-label">Phone Number</span>
                                                <span class="data-value text-soft">{if $employee.phone} {$employee.phone} {else} Not add yet {/if}</span>
                                            </div>
                                            <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                        </div>
                                        <!-- data-item -->

                                        <!-- data-item -->
                                        <div class="data-item" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                            <div class="data-col">
                                                <span class="data-label">Country</span>
                                                <span class="data-value text-soft">{if $employee.country}{$employee.country_name}{else}Not add yet{/if}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </div>
                                        <!-- data-item -->
                                        <div class="data-item" data-toggle="modal" data-size="large" data-url="#profileEditModal">
                                            <div class="data-col">
                                                <span class="data-label">City/Town</span>
                                                <span class="data-value text-soft">{if $employee.city}{$employee.city}{else}Not add yet{/if}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <span class="data-more"><em class="icon ni ni-forward-ios"></em></span>
                                            </div>
                                        </div>
                                        <!-- data-item -->
        
                                        <div class="data-item">
                                            <div class="data-col">
                                                <span class="data-label">Timezone</span>
                                                <span class="data-value">{$employee.timezone}</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <a href="#" data-toggle="modal" data-url="#profileTimezone" class="link link-primary">Change</a>
                                            </div>
                                        </div>
                                        <!-- data-item -->
        
                                        <div class="data-item" data-toggle="modal" data-url="#profilePassword" data-size="small">
                                            <div class="data-col">
                                                <span class="data-label">Password</span>
                                                <span class="data-value text-soft">******</span>
                                            </div>
                                            <div class="data-col data-col-end">
                                                <a href="#" data-toggle="modal" data-url="#profilePassword" data-size="small" class="link link-primary">Change</a>
                                            </div>
                                        </div>
                                        <!-- data-item -->
                                    </div>
        
                                    {if $employee.is_editor || $employee.is_writer}
        
                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">Account</h6>
                                            </div>
        
                                            <div class="data-item" data-toggle="modal" data-size="large" data-url="#accountEditModal">
                                                <div class="data-col">
                                                    <span class="data-label">Activated</span>
                                                    <span class="data-value text-soft">
                                                        {if $employee.is_banned}
                                                            <span class="badge badge-dot badge-dot-xs badge-danger">Banned</span>
                                                        {elseif $employee.is_started}
                                                            <span class="badge badge-dot badge-dot-xs badge-success">Yes</span>
                                                        {else}
                                                            <span class="badge badge-dot badge-dot-xs badge-warning">Not Yet</span>
                                                        {/if}
                                                    </span>
                                                </div>
                                                <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                            </div>
                                            <!-- data-item -->
        
                                            {if $employee.is_editor || $employee.is_writer}
                                                <div class="data-item" data-toggle="modal" data-size="small" data-url="#accountWorkingStatus">
                                                    <div class="data-col">
                                                        <span class="data-label">Available 24/7</span>
                                                        <span class="data-value text-soft">
                                                            {if $employee.available_247}
                                                                <span class="badge badge-dot badge-dot-xs badge-success">Yes</span>
                                                            {else}
                                                                <span class="badge badge-dot badge-dot-xs badge-warning">No</span>
                                                            {/if}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </div>
                                                <!-- data-item -->

                                                <div class="data-item" data-toggle="modal" data-size="small" data-url="#accountWorkingStatus">
                                                    <div class="data-col">
                                                        <span class="data-label">Urgent Orders</span>
                                                        <span class="data-value text-soft">
                                                            {if $employee.available_urgent_orders}
                                                                <span class="badge badge-dot badge-dot-xs badge-success">Yes</span>
                                                            {else}
                                                                <span class="badge badge-dot badge-dot-xs badge-warning">No</span>
                                                            {/if}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </div>
                                                <!-- data-item -->
                                                <div class="data-item">
                                                    <div class="data-col">
                                                        <span class="data-label">Status</span>
                                                        <span class="data-value text-soft">
                                                            {if $employee.employee_status == "2"}
                                                                <span class="badge badge-dot badge-dot-xs badge-success">Looking for orders</span>
                                                            {elseif $employee.employee_status == "4"}
                                                                <span class="badge badge-dot badge-dot-xs badge-warning">Cannot work for now</span>
                                                            {elseif $employee.employee_status == "5"}
                                                                <span class="badge badge-dot badge-dot-xs badge-danger">Do not use your service</span>
                                                            {elseif $employee.employee_status == "6"}
                                                                <span class="badge badge-dot badge-dot-xs badge-danger">Probation</span>
                                                            {/if}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end">
                                                        <a href="#" data-toggle="modal" data-url="#accountWorkingStatus" data-size="small" class="link link-primary">Change</a>
                                                    </div>
                                                </div>
                                                <!-- data-item -->
        
                                                <div class="data-item" data-toggle="modal" data-size="large" data-url="#accountEditModal">
                                                    <div class="data-col">
                                                        <span class="data-label">Writer Category</span>
                                                        <span class="data-value text-soft">
                                                            {$employee.writer_category_title}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </div>
                                                <!-- data-item -->
        
                                                <div class="data-item" data-toggle="modal" data-size="large" data-url="#accountEditModal">
                                                    <div class="data-col">
                                                        <span class="data-label">Academic Level</span>
                                                        <span class="data-value text-soft">
                                                            {$employee.academic_level_title}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </div>
                                                <!-- data-item -->
        
                                            {/if}

                                            {if $is_articlewriting_enabled || $is_calculations_enabled || $is_programming_enabled}
                                                <div class="data-item">
                                                    <div class="data-col">
                                                        <span class="data-label">Order Access</span>
                                                        <span class="data-value text-soft">
                                                            {if $employee.has_academic_access}
                                                                <span class="badge badge-primary">Academic Writing</span>
                                                            {/if}

                                                            {if $is_articlewriting_enabled && $employee.has_article_access}
                                                                <span class="badge badge-success">Article Writing</span>
                                                            {/if}

                                                            {if $is_programming_enabled && $employee.has_programming_access}
                                                                <span class="badge badge-warning">Programming</span>
                                                            {/if}

                                                            {if $is_calculations_enabled && $employee.has_calculations_access}
                                                                <span class="badge badge-info">Calculations</span>
                                                            {/if}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end">
                                                        <a href="#" data-toggle="modal" data-size="medium" data-url="#ordersAccessEditModal" class="link link-primary">Change</a>
                                                    </div>
                                                </div>
                                                <!-- data-item -->
                                            {/if}

                                            {if $employee.is_writer && $employee.number_of_takes > 0}
                                                <div class="data-item" data-toggle="modal" data-size="large" data-url="#accountEditModal">
                                                    <div class="data-col">
                                                        <span class="data-label">Number of Takes</span>
                                                        <span class="data-value text-soft">
                                                            {$employee.number_of_takes}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end"><span class="data-more"><em class="icon ni ni-forward-ios"></em></span></div>
                                                </div>
                                                <!-- data-item -->
                                            {/if}
                                            
                                            {if $employee.is_editor || $employee.is_writer}
                                                <div class="data-item">
                                                    <div class="data-col">
                                                        <span class="data-label">Pay per Page</span>
                                                        <span class="data-value text-soft">
                                                            {formatPrice($employee.cpp_amount, $currencyFormat)}
                                                        </span>
                                                    </div>
                                                    <div class="data-col data-col-end">
                                                        <a href="#" data-toggle="modal" data-url="#cppEditModal" data-size="small" class="link link-primary">Change</a>
                                                    </div>
                                                </div>
                                                <!-- data-item -->
            
                                                {if $is_articlewriting_enabled}
                                                    <div class="data-item">
                                                        <div class="data-col">
                                                            <span class="data-label">Pay per Word</span>
                                                            <span class="data-value text-soft">
                                                                {formatPrice($employee.cpw_amount, $currencyFormat)}
                                                            </span>
                                                        </div>
                                                        <div class="data-col data-col-end">
                                                            <a href="#" data-toggle="modal" data-url="#cppEditModal" data-size="small" class="link link-primary">Change</a>
                                                        </div>
                                                    </div>
                                                    <!-- data-item -->
                                                {/if}
                                            {/if}
        
                                        </div>
                                        <!-- data-list -->
        
                                    {/if}
                                </div>
                            </div>

                            {if $employee.is_editor || $employee.is_writer || $employee.is_applicant}
                                <div class="tab-pane {if $_tab == 'about'}active{/if}" id="employeeAbout">
                                    <div class="nk-block-head">
                                        <div class="nk-block-between d-flex justify-content-between">
                                            <div class="nk-block-head-content">
                                                <h4 class="nk-block-title">About & Qualifications</h4>
                                                <div class="nk-block-des">
                                                    <p>Employee bio, qualifications, experience, software access and programming languages.</p>
                                                </div>
                                            </div>
                                            <div class="nk-tab-actions mr-n1">
                                                <a href="#" class="btn btn-icon btn-trigger d-none d-lg-block" data-toggle="modal" data-url="#accountEditModal" data-size="large">
                                                    <em class="icon ni ni-edit"></em>
                                                </a>
    
                                                <a href="#" class="toggle btn btn-icon btn-trigger d-lg-none" data-target="userAside">
                                                    <em class="icon ni ni-menu-alt-r"></em>
                                                </a>
                                            </div>
                                        </div>
                                    </div><!-- .nk-block-head -->

                                    <div class="nk-block">
                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">About</h6>
                                            </div>
            
                                            <div class="mt-4">
                                                {if $employee.about}
                                                    {$employeeAbout nofilter}
                                                {else}
                                                    <div class="alert alert-warning alert-icon">
                                                        <em class="icon ni ni-alert-circle"></em> No about. Add your profile about <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                                    </div>
                                                {/if}
                                            </div>
                                            <!-- data-item -->

                                        </div>

                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">Languages</h6>
                                            </div>

                                            <div class="mt-4">
                                                {if count($employee.other_languages_array)}
                                                    <ul class="preview-list m-0">
                                                        {foreach from=$languages item=language key=key}
                                                            {if in_array($key, $employee.other_languages_array)}
                                                                <li class="preview-item p-1">
                                                                    <span class="badge badge-default badge-md">{$language.name}</span>
                                                                </li>
                                                            {/if}
                                                        {/foreach}
                                                    </ul>
                                                {else}
                                                    <div class="alert alert-warning alert-icon">
                                                        <em class="icon ni ni-alert-circle"></em> No languages select. Add other languages you can write at <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                                    </div>
                                                {/if}
                                            </div>

                                        </div>

                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">Proficient Disciplines</h6>
                                            </div>

                                            <div class="mt-4">
                                                {if count($user_disciplines)}
                                                    <ul class="preview-list m-0">
                                                        {foreach $user_disciplines as $discipline}
                                                            <li class="preview-item p-1">
                                                                <span class="badge badge-default badge-md">{$discipline.title}</span>
                                                            </li>
                                                        {/foreach}
                                                    </ul>
                                                {else}
                                                    <div class="alert alert-warning alert-icon">
                                                        <em class="icon ni ni-alert-circle"></em> Please select 3-7 disciplines you are proficient in <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                                    </div>
                                                {/if}
                                            </div>

                                        </div>

                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">Software &amp; Programming Language</h6>
                                            </div>

                                            <div class="mt-4">
                                                {if count($user_softwares)}
                                                    <ul class="preview-list m-0">
                                                        {foreach $user_softwares as $software}
                                                            <li class="preview-item p-1">
                                                                <span class="badge badge-default badge-md">{$software.title}</span>
                                                            </li>
                                                        {/foreach}
                                                    </ul>
                                                {else}
                                                    <div class="alert alert-warning alert-icon">
                                                        <em class="icon ni ni-alert-circle"></em> Please indicate software you have access to and/or programming language you are expert in <a href="#" data-toggle="modal" data-url="#accountEditModal" data-size="large" class="alert-link">here</a>
                                                    </div>
                                                {/if}
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane {if $_tab == 'essays'}active{/if}" id="employeeEssays">
                                    <div class="nk-block-head">
                                        <div class="nk-block-between d-flex justify-content-between">
                                            <div class="nk-block-head-content">
                                                <h4 class="nk-block-title">Essays &amp; Samples</h4>
                                                <div class="nk-block-des">
                                                    <p>Employee bio, qualifications, experience, software access and programming languages.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- .nk-block-head -->

                                    <div class="nk-block">
                                        {if $employee.writing_prompt_answer && $employee.is_writingprompt_complete}
                                            <div class="nk-data data-list">
                                                <div class="data-head">
                                                    <h6 class="overline-title">Writing Prompt</h6>
                                                </div>
                
                                                <div class="mt-4">
                                                    <h6 class="mb-3">{$employee.writing_prompt_question}</h6>

                                                    <div>
                                                        {$employee.writing_prompt_answer nofilter}
                                                    </div>
                                                </div>
                                                <!-- data-item -->
                                            </div>
                                        {/if}

                                        {if isset($employee_files['application-essay'])}
                                            <div class="nk-data data-list">
                                                <div class="data-head">
                                                    <h6 class="overline-title">Essays</h6>
                                                </div>
                
                                                <div class="nk-files nk-files-view-group mt-2">
                                                    <div class="nk-files-group">
                                                        <div class="nk-files-list">
                                                            {foreach $employee_files['application-essay'] as $file}
                                                                {include file='dashboard/users/_application.file.tpl'}
                                                            {/foreach}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        {/if}

                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">Samples</h6>
                                            </div>
        
                                            {if isset($employee_files['application-sample'])}
                                                <div class="nk-files nk-files-view-group mt-2">
                                                    <div class="nk-files-group">
                                                        <div class="nk-files-list">
                                                            {foreach $employee_files['application-sample'] as $file}
                                                                {include file='dashboard/users/_application.file.tpl'}
                                                            {/foreach}
                                                        </div>
                                                    </div>
                                                </div>
                                            {else}
                                                <div class="card bg-secondary-dim mt-3">
                                                    <div class="card-inner">
                                                        <div class="nk-block-text">
                                                            <h5>Samples (optional)</h5>
                                                            <p>You may upload samples of your work here to show your knowledge and writing skills. The fies should be uploaded in doc / docx / pdf format (no more than 3 files and 50 MB).</p>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer">
                                                        <button class="btn btn-lg btn-primary pull-right" type="button" data-toggle="modal" data-url="#modal-upload-file"data-options='{literal}{{/literal}"handle":"application-sample"{literal}}{/literal}'>
                                                            <em class="icon ni ni-upload"></em> <span>Upload</span>
                                                        </button>
                                                    </div>
                                                </div>
                                            
                                            {/if}
                                        </div>
        
                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">CV</h6>
                                            </div>
        
                                            {if isset($employee_files['application-cv'])}
                                                <div class="nk-files nk-files-view-group mt-2">
                                                    <div class="nk-files-group">
                                                        <div class="nk-files-list">
                                                            {foreach $employee_files['application-cv'] as $file}
                                                                {include file='dashboard/users/_application.file.tpl'}
                                                            {/foreach}
                                                        </div>
                                                    </div>
                                                </div>
                                            {else}
                                                <div class="card bg-secondary-dim mt-3">
                                                    <div class="card-inner">
                                                        <div class="nk-block-text">
                                                            <h5>CV</h5>
                                                            <p class="mb-2">You are welcome to upload your CV or resume here. Make sure it is written in English and contains the description of your educational background, professional experience and recommendations if you have any.</p> 
                                                            <p class="mb-2">The file(s) should be uploaded in doc / docx / pdf format (no more than 3 files and 50 MB).</p>
                                                            <p>If you have any questions, please email us at <strong>{$site_email}</strong></p>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer">
                                                        <button class="btn btn-lg btn-primary pull-right" type="button" data-toggle="modal" data-url="#modal-upload-cv" data-options='{literal}{{/literal}"handle":"application-cv"{literal}}{/literal}'>
                                                            <em class="icon ni ni-upload"></em> <span>Upload</span>
                                                        </button>
                                                    </div>
                                                </div>
                                            {/if}
                                        </div>
        
                                        <div class="nk-data data-list">
                                            <div class="data-head">
                                                <h6 class="overline-title">Degree Certificate</h6>
                                            </div>
        
                                            {if isset($employee_files['application-degree'])}
                                                <div class="nk-files nk-files-view-group mt-2">
                                                    <div class="nk-files-group">
                                                        <div class="nk-files-list">
                                                            {foreach $employee_files['application-degree'] as $file}
                                                                {include file='dashboard/users/_application.file.tpl'}
                                                            {/foreach}
                                                        </div>
                                                    </div>
                                                </div>
                                            {else}
                                                <div class="card bg-secondary-dim mt-3">
                                                    <div class="card-inner">
                                                        <div class="nk-block-text">
                                                            <h5>Degree Certificate</h5>
                                                            <p class="mb-2">Please upload a photo of your education certificate and/or academic transcripts that can prove your highest qualification attained certificates issued in non English speaking countries should be submitted along with their English translations.</p>
                                                            <p class="mb-2">The files should be uploaded in jpg/ipeg format (no more than 3 files and 50 MB).</p>
                                                            <p>If you have any questions, please email us at <strong>{$site_email}</strong></p>
                                                        </div>
                                                    </div>
                                                    <div class="card-footer">
                                                        <button class="btn btn-lg btn-primary pull-right" type="button" data-toggle="modal" data-url="#modal-upload-degree" data-options='{literal}{{/literal}"handle":"application-degree"{literal}}{/literal}'>
                                                            <em class="icon ni ni-upload"></em> <span>Upload</span>
                                                        </button>
                                                    </div>
                                                </div>
                                            {/if}
                                        </div>
                                    </div>
                                </div>
                            {/if}

                            {if $employee.is_editor || $employee.is_writer}
                                <div class="tab-pane {if $_tab == 'finances'}active{/if}" id="employeeFinances">
                                    <div class="nk-block-head">
                                        <div class="nk-block-between d-flex justify-content-between">
                                            <div class="nk-block-head-content">
                                                <h4 class="nk-block-title">Finances</h4>
                                                <div class="nk-block-des">
                                                    <p>Keep track of your payments and fines</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- .nk-block-head -->

                                    {hook h='displayEmployeeFinancesStats' employee_id=$employee.id}
                                </div>
                            {/if}

                            <div class="tab-pane  {if $_tab == 'sessions'}active{/if}" id="loginSessions">
                                <div class="nk-block-head nk-block-head-lg">
                                    <div class="nk-block-between">
                                        <div class="nk-block-head-content">
                                            <h4 class="nk-block-title">Login Activity</h4>
                                            <div class="nk-block-des">
                                                <p>Here is your last {count($sessions)} login activities log.</p>
                                            </div>
                                        </div>
                                        <div class="nk-block-head-content">
                                            <button type="button" class="btn btn-danger js_session-delete-all" data-uid="{$employee.id}">
                                                <i class="icon ni ni-lock fa-fw"></i> <span>Logout All Sessions</span>
                                            </button>
                                        </div>
                                        <div class="nk-block-head-content align-self-start d-lg-none">
                                            <a href="#" class="toggle btn btn-icon btn-trigger mt-n1" data-target="userProfileAside">
                                                <em class="icon ni ni-menu-alt-r"></em>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <!-- .nk-block-head -->
    
                                <div class="nk-block">
                                    {if count($sessions)}
                                        <div class="active_sessions">
                                            <div class="table-responsive">
                                                {foreach $sessions as $session}
                                                    <div class="as_list" id="session_{$session.session_id}">
                                                        <div class="platform_icon">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="#222" d="M21,16H3V4H21M21,2H3C1.89,2 1,2.89 1,4V16A2,2 0 0,0 3,18H10V20H8V22H16V20H14V18H21A2,2 0 0,0 23,16V4C23,2.89 22.1,2 21,2Z"></path></svg>
                                                        </div>
                                                        <button title="Log Out" class="btn btn-mat log_out_session js_session-deleter" data-id="{$session.session_id}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z"></path></svg>
                                                        </button>
                                                        <div class="session_info">
                                                            <h4>{$session.user_os}</h4>
                                                            <p>
                                                                <span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M21,3H3A2,2 0 0,0 1,5V19A2,2 0 0,0 3,21H21A2,2 0 0,0 23,19V5A2,2 0 0,0 21,3M21,19H3V5H13V9H21V19Z"></path></svg> {$session.user_browser}</span>
                                                                <span class="middot">·</span>
                                                                <span>
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22C6.47,22 2,17.5 2,12A10,10 0 0,1 12,2M12.5,7V12.25L17,14.92L16.25,16.15L11,13V7H12.5Z"></path></svg> 
                                                                    <span class="js_moment" data-time="{$session.login_time}">{$session.login_time}</span>
                                                                </span>
                                                            </p>
                                                            <p>IP Address: {$session.user_ip}</p>
                                                        </div>
                                                    </div>
                                                {/foreach}
                                            </div>
    
                                            <div class="nk-block-between-md mt-3">
                                                <div class="g">
                                                    {$pager nofilter}
                                                </div>
                                            </div><!-- .nk-block-between -->
                                        </div>
                                    {else}
                                        <div class="text-center x-muted"> 
                                            {include file='__svg_icons.tpl' class="mb-3" icon="secure" width="100px" height="100px"}
                                            <h6 class="text-muted fw-normal title mb-3">No sessions to show</h6>
                                        </div>
                                    {/if}   
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-aside card-aside-left user-aside toggle-slide toggle-slide-left toggle-break-lg" data-content="userAside" data-toggle-screen="lg" data-toggle-overlay="true">
                        <div class="card-inner-group" data-simplebar>
                            <div class="card-inner">
                                <div class="user-card">
                                    {if $employee.user_picture_default && $employee.first_name && $employee.last_name}
                                        <div class="user-avatar bg-primary">
                                            <span>{$employee.first_name[0]|strtoupper}{$employee.last_name[0]|strtoupper}</span>
                                            {if $employee.employee_status == "4" ||  $employee.employee_status == "5" }
                                                <div class="status dot dot-lg dot-warning"></div>
                                            {elseif $employee.employee_status == "6"}
                                                <div class="status dot dot-lg dot-danger"></div>
                                            {/if}
                                        </div>
                                    {else}
                                        <div class="user-avatar avatar-img" style="background-image: url({$employee.user_picture})">
                                            {if $employee.employee_status == "4" ||  $employee.employee_status == "5"}
                                                <div class="status dot dot-lg dot-warning"></div>
                                            {elseif $employee.employee_status == "6"}
                                                <div class="status dot dot-lg dot-danger"></div>
                                            {/if}
                                        </div>
                                    {/if}
                                    <div class="user-info">
                                        <span class="lead-text">{$employee.first_name} {$employee.last_name}</span>
                                        <span class="sub-text">{$employee.email|strtolower}</span>
                                    </div>
                                </div><!-- .user-card -->
                            </div><!-- .card-inner -->
                            
                            <div class="card-inner card-inner-sm">
                                <ul class="btn-toolbar justify-center gx-1">
                                    {if $employee.is_applicant}
                                        <li>
                                            <a href="#" class="btn btn-trigger btn-icon js_approve-application" data-handle="approve" data-id="{$employee.id}" data-toggle="tooltip" title="Approve Application">
                                                <em class="icon ni ni-check"></em>
                                            </a>
                                        </li>

                                        <li>
                                            <a href="#" class="btn btn-trigger btn-icon js_approve-application" data-handle="decline" data-id="{$employee.id}" data-toggle="tooltip" title="Decline Application">
                                                <em class="icon ni ni-cross"></em>
                                            </a>
                                        </li>
                                    {/if}

                                    <li>
                                        <a target="_blank" href="{$base_uri}/authorize/{$employee.id}/{$employee.secure_key}" class="btn btn-trigger btn-icon" data-toggle="tooltip" title="Impersonate User">
                                            <em class="icon ni ni-security"></em>
                                        </a>
                                    </li>

                                    {if $employee.is_writer}
                                        <li>
                                            <a href="{$base_uri}/feedback/employee/{$employee.id}" data-ajax="/feedback/employee/{$employee.id}" class="btn btn-trigger btn-icon" data-toggle="tooltip" title="View Reviews">
                                                <em class="icon ni ni-star"></em>
                                            </a>
                                        </li>
                                    {/if}

                                    {if $employee.is_writer || $user.is_editor}
                                        <li>
                                            <a href="{$base_uri}/orders/employee/{$employee.id}" data-ajax="/orders/employee/{$employee.id}" class="btn btn-trigger btn-icon" data-toggle="tooltip" title="View Orders">
                                                <em class="icon ni ni-bag-fill"></em>
                                            </a>
                                        </li>
                                    {/if}

                                    <li>
                                        <a href="#" class="btn btn-trigger btn-icon js_reset-password-link" data-id="{$employee.id}" data-handle="employee" data-toggle="tooltip" title="Password reset link">
                                            <em class="icon ni ni-lock"></em>
                                        </a>
                                    </li>
                                </ul>
                            </div>

                            <div class="card-inner p-0">
                                <ul class="link-list-menu nav nav-tabs">
                                    <li>
                                        <a {if $_tab == 'info'}class="active"{/if} data-toggle="tab" href="#personalInformation">
                                            <em class="icon ni ni-user-fill-c"></em><span>Personal Infomation</span>
                                        </a>
                                    </li>

                                    {if $employee.is_editor || $employee.is_writer || $employee.is_applicant}
                                        <li>
                                            <a {if $_tab == 'about'}class="active"{/if} data-toggle="tab" href="#employeeAbout">
                                                <em class="icon ni ni-user-list-fill"></em><span>About &amp; Qualifications</span>
                                            </a>
                                        </li>

                                        <li>
                                            <a {if $_tab == 'essays'}class="active"{/if} data-toggle="tab" href="#employeeEssays">
                                                <em class="icon ni ni-files"></em><span>Essays &amp; Samples</span>
                                            </a>
                                        </li>
                                    {/if}
                                        
                                    {if $employee.is_editor || $employee.is_writer}
                                        <li>
                                            <a {if $_tab == 'finances'}class="active"{/if} data-toggle="tab" href="#employeeFinances">
                                                <em class="icon ni ni-wallet-fill"></em><span>Finances</span>
                                            </a>
                                        </li>
                                    {/if}

                                    <li>
                                        <a {if $_tab == 'sessions'}class="active"{/if} data-toggle="tab" href="#loginSessions">
                                            <em class="icon ni ni-activity"></em><span>Login Sessions</span>
                                        </a>
                                    </li>
                                </ul>
                            </div><!-- .card-inner -->

                            {if $employee.is_editor || $employee.is_writer}
                                <div class="card-inner">
                                    <div class="overline-title-alt mb-2">Orders Summary</div>
                                    <div class="profile-balance">
                                        <div class="profile-balance-sub mb-3">
                                            <div class="profile-balance-amount">
                                                <div class="number text-info">{formatPrice($outstanding_payment, $currencyFormat)}</div>
                                            </div>
                                            <div class="profile-balance-subtitle">Outstanding</div>
                                        </div>
                                        <div class="profile-balance-sub mb-3">
                                            <div class="profile-balance-amount">
                                                <div class="number text-secondary">{formatPrice($employee.last_pay, $currencyFormat)}</div>
                                            </div>
                                            <div class="profile-balance-subtitle">Last Pay</div>
                                        </div>
                                        <div class="profile-balance-sub">
                                            <div class="profile-balance-amount">
                                                <div class="number text-primary">{formatPrice($employee.total_paid, $currencyFormat)}</div>
                                            </div>
                                            <div class="profile-balance-subtitle">Total Earned</div>
                                        </div>
                                    </div>
                                </div>
                                <!-- .card-inner -->
                            {/if}

                            {if $employee.is_editor || $employee.is_writer}
                                <div class="card-inner">
                                    <ul class="list-group">
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.bids}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=7" data-ajax="/orders/employee/{$employee.id}?search&status_id=7">Bids</a>
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.progress}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=6" data-ajax="/orders/employee/{$employee.id}?search&status_id=6">In Progress</a> 
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.done}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=8" data-ajax="/orders/employee/{$employee.id}?search&status_id=8">Done</a> 
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.delivered}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=11" data-ajax="/orders/employee/{$employee.id}?search&status_id=11">Delivered</a> 
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.revision}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=14" data-ajax="/orders/employee/{$employee.id}?search&status_id=14">Revision</a> 
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.finished}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=10" data-ajax="/orders/employee/{$employee.id}?search&status_id=10">Finished</a> 
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-primary">{$employee.order_stats.dispute}</span> 
                                            <a class="text-primary" href="{$base_uri}/orders/employee/{$employee.id}?search&status_id=1" data-ajax="/orders/employee/{$employee.id}?search&status_id=1">Disputes</a> 
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-danger badge-dim">{$insights.total_orders_revisions}</span> Orders Revised
                                        </li>
                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-danger badge-dim">{$insights.total_orders_disputes}</span> Orders Disputed
                                        </li>

                                        <li class="list-group-item border-0 px-0"> 
                                            <span class="badge badge-warning badge-dim">{$insights.total_orders_refunds}</span> Orders Refunded
                                        </li>
                                    </ul>
                                </div>
                            {/if}

                            <div class="card-inner">
                                <h6 class="overline-title-alt mb-2">Additional</h6>
                                <div class="row g-3">
                                    <div class="col-6">
                                        <span class="sub-text">Employee ID:</span>
                                        <span>{$employee.id}</span>
                                    </div>
                                    <div class="col-6">
                                        <span class="sub-text">Last Login:</span>
                                        <span class="js_moment" data-time="{$employee.last_login}">{$employee.last_login}</span>
                                    </div>
                                    <div class="col-6">
                                        <span class="sub-text">Last Activity:</span>
                                        <span class="js_moment" data-time="{$employee.last_activity}">{$employee.last_activity}</span>
                                    </div>
                                    <div class="col-6">
                                        <span class="sub-text">Register At:</span>
                                        <span class="js_moment" data-time="{$employee.reg_date}">{$employee.reg_date}</span>
                                    </div>
                                </div>
                            </div><!-- .card-inner -->

                        </div><!-- .card-inner-group -->
                    </div><!-- card-aside -->
                </div><!-- .card-aside-wrap -->
            </div>
                        
        </div>

        <!-- @@ Profile Edit Modal @e -->
        <script id="profileEditModal" type="text/template">
            <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
            <div class="modal-body modal-body-lg">
                <h5 class="title">Update Profile</h5>
                <ul class="nk-nav nav nav-tabs">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#personal">Personal</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#email-address">Email Address</a>
                    </li>
                </ul><!-- .nav-tabs -->
                <div class="tab-content">

                    <div class="tab-pane active" id="personal">
                        <form class="js_ajax-forms" method="POST" data-url="/employees/edit?edit=profile" autocomplete="off">
                            <input type="hidden" name="employee_id" value="{$employee.id}"/>
                            <div class="row gy-4">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label" for="first_name">First Name</label>
                                        <input type="text" class="form-control form-control-lg" name="first_name" value="{$employee.first_name}" autocomplete="off" placeholder="Enter First name">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label" for="middle_name">Middle Name</label>
                                        <input type="text" class="form-control form-control-lg" name="middle_name" value="{$employee.middle_name}" autocomplete="off" placeholder="Enter Middle name">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label" for="last_name">Last Name</label>
                                        <input type="text" class="form-control form-control-lg" name="last_name" value="{$employee.last_name}" autocomplete="off" placeholder="Enter Last name">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label" for="phone-no">Phone Number</label>
                                        <input type="text" name="js_user_phone" class="form-control form-control-lg js_phone" placeholder="Enter mobile" autocomplete="off" {if $employee.phone}value="{$employee.phone}"{/if}>
                                        <input type="hidden" name="phone" class="form-control js_phone_number" autocomplete="off" readonly="true" {if $employee.phone}value="{$employee.phone}"{/if}>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label" for="gender">Gender</label>
                                        <div>
                                            <ul class="custom-control-group">
                                                <li>
                                                    <div class="custom-control custom-control-lg pl-0 custom-checkbox custom-control-pro no-control checked">
                                                        <input type="radio" class="custom-control-input" name="gender" id="gender_male" value="male" {if $employee.gender == 'male'}checked="checked"{/if}>
                                                        <label class="custom-control-label" for="gender_male"><em class="icon fas fa-male"></em><span>Male</span></label>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="custom-control custom-control-lg pl-0 custom-checkbox custom-control-pro no-control">
                                                        <input type="radio" class="custom-control-input" name="gender" id="gender_female" value="female" {if $employee.gender == 'female'}checked="checked"{/if}>
                                                        <label class="custom-control-label" for="gender_female"><em class="icon fas fa-female"></em><span>Female</span></label>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Date of Birth</label>
                                        <div class="form-control-wrap">
                                            <input type="text" data-msg="Required" class="form-control form-control-lg date-picker-alt required" data-date-format="yyyy-mm-dd" name="date_of_birth" {if $employee.date_of_birth != '0000-00-00'}value="{$employee.date_of_birth}"{/if} required>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">Country</label>
                                        <div class="form-control-wrap">
                                            <select class="form-select" data-ui="lg" data-search="on" name="country">
                                                {foreach from=$countries item=country key=key}
                                                    <option value="{$key}" {if $employee.country == $key } selected="" {/if}>{$country.name}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                    
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label">City/Town</label>
                                        <div class="form-control-wrap">
                                            <input type="text" data-msg="Required" class="form-control form-control-lg required" name="city" value="{$employee.city}">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <!-- error -->
                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                    <!-- error -->

                                    <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                    <!-- success -->
                                </div>
                                
                                <div class="col-12">
                                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                        <li>
                                            <button type="submit" class="btn btn-lg btn-primary">Update Profile</button>
                                        </li>
                                        <li>
                                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- .tab-pane -->

                    <div class="tab-pane" id="email-address">
                        <form class="js_ajax-forms" data-url="/employees/edit?edit=email" autocomplete="off">
                            <input type="hidden" name="employee_id" value="{$employee.id}"/>
                            <div class="row gy-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Email Address</label>
                                        <input type="email" class="form-control form-control-lg" name="email" value="{$employee.email}"> 
                                    </div>
                                </div>
                                
                                <div class="col-12">
                                    <!-- error -->
                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                    <!-- error -->

                                    <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                    <!-- success -->
                                </div>

                                <div class="col-12">
                                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                        <li>
                                            <button type="submit" class="btn btn-lg btn-primary">Update Email</button>
                                        </li>
                                        <li>
                                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- .tab-pane -->

                </div><!-- .tab-content -->
            </div><!-- .modal-body -->
        </script>

        <!-- @@ Account Edit Modal @e -->
        <script id="accountEditModal" type="text/template">
            <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
            <div class="modal-body modal-body-lg">
                <h5 class="title">Update Account</h5>
                <ul class="nk-nav nav nav-tabs">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#account">Account</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#qualification">Qualification & Experience</a>
                    </li>
                </ul><!-- .nav-tabs -->
                <div class="tab-content">

                    <div class="tab-pane active" id="account">
                        <form class="js_ajax-forms" method="POST" data-url="/employees/edit?edit=account" autocomplete="off">
                            <input type="hidden" name="employee_id" value="{$employee.id}"/>
                            <div class="row gy-4">
                                <div class="form-table-row col-12 mb-1"> 
                                    <div> 
                                        <div class="form-control-label h6">Activated</div> 
                                        <div class="form-text">Enable employee to view and access orders</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <div class="custom-control custom-control-lg custom-switch">
                                            <input type="checkbox" class="custom-control-input" name="started" id="started" {if $employee.is_started == '1'}checked="checked"{/if}>
                                            <label class="custom-control-label" for="started"></label>
                                        </div>
                                    </div> 
                                </div>
                    
                                <div class="form-table-row col-12 mb-1"> 
                                    <div> 
                                        <div class="form-control-label h6">Ban</div> 
                                        <div class="form-text">Ban this employee from accessing {$site_name}</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <div class="custom-control custom-control-lg custom-switch">
                                            <input type="checkbox" class="custom-control-input" name="banned" id="banned" {if $employee.is_banned == '1'}checked="checked"{/if}>
                                            <label class="custom-control-label" for="banned"></label>
                                        </div>
                                    </div> 
                                </div>

                                <div class="form-table-row col-12 mb-1"> 
                                    <div> 
                                        <div class="form-control-label h6">Available 24/7</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <div class="custom-control custom-control-lg custom-switch">
                                            <input type="checkbox" class="custom-control-input" name="available_247" class="custom-control-input" id="available_247" {if $employee.available_247}checked{/if}>
                                            <label class="custom-control-label" for="available_247"></label>
                                        </div>
                                    </div> 
                                </div>

                                <div class="form-table-row col-12 mb-1"> 
                                    <div> 
                                        <div class="form-control-label h6">Available to take Urgent Orders</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <div class="custom-control custom-control-lg custom-switch">
                                            <input type="checkbox" class="custom-control-input" name="available_urgent_orders" class="custom-control-input" id="available_urgent_orders" {if $employee.available_urgent_orders}checked{/if}>
                                            <label class="custom-control-label" for="available_urgent_orders"></label>
                                        </div>
                                    </div> 
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Employee Group</label>
                                        <select class="form-select" data-ui="lg" name="employee_group">
                                            <option value="1" {if $employee.employee_group == "1"}selected="selected"{/if}>Administrator</option>
                                            <option value="4" {if $employee.employee_group == "4"}selected="selected"{/if}>Sub Admin</option>
                                            <option value="2" {if $employee.employee_group == "2"}selected="selected"{/if}>Editor</option>
                                            <option value="3" {if $employee.employee_group == "3"}selected="selected"{/if}>Writer</option>
                                            <option value="5" {if $employee.employee_group == "5"}selected="selected"{/if}>Applicant</option>
                                        </select>
                                    </div>
                                </div>
                    
                                {if $employee.is_editor || $employee.is_writer}
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Writer Category</label>
                                            <select class="form-select" data-ui="lg" name="writer_category">
                                                <option value="2" {if $employee.writer_category == "2"}selected="selected"{/if}>Best Available</option>
                                                <option value="3" {if $employee.writer_category == "3"}selected="selected"{/if}>ESL (English Second Language)</option>
                                                <option value="4" {if $employee.writer_category == "4"}selected="selected"{/if}>ENL (English Native Language)</option>
                                            </select>
                                        </div>
                                    </div>
                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Academic Level</label>
                                            <select class="form-select" data-ui="lg" name="academic_level">
                                                <option value="1" {if $employee.academic_level == "1"}selected="selected"{/if}>High school</option>
                                                <option value="2" {if $employee.academic_level == "2"}selected="selected"{/if}>Undergrad. (yrs 1-2)</option>
                                                <option value="3" {if $employee.academic_level == "3"}selected="selected"{/if}>Undergrad. (yrs 3-4)</option>
                                                <option value="4" {if $employee.academic_level == "4"}selected="selected"{/if}>Master's</option>
                                                <option value="5" {if $employee.academic_level == "5"}selected="selected"{/if}>Ph.D.</option>
                                            </select>
                                        </div>
                                    </div>
                    
                                    {if $employee.is_writer}
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label">Number of Takes</label>
                                                <input name="number_of_takes" type="text" class="form-control form-control-lg force-integer" style="width:150px;" value="{$employee.number_of_takes}">
                                            </div>
                                        </div>
                                    {/if}
                    
                                {/if}
                    
                                {hook h='displayAdminEditEmployeeAccount' employee_id=$employee.id}
                    
                                <div class="col-12">
                                    <!-- error -->
                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                    <!-- error -->
                    
                                    <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                    <!-- success -->
                                </div>
                                
                                <div class="col-12">
                                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                        <li>
                                            <button type="submit" class="btn btn-lg btn-primary">Update Account</button>
                                        </li>
                                        <li>
                                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- .tab-pane -->

                    <div class="tab-pane" id="about">
                        <form class="js_ajax-forms" method="POST" data-url="/employees/edit?edit=about" autocomplete="off">
                            <input type="hidden" name="employee_id" value="{$employee.id}"/>
                            <div class="row gy-4">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">About Me</label>
                                        <div class="form-control-wrap">
                                            <textarea class="form-control summernote-minimal" data-height="250" name="about_me">{$employee.about}</textarea>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Facebook Profile</label>
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control form-control-lg" name="facebook_profile" value="{$employee.facebook_profile}">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">LinkedIn Profile</label>
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control form-control-lg" name="linkedin_profile" value="{$employee.linkedin_profile}">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <!-- error -->
                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                    <!-- error -->
                    
                                    <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                    <!-- success -->
                                </div>
                                
                                <div class="col-12">
                                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                        <li>
                                            <button type="submit" class="btn btn-lg btn-primary">Update Account</button>
                                        </li>
                                        <li>
                                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                        </form>
                    </div>
                    <!-- .tab-pane -->

                    <div class="tab-pane" id="qualification">
                        <form class="js_ajax-forms" method="POST" data-url="/employees/edit?edit=qualifications" autocomplete="off">
                            <input type="hidden" name="employee_id" value="{$employee.id}"/>
                            <div class="row gy-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Your Native Language</label>
                                        <div class="form-control-wrap">
                                            <select class="form-select" data-ui="lg" data-search="on" name="native_language" required>
                                                {foreach from=$languages item=language key=key}
                                                    <option value="{$key}" {if $employee.native_language == $key } selected="" {/if}>{$language.name}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                    
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Other Languages You Can Write At</label>
                                        <div class="form-control-wrap">
                                            <select class="form-select" data-ui="lg" data-search="on" name="other_languages[]" multiple data-search="on">
                                                {foreach from=$languages item=language key=key}
                                                    <option value="{$key}" {if in_array($key, $employee.other_languages_array)} selected="" {/if}>{$language.name}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                    
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Your Highest Verifiable Academic Degree</label>
                                        <div class="form-control-wrap">
                                            <select class="form-select" data-ui="lg" data-search="on" name="highest_academic_degree" required>
                                                {foreach from=$academicDegrees item=academicDegree key=key}
                                                    <option value="{$key}" {if $employee.highest_academic_degree == $key } selected="" {/if}>{$academicDegree.degree}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                    
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">Your Degree Major</label>
                                        <div class="form-control-wrap">
                                            <input type="text" data-msg="Required" class="form-control form-control-lg required" name="academic_degree_major" value="{$employee.academic_degree_major}" required>
                                        </div>
                                    </div>
                                </div>
                    
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Please Select 3-7 Disciplines You Are Proficient In</label>
                                        <div class="form-control-wrap">
                                            <select class="form-select required" data-search="on" data-ui="lg" data-msg="Required" name="proficient_disciplines[]" multiple data-search="on">
                                                {foreach $disciplineGroups as $topicCat}
                                                    <optgroup label="{$topicCat.title}">
                                                        {foreach $topicCat.disciplines as $discipline}
                                                            <option value="{$discipline.discipline_id}" {if in_array($discipline.discipline_id, $employee.proficient_disciplines_array)}selected=""{/if} >{$discipline.title}</option>
                                                        {/foreach}
                                                    </optgroup>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                    
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Please Indicate Software You Have Access To And/OR Programming Language You Are Expert In</label>
                                        <div class="form-control-wrap">
                                            <select class="form-select required" data-search="on" data-ui="lg" data-msg="Required" name="software[]" multiple data-search="on">
                                                {foreach $software_programming as $snf}
                                                    <option value="{$snf.software_programming_id}" {if in_array($snf.software_programming_id, $employee.software_array)}selected=""{/if}>{$snf.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <!-- .col -->

                                <div class="col-12">
                                    <!-- error -->
                                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                                    <!-- error -->
                    
                                    <!-- success -->
                                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                                    <!-- success -->
                                </div>
                                
                                <div class="col-12">
                                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                        <li>
                                            <button type="submit" class="btn btn-lg btn-primary">Update Account</button>
                                        </li>
                                        <li>
                                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                        </form>
                    </div>
                    <!-- .tab-pane -->

                </div><!-- .tab-content -->
            </div><!-- .modal-body -->
        </script>

        <!-- @@ Profile Timezone Modal @e -->
        <script id="profileTimezone" type="text/template">
            <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
            <div class="modal-body">
                <h5 class="title">Update Timezone</h5>
                <form class="js_ajax-forms" data-url="/employees/edit?edit=timezone" autocomplete="off">
                    <input type="hidden" name="employee_id" value="{$employee.id}"/>
                    <div class="form-group mt-4">
                        <label class="form-label">Timezone</label>
                        <div class="row">
                            <div class="col-md-6">
                                <select id="timezone-region" class="form-control form-control-lg" data-combo="timezone-combo">
                                    {foreach from=$regions item=region key=key name=name}
                                        <option value="{$key}" {if $employee.default_region == $key } selected="" {/if} >{$key}</option>
                                    {/foreach}
                                </select>
                            </div>
                            {assign var='timezoneId' value=0}
                            <div id="timezone-combo" class="col-md-6">
                                {foreach from=$regions item=region key=key name=name}
                                    <select id="timezone-combo-{$key}" class="form-control form-control-lg {if $employee.default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                        {foreach from=$region item=item key=key name=name}
                                            <option value="{$key}" {if $employee.timezone == $key } selected="" {/if} >{$item}</option>
                                        {/foreach}
                                    </select>
                                {assign var='timezoneId' value=$timezoneId+1}
                                {/foreach}
                            </div>
                        </div>
                        <input type="hidden" id="timezone" name="timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">
                    </div>
                        
                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                        
                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                        <li>
                            <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                        </li>
                        <li>
                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                        </li>
                    </ul>
                </form>
            </div>
        </script>

        <!-- @@ Profile Password Modal @e -->
        <script id="profilePassword" type="text/template">
            <a href="#" class="close" data-dismiss="modal">
                <em class="icon ni ni-cross-sm"></em>
            </a>
            <div class="modal-body">
                <h5 class="title">Change Password</h5>
                <form class="js_ajax-forms" data-url="/employees/edit?edit=password" autocomplete="off">
                    <input type="hidden" name="employee_id" value="{$employee.id}"/>
                    <div class="form-group mt-4">
                        <label class="form-label">New Password</label>
                        <input type="text" class="form-control form-control-lg" name="password" autocomplete="off"> 
                    </div>

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                        
                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                        <li>
                            <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                        </li>
                        <li>
                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                        </li>
                    </ul>
                </form>
            </div>
        </script>

        <!-- @@ Account Status Modal @e -->
        <script id="accountWorkingStatus" type="text/template">
            <a href="#" class="close" data-dismiss="modal">
                <em class="icon ni ni-cross-sm"></em>
            </a> 
            <div class="modal-body">
                <h5 class="title">Change Working Status</h5>
                <form class="js_ajax-forms" data-url="/employees/edit?edit=working_status" autocomplete="off">
                    <input type="hidden" name="employee_id" value="{$employee.id}"/>
                    <div class="form-group mt-4">
                        <label class="form-label">Status</label>
                        <select class="form-select" data-ui="lg" name="employee_status">
                            <option value="2" {if $employee.employee_status == "2"}selected="selected"{/if}>Looking for orders</option>
                            <option value="4" {if $employee.employee_status == "4"}selected="selected"{/if}>Cannot work for now</option>
                            <option value="5" {if $employee.employee_status == "5"}selected="selected"{/if}>Do not use your service</option>
                            <option value="6" {if $employee.employee_status == "6"}selected="selected"{/if}>Probation</option>
                        </select>
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label fw-bold">Available 24/7</div> 
                        </div> 
                        <div class="text-right"> 
                            <div class="custom-control custom-control-md custom-switch">
                                <input type="checkbox" class="custom-control-input" name="available_247" class="custom-control-input" id="available_247" {if $employee.available_247}checked{/if}>
                                <label class="custom-control-label" for="available_247"></label>
                            </div>
                        </div> 
                    </div>

                    <div class="form-table-row"> 
                        <div> 
                            <div class="form-control-label fw-bold">Available to take Urgent Orders</div> 
                        </div> 
                        <div class="text-right"> 
                            <div class="custom-control custom-control-md custom-switch">
                                <input type="checkbox" class="custom-control-input" name="available_urgent_orders" class="custom-control-input" id="available_urgent_orders" {if $employee.available_urgent_orders}checked{/if}>
                                <label class="custom-control-label" for="available_urgent_orders"></label>
                            </div>
                        </div> 
                    </div>

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                        
                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                        <li>
                            <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                        </li>
                        <li>
                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                        </li>
                    </ul>
                </form>
            </div>
        </script>

        {if $employee.is_sub_admin || $employee.is_editor || $employee.is_writer}
            <!-- @@ Employee CPP Modal @e -->
            <script id="cppEditModal" type="text/template">
                <a href="#" class="close" data-dismiss="modal">
                    <em class="icon ni ni-cross-sm"></em>
                </a>
                <div class="modal-body">
                    <h5 class="title">Change Pay</h5>
                    <form class="js_ajax-forms mt-4" data-url="/employees/edit?edit=employee_cpp" autocomplete="off">
                        <input type="hidden" name="employee_id" value="{$employee.id}"/>
                        <div class="form-group">
                            <label class="form-label">Cost Per Page Type</label>
                            <select class="form-select" data-ui="lg" name="cpp_type" data-combo="cpp_type">
                                <option value="system" {if $employee.cpp_type == 'system'}selected=""{/if}>System CPP</option>
                                <option value="custom" {if $employee.cpp_type == 'custom'}selected=""{/if}>Custom CPP</option>
                            </select>
                        </div>
                    
                        <div id="cpp_type" class="form-group">
                            <div class="switch-combo {if $employee.cpp_type == 'system'}x-hidden{/if}" data-combo-value="custom">
                                <div class="form-group">
                                    <label class="form-label">Cost Per Page</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text">$</span> 
                                        </div>
                                        <input name="cpp_amount" type="text" class="form-control form-control-lg force-integer" value="{$employee.cpp_amount}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                        {if $is_articlewriting_enabled}
                            <div class="form-group">
                                <label class="form-label">Cost Per Word Type</label>
                                <select class="form-select" data-ui="lg" name="cpw_type" data-combo="cpw_type">
                                    <option value="system" {if $employee.cpw_type == 'system'}selected=""{/if}>System CPW</option>
                                    <option value="custom" {if $employee.cpw_type == 'custom'}selected=""{/if}>Custom CPW</option>
                                </select>
                            </div>

                            <div id="cpw_type" class="form-group">
                                <div class="switch-combo {if $employee.cpw_type == 'system'}x-hidden{/if}" data-combo-value="custom">
                                    <div class="form-group">
                                        <label class="form-label">Cost Per Word</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend"> 
                                                <span class="input-group-text">$</span> 
                                            </div>
                                            <input name="cpw_amount" type="text" class="form-control form-control-lg force-integer" value="{$employee.cpw_amount}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        {/if}

                        <!-- error -->
                        <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                        <!-- error -->

                        <!-- success -->
                        <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                        <!-- success -->
                            
                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                            <li>
                                <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                            </li>
                            <li>
                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                            </li>
                        </ul>
                    </form>
                </div>
            </script>
        {/if}

        <!-- @@ Employee Orders Access Modal @e -->
        <script id="ordersAccessEditModal" type="text/template">
            <a href="#" class="close" data-dismiss="modal">
                <em class="icon ni ni-cross-sm"></em>
            </a>
            <div class="modal-body">
                <h5 class="title">Change Order Access</h5>
                <form class="js_ajax-forms mt-4" data-url="/employees/edit?edit=dashboard_access" autocomplete="off">
                    <input type="hidden" name="employee_id" value="{$employee.id}"/>
                    <div class="form-group">
                        <ul class="custom-control-group custom-control-vertical w-100">
                            <li>
                                <div class="custom-control custom-control-md custom-radio custom-control-pro"> 
                                    <input type="checkbox" class="custom-control-input" name="dashboard_access[]" {if $employee.has_academic_access}checked{/if} value="academic" id="dashboard_access_academic"> 
                                    <label class="custom-control-label" for="dashboard_access_academic">                
                                        <em class="icon icon-lg ni ni-text"></em><span>Academic Writing</span>            
                                    </label>            
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-md custom-radio custom-control-pro"> 
                                    <input type="checkbox" class="custom-control-input" name="dashboard_access[]" {if $employee.has_article_access}checked{/if} value="article" id="dashboard_access_article"> 
                                    <label class="custom-control-label" for="dashboard_access_article">                
                                        <em class="icon icon-lg ni ni-article"></em><span>Article Writing</span>            
                                    </label>            
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-md custom-radio custom-control-pro"> 
                                    <input type="checkbox" class="custom-control-input" name="dashboard_access[]" {if $employee.has_programming_access}checked{/if} value="programming" id="dashboard_access_programming"> 
                                    <label class="custom-control-label" for="dashboard_access_programming">                
                                        <em class="icon icon-lg ni ni-code"></em><span>Programming</span>            
                                    </label>            
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-md custom-radio custom-control-pro"> 
                                    <input type="checkbox" class="custom-control-input" name="dashboard_access[]" {if $employee.has_calculations_access}checked{/if} value="calculations" id="dashboard_access_calculations"> 
                                    <label class="custom-control-label" for="dashboard_access_calculations">                
                                        <em class="icon icon-lg ni ni-calc"></em><span>Calculations</span>            
                                    </label>            
                                </div>
                            </li>
                        </ul>
                    </div>

                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                        
                    <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                        <li>
                            <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                        </li>
                        <li>
                            <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                        </li>
                    </ul>
                </form>
            </div>
        </script>

        <script id="modal-upload-file" type="text/template">
            <form class="js_files-uploader p0 m0" method="POST" data-action="employees/upload" data-id="{$employee.id}" data-handle="{literal}{{handle}}{/literal}">
                <div class="modal-header"> 
                    <h5 class="modal-title">Essay</h5>
                    <span class="close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>
                
                <div class="modal-body">
                    <div class="alert alert-secondary">
                        <p>Upload your sample essay in <strong>doc/docx/pdf format</strong>. Make sure your sample essay:</p>
                        <ul class="list list-checked-circle">
                            <li>Contains 275-350 words</li>
                            <li>Is formatted according to the <strong>indicated format style</strong></li>
                            <li>Is <strong>not handwritten</strong></li>
                        </ul>
                    </div>
        
                    <h6 class="mb-3 overline-title title">Upload File</h6>
                    <div class="files-control js_dropzone" data-handle="{literal}{{handle}}{/literal}">
                        <div class="files-control--files"></div>
                        <div class="dropzone-description">
                            <button class="browse-button btn btn-primary" type="button">Browse </button>
                            <span class="control-or">or</span>
                            <span class="control-drop-here">Drop plugin here</span>
                        </div>
                        <div class="dropzone-static">
                            <div class="dropzone-border">Drop files here</div>
                        </div>
                        <input accept=".pdf,.doc,.docx" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
                    </div>
                    <!-- error -->
                    <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer bg-lighter">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
                </div>
            </form>
        </script>
        
        <script id="modal-upload-cv" type="text/template">
            <form class="js_files-uploader p0 m0" method="POST" data-action="employees/upload" data-id="{$employee.id}" data-handle="{literal}{{handle}}{/literal}">
                <div class="modal-header"> 
                    <h5 class="modal-title">CV</h5>
                    <span class="close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>
                
                <div class="modal-body">
                    <div class="alert alert-secondary">
                        <p>Please upload your CV / resume here.</p>
                        <p>The file(s) should be uploaded in <strong>doc / docx / pdf format (no more than 3 files and 50MB)</strong></p>
                    </div>
        
                    <h6 class="mb-3 overline-title title">Upload File</h6>
                    <div class="files-control js_dropzone" data-handle="{literal}{{handle}}{/literal}">
                        <div class="files-control--files"></div>
                        <div class="dropzone-description">
                            <button class="browse-button btn btn-primary" type="button">Browse </button>
                            <span class="control-or">or</span>
                            <span class="control-drop-here">Drop plugin here</span>
                        </div>
                        <div class="dropzone-static">
                            <div class="dropzone-border">Drop files here</div>
                        </div>
                        <input accept=".pdf,.doc,.docx" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
                    </div>
                    <!-- error -->
                    <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer bg-lighter">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
                </div>
            </form>
        </script>
        
        <script id="modal-upload-degree" type="text/template">
            <form class="js_files-uploader p0 m0" method="POST" data-action="employees/upload" data-id="{$employee.id}" data-handle="{literal}{{handle}}{/literal}">
                <div class="modal-header"> 
                    <h5 class="modal-title">Degree Certificate</h5>
                    <span class="close" data-dismiss="modal" aria-label="Close">
                        <em class="icon ni ni-cross"></em>
                    </span>
                </div>
                
                <div class="modal-body">
                    <div class="alert alert-secondary">
                        <p>Please upload a photo of your education certificate and/or academic transcripts that can prove your highest qualification attained.</p>
                        <p><strong>Certificates issued in non-English-speaking countries should be submitted along with their English translations.</strong></p>
                        <p>The file(s) should be uploaded in <strong>jpg / jpeg format (no more than 3 files and 50MB)</strong></p>
                    </div>
        
                    <h6 class="mb-3 overline-title title">Upload File</h6>
                    <div class="files-control js_dropzone" data-handle="{literal}{{handle}}{/literal}">
                        <div class="files-control--files"></div>
                        <div class="dropzone-description">
                            <button class="browse-button btn btn-primary" type="button">Browse </button>
                            <span class="control-or">or</span>
                            <span class="control-drop-here">Drop plugin here</span>
                        </div>
                        <div class="dropzone-static">
                            <div class="dropzone-border">Drop files here</div>
                        </div>
                        <input accept=".jpg,.jpeg" multiple="" type="file" style="display: none;" data-handle="{literal}{{handle}}{/literal}">
                    </div>
                    <!-- error -->
                    <div class="alert alert-danger alert-fill mt20 mb0 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer bg-lighter">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
                </div>
            </form>
        </script>

    {/if}
{/block}