{strip}
<!-- Modals -->
<div id="modal" class="modal fade">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body">
                <div class="loader pt10 pb10"></div>
            </div>
        </div>
    </div>
</div> 

<script id="modal-login" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">Not Logged In</h5>
    </div>
    <div class="modal-body">
        <p>Please log in to continue</p>
    </div>
    <div class="modal-footer">
        <a class="btn btn-primary" href="{$base_uri}/signin">Login</a>
    </div>
</script>

<script id="modal-message" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">{literal}{{title}}{/literal}</h5>
        <span class="modal-close" data-dismiss="modal" aria-label="Close">
            <i class="fa fa-times"></i>
        </span>
    </div>
    <div class="modal-body">
        <p>{literal}{{message}}{/literal}</p>
    </div>
</script>

<script id="modal-success" type="text/template">
    <div class="modal-body text-center">
        <div class="big-icon success">
            <i class="fa fa-thumbs-up fa-3x"></i>
        </div>
        <h4>{literal}{{title}}{/literal}</h4>
        <p class="mt20 mb20">{literal}{{message}}{/literal}</p>

        {literal}{{#redirect_link}}{/literal}
            <a href="{literal}{{redirect_link}}{/literal}" class="btn btn-primary mrauto mlauto">OK</a>
        {literal}{{/redirect_link}}{/literal}

        {literal}{{^redirect_link}}{/literal}
            <a href="javascript:void(0);" onclick="window.location.reload();" class="btn btn-primary mrauto mlauto">OK</a>
        {literal}{{/redirect_link}}{/literal}
    </div>
</script>

<script id="modal-error" type="text/template">
    <div class="modal-body text-center">
        <div class="big-icon error">
            <i class="fa fa-times fa-3x"></i>
        </div>
        <h4>{literal}{{title}}{/literal}</h4>
        <p class="mt20">{literal}{{message}}{/literal}</p>
    </div>
</script>

<script id="modal-confirm" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">{literal}{{title}}{/literal}</h5>
        <span class="modal-close" data-dismiss="modal" aria-label="Close">
            <i class="fa fa-times"></i>
        </span>
    </div>
    <div class="modal-body">
        <p>{literal}{{message}}{/literal}</p>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="modal-confirm-ok">Confirm</button>
    </div>
</script>

<script id="modal-loading" type="text/template">
    <div class="modal-body text-center">
        <div class="loader pt10 pb10"></div>
    </div>
</script>
<!-- Modals -->

{if $user.is_admin}
    <!-- Activate Module -->
    <script id="activateModule" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/admin/modules" method="POST">
            <input type="hidden" name="do" value="activate">
            <input type="hidden" name="module_name" value="{literal}{{module_name}}{/literal}">
            <div class="modal-header">
                <h5 class="modal-title">Activate Module</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="control-label text-left">Activation Key</label>
                    <input name="activation_key" type="text" class="form-control" required="">
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Activate</button>
            </div>
        </form>
    </script>
    <!-- Activate Module -->

    
    <!-- Upload Plugin -->
    <script id="modalUploadPlugin" type="text/template">
        <form class="js_files-uploader p0 m0" method="POST" data-handle="plugin">
            <div class="modal-header">
                <h5 class="modal-title">Upload Addon</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            
            <div class="modal-body">
                <div class="files-control js_dropzone" data-handle="plugin">
                    <div class="files-control--files"></div>
                    <div class="dropzone-description">
                        <button class="browse-button btn btn-info" type="button">Browse </button>
                        <span class="control-or">or</span>
                        <span class="control-drop-here">Drop plugin here</span>
                    </div>
                    <div class="dropzone-static">
                        <div class="dropzone-border">Drop files here</div>
                    </div>
                    <input accept=".zip" multiple="" type="file" style="display: none;" data-handle="plugin">
                </div>
                <!-- error -->
                <div class="alert alert-danger mt20 mb0 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
            </div>
        </form>
    </script>
{/if}

{if $user.is_admin || $user.is_sub_admin}

    <script id="modalPasswordResetLink" type="text/template">
        <div class="modal-header">
            <h5 class="modal-title">Password Reset Link</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>
        <div class="modal-body">
            <div class="alert bg-info text-dark">{literal}{{password_reset_link}}{/literal}</div>
        </div>
    </script>

    <!-- Change Deadline -->
    <script id="extendDeadlineModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/orders/{literal}{{order_id}}{/literal}/deadline" method="POST" autocomplete="off">
            <input type="hidden" name="handle" value="{literal}{{handle}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Change Deadline</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">

                <div class="form-group mb0">
                    <label class="form-control-label">Select Deadline</label>
                    <div class="input-group date js_datetimepicker" id="deadline" data-target-input="nearest">
                        <input type='text' class="form-control datetimepicker-input" data-target="#deadline" name="deadline" />
                        <div class="input-group-append" data-target="#deadline" data-toggle="datetimepicker">
                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                        </div>
                    </div>
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Change Deadline</button>
            </div>
        </form>
    </script>
    <!-- Change Deadline -->

    <!-- Bulk Actions -->
    <script id="modal-bulk-actions"  type="text/template">
        <form class="js_ajax-forms" data-url="/admin/bulk-actions" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Bulk Actions</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>

            <div class="modal-body">
                <input name="orderIds" value="{literal}{{orderIds}}{/literal}" type="hidden">
                <div class="form-group">
                    <label class="form-label">Select an Action</label>
                    <select data-combo="bulk-actions-combo" name="action" class="form-control custom-select">
                        <optgroup label="Status">
                            <option value="status" selected="">Change order status</option>
                        </optgroup>
                        <optgroup label="Paid">
                            <option value="mark-paid">Mark as Client Paid</option>
                            <option value="writer-paid">Mark as Writer Paid</option>
                            <option value="editor-paid">Mark as Editor Paid</option>
                        </optgroup>
                        <optgroup label="Unpaid">
                            <option value="mark-unpaid">Mark as Client Unpaid</option>
                            <option value="writer-unpaid">Mark as Writer Unpaid</option>
                            <option value="editor-unpaid">Mark as Editor Unpaid</option>
                        </optgroup>
                        <optgroup label="Delete">
                            <option value="delete">Delete</option>
                        </optgroup>
                    </select>
                </div>

                <div id="bulk-actions-combo" class="mt-3">
                    <div data-combo-value="status" class="switch-combo">
                        <div class="form-group">
                            <label class="form-label">Status ID</label>
                            <select name="status_id" class="form-control custom-select">
                                <option value="13">Free Inquiry</option>
                                <option value="0">Waiting for Payment</option>
                                <option value="12">New Paid</option>
                                <option value="19">Available</option>
                                <option value="6">Writer Assigned</option>
                                {if $editor_account_enabled}
                                    <option value="8">Done/Editing</option>
                                {/if}
                                <option value="11">Delivered</option>
                                <option value="10">Finished</option>
                                <option value="14">Revision</option>
                                <option value="9">Cancelled</option>
                                <option value="1">Dispute</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Confirm</button>
            </div>
        </form>
    </script>
    <!-- Bulk Actions -->

    <!-- Feedback Modal -->
    <script id="modal-feedback" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/feedback/{literal}{{feedback_id}}{/literal}/reply" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Reply to Feedback</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">

                <div class="form-group">
                    <label>Reply</label>
                    <textarea name="reply" type="text" class="form-control js_autosize"></textarea>
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Reply</button>
            </div>
        </form>
    </script>
    <!-- Feedback Modal -->

    <!-- Duplicate Order Modal -->
    <script id="duplicateOrderModal" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/orders/{literal}{{order_id}}{/literal}/duplicate" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Duplicate Order</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">

                <div class="form-group">
                    <label class="form-label">Duplicates</label>
                    <input class="form-control force-integer" type="text" name="duplicates" autocomplete="off">
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Duplicate</button>
            </div>
        </form>
    </script>
    <!-- Duplicate Order Modal -->

    <!-- Employee Pay -->
    <script id="modal-edit-pay" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/orders/{literal}{{order_id}}{/literal}/edit-cost" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Edit Pay</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">

                {literal}{{#edit_customer_pay}}{/literal}
                    {literal}{{#customer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Customer Pay</label>
                            <input name="customer_pay" class="form-control force-integer" value="{literal}{{customer_pay}}{/literal}"/>
                        </div>
                    {literal}{{/customer_pay}}{/literal}

                    {literal}{{^customer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Customer Pay</label>
                            <input name="customer_pay" class="form-control force-integer" value="0.00"/>
                        </div>
                    {literal}{{/customer_pay}}{/literal}
                {literal}{{/edit_customer_pay}}{/literal}

                {literal}{{#edit_writer_pay}}{/literal}
                    {literal}{{#writer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Writer Pay</label>
                            <input name="writer_pay" class="form-control force-integer" value="{literal}{{writer_pay}}{/literal}"/>
                        </div>
                    {literal}{{/writer_pay}}{/literal}

                    {literal}{{^writer_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Writer Pay</label>
                            <input name="writer_pay" class="form-control force-integer" value="0.00"/>
                        </div>
                    {literal}{{/writer_pay}}{/literal}
                {literal}{{/edit_writer_pay}}{/literal}

                {literal}{{#edit_editor_pay}}{/literal}
                    {literal}{{#editor_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Editor Pay</label>
                            <input name="editor_pay" class="form-control force-integer" value="{literal}{{editor_pay}}{/literal}"/>
                        </div>
                    {literal}{{/editor_pay}}{/literal}

                    {literal}{{^editor_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Editor Pay</label>
                            <input name="editor_pay" class="form-control force-integer" value="0.00"/>
                        </div>
                    {literal}{{/editor_pay}}{/literal}
                {literal}{{/edit_editor_pay}}{/literal}

                {literal}{{#edit_ordermanager_pay}}{/literal}
                    {literal}{{#ordermanager_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Writer Pay</label>
                            <input name="ordermanager_pay" class="form-control force-integer" value="{literal}{{ordermanager_pay}}{/literal}"/>
                        </div>
                    {literal}{{/ordermanager_pay}}{/literal}

                    {literal}{{^ordermanager_pay}}{/literal}
                        <div class="form-group">
                            <label class="form-label">Writer Pay</label>
                            <input name="ordermanager_pay" class="form-control force-integer" value="0.00"/>
                        </div>
                    {literal}{{/ordermanager_pay}}{/literal}
                {literal}{{/edit_ordermanager_pay}}{/literal}

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Employee Pay -->

    <!-- Progressive Delivery -->
    <script id="modalProgressiveDelivery" type="text/template">
        <form class="js_ajax-forms" data-url="/orders/{literal}{{order_id}}{/literal}/pd_schedule" method="POST" autocomplete="off">
            <div class="modal-header">
                <h5 class="modal-title">Add Delivery Schedule</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">Pages</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="pages" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                            <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">Charts</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="charts" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                            <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">PowerPoint slides</label>
                    <div class="col-sm-4">
                        <div class="control-stepper">
                            <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                            <input name="slides" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                            <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                        </div>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="form-group">
                    <label class="form-control-label">Customer Deadline</label>
                    <div class="input-group date js_datetimepicker" id="customer_deadline" data-target-input="nearest">
                        <input type='text' class="form-control datetimepicker-input" data-target="#customer_deadline" name="customer_deadline" />
                        <div class="input-group-append" data-target="#customer_deadline" data-toggle="datetimepicker">
                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-control-label">Writer Deadline</label>
                    <div class="input-group date js_datetimepicker" id="writer_deadline" data-target-input="nearest">
                        <input type='text' class="form-control datetimepicker-input" data-target="#writer_deadline" name="writer_deadline" />
                        <div class="input-group-append" data-target="#writer_deadline" data-toggle="datetimepicker">
                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                        </div>
                    </div>
                </div>

                <div class="divider"></div>

                <div class="form-group">
                    <label class="control-label">Comments</label>
                    <textarea name="comments" type="text" class="form-control js_autosize"></textarea>
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Schedule</button>
            </div>
        </form>
    </script>
    <!-- Progressive Delivery -->
{/if}

{if $user.logged}

    <script id="newMessage" type="text/template">
        <form class="js_ajax-forms p0 m0" autocomplete="off" data-url="/messages/send" method="POST">
            <input type="hidden" name="order_id" value="{literal}{{order_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">New message</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Recepient</label>
                    <select name="recepient" data-combo="recepient" class="form-control" required="">
                        {if $user.is_writer}
                            <option value="7">Customer</option>
                            <option value="8">Support Department</option>
                        {elseif $user.is_editor}
                            <option value="6">Writer</option>
                            <option value="8">Support Department</option>
                        {elseif $user.is_admin || $user.is_sub_admin}
                            <option value="7">Customer</option>
                            <option value="6">Writer</option>
                        {/if}
                    </select>
                </div>

                {if $user.is_admin || $user.is_sub_admin}
                    <div class="form-group">
                        <label class="form-label">Subject</label>
                        <input name="subject" class="form-control"/>
                    </div>
                {else}
                    <div id="recepient">
                        <div class="switch-combo x-hidden" data-combo-value="8">
                            <div class="form-group">
                                <label class="form-label">Subject</label>
                                <input name="subject" class="form-control"/>
                            </div>
                        </div>
                    </div>
                {/if}

                <div class="form-group">
                    <label class="form-label">Message</label>
                    <textarea name="message" class="form-control js_summernote" data-height="200"></textarea>
                </div>

                {if $smsnotifications_enabled}
                    <div class="custom-control custom-checkbox mb10">
                        <input type="checkbox" class="custom-control-input" name="send_sms" id="send_sms">
                        <label for="send_sms" class="custom-control-label">Send SMS</label>
                    </div>
                {/if}

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>  
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Send</button>
            </div>
        </form>
    </script>

    <!-- Revision -->
    <script id="revision" type="text/template">
        <form class="js_ajax-forms p0 m0" autocomplete="off" data-url="/orders/{literal}{{order_id}}{/literal}/sendToRevision" method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Send order to revision</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Revision Note</label>
                    <textarea name="revision_note" class="form-control js_summernote"></textarea>
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>  
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </script>

    <!-- Upload -->
    <script id="modal-upload" type="text/template">
        <form class="js_files-uploader p0 m0" data-oid="{literal}{{order_id}}{/literal}" {if !$user.is_admin}data-upload-me=""{/if} method="POST">
            <div class="modal-header">
                <h5 class="modal-title">Upload files</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                {if $user.is_admin || $user.is_sub_admin}
                    <div class="row mb10">
                        <label class="col-sm-12 control-label text-left">Upload on behalf of</label>
                        <div class="selectgroup col-sm-12">
                            <label class="selectgroup-item">
                                <input type="radio" name="upload_for" value="customer" class="selectgroup-input" checked="">
                                <span class="selectgroup-button">Customer</span>
                            </label>
                            <label class="selectgroup-item">
                                <input type="radio" name="upload_for" value="writer" class="selectgroup-input">
                                <span class="selectgroup-button">Writer</span>
                            </label>
                            <label class="selectgroup-item">
                                <input type="radio" name="upload_for" value="editor" class="selectgroup-input">
                                <span class="selectgroup-button">Editor</span>
                            </label>
                            <label class="selectgroup-item">
                                <input type="radio" name="upload_for" value="support" class="selectgroup-input">
                                <span class="selectgroup-button">Support</span>
                            </label>
                        </div>
                    </div>
                {/if}
                <div class="files-control js_dropzone" data-handle="order"> 
                    <div class="files-control--files"></div>
                    <div class="dropzone-description">
                        <button class="browse-button btn btn-info" type="button">Browse </button>
                        <span class="control-or">or</span>
                        <span class="control-drop-here">Drop files here</span>
                    </div>
                    <div class="dropzone-static">
                        <div class="dropzone-border">Drop files here</div>
                    </div>
                    <input multiple="" type="file" style="display: none;" data-handle="order" data-id="{literal}{{order_id}}{/literal}">
                </div>
                <!-- error -->
                <div class="alert alert-danger mt20 mb0 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok" disabled="true">Upload</button>
            </div>
        </form>
    </script>
    <!-- Upload -->

    <!-- Form File -->
    <script id="form-file" type="text/template">
        <div class="FormFile" data-id="{literal}{{id}}{/literal}">
            <div class="FormFile__controls">
                <div class="FormFile__icon">
                    <div class="FormFile__icon__badge FormFile__icon__badge--jpg">{literal}{{extension}}{/literal}</div>
                </div>
                <button type="button" class="FormFile__info">
                    <div class="FormFile__title">{literal}{{filename}}{/literal}</div>
                    <span class="FormFile__size">{literal}{{size}}{/literal}</span>
                </button>

                {literal}{{#is_order}}{/literal}
                    <div class="FormFile__upload-type-control">
                        <select name="uploadTypeId" class="form-control" disabled>
                            <option value="-1" selected="">Select file type</option>
                            {foreach $upload_types as $upload_type}
                                <option value="{$upload_type.id}">{$upload_type.title}</option>
                            {/foreach}
                        </select>
                    </div>
                {literal}{{/is_order}}{/literal}
                
                <button {literal}{{^isUploaded}}disabled{{/isUploaded}}{/literal} type="button" class="FormFile__remove-button"></button>
            </div>
            <!-- error -->
            <div class="alert alert-danger mt20 mb0 x-hidden pt5 pb5" role="alert"></div>
            <!-- error -->
            <div class="FormFile__upload-progress">
                <div class="FormFile__upload-progress-bar" style="width:0;"></div>
            </div>
        </div>
    </script>
    <!-- Form File -->

    {/strip}

    <!-- x-uploader -->
    <script id="x-uploader" type="text/template">
        <form class="x-uploader" action="{literal}{{url}}{/literal}" method="post" enctype="multipart/form-data">
            {literal}{{#multiple}}{/literal}
            <input name="file[]" type="file" multiple="multiple">
            {literal}{{/multiple}}{/literal}
            {literal}{{^multiple}}{/literal}
            <input name="file" type="file">
            {literal}{{/multiple}}{/literal}
            <input type="hidden" name="secret" value="{literal}{{secret}}{/literal}">
        </form>
    </script>
    <!-- x-uploader -->

    <!-- Publisher -->
    <script id="publisher-attachments-item" type="text/template">
        <li class="item deletable" data-handle="{literal}{{handle}}{/literal}" data-id="{literal}{{id}}{/literal}">
            <div class="item-image" style="background-image:url('{literal}{{image_path}}{/literal}');"></div>
            <button type="button" class="close js_publisher-attachment-remover" title="Remove"><span>&times;</span></button>
        </li>
    </script>
    <!-- Publisher -->

{/if}