{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20"> 

            {if $sub_view == "unrequested" && ( ($user.is_writer || $user.is_editor) || ($user.is_sub_admin && $order_manager_enabled))}
                <div class="pull-right flip">
                    <button type="button" data-toggle="popover" data-html="true" data-trigger="hover" data-placement="bottom" data-content="You can request payment on these dates - <strong>{$payment_dates}</strong>" class="btn {if $can_request_payment}btn-success js_request-payment{else}btn-default disabled{/if}">
                        <i class="fa fa-check-circle"></i> Request Payment
                    </button>
                </div>
            {/if}

            <i class="fa fa-money-bill-alt mr10"></i> <strong>Financial overview</strong> 
        </div>
        <ul class="nav nav-tabs">
            <li {if $sub_view == "unrequested"}class="active"{/if}>
                <a href="{$base_uri}/financial-overview/unrequested" data-ajax="/financial-overview/unrequested"> 
                    {if $sub_view == "unrequested"}<strong class="pr5">Unrequested</strong>{else}Unrequested{/if} 
                </a>
            </li>
            <li {if $sub_view == "requested"}class="active"{/if}> 
                <a href="{$base_uri}/financial-overview/requested" data-ajax="/financial-overview/requested">
                    {if $sub_view == "requested"}<strong class="pr5">Payment Requests</strong>{else}Payment Requests{/if} 
                </a> 
            </li>
            <li {if $sub_view == "history"}class="active"{/if}> 
                <a href="{$base_uri}/financial-overview/history" data-ajax="/financial-overview/history">
                    {if $sub_view == "history"}<strong class="pr5">Payment History</strong>{else}Payment History{/if} 
                </a> 
            </li>
            {hook h='displayFinancialOverviewNavbar'}
        </ul>
    </div>

    {if $sub_view == "unrequested"}

        <div class="card-body">
            {if count($orders) > 0}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <th>DATE</th>
                                <th>ORDER</th>
                                <th>TRANSACTION TYPE</th>
                                <th>COMMENTS</th>
                                <th>AMOUNT</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $orders as $order}
                                <tr>
                                    <td>
                                        {if $order.status == "10"}
                                            <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                                        {elseif $order.status == "11"}
                                            <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                                        {/if}
                                    </td>
                                    <td>
                                        <strong><a target="_blank" href="{$base_uri}/order/{$order.id}">#{$order.referenceId}</a></strong>
                                    </td>
                                    <td>
                                        {if $order.status == "10"}
                                            <strong>Approved</strong>
                                        {elseif $order.status == "11"}
                                            <strong>Completed</strong> 
                                        {/if} 
                                        {" - "}
                                        {if $order.isProgramming || $order.isCalculations}
                                            {$order.serviceTypeTitle}
                                        {elseif $order.isArticleWriting}
                                            {pluralize('word', $order.words)}
                                        {else}
                                            {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                                            {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                                            {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                                            {if $order.excelSheets} {pluralize('excel sheet', $order.excelSheets)} {/if} 
                                        {/if}
                                    </td>
                                    {if $order.isProgramming || $order.isCalculations}
                                        <td>{$order.topicCategory}</td>
                                    {elseif $order.isArticleWriting}
                                        <td>{$order.disciplineTitle}</td>
                                    {else}
                                        <td>{$order.topicCategory}</td>
                                    {/if}
                                    <td class="text-right">
                                        {if $user.is_sub_admin}
                                            <strong class="text-success">+ {$order.orderManagerPayFormatted}</strong>
                                        {elseif $user.is_writer}
                                            <strong class="text-success">+ {$order.writerPayFormatted}</strong>
                                        {elseif $user.is_editor}
                                            <strong class="text-success">+ {$order.editorPayFormatted}</strong>
                                        {else}
                                            <strong class="text-danger">+ $0.00</strong>
                                        {/if}
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                        <tfoot>
                            {if $pay_delivered_orders}
                                <tr style="display: table-row;">
                                    <th class="text-right" align="right" colspan="4">Completed orders:</th>
                                    <td class="text-right">
                                        <strong class="text-success">+ {formatPrice($done_orders_pay)}</strong>
                                    </td>
                                </tr>
                            {/if}
                            <tr style="display: table-row;">
                                <th class="text-right" align="right" colspan="4">Approved orders:</th>
                                <td class="text-right">
                                    <strong class="text-success">+ {formatPrice($completed_orders_pay)}</strong>
                                </td>
                            </tr>
                            {if $has_employee_credit || $has_employee_fine}
                                <tr style="display: table-row;">
                                    <th class="text-right" align="right" colspan="4">Sub Total:</th>
                                    <td class="text-right">
                                        <strong class="text-success">+ {formatPrice($subtotal_pay)}</strong>
                                    </td>
                                </tr>
                            {/if}
                            {if $has_employee_credit}
                                <tr style="display: table-row;">
                                    <th class="text-right" align="right" colspan="4">Credit:</th>
                                    <td class="text-right">
                                        <strong class="text-warning">+ {formatPrice($employee_credit)}</strong>
                                    </td>
                                </tr>
                            {/if}
                            {if $has_employee_fine}
                                <tr style="display: table-row;">
                                    <th class="text-right" align="right" colspan="4">Fine:</th>
                                    <td class="text-right">
                                        <strong class="text-danger">- {formatPrice($employee_fine)}</strong>
                                    </td>
                                </tr>
                            {/if}
                            <tr style="display: table-row;">
                                <th class="text-right" align="right" colspan="4">Total:</th>
                                <td class="text-right">
                                    <strong class="{if $total_pay < 0}text-danger{else}text-success{/if}">{formatPrice($total_pay)}</strong>
                                </td>
                            </tr>
                        </tfoot>
                        
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>The list is empty.</strong></p>
                </div>
            {/if}
        </div>

    {elseif $sub_view == "requested"}

        <div class="card-body">
            {if count($requests) > 0}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                            
                                <th>DATE</th>
                                <th>DONE ORDERS</th>
                                <th>APPROVED ORDERS</th>
                                <th>TOTAL</th>
                                <th>ORDERS</th>
                                <th>STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $requests as $request}
                                <tr>
                                    <td>
                                        <span class="js_moment" data-time="{$request.date_add}">{$request.date_add}</span>
                                    </td>
                                    <td class="text-right">
                                        <strong class="text-success">{formatPrice($request.total_done_pay)}</strong>
                                    <td class="text-right">
                                        <strong class="text-success">{formatPrice($request.total_completed_pay)}</strong>
                                    </td>
                                    <td class="text-right">
                                        <strong class="text-success">{formatPrice($request.total_pay)}</strong>
                                    </td>
                                    <td>
                                        {if $request.status == "-1"}
                                            <span>N/A</span>
                                        {else}
                                            <span class="text-link" data-toggle="modal" data-size="medium" data-url="/user/payment-requests/{$request.payment_request_id}">Show</span>
                                        {/if}
                                    </td>
                                    <td>
                                        {if $request.status == "0"}
                                            <span class="label label-warning">Pending</span>
                                        {elseif $request.status == "1"}
                                            <span class="label label-success">Paid</span>
                                        {elseif $request.status == "-1"}
                                            <span class="label label-danger">Declined</span>
                                        {/if}
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>The list is empty.</strong></p>
                </div>
            {/if}
        </div>

    {elseif $sub_view == "history"}

        <div class="card-body">
            {if count($requests) > 0}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                            
                                <th>PAID AT</th>
                                <th>DONE ORDERS</th>
                                <th>APPROVED ORDERS</th>
                                <th>TOTAL</th>
                                <th>ORDERS</th>
                                <th>STATUS</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $requests as $request}
                                <tr class="{if $request.status == "-1"}danger{/if}">
                                    <td>
                                        {if $request.status == "-1"} 
                                            <strong class="text-danger">Declined</strong>
                                        {else} 
                                            <span class="js_moment" data-time="{$request.paid_at}">{$request.paid_at}</span> 
                                        {/if}
                                    </td>
                                    <td class="text-right">
                                        <strong class="{if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_done_pay)}</strong>
                                    <td class="text-right">
                                        <strong class="{if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_completed_pay)}</strong>
                                    </td>
                                    <td class="text-right">
                                        <strong class="{if $request.status == "-1"}text-danger{else}text-success{/if}">{formatPrice($request.total_pay)}</strong>
                                    </td>
                                    <td>
                                        <span class="text-link" data-toggle="modal" data-url="/user/payment-requests/{$request.payment_request_id}">Show</span>
                                    </td>
                                    <td>
                                        {if $request.status == "0"}
                                            <span class="label label-warning">Pending</span>
                                        {elseif $request.status == "1"}
                                            <span class="label label-success">Paid</span>
                                        {elseif $request.status == "-1"}
                                            <span class="label label-danger">Declined</span>
                                        {/if}
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>The list is empty.</strong></p>
                </div>
            {/if}
        </div>
        
    {else}
        {hook h='displayFinancialOverviewNavContent'}
    {/if}
</div>
{/block}