<div class="card-body row">
    <form class="js_ajax-forms col-md-9" data-url="/admin/mailing?do=send_mail" autocomplete="off">
        <div class="form-group form-row">
            <label class="col-sm-2 control-label text-left">
                Subject
            </label>
            <div class="col-sm-10">  
                <input class="form-control" type="text" name="subject">
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-2 control-label text-left">
                Message
            </label>
            <div class="col-sm-10">  
                <textarea class="form-control js_summernote" rows="10" name="message"></textarea>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-2 control-label text-left">
                Send to
            </label>
            <div class="col-sm-10">
                <select class="form-control" name="recipient" data-combo="recipient">
                    <option value="1">Select from customers</option>
                    <option value="2">Select from writers</option>
                    <option value="7">Select from sites</option>
                    <option value="3">Select from mailing list</option>
                    <option value="4">All customers</option>
                    <option value="5">All writers</option>
                    <option value="6">All mailing list</option>
                </select>
            </div>
        </div>

        <div id="recipient">
            <div class="switch-combo" data-combo-value="1">
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Customer</label>
                    <div class="col-sm-10">
                        <select class="form-control select_search" name="customer_ids[]" multiple="">
                            {foreach from=$customers item=$site_customers key=$site_name}
                                <optgroup label="{$site_name}">
                                    {foreach $site_customers as $customer}
                                        <option value="{$customer.id}">{$customer.id} - {$customer.name}</option>
                                    {/foreach}
                                </optgroup>
                            {/foreach}
                        </select>
                    </div>
                </div>
            </div>

            <div class="x-hidden switch-combo" data-combo-value="2">
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Writer</label>
                    <div class="col-sm-10">
                        <select class="form-control select_search" name="writer_ids[]" multiple="">
                            {foreach $writers as $writer}
                                <option value="{$writer.employee_id}">{$writer.employee_id} - {$writer.first_name} {$writer.last_name}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>
            </div>

            <div class="x-hidden switch-combo" data-combo-value="3">
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Mail list</label>
                    <div class="col-sm-10">
                        <select class="form-control select_search" name="mail_ids[]" multiple="">
                            {foreach $mailing_list as $mail}
                                <option value="{$mail.mail_id}">{$mail.name} - {$mail.email}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>
            </div>

            <div class="x-hidden switch-combo" data-combo-value="7">
                <div class="form-group form-row">
                    <label class="col-sm-2 control-label text-left">Select Site</label>
                    <div class="col-sm-10">
                        <select class="form-control select_search" name="site_ids[]" multiple="">
                            {foreach $mail_sites as $mail_site}
                                <option value="{$mail_site.site_id}">{$mail_site.name}</option>
                            {/foreach}
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-2 control-label">Test email</label>
            <div class="col-sm-10">
                <label class="switch" for="test_email">
                    <input type="checkbox" name="test_email" id="test_email">
                    <span class="slider round"></span>
                </label>
                <span class="help-block">The message will be sent to Website Email only</span>
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-10 col-sm-offset-2">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Send Mail</button>
            </div>
        </div>
    </form>
</div>