<div class="card-body">
    {if $_tab == "templates"}
        <div class="heading-small mb20">Orders</div>
        {if count($orderTemplates)}
            <div class="table-responsive">
                <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <td width="80%">Template Name</td>
                            <td>Actions</td>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $orderTemplates as $template}
                            <tr>
                                <td>
                                    <a href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">{$template.name}</a>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$template.mail_template_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$template.mail_template_id}">
                                            <a class="dropdown-item" href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">
                                                <i class="fa fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="mail_template" data-id="{$template.mail_template_id}">
                                                <i class="fa fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                <p class="mb10"><strong>No order templates to show</strong></p>
            </div>
        {/if}

        <div class="heading-small mb20">Customers</div>
        {if count($customerTemplates)}
            <div class="table-responsive">
                <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <td width="80%">Template Name</td>
                            <td>Actions</td>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $customerTemplates as $template}
                            <tr>
                                <td>
                                    <a href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">{$template.name}</a>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$template.mail_template_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$template.mail_template_id}">
                                            <a class="dropdown-item" href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">
                                                <i class="fa fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="mail_template" data-id="{$template.mail_template_id}">
                                                <i class="fa fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                <p class="mb10"><strong>No customer templates to show</strong></p>
            </div>
        {/if}

        <div class="heading-small mb20">Employees</div>
        {if count($employeeTemplates)}
            <div class="table-responsive">
                <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <td width="80%">Template Name</td>
                            <td>Actions</td>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $employeeTemplates as $template}
                            <tr>
                                <td>
                                    <a href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">{$template.name}</a>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$template.mail_template_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Actions
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$template.mail_template_id}">
                                            <a class="dropdown-item" href="{$base_uri}/mailing/templates/edit?template={$template.template}" data-ajax="/mailing/templates/edit?template={$template.template}">
                                                <i class="fa fa-pencil-alt mr5"></i> Edit
                                            </a>
                                            <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="mail_template" data-id="{$template.mail_template_id}">
                                                <i class="fa fa-trash mr5"></i> Delete
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                <p class="mb10"><strong>No employee templates to show</strong></p>
            </div>
        {/if}
    {elseif $_tab == "add"}
        <form class="js_ajax-forms row" data-url="/admin/mailing?do=add_template" autocomplete="off">
            <div class="col-md-7">
                <div class="form-group">
                    <label class="control-label text-left mb10">Template</label>
                    <select class="form-control" name="template">
                        <optgroup label="Orders"> 
                            <option value="order_payment" {if isset($emailTemplates['order_payment'])}disabled{/if}>Successful Order Payment (Sent to Customer)</option>
                            <option value="new_order_available" {if isset($emailTemplates['new_order_available'])}disabled{/if}>New Order Available (Sent to Support &amp; Writers)</option>
                            <option value="order_files" {if isset($emailTemplates['order_files'])}disabled{/if}>Order Files Uploaded (Sent to Support &amp; Writers)</option>
                            <option value="order_assign" {if isset($emailTemplates['order_assign'])}disabled{/if}>New Order Assigned (Sent to Writers &amp; Editors)</option>
                            <option value="writer_submitted_order" {if isset($emailTemplates['writer_submitted_order'])}disabled{/if}>Writer Submitted Order (Sent to Support)</option>
                            <option value="editor_new_order" {if isset($emailTemplates['editor_new_order'])}disabled{/if}>New Order Available (Sent to Editor)</option>
                            <option value="order_complete" {if isset($emailTemplates['order_complete'])}disabled{/if}>Order Complete (Sent to Customer)</option>
                            <option value="order_status_change" {if isset($emailTemplates['order_status_change'])}disabled{/if}>Order Status Changed (Sent to Customer)</option>
                            <option value="order_revision_request" {if isset($emailTemplates['order_revision_request'])}disabled{/if}>Order Revision Request (Sent to Support)</option>
                            <option value="order_message" {if isset($emailTemplates['order_message'])}disabled{/if}>New Message (Sent to Customer &amp; Writers)</option>
                            <option value="feedback_reply" {if isset($emailTemplates['feedback_reply'])}disabled{/if}>Feedback Reply  (Sent to Customer)</option>
                            <option value="pay_order_reminder" {if isset($emailTemplates['pay_order_reminder'])}disabled{/if}>Pay Order Reminder (Sent to Customer)</option>
                            <option value="order_file_delete" {if isset($emailTemplates['order_file_delete'])}disabled{/if}>Order File Delete Request (Sent to Support)</option>
                            <option value="order_refund_request" {if isset($emailTemplates['order_refund_request'])}disabled{/if}>Order Refund Request (Sent to Support)</option>
                        </optgroup>
                        <optgroup label="Employees">
                            <option value="employee_password_change" {if isset($emailTemplates['employee_password_change'])}disabled{/if}>Password Reset - Confirmation</option>
                            <option value="employee_two_factor_email" {if isset($emailTemplates['employee_two_factor_email'])}disabled{/if}>Two Factor Authentication</option>
                        </optgroup>
                        <optgroup label="Customers">
                            <option value="customer_password_change" {if isset($emailTemplates['customer_password_change'])}disabled{/if}>Password Reset - Confirmation</option>
                        </optgroup>
                    </select>
                </div>

                <div class="form-group">
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->

                    <button type="submit" class="btn btn-primary">Add Template</button>
                </div>
            </div>
        </form>
    {elseif $_tab == "edit"}
        <form class="js_ajax-forms row" data-url="/admin/mailing?do=edit_template" autocomplete="off">
            <input type="hidden" name="template_id" value="{$mailTemplate.id}">
            <div class="col-md-7">
                <div class="form-group">
                    <label class="control-label text-left mb10">Template Title</label>
                    <input class="form-control" type="text" name="name" value="{$mailTemplate.name}" disabled="">
                </div>

                <div class="form-group">
                    <label class="control-label text-left mb10">Subject</label>
                    <input class="form-control" type="text" name="subject" value="{$mailTemplate.subject}" required="">
                </div>

                <div class="form-group">
                    <label class="control-label text-left mb10">From Name</label>
                    <input class="form-control" type="text" name="from_name" value="{$mailTemplate.from_name}" required="">
                </div>

                <div class="custom-control custom-checkbox mb10">
                    <input type="checkbox" class="custom-control-input" name="plaintext" id="plaintext" {if $mailTemplate.plaintext == '1'}checked{/if}>
                    <label for="plaintext" class="custom-control-label">Send as Plaintext</label>
                </div>

                <div class="custom-control custom-checkbox mb10">
                    <input type="checkbox" class="custom-control-input" name="is_disabled" id="is_disabled" {if $mailTemplate.is_disabled == '1'}checked{/if}>
                    <label for="is_disabled" class="custom-control-label">Disabled</label>
                </div>

                <div class="form-group">
                    <label class="control-label text-left mb10">Email message</label>
                    <textarea class="form-control js_summernote" rows="10" name="message">{$mailTemplate.message nofilter}</textarea>
                </div>

                <div class="form-group">
                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->

                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </div>
            <div class="col-md-5">
                <div class="heading-small mb20">Available merge fields</div>
                {if $mailTemplate.template == 'order_payment' || 
                    $mailTemplate.template == 'order_files'
                }
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Customer</h5>
                            <p>Customer Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}

                {elseif $mailTemplate.template == 'writer_submitted_order' || 
                        $mailTemplate.template == 'order_complete'
                }
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'order_status_change'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Customer</h5>
                            <p>Customer Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'order_assign'}
                {elseif $mailTemplate.template == 'editor_new_order'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Employee</h5>
                            <p>Employee Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'new_order_available'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'order_file_delete'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">File</h5>
                            <p>File ID<span class="pull-right text-link">{file_id}</span></p>
                            <p>File Name<span class="pull-right text-link">{file_name}</span></p>
                            <p>File Size<span class="pull-right text-link">{file_size}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'feedback_reply'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Feedback</h5>
                            <p>Customer Feedback<span class="pull-right text-link">{username}</span></p>
                            <p>Support Reply<span class="pull-right text-link">{support_reply}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Customer</h5>
                            <p>Customer Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'writer_submitted_order'}
                {elseif $mailTemplate.template == 'pay_order_reminder'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Customer</h5>
                            <p>Customer Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'order_refund_request'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Refund</h5>
                            <p>Content<span class="pull-right text-link">{content}</span></p>
                            <p>Sources<span class="pull-right text-link">{sources}</span></p>
                            <p>Format<span class="pull-right text-link">{format}</span></p>
                            <p>Grammar<span class="pull-right text-link">{grammar}</span></p>
                            <p>Instructions<span class="pull-right text-link">{instructions}</span></p>
                            <p>Other<span class="pull-right text-link">{other}</span></p>
                            <p>Message Body<span class="pull-right text-link">{message_body}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'order_revision_request'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                            <p>Order Title<span class="pull-right text-link">{order_title}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Revision</h5>
                            <p>Sources<span class="pull-right text-link">{sources}</span></p>
                            <p>Format<span class="pull-right text-link">{format}</span></p>
                            <p>Grammar<span class="pull-right text-link">{grammar}</span></p>
                            <p>Instructions<span class="pull-right text-link">{instructions}</span></p>
                            <p>Customize Content<span class="pull-right text-link">{customize_content}</span></p>
                            <p>Other<span class="pull-right text-link">{other}</span></p>
                            <p>Message Body<span class="pull-right text-link">{message_body}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'order_message'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Message</h5>
                            <p>Subject<span class="pull-right text-link">{subject}</span></p>
                            <p>Username<span class="pull-right text-link">{username}</span></p>
                            <p>Text Message<span class="pull-right text-link">{text_message}</span></p>
                            <p>HTML Message<span class="pull-right text-link">{message}</span></p>
                            <p>Receiver Department<span class="pull-right text-link">{to_department}</span></p>
                            <p>Sender Department<span class="pull-right text-link">{from_department}</span></p>
                        </div> 

                        <div class="mb10">
                            <h5 class="fw-bold">Order</h5>
                            <p>Order ID<span class="pull-right text-link">{order_id}</span></p>
                            <p>Order Link<span class="pull-right text-link">{order_url}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'employee_password_change'}
                {elseif $mailTemplate.template == 'customer_password_change'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Reset Link</h5>
                            <p>Password Reset Link<span class="pull-right text-link">{reset_url}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Employee</h5>
                            <p>Employee Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}
                {elseif $mailTemplate.template == 'employee_two_factor_email'}
                    {literal}
                        <div class="mb10">
                            <h5 class="fw-bold">Two Factor</h5>
                            <p>Two Factor Key<span class="pull-right text-link">{two_factor_key}</span></p>
                        </div>

                        <div class="mb10">
                            <h5 class="fw-bold">Employee</h5>
                            <p>Employee Name<span class="pull-right text-link">{username}</span></p>
                        </div>
                    {/literal}
                {/if}
                {literal}
                    <div class="mb10">
                        <h5 class="fw-bold">Website</h5>
                        <p>Site Name<span class="pull-right text-link">{site_name}</span></p>
                    </div>
                {/literal}
            </div>
        </form>
    {/if}
</div>