{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon with-nav">
            <div class="mb20">
                <i class="fa fa-globe mr10"></i>
                <strong>My Sites</strong>
                &rsaquo; <strong>{$site.name}</strong>

                <div class="pull-right flip">
                    <a href="{$base_uri}/my-sites/{$site.id}/deadlines" data-ajax="/my-sites/{$site.id}/deadlines" class="btn btn-success mr5">
                        <i class="fas fa-calendar-alt mr5"></i> Deadlines
                    </a>
                    
                    <a href="{$base_uri}/my-sites/{$site.id}/preferences" data-ajax="/my-sites/{$site.id}/preferences" class="btn btn-primary">
                        {include file='__svg_icons.tpl' icon="preferences" class="mr5" width="16px" height="16px"} Preferences
                    </a>
                </div>
            </div>

            <!-- tabs nav -->
            <ul class="nav nav-tabs admin">
                <li class="nav-item">
                    <a class="nav-link active" href="#general" data-toggle="tab">
                        <i class="fa fa-server fa-fw mr5"></i><strong class="pr5">General</strong>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="#email" data-toggle="tab">
                        <i class="fa fa-envelope fa-fw mr5"></i><strong class="pr5">Email</strong>
                    </a>
                </li> 

                <li class="nav-item">
                    <a class="nav-link" href="#payment-methods" data-toggle="tab">
                        <i class="fas fa-credit-card fa-fw mr5"></i><strong class="pr5">Payment Methods</strong>
                    </a> 
                </li> 

                {hook h='displayAdminEditSiteNavbar'}
                
            </ul>
            <!-- tabs nav -->
        </div>

        <div class="card-body">
            <!-- tabs content -->
            <div class="tab-content">

                <!-- General -->
                <div class="tab-pane active" id="general">
                    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/sites?do=general_settings">
                        <input type="hidden" name="site_id" value="{$site.id}"/>
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Site ID
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="site_id" id="site_id" value="{$site.id}" disabled="">
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Site Name
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="site_name" id="site_name" value="{$site.name}" maxlength="255">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Site Email
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="site_email" id="site_email" value="{$site.email}" maxlength="255">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Site URL
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control" type="text" name="site_domain" id="site_domain" value="{$site.domain}" maxlength="255">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Default Academic Level
                            </label>
                            <div class="col-sm-9">
                                <select class="form-control" name="default_course_level">
                                    <option value="1" {if $formValues.DEFAULT_COURSELEVEL == 1}selected=""{/if}>High school</option>
                                    <option value="2" {if $formValues.DEFAULT_COURSELEVEL == 2}selected=""{/if}>Undergrad. (yrs 1-2)</option>
                                    <option value="3" {if $formValues.DEFAULT_COURSELEVEL == 3}selected=""{/if}>Undergrad. (yrs 3-4)</option>
                                    <option value="4" {if $formValues.DEFAULT_COURSELEVEL == 4}selected=""{/if}>Master's</option>
                                    <option value="5" {if $formValues.DEFAULT_COURSELEVEL == 5}selected=""{/if}>PhD</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Urgent Max Pages
                            </label>
                            <div class="col-sm-9">
                                <input class="form-control force-integer" type="text" name="urgent_deadline_max_pages" id="urgent_deadline_max_pages" maxlength="255" value="{$formValues.URGENT_DEADLINE_MAX_PAGES}">
                                <span class="help-block">
                                    The maximum number of pages that can be ordered for an urgent deadline
                                </span>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Default Deadline
                            </label>
                            <div class="col-sm-9">
                                <select class="form-control select_search" name="default_deadlines[]" multiple>
                                    {foreach $tariffs as $tariff}
                                        <optgroup label="{$tariff.title}">
                                            {foreach $tariff.deadlines as $deadline}
                                                <option value="{$deadline.id}" {if $deadline.selected}selected=""{/if}>{$deadline.name} - {$tariff.title}</option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                                <span class="help-block">
                                    The order form and calculator default deadline. Select one deadline for each academic level
                                </span>
                            </div>
                        </div>

                        {if count($currencies)}
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label text-left">
                                    Default Currency
                                </label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="default_currency">
                                        {foreach $currencies as $currency}
                                            <option value="{$currency.currency_id}" {if $formValues.CURRENCY_DEFAULT == $currency.currency_id}selected=""{/if}>{$currency.title}</option>
                                        {/foreach}
                                    </select>
                                    <div class="form-text">
                                        You can add, edit or delete currencies from <a href="{$base_uri}/system/currency" data-ajax="/system/currency">Currencies</a> 
                                    </div>
                                </div>
                            </div>
                        {/if}

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Deadline CPP Percentage</label>
                            <div class="col-sm-9">
                                <input class="form-control force-integer" type="text" name="cpp_percentage" id="cpp_percentage" value="{$formValues.CPP_PERCENTAGE}">
                                <span class="help-block">
                                    Increase or decrease the customer cpp by a percentage. Default value is <strong>100</strong> of the deadlines cpp.
                                </span>
                            </div>
                        </div>

                        <div class="divider"></div>

                        <div class="form-table-row"> 
                            <div> 
                                <div class="form-control-label h5">Require Name</div> 
                                <div class="form-text">Require customer to enter name on signup</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="requireName"> 
                                    <input type="checkbox" name="requireName" id="requireName" {if $formValues.AUTH_REQUIRE_NAME == '1'}checked{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>

                        <div class="form-table-row"> 
                            <div> 
                                <div class="form-control-label h5">Require Phone</div> 
                                <div class="form-text">Require customer to enter phone on signup</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="requirePhone"> 
                                    <input type="checkbox" name="requirePhone" id="requirePhone" {if $formValues.AUTH_REQUIRE_PHONE == '1'}checked{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>

                        <div class="form-table-row"> 
                            <div> 
                                <div class="form-control-label h5">Sign up Default Screen</div> 
                                <div class="form-text">Enable if you want to make the Signup Form as the default auth screen</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="signupDefault"> 
                                    <input type="checkbox" name="signupDefault" id="signupDefault" {if $formValues.SIGNUP_DEFAULT == '1'}checked{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>

                        <div class="form-table-row"> 
                            <div> 
                                <div class="form-control-label h5">UK Form</div> 
                                <div class="form-text">Enable Desirable grade in the order form</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="ukForm"> 
                                    <input type="checkbox" name="ukForm" id="ukForm" {if $formValues.UK_FORM == '1'}checked{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>

                        <div class="form-table-row"> 
                            <div> 
                                <div class="form-control-label h5">Shared Authentication</div> 
                                <div class="form-text">Enable to allow customers from any of your sites to login via this website</div> 
                            </div> 
                            <div class="text-right"> 
                                <label class="switch" for="shareCustomers"> 
                                    <input type="checkbox" name="shareCustomers" id="shareCustomers" {if $formValues.SHARED_AUTH == '1'}checked{/if}> 
                                    <span class="slider round"></span> 
                                </label> 
                            </div> 
                        </div>

                        {if $is_articlewriting_enabled || $is_calculations_enabled || $is_programming_enabled}
                            <div class="divider"></div>
                            <div class="heading-small mb20">Order Forms</div>

                            <div class="form-table-row"> 
                                <div class="icon"> 
                                    {include file='__svg_icons.tpl' icon="academic" class="mr5" width="40px" height="40px"}
                                </div>
                                <div> 
                                    <div class="form-control-label h5">Academic Writing</div> 
                                    <div class="form-text">Enable and disable academic writing order form</div> 
                                </div> 
                                <div class="text-right"> 
                                    <label class="switch" for="academicwriting_enabled"> 
                                        <input type="checkbox" name="academicwriting_enabled" id="academicwriting_enabled" {if $formValues.ACADEMIC_WRITING_ENABLED == '1'}checked{/if}> 
                                        <span class="slider round"></span> 
                                    </label> 
                                </div> 
                            </div>

                            {if $is_articlewriting_enabled}
                                <div class="form-table-row"> 
                                    <div class="icon"> 
                                        {include file='__svg_icons.tpl' icon="article" class="mr5" width="40px" height="40px"}
                                    </div>
                                    <div> 
                                        <div class="form-control-label h5">Article Writing</div> 
                                        <div class="form-text">Enable and disable article writing order form</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <label class="switch" for="articlewriting_enabled"> 
                                            <input type="checkbox" name="articlewriting_enabled" id="articlewriting_enabled" {if $formValues.ARTICLE_WRITING_ENABLED == '1'}checked{/if}> 
                                            <span class="slider round"></span> 
                                        </label> 
                                    </div> 
                                </div>
                            {/if}

                            {if $is_calculations_enabled}
                                <div class="form-table-row"> 
                                    <div class="icon"> 
                                        {include file='__svg_icons.tpl' icon="calculations" class="mr5" width="40px" height="40px"}
                                    </div>
                                    <div> 
                                        <div class="form-control-label h5">Calculations</div> 
                                        <div class="form-text">Enable and disable calculations order form</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <label class="switch" for="calculations_enabled"> 
                                            <input type="checkbox" name="calculations_enabled" id="calculations_enabled" {if $formValues.CALCULATIONS_ENABLED == '1'}checked{/if}> 
                                            <span class="slider round"></span> 
                                        </label> 
                                    </div> 
                                </div>
                            {/if} 

                            {if $is_programming_enabled}
                                <div class="form-table-row"> 
                                    <div class="icon"> 
                                        {include file='__svg_icons.tpl' icon="programming" class="mr5" width="40px" height="40px"}
                                    </div>
                                    <div> 
                                        <div class="form-control-label h5">Programming</div> 
                                        <div class="form-text">Enable and disable programming order form</div> 
                                    </div> 
                                    <div class="text-right"> 
                                        <label class="switch" for="programming_enabled"> 
                                            <input type="checkbox" name="programming_enabled" id="programming_enabled" {if $formValues.PROGRAMMING_ENABLED == '1'}checked{/if}> 
                                            <span class="slider round"></span> 
                                        </label> 
                                    </div> 
                                </div>
                            {/if}

                            <div class="form-group">
                                <label class="form-label mb10">Default Order Form</label>
                                <div class="">
                                    <div class="form-selectgroup">
                                        <label class="form-selectgroup-item" for="default_service_type_academic">
                                            <input id="default_service_type_academic" type="radio" name="default_service_type" value="37" class="form-selectgroup-input" {if $formValues.DEFAULT_SERVICE_TYPE_ID == '37'}checked{/if}>
                                            <span class="form-selectgroup-label">
                                                <i class="icon">
                                                    {include file='__svg_icons.tpl' icon="academic" class="mr5" width="25px" height="25px"}
                                                </i>    
                                                <span class="text middle">Academic Writing</span> 
                                            </span>
                                        </label>

                                        {if $is_articlewriting_enabled}
                                            <label class="form-selectgroup-item" for="default_service_type_article">
                                                <input id="default_service_type_article"  type="radio" name="default_service_type" value="52" class="form-selectgroup-input" {if $formValues.DEFAULT_SERVICE_TYPE_ID == '52'}checked{/if}>
                                                <span class="form-selectgroup-label">
                                                    <i class="icon">
                                                        {include file='__svg_icons.tpl' icon="article" class="mr5" width="25px" height="25px"}
                                                    </i>    
                                                    <span class="text middle">Article Writing</span>
                                                </span>
                                            </label>
                                        {/if}

                                        {if $is_calculations_enabled}
                                            <label class="form-selectgroup-item" for="default_service_type_calculations">
                                                <input id="default_service_type_calculations" type="radio" name="default_service_type" value="50" class="form-selectgroup-input" {if $formValues.DEFAULT_SERVICE_TYPE_ID == '50'}checked{/if}>
                                                <span class="form-selectgroup-label">
                                                    <i class="icon">
                                                        {include file='__svg_icons.tpl' icon="calculations" class="mr5" width="25px" height="25px"}
                                                    </i>    
                                                    <span class="text middle">Calculations</span>
                                                </span>
                                            </label>
                                        {/if}
                                        
                                        {if $is_programming_enabled}
                                            <label class="form-selectgroup-item" for="default_service_type_programming">
                                                <input id="default_service_type_programming" type="radio" name="default_service_type" value="51" class="form-selectgroup-input" {if $formValues.DEFAULT_SERVICE_TYPE_ID == '51'}checked{/if}>
                                                <span class="form-selectgroup-label">
                                                    <i class="icon">
                                                        {include file='__svg_icons.tpl' icon="programming" class="mr5" width="25px" height="25px"}
                                                    </i>    
                                                    <span class="text middle">Programming</span>
                                                </span>
                                            </label>
                                        {/if}
                                    </div>
                                </div>
                            </div>

                            <div class="divider"></div>
                        {/if}

                        <div class="heading-small mb20">Tawk.to</div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Tawk.To Chat Code</label>
                            <div class="col-sm-9">
                                <textarea class="form-control" name="tawkChatCode" rows="3" spellcheck="false">{$formValues.TAWK_CHAT_CODE}</textarea>
                            </div>
                        </div>

                        <div class="divider"></div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Website Logo</label>
                            <div class="col-sm-9">
                                {if $formValues.SITE_BRAND_LOGO == ''}
                                    <div class="x-image">
                                        <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                            <span>×</span>
                                        </button>
                                        <div class="loader loader_small x-hidden"></div>
                                        <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                        <input type="hidden" class="js_x-image-input" name="site_brand_logo" value="">
                                    </div>
                                {else}
                                    <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_BRAND_LOGO}')">
                                        <button type="button" class="close js_x-image-remover" title='Remove'>
                                            <span>×</span>
                                        </button>
                                        <div class="loader loader_small x-hidden"></div>
                                        <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                        <input type="hidden" class="js_x-image-input" name="site_brand_logo" value="{$formValues.SITE_BRAND_LOGO}">
                                    </div>
                                {/if}
                                <span class="help-block">
                                    The perfect size for your logo should be (width: 130px & height: 50px)
                                </span>
                            </div>
                        </div>
                        
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Email Logo</label>
                            <div class="col-sm-9">
                                {if $formValues.SITE_EMAIL_LOGO == ''}
                                    <div class="x-image">
                                        <button type="button" class="close x-hidden js_x-image-remover" title='Remove'>
                                            <span>×</span>
                                        </button>
                                        <div class="loader loader_small x-hidden"></div>
                                        <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                        <input type="hidden" class="js_x-image-input" name="site_email_logo" value="">
                                    </div>
                                {else}
                                    <div class="x-image" style="background-image: url('{$uploads_path}/{$formValues.SITE_EMAIL_LOGO}')">
                                        <button type="button" class="close js_x-image-remover" title='Remove'>
                                            <span>×</span>
                                        </button>
                                        <div class="loader loader_small x-hidden"></div>
                                        <i class="fa fa-camera fa-lg js_x-uploader" data-handle="x-image"></i>
                                        <input type="hidden" class="js_x-image-input" name="site_email_logo" value="{$formValues.SITE_EMAIL_LOGO}">
                                    </div>
                                {/if}
                                <span class="help-block">
                                    The perfect size for your logo should be (width: 130px & height: 50px)
                                </span>
                            </div>
                        </div>

                        {hook h='displayAdminEditSiteGeneralTabContent'}

                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- success -->
                                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                <!-- success -->

                                <!-- error -->
                                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                <!-- error -->

                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </div>

                    </form>
                </div>
                <!-- General -->

                <!-- Email -->
                <div class="tab-pane" id="email">
                    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/sites?do=email_settings">
                        <input type="hidden" name="site_id" value="{$formValues.SITE_ID}"/>
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">
                                Mail Method
                            </label>
                            <div class="col-sm-9">
                                <div class="radio radio-primary"> 
                                    <input type="radio" name="mail_method" value="1" id="mail_method_1" {if $formValues.MAIL_METHOD == '1'}checked="checked"{/if}> 
                                    <label for="mail_method_1">Use PHP's mail() (recommended)</label> 
                                </div>
                                <div class="radio radio-primary"> 
                                    <input type="radio" name="mail_method" value="2" id="mail_method_2" {if $formValues.MAIL_METHOD == '2'}checked="checked"{/if}> 
                                    <label for="mail_method_2">Set my own SMTP parameters</label> 
                                </div>
                                <div class="radio radio-primary"> 
                                    <input type="radio" name="mail_method" value="3" id="mail_method_3" {if $formValues.MAIL_METHOD == '3'}checked="checked"{/if}> 
                                    <label for="mail_method_3">Never send emails</label> 
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">
                                SMTP server
                            </label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="smtp_server" value="{$formValues.MAIL_SERVER}">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">
                                SMTP username
                            </label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="smtp_username" value="{$formValues.MAIL_USER}">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">
                                SMTP password
                            </label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="smtp_password" value="{$formValues.MAIL_PASSWD}">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">
                                Port
                            </label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="smtp_port" value="{$formValues.MAIL_SMTP_PORT}">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">
                                Encryption
                            </label>
                            <div class="col-sm-9">
                                <div class="form-selectgroup">
                                    <label class="form-selectgroup-item" for="smtp_encryption_off">
                                        <input id="smtp_encryption_off" type="radio" name="smtp_encryption" value="off" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'off'}checked{/if}>
                                        <span class="form-selectgroup-label">
                                            <i class="icon fas fa-unlock fa-lg"></i>    
                                            <span class="text middle">None</span>
                                        </span>
                                    </label>
                                    <label class="form-selectgroup-item" for="smtp_encryption_ssl">
                                        <input id="smtp_encryption_ssl" type="radio" name="smtp_encryption" value="ssl" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'ssl'}checked{/if}>
                                        <span class="form-selectgroup-label">
                                            <i class="icon fab fa-expeditedssl fa-lg"></i>    
                                            <span class="text middle">SSL</span>
                                        </span>
                                    </label>
                                    <label class="form-selectgroup-item" for="smtp_encryption_tls">
                                        <input id="smtp_encryption_tls" type="radio" name="smtp_encryption" value="tls" class="form-selectgroup-input" {if $formValues.MAIL_SMTP_ENCRYPTION == 'tls'}checked{/if}>
                                        <span class="form-selectgroup-label">
                                            <i class="icon fas fa-shield-alt fa-lg"></i>    
                                            <span class="text middle">TLS</span>
                                        </span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-sm-3">
                                <!-- success -->
                                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                <!-- success -->

                                <!-- error -->
                                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                <!-- error -->

                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- Email -->

                <!-- Payment Methods -->
                <div class="tab-pane" id="payment-methods">
                    {if count($paymentMethods)}
                        <div class="row"> 
                            {foreach $paymentMethods as $paymentMethod}
                                <div class="col-md-6 mb10">
                                    <div class="card">
                                        <div class="card-body pt10 pl10 pb10 pr10">
                                            <div class="row align-items-center">
                                                <div class="col-md-3">
                                                    <div class="card-img module_image" style="background-image: url({$paymentMethod.logo});"></div>
                                                </div>
                                                <div class="col-md-9">
                                                    <h4 class="card-title mt0 pt0 mb5">{$paymentMethod.displayName}</h4>
                                                    <p class="card-text">{$paymentMethod.description}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-footer clearfix">
                                            <a href="{$base_uri}/{$paymentMethod.name}/configure?site_id={$formValues.SITE_ID}" data-ajax="/{$paymentMethod.name}/configure?site_id={$formValues.SITE_ID}" class="btn btn-sm btn-success pull-right"><i class="fa fa-cog"></i> Configure</a>
                                        </div>
                                    </div>
                                </div>
                            {/foreach}
                        </div>
                    {else}
                        <div class="text-center x-muted"> 
                            <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                            <p class="mb10"><strong>No payment methods to show</strong></p>
                        </div>
                    {/if}
                </div>
                <!-- Payment Methods -->

                {hook h='displayAdminEditSiteNavContent'}
            </div>

        </div>
    </div>
{/block}