{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-globe mr10"></i>
            <strong>Sites</strong>
            {if $sub_view == "add"} 
                &rsaquo; <strong>Add New</strong>
            {/if}

            <div class="pull-right flip">
                <a href="{$base_uri}/my-sites/add" data-ajax="/my-sites/add" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Add New Site
                </a>
            </div>
        </div>

        <div class="card-body">
            {if $total_sites}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <td>Site ID</td>
                                <td>Site Name</td>
                                <td>URL</td>
                                <td>Orders</td>
                                <td>Customers</td>
                                <td>Payments</td>
                                <td>Actions</td>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $sites as $site}
                                <tr>
                                    <td><a href="{$base_uri}/my-sites/{$site.id}/edit" data-ajax="/my-sites/{$site.id}/edit">#{$site.id}</a></td>
                                    <td><span class="order-subject">{$site.name}</span></td>
                                    <td><span class="order-subject">{$site.domain}</span></td>
                                    <td><span class="green_currency">{toFixed($site.orders, 0)}</span></td>
                                    <td><span class="green_currency">{toFixed($site.customers, 0)}</span></td>
                                    <td><span class="green_currency">{formatPrice($site.payments)}</span></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$site.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$site.id}">
                                                <a class="dropdown-item" href="{$base_uri}/my-sites/{$site.id}/edit" data-ajax="/my-sites/{$site.id}/edit">
                                                    <i class="fa fa-pencil-alt mr5"></i> Edit
                                                </a>
                                                <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="site" data-id="{$site.id}">
                                                    <i class="fa fa-trash-alt mr5"></i> Delete
                                                </a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <i class="fa fa-globe fa-4x"></i>
                    <p class="mb10"><strong>No sites to show</strong></p>
                </div>
            {/if}
        </div>
    </div>
{/block}