<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="academicLevel">Academic Level</label>
    <div class="col-sm-8">
        <select name="academicLevelId" class="form-control js_calculate">
            {foreach $academicLevels as $academicLevel}
                <option value="{$academicLevel.id}" {if $defaultCourseLevelId == $academicLevel.id}selected=""{/if}>{$academicLevel.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="paperTypeId">Type of Paper</label>
    <div class="col-sm-8">
        <select name="paperTypeId" class="form-control select_search js_calculate js_custom-toggle" data-val="64">
            {foreach $paperTypes as $paperType}
                <option value="{$paperType.id}">{$paperType.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group x-hidden form-row">
    <label class="col-sm-2 control-label text-left" for="paperTypeOption">Add Paper Type</label>
    <div class="col-sm-8">
        <input type="text" class="form-control js_calculate" name="paperTypeOption" id="paperTypeOption" maxlength="255">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="topicCatId">Discipline</label>
    <div class="col-sm-8">
        <select name="topicCatId" id="topicCatId" class="form-control select_search js_calculate js_custom-toggle" data-val="52">
            {foreach $academicDisciplineGroups as $topicCat}
                <optgroup label="{$topicCat.title}">
                    {foreach $topicCat.disciplines as $discipline}
                        <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}">{$discipline.title}</option>
                    {/foreach}
                </optgroup>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group x-hidden form-row">
    <label class="col-sm-2 control-label text-left" for="topcatOption">Add Discipline</label>
    <div class="col-sm-8">
        <input type="text" class="form-control js_calculate" name="topcatOption" id="topcatOption" maxlength="255">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="topic">Topic</label>
    <div class="col-sm-8">   
        <input type="text" class="form-control" name="topic" id="topic" value="Writer’s choice" maxlength="255">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="paperDetails">Paper instructions</label>
    <div class="col-sm-8">
        <textarea name="paperDetails" class="form-control js_summernote"></textarea>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="paperFormat">Paper Format</label>
    <div class="col-sm-8">
        <select class="form-control js_calculate js_custom-toggle" name="paperFormat" data-val="4">
            {foreach $paperFormats as $paperFormat}
                <option value="{$paperFormat.paper_format_id}">{$paperFormat.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row x-hidden">
    <label class="col-sm-2 control-label text-left" for="paperFormatOption">Add Paper Format</label>
    <div class="col-sm-8">
        <input class="form-control js_calculate" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Deadline</label>
    <div class="col-sm-8">
        <select name="tariffId" class="form-control js_calculate" data-tariff-control=""></select>
    </div>
</div>

<div class="divider"></div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Spacing</label>
    <div class="col-sm-4">
        <div class="form-selectgroup">
            <label class="form-selectgroup-item" for="double_spaced">
                <input id="double_spaced" type="radio" name="spacing" value="double" class="form-selectgroup-input js_calculate" checked="">
                <span class="form-selectgroup-label">
                    <span class="text middle">Double Spaced</span>
                </span>
            </label>
            <label class="form-selectgroup-item" for="single_spaced">
                <input id="single_spaced" type="radio" name="spacing" value="single" class="form-selectgroup-input js_calculate">
                <span class="form-selectgroup-label">
                    <span class="text middle">Single Spaced</span>
                </span>
            </label>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Pages</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="pages" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="1">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Sources to be cited</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="sources" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Charts</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="charts" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">PowerPoint slides</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="slides" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Excel Sheets</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="excelSheets" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Writer Category</label>
    <div class="col-sm-8">
        <select class="form-control js_calculate" name="writerCategoryId">
            {foreach $writerPreferences as $writerPreference}
                <option {if isset($writerPreference.percent)}data-percent="{$writerPreference.percent}"{/if} value="{$writerPreference.id}"{if $writerPreference.id == "2"}selected=""{/if}>{$writerPreference.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Tracking ID</label>
    <div class="col-sm-8">
        <input class="form-control" type="text" name="tracking_id" id="tracking_id" maxlength="255">
    </div>
</div>

<div class="divider"></div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Get Writer Samples</label>
    <div class="col-sm-8">
        <label class="switch" for="samplesNeeded">
            <input class="js_calculate" type="checkbox" name="samplesNeeded" id="samplesNeeded">
            <span class="slider round"></span>
        </label>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Copy of Sources</label>
    <div class="col-sm-8">
        <label class="switch" for="usedsources">
            <input class="js_calculate" type="checkbox" name="usedsources" id="usedsources">
            <span class="slider round"></span>
        </label>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Progressive Delivery</label>
    <div class="col-sm-8">
        <label class="switch" for="progressiveDeliveryHidden">
            <input class="js_calculate" type="checkbox" name="progressiveDeliveryHidden" id="progressiveDeliveryHidden">
            <span class="slider round"></span>
        </label>
    </div>
</div>
<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Expert Proofreading</label>
    <div class="col-sm-8">
        <label class="switch" for="expertProofreading">
            <input class="js_calculate" type="checkbox" name="expertProofreading" id="expertProofreading">
            <span class="slider round"></span>
        </label>
    </div>
</div>