<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Type of Paper</label>
    <div class="col-sm-7">
        <select name="paperTypeId" class="form-control js_calculate select_search js_custom-toggle" data-val="64">
            {foreach $paperTypes as $paperType}
                <option value="{$paperType.id}" {if $order.paperType == $paperType.id}selected=""{/if}>{$paperType.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row {if $order.paperType != 64}x-hidden{/if}">
    <label class="col-sm-2 control-label text-left">Add Paper Type</label>
    <div class="col-sm-7">
        <input type="text" class="js_calculate form-control" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$order.paperTypeOption}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Discipline</label> 
    <div class="col-sm-7">
        <select name="topicCatId" id="topicCatId" class="form-control js_calculate select_search js_custom-toggle" data-val="52">
            {foreach $disciplineGroups as $topicCat}
                <optgroup label="{$topicCat.title}">
                    {foreach $topicCat.disciplines as $discipline}
                        <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $order.topicCategoryId == $discipline.discipline_id}selected=""{/if} >{$discipline.title}</option>
                    {/foreach}
                </optgroup>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row {if $order.topicCategoryId != 52}x-hidden{/if}">
    <label class="col-sm-2 control-label text-left">Add Discipline</label>
    <div class="col-sm-7">
        <input type="text" class="js_calculate form-control" name="topcatOption" id="topcatOption" maxlength="255" value="{$order.topicCategory}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="paperFormat">Paper Format:</label>
    <div class="col-sm-7">
        <select class="form-control js_calculate js_custom-toggle" name="paperFormat" data-val="4">
            {foreach $paperFormats as $paperFormat} 
                <option value="{$paperFormat.paper_format_id}" {if $order.paperFormat == $paperFormat.paper_format_id}selected=""{/if}>{$paperFormat.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row {if $order.paperFormat != 4}x-hidden{/if}">
    <label class="col-sm-2 control-label text-left">Add Paper Format</label>
    <div class="col-sm-7">
        <input type="text" class="js_calculate form-control" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$order.paperFormatTypeOption}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Topic</label>
    <div class="col-sm-7">
        <input class="form-control" type="text" name="topic" id="topic" maxlength="255" value="{$order.title}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Paper Instructions</label>
    <div class="col-sm-7">
        <textarea class="form-control js_summernote" name="paperDetails">{$order.paperDetailsRaw}</textarea>
    </div>
</div>

<div class="divider"></div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Spacing</label>
    <div class="col-sm-4">
        <div class="form-selectgroup">
            <label class="form-selectgroup-item" for="double_spaced">
                <input id="double_spaced" type="radio" name="spacing" value="double" class="form-selectgroup-input js_calculate" {if $order.spacing == 'double'}checked=""{/if}>
                <span class="form-selectgroup-label">
                    <span class="text middle">Double Spaced</span>
                </span>
            </label>
            <label class="form-selectgroup-item" for="single_spaced">
                <input id="single_spaced" type="radio" name="spacing" value="single" class="form-selectgroup-input js_calculate" {if $order.spacing == 'single'}checked=""{/if}>
                <span class="form-selectgroup-label">
                    <span class="text middle">Single Spaced</span>
                </span>
            </label>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Pages</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="pages" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.pages}" data-minvalue="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Sources to be cited</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="sources" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.sources}" data-minvalue="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Charts</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="charts" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.charts}" data-minvalue="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">PowerPoint slides</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="slides" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.slides}" data-minvalue="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Excel Sheets</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="excelSheets" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" value="{$order.excelSheets}" data-minvalue="0">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Writer Category</label>
    <div class="col-sm-7">
        <select class="form-control js_calculate" name="writerCategoryId">
            {foreach $writerPreferences as $writerPreference}
                <option {if isset($writerPreference.percent)}data-percent="{$writerPreference.percent}"{/if} value="{$writerPreference.id}" {if $order.writerCategoryId == $writerPreference.id}selected=""{/if} >{$writerPreference.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Tracking ID</label>
    <div class="col-sm-7">
        <input class="form-control" type="text" name="tracking_id" id="tracking_id" maxlength="255" value="{$order.trackingId}">
    </div>
</div>

{if ($siteSettings.WRITER_SAMPLES_ENABLED ||  $order.areSamplesRequired) ||
    ($siteSettings.COPY_OF_SOURCES_ENABLED || $order.areSourcesRequired) ||
    ($siteSettings.PROGRESSIVE_DELIVERY_ENABLED || $order.progressiveDeliveryHidden) ||
    ($siteSettings.EXPERT_PROOFREADING_ENABLED || $order.expertProofreading)
}
    <div class="divider"></div>
{/if}

{if $siteSettings.WRITER_SAMPLES_ENABLED ||  $order.areSamplesRequired}
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Get Writer Samples</label>
        <div class="col-sm-7">
            <label class="switch" for="samplesNeeded">
                <input class="js_calculate" type="checkbox" name="samplesNeeded" id="samplesNeeded" {if $order.areSamplesRequired == '1'}checked="checked"{/if}>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
{/if}

{if $siteSettings.COPY_OF_SOURCES_ENABLED || $order.areSourcesRequired}
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Copy of Sources</label>
        <div class="col-sm-7">
            <label class="switch" for="usedsources">
                <input class="js_calculate" type="checkbox" name="usedsources" id="usedsources" {if $order.areSourcesRequired == '1'}checked="checked"{/if}>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
{/if}

{if $siteSettings.PROGRESSIVE_DELIVERY_ENABLED ||  $order.progressiveDeliveryHidden}
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Progressive Delivery</label>
        <div class="col-sm-7">
            <label class="switch" for="progressiveDeliveryHidden">
                <input class="js_calculate" type="checkbox" name="progressiveDeliveryHidden" id="progressiveDeliveryHidden" {if $order.progressiveDeliveryHidden == '1' && $order.tariffHrs > 120}checked="checked"{/if} {if $order.tariffHrs < 120}disabled=""{/if}>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
{/if}

{if $siteSettings.EXPERT_PROOFREADING_ENABLED ||  $order.expertProofreading}
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Expert Proofreading</label>
        <div class="col-sm-7">
            <label class="switch" for="expertProofreading">
                <input class="js_calculate" type="checkbox" name="expertProofreading" id="expertProofreading" {if $order.expertProofreading == '1'}checked="checked"{/if}>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
{/if}

{if ($siteSettings.WRITER_SAMPLES_ENABLED ||  $order.areSamplesRequired) ||
    ($siteSettings.COPY_OF_SOURCES_ENABLED || $order.areSourcesRequired) ||
    ($siteSettings.PROGRESSIVE_DELIVERY_ENABLED || $order.progressiveDeliveryHidden) ||
    ($siteSettings.EXPERT_PROOFREADING_ENABLED || $order.expertProofreading)
}
    <div class="divider"></div>
{/if}

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">
        Change Deadline
    </label>
    <div class="col-sm-7">
        <label class="switch" for="changeDeadline">
            <input type="checkbox" name="changeDeadline" id="changeDeadline">
            <span class="slider round"></span>
        </label>
    </div>
</div>

<div deadline-combo class="x-hidden">
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Academic level</label>
        <div class="col-sm-7">
            <select name="academicLevelId" class="form-control js_calculate">
                {foreach $academicLevels as $academicLevel}
                    <option value="{$academicLevel.id}" {if $order.academicLevel == $academicLevel.id}selected=""{/if}>{$academicLevel.title}</option>
                {/foreach}
            </select>
        </div>
    </div>

    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Deadline</label>
        <div class="col-sm-7">
            <select name="tariffId" class="form-control js_calculate" data-tariff-control="" tariff-id="{$order.tariffId}"></select>
        </div>
    </div>
</div>

{if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Total</label>
        <div class="col-sm-7">
            <span id="orderPrice" class="h2 text-success">{$order.priceFormatted}</span>
        </div>
    </div>
{/if}