<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="typeOfContent">Type of content</label>
    <div class="col-sm-8">
        <select name="article[typeOfContent]" class="form-control select_search js_calculate">
            {foreach $configsForArticleWriting.contentTypes as $contentType}
                <option value="{$contentType.paper_type_id}" {if $order.paperType == $contentType.paper_type_id}selected=""{/if}>{$contentType.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="categoryId">Category</label>
    <div class="col-sm-8">
        <select name="article[categoryId]" id="categoryId" class="form-control select_search js_calculate">
            {foreach $configsForArticleWriting.categories as $category}
                <option value="{$category.discipline_id}" {if $order.disciplineId == $category.discipline_id}selected=""{/if}>{$category.title}</option>
            {/foreach}
        </select>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="title">Title</label>
    <div class="col-sm-8">   
        <input type="text" class="form-control" name="article[title]" id="title" maxlength="255" value="{$order.title}" required>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="paperDetails">Additional Information</label>
    <div class="col-sm-8">
        <textarea name="article[paperDetails]" class="form-control js_summernote" data-height="100">{$order.paperDetailsRaw}</textarea>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left" for="title">Suggested keywords</label>
    <div class="col-sm-8">   
        <input type="text" class="form-control" name="article[keywords]" id="keywords" value="{$order.keywords}">
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Words</label>
    <div class="col-sm-4">
        <div class="control-stepper">
            <button type="button" class="js_calculate btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
            <input name="article[words]" type="text" class="js_calculate form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$order.words}">
            <button type="button" class="js_calculate btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
        </div>
    </div>
</div>

<div class="divider"></div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Writer category</label>
    <div class="col-sm-8">
        <div class="form-selectgroup-boxes row mb-3">
            <div class="col-md-4">
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[writerCategory]" value="2" data-percent="0" class="form-selectgroup-input" {if $order.writerCategoryId == '2'}checked=""{/if}>
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr10">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title strong mb10">Standard</span>
                            <span class="d-block text-muted fw-normal">Great content on a budget. Professional writers who we've vetted, tested, and approved.</span>
                        </span>
                    </span>
                </label>
            </div>
            <div class="col-md-4">
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[writerCategory]" value="3" data-percent="25" class="form-selectgroup-input" {if $order.writerCategoryId == '3'}checked=""{/if}>
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr10">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title strong mb10">Premium</span>
                            <span class="d-block text-muted fw-normal">Well researched content written by tested and talented writers who have a great rating in our system.</span>
                        </span>
                    </span>
                </label>
            </div>
            <div class="col-md-4">
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[writerCategory]" value="4" data-percent="30" class="form-selectgroup-input" {if $order.writerCategoryId == '4'}checked=""{/if}>
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr10">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title strong mb10">Ultimate</span>
                            <span class="d-block text-muted fw-normal">Thoroughly researched content written by the very best writers in our talent pool (and on the planet).</span>
                        </span>
                    </span>
                </label>
            </div>
        </div>
    </div>
</div>

<div class="form-group form-row mb20">
    <label class="col-sm-2 control-label text-left">English Type</label>
    <div class="col-sm-8">
        <div class="form-selectgroup mb-3">
            {foreach $configsForArticleWriting.englishTypes as $englishType}
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[englishTypeId]" value="{$englishType.id}" class="form-selectgroup-input" {if $order.englishTypeId == $englishType.id}checked=""{/if}>
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr10">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title strong mb10">{$englishType.title}</span>
                        </span>
                    </span>
                </label>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row mb20">
    <label class="col-sm-2 control-label text-left">Target Audience</label>
    <div class="col-sm-8">
        <div class="form-selectgroup mb-3">
            {foreach $configsForArticleWriting.targetAudiences as $targetAudience}
                <label class="form-selectgroup-item">
                    <input type="radio" name="article[targetAudienceId]" value="{$targetAudience.id}" class="form-selectgroup-input" {if $order.targetAudienceId == $targetAudience.id}checked=""{/if}>
                    <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                        <span class="mr10">
                            <span class="form-selectgroup-check"></span>
                        </span>
                        <span class="form-selectgroup-label-content">
                            <span class="form-selectgroup-title strong mb10">{$targetAudience.title}</span>
                        </span>
                    </span>
                </label>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row mb20">
    <label class="col-sm-2 control-label text-left">Writing Tone</label>
    <div class="col-sm-8">
        <div class="form-selectgroup-boxes row mb-3">
            {foreach $configsForArticleWriting.writingTones as $writingTone}
                <div class="col-md-4">
                    <label class="form-selectgroup-item">
                        <input type="radio" name="article[writingToneId]" value="{$writingTone.id}" class="form-selectgroup-input"  {if $order.writingToneId == $writingTone.id}checked=""{/if}>
                        <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                            <span class="mr10">
                                <span class="form-selectgroup-check"></span>
                            </span>
                            <span class="form-selectgroup-label-content">
                                <span class="form-selectgroup-title strong mb10">{$writingTone.title}</span>
                                <span class="d-block text-muted fw-normal">{$writingTone.description}</span>
                            </span>
                        </span>
                    </label>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row mb20">
    <label class="col-sm-2 control-label text-left">Writing Style</label>
    <div class="col-sm-8">
        <div class="form-selectgroup-boxes row mb-3">
            {foreach $configsForArticleWriting.writingStyles as $writingStyle}
                <div class="col-md-6">
                    <label class="form-selectgroup-item">
                        <input type="radio" name="article[writingStyleId]" value="{$writingStyle.id}" class="form-selectgroup-input"  {if $order.writingStyleId == $writingStyle.id}checked=""{/if}>
                        <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                            <span class="mr10">
                                <span class="form-selectgroup-check"></span>
                            </span>
                            <span class="form-selectgroup-label-content">
                                <span class="form-selectgroup-title strong mb10">{$writingStyle.title}</span>
                                <span class="d-block text-muted fw-normal">{$writingStyle.description}</span>
                            </span>
                        </span>
                    </label>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">Content Feel</label>
    <div class="col-sm-8">
        <div class="form-selectgroup-boxes row mb-3">
            {foreach $configsForArticleWriting.contentFeels as $contentFeel}
                <div class="col-md-6">
                    <label class="form-selectgroup-item">
                        <input type="radio" name="article[contentFeelId]" value="{$contentFeel.id}" class="form-selectgroup-input"  {if $order.contentFeelId == $contentFeel.id}checked=""{/if}>
                        <span class="form-selectgroup-label d-flex align-items-center p10 text-left">
                            <span class="mr10">
                                <span class="form-selectgroup-check"></span>
                            </span>
                            <span class="form-selectgroup-label-content">
                                <span class="form-selectgroup-title strong mb10">{$contentFeel.title}</span>
                                <span class="d-block text-muted fw-normal">{$contentFeel.description}</span>
                            </span>
                        </span>
                    </label>
                </div>
            {/foreach}
        </div>
    </div>
</div>


<div class="form-group form-row">
    <label class="col-sm-2 control-label text-left">
        Change Deadline
    </label>
    <div class="col-sm-7">
        <label class="switch" for="changeDeadline">
            <input type="checkbox" name="changeDeadline" id="changeDeadline">
            <span class="slider round"></span>
        </label>
    </div>
</div>

<div deadline-combo class="x-hidden">
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Deadline</label>
        <div class="col-sm-8">
            <select name="article[tariffId]" class="form-control js_calculate">
                {foreach $configsForArticleWriting.tariffs as $tariff}
                    <option value="{$tariff.id}"  {if $order.tariffId == $tariff.id}selected=""{/if} data-pricing="{$tariff.pricePerWord.value}">{$tariff.name}</option>
                {/foreach}
            </select>
        </div> 
    </div>
</div>

{if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
    <div class="form-group form-row">
        <label class="col-sm-2 control-label text-left">Total</label>
        <div class="col-sm-7">
            <span id="orderPrice" class="h2 text-success">{$order.priceFormatted}</span>
        </div>
    </div>
{/if}