{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
 
    {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}

        <div class="card">
            <div class="card-header with-icon with-nav {$order.deadlineHighlight} {if ($user.is_sub_admin && $user.id == $order.orderManager.id) && ($order_manager_enabled && $order_manager_public)}info{/if}">
                
                <div class="mb20">
                    <div class="pull-right flip">
                        {* Writer *}
                        {if $user.is_writer}

                            {* Order published || Inquiry published || Writer Accepted || Inquiry Writer Accepted*}
                            {if $order.status == "19" || 
                                $order.status == "16" || 
                                $order.status == "7"  ||
                                $order.status == "17" 
                            }

                                {if $can_take}
                                    <button data-toggle="tooltip" data-title="Take the order if you are ready to execute this order for {$order.writerPayFormatted}" data-oid="{$order.id}" class="btn btn-success js_take-order"> 
                                        <i class="fa fa-check mr10"></i> Take Order
                                    </button>
                                {elseif $has_bidded}
                                    <button data-toggle="tooltip" data-bid="{$bid.bid_id}" data-title="The bid you have placed equals to - ${$bid.amount} on {$bid.date_add}" data-oid="{$order.id}" class="btn btn-warning js_remove-bid">
                                    <i class="fa fa-times mr10"></i> Remove Bid
                                </button>
                                {else}
                                    <button data-toggle="tooltip" data-title="Place your bid if you are ready to execute this order for {$order.writerPayFormatted}" data-oid="{$order.id}" class="btn btn-success js_place-bid">
                                        <i class="fa fa-check mr10"></i> Place Bid
                                    </button>
                                {/if}

                            {/if}

                            {* Writer Assigned *}
                            {if $order.status == "6"}

                                {if !$order.isWriterConfirmed}
                                    <button data-toggle="tooltip" data-title="I will work on the order" class="btn btn-success js_confirm-order" data-action="accept" data-oid="{$order.id}">
                                        <i class="fa fa-check fa-fw mr5"></i> Accept
                                    </button>

                                    <button data-toggle="tooltip" data-title="I cannot work on the order at the moment" class="btn btn-danger js_confirm-order" data-action="decline" data-oid="{$order.id}">
                                        <i class="fa fa-times fa-fw mr5"></i> Decline
                                    </button>
                                {else}
                                    {if $order.canSubmitOrder}
                                        {if !$editor_account_enabled}
                                            <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                                <i class="fa fa-check fa-fw mr5"></i> Deliver Order
                                            </button>
                                        {else}
                                            <button data-toggle="tooltip" data-title="I have completed the order" class="btn btn-success js_complete-order" data-oid="{$order.id}">
                                                <i class="fa fa-check fa-fw mr5"></i> Mark as Complete
                                            </button>
                                        {/if}
                                    {/if}
                                {/if}

                            {/if}

                            {* Revision *}
                            {if $order.status == "14" && $order.canSubmitOrder}
                                {if !$editor_account_enabled}
                                    <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                        <i class="fa fa-check fa-fw mr5"></i> Deliver Order
                                    </button>
                                {else}
                                    <button data-toggle="tooltip" data-title="I have completed the order" class="btn btn-success js_complete-order" data-oid="{$order.id}">
                                        <i class="fa fa-check fa-fw mr5"></i> Mark as Complete
                                    </button>
                                {/if}
                            {/if}
                            
                        {/if}

                        {* Editor *}
                        {if $user.is_editor}
                            {* Done *}
                            {if $order.status == "8" && !$order.isEditorAssigned}
                                <button data-toggle="tooltip" data-title="Take and work on this order" class="btn btn-success js_take-order" data-oid="{$order.id}">
                                    <i class="fa fa-check fa-fw mr5"></i> Take Order
                                </button>
                            {/if}

                            {* In Progress *}
                            {if $order.status == "8" && $order.isEditorAssigned}
                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#revision" data-title="Send order to Revision" class="btn btn-danger" data-oid="{$order.id}">
                                    Revision
                                </button>
                                
                                <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                    <i class="fa fa-check fa-fw mr5"></i> Deliver Order
                                </button>
                            {/if}
                        {/if}

                        {* Admin *}
                        {if $user.is_admin || $user.is_sub_admin}

                            {* Unpaid *}
                            {if $order.status == "0"}
                                <button data-toggle="tooltip" data-title="Make this order available to writers" data-oid="{$order.id}" class="btn btn-primary js_mark-as-paid">
                                    <i class="fas fa-clipboard-check fa-fw mr5"></i> Mark as Paid
                                </button>
                            {/if}

                            {if $order.status == "6" || $order.status == "7" || $order.status == "8"}
                                <button data-toggle="tooltip" data-title="Deliver order to customer" class="btn btn-success js_deliver-order" data-oid="{$order.id}">
                                    <i class="fas fa-check fa-fw mr5"></i> Deliver Order
                                </button>
                            {/if}

                            {if $order.status == "8"}
                                <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#revision" data-title="Send order to Revision" class="btn btn-danger" data-oid="{$order.id}">
                                    Revision
                                </button> 
                            {/if}

                            {if $sub_view != "assign"}
                                {if $order.isPaid && $order.status != "10" && $order.status != "1"}
                                    <a href="{$base_uri}/order/{$order.id}/assign" data-ajax="/order/{$order.id}/assign" class="btn btn-primary">
                                        <i class="fas fa-user-check fa-fw mr5"></i> Assign Order
                                    </a>
                                {/if}

                                
                            {/if}

                        {/if}

                        <div class="pull-right dropdown ml5">
                            {if $user.is_admin || $user.is_sub_admin}
                                <button class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" data-display="static" aria-expanded="false">Actions</button>
                                
                                <div class="dropdown-menu dropdown-menu-right post-dropdown-menu">

                                    {if $sub_view != "assign"}
                                        <a data-toggle="tooltip" data-title="Edit Order" href="{$base_uri}/order/{$order.id}/edit" class="dropdown-item pointer">
                                            <i class="fas fa-edit fa-fw mr5"></i> Edit
                                        </a>
                                    {/if}

                                    {if $order.isArticleWriting}
                                        <div data-toggle="modal" data-url="#duplicateOrderModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' class="dropdown-item pointer">
                                            <div class="action no-desc">
                                                <i class="fas fa-copy fa-fw mr5"></i> Duplicate Order
                                            </div>
                                        </div>
                                    {else}
                                        <div class="dropdown-item pointer js_reorder" data-oid="{$order.id}">
                                            <div class="action no-desc">
                                                <i class="fas fa-redo fa-fw mr5"></i> Re-order
                                            </div>
                                        </div>
                                    {/if}

                                    {hook h='displayOrderActions' order_id=$order.id}
                                </div>
                            {else}
                                {hook h='displayOrderActions' order_id=$order.id}
                            {/if}
                        </div>
                    </div>                            

                    <i class="fa fa-shopping-basket mr10"></i>
                    <strong>Orders</strong>
                    &rsaquo; <strong>#{$order.referenceId}</strong>
                    {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}
                        &rsaquo; <strong class="mr10">{$order.statusTitle}</strong>
                    {/if}
                </div>

                <!-- tabs nav -->
                <ul class="nav nav-tabs admin">
                    <li class="nav-item"> 
                        <a class="nav-link {if $sub_view == "instructions"} active {/if}" href="#instructions" data-toggle="tab">
                            <strong class="pr5">Instructions</strong>
                        </a>
                    </li>

                    {if $order.progressiveDeliveryHidden}
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "#progressive-delivery"} active {/if}" href="#progressive-delivery" data-toggle="tab">
                                <strong class="pr5">Progressive Delivery</strong>
                            </a>
                        </li>
                    {/if}
                    
                    <li class="nav-item">
                        <a class="nav-link {if $sub_view == "files"} active {/if}" href="#files" data-toggle="tab">
                            <strong class="pr5">All Files {if $order.allFilesCount} ({$order.allFilesCount}) {/if}</strong>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {if $sub_view == "messages"} active {/if}" href="#messages" data-toggle="tab">
                            <strong class="pr5">Messages {if $order.allMessagesCount} ({$order.allMessagesCount}) {/if}</strong>
                        </a>
                    </li>

                    {if count($orderHistory)}
                        <li class="nav-item">
                            <a class="nav-link {if $sub_view == "history"} active {/if}" href="#order-history" data-toggle="tab">
                                <strong class="pr5">Order History</strong>
                            </a>
                        </li>
                    {/if}
                </ul>
                <!-- tabs nav -->

            </div>

            {if $sub_view == "instructions" || $sub_view == "files" || $sub_view == "messages" || $sub_view == "history"}

                <div class="card-body">

                    <!-- tabs content -->
                    <div class="tab-content">

                        <!-- instructions tab -->
                        <div class="tab-pane {if $sub_view == "instructions"}active{/if}" id="instructions">
                           
                            <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                <tbody>
                                    <tr class="first">
                                        <th>Type of service:</th>
                                        <td>{$order.serviceTypeTitle}</td>
                                    </tr>
                                    
                                    {if $order.trackingId && ($user.is_admin || $user.is_sub_admin)}
                                        <tr>
                                            <th>Tracking ID:</th>
                                            <td>{$order.trackingId}</td>
                                        </tr>
                                    {/if}

                                    {if $order.isAcademicWriting}
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <tr>
                                                <th>{if $order.ukForm}Desirable grade{else}Writer category{/if}:</th>
                                                <td>{$order.writerCategoryTitle}</td>
                                            </tr>
                                        {/if}

                                        <tr>
                                            <th>Work type:</th>
                                            <td>{$order.paperTypeTitle} {if $order.paperType == "64"}: {$order.paperTypeOption} {/if}</td>
                                        </tr>

                                        <tr>
                                            <th>Format:</th>
                                            <td>{$order.paperFormatTitle} {if $order.paperFormat == "4"}: {$order.paperFormatTypeOption} {/if}</td>
                                        </tr>

                                        <tr>
                                            <th>Pages:</th> 
                                            <td>{pluralize('page', $order.pages)} - <strong>{pluralize('word', $order.wordsPerPage)}, {$order.spacing|capitalize} spaced</strong></td>
                                        </tr>

                                        {if $order.slides}
                                            <tr>
                                                <th>Slides:</th>
                                                <td>{$order.slides}</td>
                                            </tr>
                                        {/if}

                                        {if $order.charts}
                                            <tr>
                                                <th>Charts:</th>
                                                <td>{$order.charts}</td>
                                            </tr>
                                        {/if}

                                        {if $order.excelSheets}
                                            <tr>
                                                <th>Excel Sheets:</th>
                                                <td>{$order.excelSheets}</td>
                                            </tr>
                                        {/if}

                                        {if count($order.services)}
                                            <tr>
                                                <th>Additional services:</th>
                                                <td>
                                                    {foreach $order.services as $service}
                                                        <output class="fw-bold">{$service.title}</output>
                                                    {/foreach}
                                                </div>
                                            </tr>
                                        {/if}
                                    {/if}

                                    {if $order.isArticleWriting}
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <tr>
                                                <th>Writer Category:</th>
                                                <td>{$order.writerCategoryTitle}</td>
                                            </tr>
                                        {/if}

                                        <tr>
                                            <th>Type of Content:</th>
                                            <td>{$order.contentTypeTitle}</td>
                                        </tr>

                                        <tr>
                                            <th>Words:</th>
                                            <td>{pluralize('word', $order.words)}</td>
                                        </tr>
                                    {/if}

                                    <tr>
                                        <th>Deadline:</th>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="js_moment" data-time="{$order.deadline}">{$order.deadline}</span> ({$order.timeLeftHtml nofilter})
                                                {if $user.is_admin || $user.is_sub_admin}
                                                    <span data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"customer"{literal}}{/literal}' class="btn btn-info btn-sm mlauto mr0">
                                                        <i class="fas fa-clock"></i> Change Deadline
                                                    </span>
                                                {/if}
                                            </div>
                                        </td>
                                    </tr>
                                    
                                    {if $user.is_admin || $user.is_sub_admin}
                                        {if $order.isPaid}
                                            <tr>
                                                <th>Writer deadline:</th>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <span class="js_moment" data-time="{$order.writerDeadline}">{$order.writerDeadline}</span> ({$order.writerTimeLeftHtml nofilter})
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <span data-toggle="modal" data-url="#extendDeadlineModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"handle":"writer"{literal}}{/literal}' class="btn btn-info btn-sm mlauto mr0">
                                                                <i class="fas fa-clock"></i> Change Deadline
                                                            </span>
                                                        {/if}
                                                    </div>  
                                                </td>
                                            </tr>
                                        {/if}
                                        <tr>
                                            <th>Created At:</th>
                                            <td>
                                                <span class="js_moment" data-time="{$order.createdAt}">{$order.createdAt}</span>
                                            </td>
                                        </tr>

                                        {if $order.status == "11" || $order.status == "10"}
                                            <tr>
                                                <th>Delivered At:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                                                </td>
                                            </tr>
                                        {/if}

                                        {if $order.status == "10"}
                                            <tr>
                                                <th>Approved At:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                                                </td>
                                            </tr>
                                        {/if}
                                        {if $order.status == "9"}
                                            <tr>
                                                <th>Cancelled At:</th>
                                                <td>
                                                    <span class="js_moment" data-time="{$order.cancelledAt}">{$order.cancelledAt}</span>
                                                </td>
                                            </tr>
                                        {/if}
                                    {/if}
                                </tbody>
                            </table>
                            <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                <tbody>
                                    {if $order.isAcademicWriting}
                                        <tr class="first">
                                            <th>Academic level:</th>
                                            <td>{$order.academicLevelTitle}</td>
                                        </tr>
                                        
                                        <tr>
                                            <th>Discipline:</th>
                                            <td>{$order.topicCategory} {if $order.topicCategoryId == "52"}: {$order.topicCategoryOption} {/if}</td>
                                        </tr>

                                        <tr>
                                            <th>Title:</th>
                                            <td>{$order.title}</td>
                                        </tr>

                                        <tr>
                                            <th>Number of sources:</th>
                                            <td>{$order.sources}</td>
                                        </tr>
                                    {/if}

                                    {if $order.isArticleWriting}
                                        <tr>
                                            <th>Category:</th>
                                            <td>{$order.disciplineTitle}</td>
                                        </tr>

                                        {if $order.keywords}
                                            <tr>
                                                <th>Keywords:</th>
                                                <td>{$order.keywords}</td>
                                            </tr>
                                        {/if}

                                        {if $order.englishTypeTitle}
                                            <tr>
                                                <th>English Type:</th>
                                                <td>{$order.englishTypeTitle}</td>
                                            </tr>
                                        {/if}

                                        {if $order.targetAudienceTitle}
                                            <tr>
                                                <th>Target Audience:</th>
                                                <td>{$order.targetAudienceTitle}</td>
                                            </tr>
                                        {/if}

                                        {if $order.writingStyleTitle}
                                            <tr>
                                                <th>Writing Style:</th>
                                                <td>{$order.writingStyleTitle}</td>
                                            </tr>
                                        {/if}

                                        {if $order.writingToneTitle}
                                            <tr>
                                                <th>Writing Tone:</th>
                                                <td>{$order.writingToneTitle}</td>
                                            </tr>
                                        {/if}

                                        {if $order.contentFeelTitle}
                                            <tr>
                                                <th>Content Feel:</th>
                                                <td>{$order.contentFeelTitle}</td>
                                            </tr>
                                        {/if}
                                    {/if}

                                    {if $order.isProgramming || $order.isCalculations}
                                        <tr>
                                            <th>Discipline:</th>
                                            <td>{$order.topicCategory} {if $order.topicCategoryId == "52"}: {$order.topicCategoryOption} {/if}</td>
                                        </tr>

                                        <tr>
                                            <th>Task size:</th>
                                            <td>
                                                <h5 class="fw-bold mt5 mb10 text-dark">{$order.sizeTitle}</h5>
                                                {if count($order.deliverables)} 
                                                    <div class="fw-bold mt5 mb5 text-muted">Possible Deliverables:</div>
                                                    <ul class="task_deliverables">
                                                        {foreach $order.deliverables as $deliverable}
                                                            <li class="task_deliverables_item task_deliverables_item--{$deliverable.slug}">{$deliverable.name}</li>
                                                        {/foreach}
                                                    </ul>
                                                {/if}
                                            </td>
                                        </tr>

                                        {if $order.software}
                                            <tr>
                                                <th>Software:</th>
                                                <td>{$order.software}</td>
                                            </tr>
                                        {/if}
                                    {/if}
                                </tbody>
                            </table>
                            <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                <tbody>
                                    {if $order.paperDetails}
                                        <tr class="first">
                                            <th>{if $order.isAcademicWriting}Paper instructions:{else}Instructions:{/if}</th>
                                            <td>
                                                <div class="OrderInstructions">
                                                    {$order.paperDetails nofilter}
                                                </div>
                                            </td>
                                        </tr>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        {if $order.requestedWriter.id}
                                            <tr>
                                                <th>Requested Writer:</th>
                                                <td>
                                                    {if $show_writer_info}
                                                        <a href="{$base_uri}/employees/edit/{$order.requestedWriter.id}" target="_blank"> {$order.requestedWriter.first_name} {$order.requestedWriter.last_name} ({$order.requestedWriter.id}) </a>
                                                    {else}
                                                        <strong class="text-primary">{$order.requestedWriter.id} - {$order.requestedWriter.first_name}</strong>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/if}
                                    {/if}

                                    {if $order.comments}
                                        <tr>
                                            <th>Additional comments from Customer:</th>
                                            <td>{$order.comments}</td>
                                        </tr>
                                    {/if}

                                    {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
                                        <tr>
                                            <th>Price:</th>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    {if $order.noDiscountPrice > $order.price}
                                                        <span style="text-decoration:line-through;" class="text-dark mr10 text-sm">{$order.noDiscountPriceFormatted}</span>
                                                    {/if}
                                                    <span class="text-success text-lg">{$order.priceFormatted}</span>

                                                    <div class="mlauto mr0">
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_customer_pay":"1","customer_pay":{$order.price}{literal}}{/literal}' class="btn btn-info btn-sm mr10">
                                                                <i class="fas fa-edit"></i> Edit
                                                            </span>
                                                        {/if}

                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <span data-toggle="modal" data-url="#modal-additional-payment" data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' class="btn btn-info btn-sm">
                                                                <i class="fa fa-credit-card mr1"></i> Additional Payment
                                                            </span>
                                                        {/if}
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>

                                        {if $order.additionalPayments}
                                            <tr>
                                                <th>Additional payments:</th>
                                                <td>
                                                    {foreach $order.additionalPayments as $additionalPayment}
                                                        <div>{$additionalPayment.title} was paid at <span class="js_moment" data-time="{$additionalPayment.paidAt}"></span></div>
                                                        {if count($order.additionalPayments) > 1}<hr  class="mb10 mt10">{/if}
                                                    {/foreach}
                                                </td>
                                            </tr>
                                        {/if}

                                        {if $order.paymentMethod}
                                            <tr>
                                                <th>Payment Method:</th>
                                                <td class="text-capitalize">{$order.paymentMethod}</td>
                                            </tr>
                                        {/if}

                                    {/if}

                                    {if count($order.orderReviews)}
                                        <tr>
                                            <th>Feedback:</th>
                                            <td>
                                                {foreach from=$order.orderReviews item=$orderReview key=$ratingId}
                                                    <div class="ptb5 plr5 {if $orderReview.user_type == 'customer'}bg-success{else}bg-info{/if}">
                                                        <div class="mb5">  
                                                            <small class="media-object">{if $orderReview.user_type == 'customer'}Customer's Feedback{else}Editor's Feedback{/if}</small>
                                                            {if $orderReview.user_type == 'customer'}  
                                                                <span class="fw-bold mr10">Service Rating</span>                                         
                                                                <div class="Rating Rating--labeled" data-star_rating="{$orderReview.service_rating}">
                                                                    <span class="Rating-total">
                                                                        <span class="Rating-progress"></span>
                                                                    </span>
                                                                </div>
                                                            {/if}
                                                            <span class="fw-bold {if $orderReview.user_type == 'customer'}ml10{/if} mr10">Paper Rating</span>                                         
                                                            <div class="Rating Rating--labeled" data-star_rating="{$orderReview.paper_rating}">
                                                                <span class="Rating-total">
                                                                    <span class="Rating-progress"></span>
                                                                </span>
                                                            </div>
                                                        </div>

                                                        <div class="text-dark">{$orderReview.comment nofilter}</div>

                                                        <div class="js_moment mt5 text-muted" data-time="{$orderReview.date}">{$orderReview.date}</div>
                                                    </div>
                                                    {if $ratingId != count($order.orderReviews)-1}<div class="divider mt10 mb10"></div>{/if}
                                                {/foreach}
                                            </td>
                                        </tr>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin || $user.is_writer}
                                        <tr>
                                            <th>{if $user.is_admin || $user.is_sub_admin}Writer {/if}Fee:</th>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="text-success text-lg">{$order.writerPayFormatted}</span> 
                                                    {if $order.isWriterPaid && ($user.is_admin || $user.is_sub_admin)}
                                                        <span class="ml10 badge badge-success">Paid</span>
                                                    {/if}
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_writer_pay":"1","writer_pay":{$order.writerPay}{literal}}{/literal}' class="btn btn-info btn-sm mlauto mr0">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </span>
                                                    {/if}
                                                </div>
                                            </td>
                                        </tr>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin || $user.is_editor}
                                        <tr>
                                            <th>{if $user.is_admin || $user.is_sub_admin}Editor {/if}Fee:</th>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="text-success text-lg">{$order.editorPayFormatted}</span>
                                                    {if $order.isEditorPaid && ($user.is_admin || $user.is_sub_admin)}
                                                        <span class="ml10 badge badge-success">Paid</span>
                                                    {/if}
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_editor_pay":"1","editor_pay":{$order.editorPay}{literal}}{/literal}' class="btn btn-info btn-sm mlauto mr0">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </span>
                                                    {/if}
                                                </div>
                                            </td>
                                        </tr>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <tr>
                                            <th>Order Manager Fee:</th>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <span class="text-success text-lg">{$order.orderManagerPayFormatted}</span>
                                                    {if $user.is_admin}
                                                        <span data-toggle="modal" data-url="#modal-edit-pay" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"edit_ordermanager_pay":"1","ordermanager_pay":{$order.orderManagerPay}{literal}}{/literal}' class="btn btn-info btn-sm mlauto mr0">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </span>
                                                    {/if}
                                                </div>
                                            </td>
                                        </tr>
                                    {/if}

                                    {if ($user.is_writer || $user.is_editor) && $order.customerCountry}
                                        <tr>
                                            <th>Customer:</th>
                                            <td>
                                                <div data-toggle="tooltip" data-title="{$order.customerCountry.name}" class="customer-country iti-flag {$order.customerCountry.countryCode}"></div>
                                            </td>
                                        </tr>
                                    {/if}

                                    {if  $user.is_editor && $order.writer.id}
                                        <tr>
                                            <th>Writer:</th>
                                            <td>
                                                <strong class="text-primary">{$order.writer.first_name} {$order.writer.last_name}</strong>
                                            </td>
                                        </tr>
                                    {/if}

                                    {hook h='displayOrderAdditionalInfo' order_id=$order.id|intval}
                                </tbody>
                            </table>
 
                            {if $user.is_admin || $user.is_sub_admin}
                                <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info">
                                    <tbody>
                                        <tr class="first">
                                            <th>Status:</th>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <strong>{$order.statusTitle}</strong>
                                                    <span data-toggle="modal" data-url="#editStatusModal" data-size="small" data-options='{literal}{{/literal}"order_id":{$order.id},"status_id":{$order.status}{literal}}{/literal}' class="btn btn-info btn-sm mlauto mr0"><i class="fas fa-edit"></i> Change Status</span>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Customer:</th>
                                            <td>
                                                {if $user.is_sub_admin}
                                                    <strong>{$order.customer.id}</strong>
                                                {else}
                                                    <a href="{$base_uri}/customers/edit/{$order.customer.id}" target="_blank"> {$order.customer.name} ({$order.customer.id}) </a>
                                                {/if}

                                                {if $order.customerCountry}
                                                    <div data-toggle="tooltip" data-title="{$order.customerCountry.name}" class="ml10 customer-country iti-flag {$order.customerCountry.countryCode}"></div>
                                                {/if}
                                            </td>
                                        </tr>

                                        {if $order.writer.id}
                                            <tr>
                                                <th>Writer:</th>
                                                <td>
                                                    {if $show_writer_info}
                                                        <a href="{$base_uri}/employees/edit/{$order.writer.id}" target="_blank"> {$order.writer.first_name} {$order.writer.last_name} ({$order.writer.id}) </a>
                                                    {else}
                                                        <strong class="text-primary">{$order.writer.id} - {$order.writer.first_name}</strong>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/if}

                                        {if $order.editor.id}
                                            <tr>
                                                <th>Editor:</th>
                                                <td>
                                                    <a href="{$base_uri}/employees/edit/{$order.editor.id}" target="_blank"> {$order.editor.first_name} {$order.editor.last_name} ({$order.editor.id}) </a>
                                                </td>
                                            </tr>
                                        {/if}

                                        {if $order.orderManager.id}
                                            <tr>
                                                <th>Order Manager:</th>
                                                <td>
                                                    {if $user.is_admin}
                                                        <a href="{$base_uri}/employees/edit/{$order.orderManager.id}" target="_blank"> {$order.orderManager.first_name} {$order.orderManager.last_name} ({$order.orderManager.id}) </a>
                                                    {else}
                                                        <strong class="text-primary">{$order.orderManager.id} - {$order.orderManager.first_name} {$order.orderManager.last_name}</strong>
                                                    {/if}
                                                </td>
                                            </tr>
                                        {/if}

                                        <tr>
                                            <th>Site:</th>
                                            <td>
                                                {if $user.is_admin}
                                                    <a href="{$base_uri}/my-sites/{$order.site.id}/edit" target="_blank"> {$order.site.name} </a>
                                                {elseif $user.is_sub_admin}
                                                    <strong class="text-primary">#{$order.site.id}</strong>
                                                {/if}
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            {/if}
                        </div>
                        <!-- instructions tab -->

                        {if $order.progressiveDeliveryHidden}
                            <!-- progressive-delivery tab -->
                            <div class="tab-pane" id="progressive-delivery">

                                {if count($order.pdSchedule)}
                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="mb20 clearfix">
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#modalProgressiveDelivery" type="button" class="btn btn-primary pull-right">
                                                <i class="fa fa-plus"></i> Add Delivery Schedule
                                            </button>
                                        </div>
                                    {/if}

                                    <div class="table-responsive">
                                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                            <thead>
                                                <tr>
                                                    <th>Part</th>
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <th>Customer Deadline</th>
                                                    {/if}
                                                    <th>Writer Deadline</th>
                                                    <th>Task</th>
                                                    {if $user.is_admin || $user.is_sub_admin}
                                                        <th>Actions</th>
                                                    {/if}
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {counter assign=schedulePart start=1 print=false}
                                                {foreach $order.pdSchedule as $schedule}
                                                    <tr>
                                                        <td>Part {$schedulePart}</td>
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <td>
                                                                {$schedule.customer_deadline|date_format:"%e %b %I:%M %p"}
                                                            </td>
                                                        {/if}
                                                        <td>
                                                            {$schedule.writer_deadline|date_format:"%e %b %I:%M %p"}
                                                        </td>
                                                        <td>
                                                            {if $schedule.pages} {pluralize('page', $schedule.pages)} {/if} 
                                                            {if $schedule.slides}, {pluralize('slide', $schedule.slides)} {/if} 
                                                            {if $schedule.charts} {pluralize('chart', $schedule.charts)} {/if} 
                                                        </td>
                                                        {if $user.is_admin || $user.is_sub_admin}
                                                            <td>
                                                                <div class="dropdown">
                                                                    <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$schedule.schedule_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                        Actions
                                                                    </button>
                                                                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$schedule.schedule_id}">
                                                                        <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="">
                                                                            <i class="fa fa-pencil-alt mr5"></i> Edit
                                                                        </a>
                                                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="pd_schedule" data-id="{$schedule.schedule_id}">
                                                                            <i class="fa fa-trash mr5"></i> Delete
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                        {/if}
                                                    </tr>
                                                    {counter}
                                                {/foreach}
                                            </tbody>
                                        </table>
                                    </div>
                                {else} 

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="text-center x-muted mt20 mb20"> 
                                            <i class="fa fa-calendar fa-4x"></i>
                                            <p class="mt20">
                                                <strong>This is a progressive delivey order. Create a delivery schedule.</strong>
                                            </p>
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#modalProgressiveDelivery" type="button" class="btn btn-primary">
                                                <i class="fa fa-plus"></i> Add Delivery Schedule
                                            </button>
                                        </div>
                                    {else}
                                        <div class="text-center x-muted"> 
                                            {include file='__svg_icons.tpl' icon="calendar" class="mb5" width="60px" height="60px"} 
                                            <p class="mb20"><strong>No delivery schedule to show</strong></p>
                                        </div>
                                    {/if}
                                {/if}

                            </div>
                            <!-- progressive-delivery tab -->
                        {/if}

                        <!-- files tab -->
                        <div class="tab-pane {if $sub_view == "files"}active{/if}" id="files">
                               
                            <div class="OrderDetailsFiles">
                                <div class="OrderDetailsFiles__split OrderDetailsFiles__split--from-service pl0">
                                    <div class="OrderDetailsFiles__split__header">
                                        <strong class="OrderDetailsFiles__split__title bold">Files uploaded by Writer </strong>
                                        <span class="OrderDetailsFiles__split__count">{count($order.writerFiles)} files</span>
                                    </div>
                                    <div class="OrderDetailsFiles__split__body">
                                        {if count($order.writerFiles) > 0}
                                            {foreach $order.writerFiles as $file}
                                                {include file="dashboard/order/_order.file.tpl"}
                                            {/foreach}
                                        {else}
                                            <div class="OrderDetailsFiles__no-from-customer-message">There are no files uploaded writer</div>
                                        {/if}
                                    </div>
                                     
                                    {if $user.is_writer}
                                        {* Writer | Writer Assigned *}
                                        {if $order.status == "11" || $order.status == "6" && $order.isWriterConfirmed}
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">Upload Files</button>
                                        {/if}

                                        {* Writer | Revision *}
                                        {if $order.status == "14" && $order.isWriterConfirmed}
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">Upload Files</button>
                                        {/if}
                                    {/if}

                                    {if $user.is_editor}
                                        {* Editor | Done *}
                                        {if $order.isEditorAssigned == '1' && $order.editor.id == $user.id && $order.status == "8"}
                                            <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">Upload Files</button>
                                        {/if}
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <button data-options='{literal}{{/literal}"order_id":{$order.id},"sources":{$order.areSourcesRequired|intval}{literal}}{/literal}' data-toggle="modal" data-url="#modal-upload" class="btn btn-primary">
                                            <i class="fa fa-upload"></i> Upload Files
                                        </button>
                                    {/if}

                                    {hook h='displayOrderWriterFilesActions' order_id=$order.id}
                                </div>

                                <div class="OrderDetailsFiles__split OrderDetailsFiles__split--from-customer pr0">
                                    <div class="OrderDetailsFiles__split__header">
                                        <strong class="OrderDetailsFiles__split__title bold">Customer uploads</strong>
                                        <div class="OrderDetailsFiles__split__count">{count($order.customerFiles)} files</div>
                                    </div>
                                    <div class="OrderDetailsFiles__split__body">
                                        {if count($order.customerFiles) > 0}
                                            {foreach $order.customerFiles as $file}
                                                {include file="dashboard/order/_order.file.tpl"}
                                            {/foreach}
                                        {else}
                                            <div class="OrderDetailsFiles__no-from-customer-message">There are no files uploaded by customer</div>
                                        {/if}
                                    </div>
                                    
                                    {if count($order.customerFiles) > 0 && (!$cloud_storage && !$ifs_enabled)}
                                        <a class="btn btn-primary" href="{$base_uri}/api/orders/{$order.id}/download_all_attachments">Download all attachments</a>
                                    {/if}

                                    {hook h='displayOrderCustomerFilesActions' order_id=$order.id}
                                </div>
                            </div>
                        </div>
                        <!-- files tab -->

                        <!-- messages tab -->
                        <div class="tab-pane {if $sub_view == "messages"}active{/if}" id="messages">
                            {if count($order.messages)}
                                <div class="clearfix">
                                    <div class="pull-right">
                                        <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#newMessage" class="btn btn-primary">New Message</button>
                                    </div>
                                </div>
                            {/if}

                            <div class="OrderMessages__content mt20">
                                {if count($order.messages)}
                                    {foreach $order.messages as $message}
                                        <div class="message">
                                            <div class="message--container js_order-message {if !$message.isSender && !$message.isViewed}new{/if}" data-id="{$message.id}" data-read="{$message.isViewed}">
                                                <button class="message--toggle" data-toggle="collapse" href="#message-{$message.id}" role="button" aria-expanded="false" aria-controls="message-{$message.id}">
                                                    <div class="message--icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19"><path d="M4,7.863l8,4.907,8-4.907h0L12,2.956,4,7.863H4m18,0v9.814a1.982,1.982,0,0,1-2,1.963H4a1.982,1.982,0,0,1-2-1.963V7.863a1.947,1.947,0,0,1,.97-1.678L12,.64l9.03,5.545A1.947,1.947,0,0,1,22,7.863Z" transform="translate(-2 -0.64)" fill="#9e9e9e"></path></svg>
                                                    </div>
                                                    <div class="message--from-to">
                                                        <div class="message--sender">{$message.fromDepartment.name|ucfirst}</div>
                                                        <div class="message--to">{$message.toDepartment.name|ucfirst}</div>
                                                    </div>
                                                    
                                                    <div class="message--subject">
                                                        <span class="message--subject__text_collapse">{$message.subject}</span>
                                                    </div>
                                                    <div class="message--date">
                                                        {if $message.isViewed && $message.isSender}
                                                            <span data-toggle="tooltip" data-placement="top" data-title="{$message.readAt}">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                                            </span>
                                                        {/if}
                                                        <span class="js_moment" data-time="{$message.createdAt}">{$message.createdAt}</span>
                                                    </div>
                                                    <div class="message--arrow">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                                    </div>
                                                </button>
                                                <div class="message--collapse collapse" id="message-{$message.id}">
                                                    <div class="message--text">{$message.body nofilter}</div>

                                                    {if !$message.isSender}
                                                        <form data-url="/messages/{$message.id}/reply" class="ReplyMessageForm js_ajax-forms" method="POST">
                                                            <textarea name="reply" class="form-control mb10 js_autosize" placeholder="Type your reply..." tabindex="0"></textarea>
                                                            <!-- success -->
                                                            <div class="alert alert-success mt10 mb10 x-hidden" role="alert"></div>
                                                            <!-- success -->

                                                            <!-- error -->
                                                            <div class="alert alert-danger mt10 mb10 x-hidden" role="alert"></div>
                                                            <!-- error -->
                                                            <div class="ReplyMessageForm__buttons">
                                                                <button class="btn btn-primary" type="submit">Reply</button>
                                                                {if $user.is_admin || $user.is_sub_admin}
                                                                    <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">Delete</a>
                                                                {/if}
                                                            </div>
                                                        </form>
                                                    {else}
                                                        <div class="message--buttons">
                                                            {if $user.is_admin || $user.is_sub_admin}
                                                                <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="message" data-id="{$message.id}">Delete</a>
                                                            {/if}
                                                        </div>
                                                    {/if}
                                                </div>
                                            </div>
                                        </div>
                                    {/foreach}
                                {else}
                                    <div class="text-center x-muted"> 
                                        {include file='__svg_icons.tpl' icon="messages" class="mb5" width="60px" height="60px"} 
                                        <p class="mb20"><strong>No messages to show</strong></p>
                                        <button data-options='{literal}{{/literal}"order_id":{$order.id}{literal}}{/literal}' data-toggle="modal" data-url="#newMessage" class="btn btn-primary">New Message</button>
                                    </div>
                                {/if}
                            </div>
                        </div>
                        <!-- messages tab -->

                        <!-- order-history tab -->
                        {if count($orderHistory)}
                            <div class="tab-pane {if $sub_view == "history"}active{/if}" id="order-history">
                                <div class="table-responsive">
                                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                        <thead>
                                            <tr>
                                                <th>Order ID</th>
                                                <th>Topic Title</th>
                                                <th>Discipline</th>
                                                <th>Status</th>
                                                <th>Task</th>
                                                {if $show_client_cost}
                                                    <th>Cost</th>
                                                {/if}
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {foreach $orderHistory as $oHistory}
                                                <tr {if ($user.is_sub_admin && $user.id == $oHistory.orderManager.id) && ($order_manager_enabled && $order_manager_public)}class="info"{/if}>
                                                    <td>
                                                        <strong><a href="{$base_uri}/order/{$oHistory.id}" data-ajax="/order/{$oHistory.id}">#{$oHistory.id}</a></strong>
                                                    </td>
                                                    {if $oHistory.isProgramming || $oHistory.isCalculations}
                                                        <td>{$oHistory.serviceTypeTitle}</td>
                                                        <td>
                                                            <small class="btn-block">{$oHistory.topicCategory}</small>
                                                            <small class="btn-block text-muted">{$oHistory.sizeTitle}</small>
                                                        </td>
                                                    {elseif $oHistory.isArticleWriting}
                                                        <td>{$oHistory.title}</td>
                                                        <td>
                                                            <small class="btn-block">{$oHistory.contentTypeTitle}</small>
                                                            <small class="btn-block text-muted">{$oHistory.disciplineTitle}</small>
                                                        </td>
                                                    {else}
                                                        <td>{$oHistory.title}</td>
                                                        <td>
                                                            <small class="btn-block">{$oHistory.topicCategory}</small>
                                                            <small class="btn-block text-muted">{$oHistory.academicLevelTitle}</small>
                                                        </td>
                                                    {/if}

                                                    <td>{$oHistory.statusTitle}</td>

                                                    {if $oHistory.isProgramming || $oHistory.isCalculations}
                                                        <td>{$oHistory.sizeTitle}</td>
                                                    {elseif $oHistory.isArticleWriting}
                                                        <td>{pluralize('word', $oHistory.words)}</td>
                                                    {else}
                                                        <td>
                                                            {if $oHistory.pages} {pluralize('page', $oHistory.pages)} {/if} 
                                                            {if $oHistory.slides}, {pluralize('slide', $oHistory.slides)} {/if} 
                                                            {if $oHistory.charts} {pluralize('chart', $oHistory.charts)} {/if} 
                                                            {if $oHistory.excel_sheets} {pluralize('excel sheet', $oHistory.excel_sheets)} {/if} 
                                                        </td>
                                                    {/if}

                                                    {if $user.is_writer}
                                                        <td>{$oHistory.writerPayFormatted}</td>
                                                    {elseif $user.is_editor}
                                                        <td>{$oHistory.editorPayFormatted}</td>
                                                    {elseif $show_client_cost}
                                                        <td>{$oHistory.priceFormatted}</td>
                                                    {/if}
                                                </tr>
                                            {/foreach}
                                        </tbody>
                                    </table>

                                    {$pager nofilter}
                                </div>
                            </div>
                        {/if}
                        <!-- order-history tab -->

                    </div>
                    <!-- tabs content -->

                </div>
            {/if}
        </div>

    {elseif $sub_view == "assign"}
        {include file='dashboard/order/order.assign.tpl'}
    {/if}

    {if $user.is_admin || $user.is_sub_admin}
        <!-- Order Status -->
        <script id="editStatusModal" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/orders/{$order.id}/edit-status" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Change Status</h5>
                    <span class="modal-close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="form-label">Select status</label>
                        <select class="form-control" name="status_id">
                            <option value="-1" selected="">Select Status</option>
                            <option value="13" {if $order.status == '13'}selected=""{/if}>Free Inquiry</option>
                            <option value="0" {if $order.status == '0'}selected=""{/if}>Waiting for Payment</option>
                            <option value="12" {if $order.status == '12'}selected=""{/if}>New Paid</option>
                            <option value="19" {if $order.status == '19'}selected=""{/if}>Available</option>
                            <option value="6" {if $order.status == '6'}selected=""{/if}>Writer Assigned</option>
                            {if $editor_account_enabled}
                                <option value="8" {if $order.status == '8'}selected=""{/if}>Done/Editing</option>
                            {/if}
                            <option value="11" {if $order.status == '11'}selected=""{/if}>Delivered</option>
                            <option value="10" {if $order.status == '10'}selected=""{/if}>Finished</option>
                            <option value="14" {if $order.status == '14'}selected=""{/if}>Revision</option>
                            <option value="9" {if $order.status == '9'}selected=""{/if}>Cancelled</option>
                            <option value="1" {if $order.status == '1'}selected=""{/if}>Dispute</option>
                        </select>
                    </div>

                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
                </div>
            </form>
        </script>
        <!-- Order Status -->

        <!-- Additional Pay -->
        <script id="modal-additional-payment" type="text/template">
            <form class="js_ajax-forms p0 m0" data-url="/orders/{$order.id}/additional-payment" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Request Additional Payment</h5>
                    <span class="modal-close" data-dismiss="modal" aria-label="Close">
                        <i class="fa fa-times"></i>
                    </span>
                </div>
                <div class="modal-body">

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Amount</label>
                        <div class="col-sm-5">
                            <div class="input-group">
                                <div class="input-group-prepend"> 
                                    <span class="input-group-text">$</span> 
                                </div>
                                <input name="amount" type="text" class="form-control force-integer">
                            </div>
                        </div>
                    </div>

                    {if $order.isAcademicWriting}
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Pages</label>
                            <div class="col-sm-9">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="pages" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                                <div class="help-block">Additional pages to be added to the order when the payment is done</div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Charts</label>
                            <div class="col-sm-9">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="charts" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                                <div class="help-block">Additional charts to be added to the order when the payment is done</div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">PowerPoint slides</label>
                            <div class="col-sm-9">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="slides" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                                <div class="help-block">Additional slides to be added to the order when the payment is done</div>
                            </div>
                        </div>
                    {/if}

                    {if $order.isArticleWriting}
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label text-left">Words</label>
                            <div class="col-sm-9">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="words" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                                <div class="help-block">Additional words to be added to the order when the payment is done</div>
                            </div>
                        </div>
                    {/if}

                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Comments</label>
                        <div class="col-sm-9">
                            <textarea name="comments" type="text" class="form-control js_autosize"></textarea>
                            <div class="help-block">Comments regarding this additional payment</div>
                        </div>
                    </div>

                    <!-- success -->
                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                    <!-- success -->

                    <!-- error -->
                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                    <!-- error -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Confirm</button>
                </div>
            </form>
        </script>
        <!-- Additional Pay -->

        <script id="modalAdditionalPaymentLink" type="text/template">
            <div class="modal-header">
                <h5 class="modal-title">Additional Payment Link</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="alert bg-info text-dark" id="paymentLinkPrint">{literal}{{payment_link}}{/literal}</div>
            </div>
        </script>
    {/if}
{/block}
