{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-flag mr10"></i>
            <strong>Orders</strong>
            {if $sub_view != ""}
                &rsaquo; <strong>{$sub_view|capitalize} ({$total_orders})</strong>
            {/if}
        </div>

        <div class="card-body">

            {if $user.is_admin || $user.is_sub_admin}
                {include file='dashboard/orders/_filters.orders.tpl'}
            {/if}

            {if count($orders)}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <th>
                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="custom-control custom-checkbox"> 
                                            <input type="checkbox" class="custom-control-input js_select-all" name="select_all" id="js_select-all"> 
                                            <label class="custom-control-label" for="js_select-all">Order ID</label>
                                        </div>
                                    {else}
                                        Order ID
                                    {/if}
                                </th>
                                <th>Title</th>
                                <th>Discipline</th>
                                <th>Created At</th>
                                <th>Task</th>
                                {if $show_client_cost}
                                    <th>COST</th>
                                {/if}
                                {if $user.is_admin || $user.is_sub_admin}
                                <th>Actions</th>
                                {/if}
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $orders as $order}
                                <tr class="{if ($user.is_sub_admin && $user.id == $order.orderManager.id) && ($order_manager_enabled && $order_manager_public)} success {/if} {if $order.isArticleWriting} info {/if} {if $order.isProgramming || $order.isCalculations} warning {/if}">
                                    <td>
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="custom-control custom-checkbox"> 
                                                <input type="checkbox" class="custom-control-input" name="bulk_action" value="{$order.id}" id="check-{$order.id}"> 
                                                <label class="custom-control-label" for="check-{$order.id}"><a class="fw-bold" href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">#{$order.referenceId}</a></label>
                                            </div>
                                        {else}
                                            <strong><a class="text-primary" href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">#{$order.referenceId}</a></strong>
                                        {/if}
                                    </td>
                                    {if $order.isProgramming || $order.isCalculations}
                                        <td>
                                            <span data-toggle="tooltip" data-title="{$order.serviceTypeTitle}"> {$order.serviceTypeTitle}</span>
                                        </td>

                                        <td>
                                            <span class="btn-block">{$order.topicCategory}</small>
                                            <small class="btn-block text-secondary">{$order.sizeTitle}</small>
                                        </td>
                                    {elseif $order.isArticleWriting}
                                        <td>
                                            <span data-toggle="tooltip" data-title="{$order.title}"> {$order.title}</span>
                                        </td>

                                        <td>
                                            <span class="btn-block">{$order.contentTypeTitle}</small>
                                            <small class="btn-block text-secondary">{$order.disciplineTitle}</small>
                                        </td>
                                    {else}
                                        <td>
                                            <span data-toggle="tooltip" data-title="{$order.title}"> {$order.titleTruncated}</span>
                                        </td>

                                        <td>
                                            <small class="btn-block">{$order.topicCategory}</small>
                                            <small class="btn-block text-secondary">{$order.academicLevelTitle}</small>
                                        </td>
                                    {/if}
                                    <td>
                                        <span class="js_moment" data-time="{$order.createdAt}"></span>
                                    </td>
 
                                    {if $order.isProgramming || $order.isCalculations}
                                        <td>{$order.sizeTitle}</td>
                                    {elseif $order.isArticleWriting}
                                        <td>{pluralize('word', $order.words)}</td>
                                    {else}
                                        <td>
                                            {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                                            {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                                            {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                                            {if $order.excel_sheets} {pluralize('excel sheet', $order.excel_sheets)} {/if} 
                                        </td>
                                    {/if}
                                        
                                    {if ($user.is_admin || $user.is_sub_admin) && $show_client_cost}
                                        <td>{$order.priceFormatted}</td>
                                    {elseif $user.is_writer}
                                        <td>{$order.writerPayFormatted}</td>
                                    {elseif $user.is_editor}
                                        <td>{$order.editorPayFormatted}</td>
                                    {/if}

                                    {if $user.is_admin || $user.is_sub_admin}
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$order.id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$order.id}">
                                                    <a class="dropdown-item" href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">
                                                        <i class="fa fa-pencil-alt mr5"></i> View
                                                    </a>
                                                    <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="order" data-id="{$order.id}">
                                                        <i class="fa fa-trash mr5"></i> Delete
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    {/if}
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {if $user.is_admin || $user.is_sub_admin}
                        <div class="mb-1">
                            <button class="btn btn-success btn-sm js_bulk-actions float-left">Bulk Actions</button>
                        </div>
                    {/if}

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No orders to show</strong></p>
                </div>
            {/if}

        </div>
    </div>
{/block}
