{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-flag mr10"></i>
            <strong>{$sub_view|capitalize}</strong> 
            &rsaquo; <strong>{$user_id}</strong>
            &rsaquo; <strong>Orders</strong> 
            &rsaquo; ({$total_orders})</strong>

            <div class="pull-right flip">
                {if $user_group == 'customer'}
                    <a href="{$base_uri}/customers/edit/{$user_id}" data-ajax="/customers/edit/{$user_id}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left fa-fw mr5"></i> Go Back
                    </a>
                {else}
                    <a href="{$base_uri}/employees/edit/{$user_id}" data-ajax="/employees/edit/{$user_id}" class="btn btn-secondary">
                        <i class="fa fa-arrow-left fa-fw mr5"></i> Go Back
                    </a>
                {/if}
            </div>
        </div> 

        <div class="card-body">

            <div class="mb20">
                <form method="GET" id="filter_form" autocomplete="off">
                    <div class="row mb10">
                        <div class="col-md-3">
                            <label>Status ID:</label>
                            <select class="form-control input-sm" name="status_id">
                                <option value="all" selected="selected">All</option>
                                <option value="13" {if $status_id == "13"} selected=""{/if}>Free Inquiry</option>
                                <option value="0" {if $status_id == "0"} selected=""{/if}>Waiting for Payment</option>
                                <option value="12" {if $status_id == "12"} selected=""{/if}>New Paid</option>
                                <option value="19" {if $status_id == "19"} selected=""{/if}>Available</option>
                                <option value="6" {if $status_id == "6"} selected=""{/if}>Writer Assigned</option>
                                {if $editor_account_enabled}
                                    <option value="8" {if $status_id == "8"} selected=""{/if}>Done/Editing</option>
                                {/if}
                                <option value="11" {if $status_id == "11"} selected=""{/if}>Delivered</option>
                                <option value="10" {if $status_id == "10"} selected=""{/if}>Finished</option>
                                <option value="14" {if $status_id == "14"} selected=""{/if}>Revision</option>
                                <option value="9" {if $status_id == "9"} selected=""{/if}>Cancelled</option>
                                <option value="1" {if $status_id == "1"} selected=""{/if}>Dispute</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="toptitle">Topic Title:</label>
                            <input class="form-control input-sm" type="text" name="toptitle" placeholder="Topic Title" value="{$toptitle}" />
                        </div>
                        <div class="col-md-3">
                            <label for="order_id">Order ID:</label>
                            <input class="form-control input-sm force-integer" type="text" name="order_id" placeholder="Order Id" value="{$order_id}" />
                        </div>
                        <div class="col-md-2">
                            <button name="search" class="btn btn-primary mt20"><i class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                </form>
            </div>

            {if count($orders)}
                <div class="table-responsive">
                    <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <th>
                                    {if $user.is_admin || $user.is_sub_admin}
                                        <div class="custom-control custom-checkbox"> 
                                            <input type="checkbox" class="custom-control-input js_select-all" name="select_all" id="js_select-all"> 
                                            <label class="custom-control-label" for="js_select-all">Order ID</label>
                                        </div>
                                    {else}
                                        Order ID
                                    {/if}
                                </th>
                                <th>Topic Title</th>
                                <th>Discipline</th>
                                <th>Status</th>
                                <th>Task</th>
                                {if $show_client_cost}
                                    <th>COST</th>
                                {/if}
                                {if $user_group == "writer" || $user_group == "editor" || $user_group == "ordermanager"}
                                    <th>Paid</th>
                                {/if}
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $orders as $order}
                                <tr>
                                    <td>
                                        {if $user.is_admin || $user.is_sub_admin}
                                            <div class="custom-control custom-checkbox"> 
                                                <input type="checkbox" class="custom-control-input" name="bulk_action" value="{$order.id}" id="check-{$order.id}"> 
                                                <label class="custom-control-label" for="check-{$order.id}"><a class="fw-bold" href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">#{$order.referenceId}</a></label>
                                            </div>
                                        {else}
                                            <strong><a class="text-primary" href="{$base_uri}/order/{$order.id}" data-ajax="/order/{$order.id}">#{$order.referenceId}</a></strong>
                                        {/if}
                                    </td>
                                    {if $order.isProgramming || $order.isCalculations}
                                        <td>
                                            <span data-toggle="tooltip" data-title="{$order.serviceTypeTitle}"> {$order.serviceTypeTitle}</span>
                                        </td>

                                        <td>
                                            <span class="btn-block">{$order.topicCategory}</small>
                                            <small class="btn-block text-secondary">{$order.sizeTitle}</small>
                                        </td>
                                    {elseif $order.isArticleWriting}
                                        <td>
                                            <span data-toggle="tooltip" data-title="{$order.title}"> {$order.title}</span>
                                        </td>

                                        <td>
                                            <span class="btn-block">{$order.contentTypeTitle}</small>
                                            <small class="btn-block text-secondary">{$order.disciplineTitle}</small>
                                        </td>
                                    {else}
                                        <td>
                                            <span data-toggle="tooltip" data-title="{$order.title}"> {$order.titleTruncated}</span>
                                        </td>

                                        <td>
                                            <small class="btn-block">{$order.topicCategory}</small>
                                            <small class="btn-block text-secondary">{$order.academicLevelTitle}</small>
                                        </td>
                                    {/if}
                                    <td>{$order.statusTitle}</td>
                                    {if $order.isProgramming || $order.isCalculations}
                                        <td>{$order.sizeTitle}</td>
                                    {elseif $order.isArticleWriting}
                                        <td>{pluralize('word', $order.words)}</td>
                                    {else}
                                        <td>
                                            {if $order.pages} {pluralize('page', $order.pages)} {/if} 
                                            {if $order.slides}, {pluralize('slide', $order.slides)} {/if} 
                                            {if $order.charts} {pluralize('chart', $order.charts)} {/if} 
                                            {if $order.excel_sheets} {pluralize('excel sheet', $order.excel_sheets)} {/if} 
                                        </td>
                                    {/if}
                                    {if $user_group == "writer"}
                                        <td>
                                            {$order.writerPayFormatted}
                                        </td>
                                        <td>
                                            {if $order.isWriterPaid}
                                                <span class="label label-success">Yes</span>
                                            {else}
                                                <span class="label label-danger">No</span>
                                            {/if}
                                        </td>
                                    {elseif $user_group == "editor"}
                                        <td>
                                            {$order.editorPayFormatted}
                                        </td>
                                        <td>
                                            {if $order.isEditorPaid}
                                                <span class="label label-success">Yes</span>
                                            {else}
                                                <span class="label label-danger">No</span>
                                            {/if}
                                        </td>
                                    {elseif $user_group == "ordermanager"}
                                        <td>
                                            {$order.orderManagerPayFormatted}
                                        </td>
                                        <td>
                                            {if $order.isOrderManagerPaid}
                                                <span class="label label-success">Yes</span>
                                            {else}
                                                <span class="label label-danger">No</span>
                                            {/if}
                                        </td>
                                    {/if}
                                    {if $show_client_cost}
                                        <td>
                                            {$order.priceFormatted}
                                        </td>
                                    {/if}
                                    <td>
                                        <a data-toggle="tooltip" data-placement="top" title="View" href="{$base_uri}/order/{$order.id}" class="btn btn-xs btn-primary" data-ajax="/order/{$order.id}">
                                            <i class="fa fa-eye"></i> View
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                            
                        {if $show_client_cost}
                            <tfoot>
                                <tr style="display: table-row;">
                                    {if $user_group == 'customer'}
                                        <th class="text-right" align="right" colspan="5">Total Spent:</th>
                                        <td class="text-right">
                                            <strong class="text-success">{$total_spent}</strong>
                                        </td>
                                    {else}
                                        <th class="text-right" align="right" colspan="5">Total Earned:</th>
                                        <td class="text-right">
                                            <strong class="text-success">{$total_earned}</strong>
                                        </td>
                                    {/if}
                                </tr>
                            </tfoot>
                        {/if}

                    </table>

                    {if $user.is_admin || $user.is_sub_admin}
                        <div class="mb-1">
                            <button class="btn btn-success btn-sm js_bulk-actions float-left">Bulk Actions</button>
                        </div>
                    {/if}

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No orders to show</strong></p>
                </div>
            {/if}

        </div>
    </div>
{/block}
