{if count($disciplines)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Complex Assignment</th>
                    <th>Actions</th>
                </tr>
            </thead> 
            <tbody>
                {foreach $disciplines as $discipline}
                    <tr>
                        <td>
                            {$discipline.title}
                        </td>
                        <td>
                            {if $discipline.is_complex_assignment}
                                <span class="fa fa-check text-success"></span>
                            {else}
                                <span class="fa fa-times text-danger"></span>
                            {/if}
                        </td>
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenu-{$discipline.discipline_id}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Actions
                                </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenu-{$discipline.discipline_id}">
                                    <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-url="#editDisciplineModal" data-size="medium" data-options='{$discipline|json_encode nofilter}'>
                                        <i class="fa fa-pencil-alt mr5"></i> Edit
                                    </a>
                                    {if $discipline.discipline_id != '52'}
                                        <a class="dropdown-item js_deleter" href="javascript:void(0);" data-handle="discipline" data-id="{$discipline.discipline_id}">
                                            <i class="fa fa-trash mr5"></i> Delete
                                        </a>
                                    {/if}
                                </div>
                            </div>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No disciplines to show</strong></p>
    </div>
{/if}

<!-- Edit Discipline -->
<script id="editDisciplineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDiscipline" method="POST" autocomplete="off">
        <input type="hidden" name="discipline_id" value="{literal}{{discipline_id}}{/literal}">
        {literal}{{#is_academic_writing}}{/literal}
        <input type="hidden" name="is_academic_writing" value="1">
        {literal}{{/is_academic_writing}}{/literal}

        {literal}{{#is_programming}}{/literal}
        <input type="hidden" name="is_programming" value="1">
        {literal}{{/is_programming}}{/literal}

        {literal}{{#is_calculations}}{/literal}
        <input type="hidden" name="is_calculations" value="1">
        {literal}{{/is_calculations}}{/literal}

        {literal}{{#is_article_writing}}{/literal}
        <input type="hidden" name="is_article_writing" value="1">
        {literal}{{/is_article_writing}}{/literal}
        <div class="modal-header">
            <h5 class="modal-title">Edit Discipline</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control" value="{literal}{{title}}{/literal}">
            </div>

            <div class="form-table-row mb0"> 
                <div> 
                    <div class="form-control-label h5">Complex Assignment</div> 
                    <div class="form-text">Charge an extra 20% for the complexity of this Discipline</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment" {literal}{{#is_complex_assignment}}{/literal}checked=""{literal}{{/is_complex_assignment}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Discipline -->