{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20">  

            {if $controller == "contentTypes"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addContentTypeModal" data-size="small" class="btn btn-success">
                        <i class="fa fa-plus"></i> Add Content Type
                    </button>
                </div>
            {/if}
            

            {if $controller == "categories"}
                <div class="pull-right flip">
                    <button type="button" data-toggle="modal" data-url="#addCategoryModal" class="btn btn-success">
                        <i class="fa fa-plus"></i> Add Category
                    </button>
                </div>
            {/if}

            <i class="fa fa-cogs mr10"></i> 
            <strong>Preferences</strong>
            &rsaquo; <strong>Categories</strong>
        </div>

        <ul class="nav nav-tabs">
            <li {if $controller == "contentTypes"}class="active"{/if}>
                <a href="{$base_uri}/preferences/articles/content-types" data-ajax="/preferences/articles/content-types"> 
                    {if $controller == "contentTypes"}<strong class="pr5">Content Types</strong>{else}Content Types{/if} 
                </a>
            </li>
            
            <li {if $controller == "categories"}class="active"{/if}>
                <a href="{$base_uri}/preferences/articles/categories" data-ajax="/preferences/articles/categories"> 
                    {if $controller == "categories"}<strong class="pr5">Categories</strong>{else}Categories{/if} 
                </a>
            </li>

            <li {if $controller == "other"}class="active"{/if}>
                <a href="{$base_uri}/preferences/articles/other" data-ajax="/preferences/articles/other"> 
                    {if $controller == "other"}<strong class="pr5">Other</strong>{else}Other{/if} 
                </a>
            </li>

        </ul>
    </div>

    <div class="card-body">
        {include file="dashboard/preferences/articles/$controller.tpl"}
    </div>
</div>
{/block}