{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="row">
        <div class="col-md-8"> 
            <div class="settings-page">
                <div class="avatar-holder mb20">
                    <!-- profile-avatar -->
                    <div class="profile-avatar-wrapper">
                        <div class="avatar" style="background-image: url('{$user.user_picture}');"></div>
                        <div class="profile-avatar-change">
                            <i class="fa fa-camera js_x-uploader" data-handle="picture-user"></i>
                        </div>
                        <div class="profile-avatar-delete {if $user.user_picture_default}x-hidden{/if}">
                            <i class="fa fa-trash js_delete-picture" data-handle="picture-user" title='Delete Picture'></i>
                        </div>
                        <div class="profile-avatar-change-loader">
                            <div class="loader loader_medium"></div>
                        </div>
                    </div>
                    <!-- profile-avatar -->
                    
                    <div class="infoz">
                        <h5 class="text-white" title="{$user.first_name} {$user.last_name}">{$user.first_name} {$user.last_name}</h5>
                        {if $_settings == 'general'}
                            <p>General Settings</p>
                        {elseif $_settings == 'email'}
                            <p>Email Settings</p>
                        {elseif $_settings == 'password'}
                            <p>Password Settings</p>
                        {elseif $_settings == 'sessions'}
                            <p>Manage Sessions</p>
                            <a href="javascript:void();" class="btn btn-sm btn-mat btn-glossy js_session-delete-all" id="upgrade-button">Logout From All Sessions</a>
                        {/if}
                        {hook h='displayProfileNavTitle'}
                    </div>
                </div>

                {if $_settings == 'general'}
                    <form class="js_ajax-forms" method="POST" data-url="/user/settings?edit=basic" autocomplete="off">
                        <div class="form-group form-row">
                            <div class="col-sm-4 mb10">
                                <label class="control-label">First name</label>
                                <input type="text" class="form-control" name="first_name" value="{$user.first_name}" autocomplete="off">
                            </div>

                            <div class="col-sm-4 mb10">
                                <label class="control-label">Middle name</label>
                                <input type="text" class="form-control" name="middle_name" value="{$user.middle_name}" autocomplete="off">
                            </div>

                            <div class="col-sm-4 mb10">
                                <label class="control-label">Last name</label>
                                <input type="text" class="form-control" name="last_name" value="{$user.last_name}" autocomplete="off">
                            </div>
                            
                        </div>

                        <div class="form-group form-row mb10">
                            <div class="col-md-6">
                                <label class="control-label">Phone</label>
                                <div class="">
                                    <input type="text" name="js_user_phone" class="form-control js_phone" placeholder="Enter mobile" autocomplete="off" {if $user.phone}value="{$user.phone}"{/if}>
                                    <input type="hidden" name="phone" class="form-control js_phone_number" autocomplete="off" readonly="true" {if $user.phone}value="{$user.phone}"{/if}>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group form-row">
                            <div class="col-sm-5 mb10">
                                <label class="control-label">Gender</label>
                                <div class="">
                                    <div class="form-selectgroup">
                                        <label class="form-selectgroup-item" for="gender_male">
                                            <input id="gender_male" type="radio" name="gender" value="male" class="form-selectgroup-input" {if $user.gender == 'male'}checked="checked"{/if}>
                                            <span class="form-selectgroup-label">
                                                <i class="icon fa fa-male fa-lg"></i>    
                                                <span class="text middle">Male</span>
                                            </span>
                                        </label>
                                        <label class="form-selectgroup-item" for="gender_female">
                                            <input id="gender_female" type="radio" name="gender" value="female" class="form-selectgroup-input" {if $user.gender == 'female'}checked="checked"{/if}>
                                            <span class="form-selectgroup-label">
                                                <i class="icon fa fa-female fa-lg"></i>    
                                                <span class="text middle">Female</span>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            {if $user.is_editor || $user.is_writer}
                                <div class="col-sm-5 mb10">
                                    <label class="control-label">Status</label>
                                    <div class="">
                                        <select class="form-control" name="status">
                                            <option value="2" {if $user.employee_status == "2"}selected="selected"{/if}>Looking for orders</option>
                                            <option value="4" {if $user.employee_status == "4"}selected="selected"{/if}>Cannot work for now</option>
                                            <option value="5" {if $user.employee_status == "5"}selected="selected"{/if}>Do not use your service</option>
                                        </select>
                                    </div>
                                </div>
                            {/if}
                        </div>

                        <div class="form-group">
                            <label class="control-label">Email Notifications</label>
                            <div class="">
                                <label class="switch" for="email_notifications">
                                    <input type="checkbox" name="email_notifications" id="email_notifications" {if $user.email_notifications == '1'}checked="checked"{/if}>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="control-label">Default Timezone</label>
                            <div class="form-row">
                                <div class="col-md-4">
                                    <select id="timezone-region" class="form-control" data-combo="timezone-combo">
                                        {foreach from=$regions item=region key=key name=name}
                                            <option value="{$key}" {if $user.default_region == $key } selected="" {/if} >{$key}</option>
                                        {/foreach}
                                    </select>
                                </div>
                                {assign var='timezoneId' value=0}
                                <div id="timezone-combo" class="col-md-4">
                                    {foreach from=$regions item=region key=key name=name}
                                        <select id="timezone-combo-{$key}" class="form-control {if $user.default_region != $key } x-hidden {/if} switch-combo" data-combo-value="{$key}">
                                            {foreach from=$region item=item key=key name=name}
                                                <option value="{$key}" {if $user.timezone == $key } selected="" {/if} >{$item}</option>
                                            {/foreach}
                                        </select>
                                     {assign var='timezoneId' value=$timezoneId+1}
                                    {/foreach}
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="timezone" name="timezone" data-content="timezone" data-highlight="#timezone-region" value="{$default_timezone}">

                        <div class="alert alert-success mb10 mt10 x-hidden" role="alert"></div>
                        <div class="alert alert-danger mb10 mt10 x-hidden" role="alert"></div>

                        <div class="text-center mt20">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>  
                    </form>
                {elseif $_settings == 'email'}
                    <form class="js_ajax-forms" data-url="/user/settings?edit=email" autocomplete="off">
                        <div class="form-group">
                            <label class="control-label">Email Address</label>
                            <input type="email" class="form-control" name="email" value="{$user.email}"> 
                        </div>

                        <div class="alert alert-success mb10 mt10 x-hidden" role="alert"></div>
                        <div class="alert alert-danger mb10 mt10 x-hidden" role="alert"></div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                {elseif $_settings == 'password'}
                    <form class="js_ajax-forms" data-url="/user/settings?edit=password" autocomplete="off">
                    
                        <div class="form-group mb10">
                            <label class="control-label">Current Password</label>
                            <input type="password" class="form-control" name="current" autocomplete="off"> 
                        </div>
                        <div class="form-group form-row">
                            <div class="col-md-6 mb10">
                                <label class="control-label">New Password</label>
                                <input type="password" class="form-control" name="new" autocomplete="off"> 
                            </div>
                            <div class="col-md-6 mb10">
                                <label class="control-label">Re-type New Password</label>
                                <input type="password" class="form-control" name="confirm" autocomplete="off"> 
                            </div>
                        </div>

                        <div class="alert alert-success mb10 mt10 x-hidden" role="alert"></div>
                        <div class="alert alert-danger mb10 mt10 x-hidden" role="alert"></div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                {elseif $_settings == 'sessions'}

                    {if count($sessions)}
                        <div class="active_sessions">
                            <div class="table-responsive">
                                {foreach $sessions as $session}
                                    <div class="as_list" id="session_408710">
                                        <div class="platform_icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="#222" d="M21,16H3V4H21M21,2H3C1.89,2 1,2.89 1,4V16A2,2 0 0,0 3,18H10V20H8V22H16V20H14V18H21A2,2 0 0,0 23,16V4C23,2.89 22.1,2 21,2Z"></path></svg>
                                        </div>
                                        <button title="Log Out" class="btn btn-mat log_out_session js_session-deleter" data-id="{$session.session_id}">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="currentColor" d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z"></path></svg>
                                        </button>
                                        <div class="session_info">
                                            <h4>{$session.user_os}</h4>
                                            <p>
                                                <span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M21,3H3A2,2 0 0,0 1,5V19A2,2 0 0,0 3,21H21A2,2 0 0,0 23,19V5A2,2 0 0,0 21,3M21,19H3V5H13V9H21V19Z"></path></svg> {$session.user_browser}</span>
                                                <span class="middot">·</span>
                                                <span>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="currentColor" d="M12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22C6.47,22 2,17.5 2,12A10,10 0 0,1 12,2M12.5,7V12.25L17,14.92L16.25,16.15L11,13V7H12.5Z"></path></svg> 
                                                    <span class="js_moment" data-time="{$session.date_add}">{$session.date_add}</span>
                                                </span>
                                            </p>
                                            <p>IP Address: {$session.user_ip}</p>
                                        </div>
                                    </div>
                                {/foreach}
            
                                {$pager nofilter}
                            </div>
                        </div>
                    {else}
                        <div class="text-center x-muted"> 
                            <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                            <p class="mb10"><strong>No sessions to show</strong></p>
                        </div>
                    {/if}   
                {/if}

                {hook h='displayProfileNavContent'}
            </div>
        </div>
        <div class="col-md-4"> 
            <div class="settings-sidebar">
                <ul class="list-unstyled">
                    <li {if $_settings == 'general'}class="active"{/if} dir="auto">
                        <a href="{$base_uri}/settings/general" data-ajax="/settings/general">
                            <i class="fa fa-cog fa-fw mr5"></i> General			
                        </a>
                    </li>
                    
                    <li {if $_settings == 'email'}class="active"{/if} dir="auto">
                        <a href="{$base_uri}/settings/email" data-ajax="/settings/email">
                        <i class="fa fa-envelope fa-fw mr5"></i> Email			
                        </a>
                    </li>

                    <li {if $_settings == 'password'}class="active"{/if} dir="auto">
                        <a href="{$base_uri}/settings/password" data-ajax="/settings/password">
                            <i class="fa fa-key fa-fw mr5"></i> Password			
                        </a>
                    </li>

                    <li {if $_settings == 'sessions'}class="active"{/if} dir="auto">
                        <a href="{$base_uri}/settings/sessions" data-ajax="/settings/sessions">
                            <i class="fa fa-user-shield fa-fw mr5"></i> Sessions			
                        </a>
                    </li>

                    {hook h='displayProfileNavbar'}
                </ul>
            </div>
        </div>
    </div>
    
{/block}